/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.apache.oozie.BulkResponseInfo;
import org.apache.oozie.BundleEngine;
import org.apache.oozie.BundleEngineException;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.rest.BulkResponseImpl;
import org.apache.oozie.executor.jpa.BulkJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobsGetFromParentIdJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.DateUtils;

public class TestBulkMonitorJPAExecutor
extends XDataTestCase {
    Services services;
    JPAService jpaService;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        this.jpaService = (JPAService)Services.get().get(JPAService.class);
        this.addRecordsForBulkMonitor();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testSingleRecord() throws Exception {
        String request = "bundle=" + this.bundleName + ";actionstatus=FAILED;startcreatedtime=2012-07-21T00:00Z;endcreatedtime=2012-07-22T02:00Z;startscheduledtime=2012-07-20T23:00Z;endscheduledtime=2012-07-22T03:00Z";
        BulkResponseInfo response = this._execQuery(request);
        List brList = response.getResponses();
        TestBulkMonitorJPAExecutor.assertEquals((int)1, (int)brList.size());
        TestBulkMonitorJPAExecutor.assertEquals((long)1L, (long)response.getTotal());
        BulkResponseImpl br = (BulkResponseImpl)brList.get(0);
        TestBulkMonitorJPAExecutor.assertEquals((String)this.bundleName, (String)br.getBundle().getAppName());
        TestBulkMonitorJPAExecutor.assertEquals((String)"Coord1", (String)br.getCoordinator().getAppName());
        TestBulkMonitorJPAExecutor.assertEquals((Object)CoordinatorAction.Status.FAILED, (Object)br.getAction().getStatus());
        TestBulkMonitorJPAExecutor.assertEquals((String)DateUtils.parseDateUTC((String)this.CREATE_TIME).toString(), (String)br.getAction().getCreatedTime().toString());
    }

    public void testMultipleRecords() throws Exception {
        String request = "bundle=" + this.bundleName + ";actionstatus=FAILED,KILLED;startcreatedtime=2012-07-21T00:00Z;endcreatedtime=2012-07-22T02:00Z;startscheduledtime=2012-07-20T23:00Z;endscheduledtime=2012-07-22T03:00Z";
        BulkResponseInfo response = this._execQuery(request);
        List brList = response.getResponses();
        TestBulkMonitorJPAExecutor.assertEquals((int)3, (int)brList.size());
        TestBulkMonitorJPAExecutor.assertEquals((long)3L, (long)response.getTotal());
        ArrayList<String> possibleStatus = new ArrayList<String>(Arrays.asList("KILLED", "FAILED"));
        ArrayList<String> resultStatus = new ArrayList<String>();
        resultStatus.add(((BulkResponseImpl)brList.get(0)).getAction().getStatus().toString());
        resultStatus.add(((BulkResponseImpl)brList.get(1)).getAction().getStatus().toString());
        TestBulkMonitorJPAExecutor.assertEquals(possibleStatus, resultStatus);
    }

    public void testJavaNoRecords() throws Exception {
        String request = "bundle=BUNDLE-ABC;actionstatus=FAILED";
        BulkJPAExecutor bulkjpa = new BulkJPAExecutor(BundleEngine.parseBulkFilter((String)request), 1, 10);
        try {
            this.jpaService.execute((JPAExecutor)bulkjpa);
            TestBulkMonitorJPAExecutor.fail();
        }
        catch (JPAExecutorException jex) {
            TestBulkMonitorJPAExecutor.assertTrue((boolean)jex.getMessage().contains("No entries found for given bundle(s)"));
        }
    }

    public void testMultipleCoordinators() throws Exception {
        String request = "bundle=" + this.bundleName + ";coordinators=Coord1,Coord2;actionstatus=KILLED";
        BulkResponseInfo response = this._execQuery(request);
        List brList = response.getResponses();
        TestBulkMonitorJPAExecutor.assertEquals((int)2, (int)brList.size());
        TestBulkMonitorJPAExecutor.assertEquals((long)2L, (long)response.getTotal());
        TestBulkMonitorJPAExecutor.assertEquals((String)((BulkResponseImpl)brList.get(0)).getAction().getId(), (String)"Coord1@2");
        TestBulkMonitorJPAExecutor.assertEquals((String)((BulkResponseImpl)brList.get(1)).getAction().getId(), (String)"Coord2@1");
    }

    public void testDefaultStatus() throws Exception {
        this.addRecordToCoordActionTable("Coord3", 1, CoordinatorAction.Status.FAILED, "coord-action-get.xml", 0);
        String request = "bundle=" + this.bundleName + ";";
        BulkResponseInfo response = this._execQuery(request);
        List brList = response.getResponses();
        TestBulkMonitorJPAExecutor.assertEquals((int)4, (int)brList.size());
        TestBulkMonitorJPAExecutor.assertEquals((long)4L, (long)response.getTotal());
        ArrayList<String> possibleStatus = new ArrayList<String>(Arrays.asList("FAILED", "KILLED"));
        ArrayList<String> resultStatus = new ArrayList<String>();
        resultStatus.add(((BulkResponseImpl)brList.get(0)).getAction().getStatus().toString());
        resultStatus.add(((BulkResponseImpl)brList.get(1)).getAction().getStatus().toString());
        TestBulkMonitorJPAExecutor.assertEquals(possibleStatus, resultStatus);
    }

    public void testMultipleBundleIdsForName() throws Exception {
        BundleJobBean bundle = new BundleJobBean();
        bundle.setId("00002-12345-B");
        bundle.setAppName(this.bundleName);
        bundle.setStatus(Job.Status.RUNNING);
        bundle.setStartTime(new Date());
        BundleJobInsertJPAExecutor bundleInsert = new BundleJobInsertJPAExecutor(bundle);
        this.jpaService.execute((JPAExecutor)bundleInsert);
        String request = "bundle=" + this.bundleName;
        BulkJPAExecutor bulkjpa = new BulkJPAExecutor(BundleEngine.parseBulkFilter((String)request), 1, 10);
        try {
            this.jpaService.execute((JPAExecutor)bulkjpa);
        }
        catch (JPAExecutorException jex) {
            TestBulkMonitorJPAExecutor.fail();
        }
    }

    public void testBundleId() throws Exception {
        String request = "bundle=" + this.bundleId + ";actionstatus=FAILED;startcreatedtime=2012-07-21T00:00Z;endcreatedtime=2012-07-22T02:00Z";
        BulkResponseInfo response = this._execQuery(request);
        List brList = response.getResponses();
        TestBulkMonitorJPAExecutor.assertEquals((int)1, (int)brList.size());
        TestBulkMonitorJPAExecutor.assertEquals((long)1L, (long)response.getTotal());
        BulkResponseImpl br = (BulkResponseImpl)brList.get(0);
        TestBulkMonitorJPAExecutor.assertEquals((String)this.bundleId, (String)br.getBundle().getId());
        TestBulkMonitorJPAExecutor.assertEquals((String)"Coord1", (String)br.getCoordinator().getAppName());
        TestBulkMonitorJPAExecutor.assertEquals((Object)CoordinatorAction.Status.FAILED, (Object)br.getAction().getStatus());
        TestBulkMonitorJPAExecutor.assertEquals((String)DateUtils.parseDateUTC((String)this.CREATE_TIME).toString(), (String)br.getAction().getCreatedTime().toString());
    }

    public void testBundleIdWithCoordId() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        List coordIds = (List)jpaService.execute((JPAExecutor)new CoordJobsGetFromParentIdJPAExecutor(this.bundleId, 10));
        String coordIdsStr = (String)coordIds.get(0) + "," + (String)coordIds.get(1);
        String request = "bundle=" + this.bundleId + ";coordinators=" + coordIdsStr + ";actionstatus=KILLED";
        BulkResponseInfo response = this._execQuery(request);
        List brList = response.getResponses();
        TestBulkMonitorJPAExecutor.assertEquals((int)2, (int)brList.size());
        TestBulkMonitorJPAExecutor.assertEquals((long)2L, (long)response.getTotal());
        TestBulkMonitorJPAExecutor.assertEquals((String)((BulkResponseImpl)brList.get(0)).getAction().getId(), (String)"Coord1@2");
        TestBulkMonitorJPAExecutor.assertEquals((String)((BulkResponseImpl)brList.get(1)).getAction().getId(), (String)"Coord2@1");
    }

    private BulkResponseInfo _execQuery(String request) throws JPAExecutorException, BundleEngineException {
        BulkJPAExecutor bulkjpa = new BulkJPAExecutor(BundleEngine.parseBulkFilter((String)request), 1, 10);
        BulkResponseInfo response = (BulkResponseInfo)this.jpaService.execute((JPAExecutor)bulkjpa);
        TestBulkMonitorJPAExecutor.assertNotNull((Object)response);
        return response;
    }
}

