/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.executor.jpa.BundleJobQueryExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;

public class TestBundleJobQueryExecutor
extends XDataTestCase {
    Services services;
    JPAService jpaService;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        this.jpaService = (JPAService)Services.get().get(JPAService.class);
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testGetUpdateQuery() throws Exception {
        EntityManager em = this.jpaService.getEntityManager();
        BundleJobBean bean = this.addRecordToBundleJobTable(Job.Status.PREP, false);
        Query query = BundleJobQueryExecutor.getInstance().getUpdateQuery((Enum)BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB, (Object)bean, em);
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("appName"), (Object)bean.getAppName());
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("appPath"), (Object)bean.getAppPath());
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("conf"), (Object)bean.getConfBlob());
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("timeOut"), (Object)bean.getTimeout());
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("createdTime"), (Object)bean.getCreatedTimestamp());
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("endTime"), (Object)bean.getEndTimestamp());
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("jobXml"), (Object)bean.getJobXmlBlob());
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("lastModifiedTime"), (Object)bean.getLastModifiedTimestamp());
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("origJobXml"), (Object)bean.getOrigJobXmlBlob());
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("startTime"), (Object)bean.getstartTimestamp());
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)bean.getStatus().toString());
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("timeUnit"), (Object)bean.getTimeUnitStr());
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("pending"), (Object)bean.getPending());
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
        query = BundleJobQueryExecutor.getInstance().getUpdateQuery((Enum)BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB_STATUS, (Object)bean, em);
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)bean.getStatus().toString());
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
        query = BundleJobQueryExecutor.getInstance().getUpdateQuery((Enum)BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB_STATUS_PENDING, (Object)bean, em);
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)bean.getStatus().toString());
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("pending"), (Object)bean.getPending());
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
        query = BundleJobQueryExecutor.getInstance().getUpdateQuery((Enum)BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB_STATUS_PENDING_SUSP_MOD_TIME, (Object)bean, em);
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)bean.getStatus().toString());
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("lastModifiedTime"), (Object)bean.getLastModifiedTimestamp());
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("pending"), (Object)bean.getPending());
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("suspendedTime"), (Object)bean.getSuspendedTimestamp());
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
        query = BundleJobQueryExecutor.getInstance().getUpdateQuery((Enum)BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB_STATUS_PENDING_MODTIME, (Object)bean, em);
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)bean.getStatus().toString());
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("lastModifiedTime"), (Object)bean.getLastModifiedTimestamp());
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("pending"), (Object)bean.getPending());
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
        query = BundleJobQueryExecutor.getInstance().getUpdateQuery((Enum)BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB_STATUS_PAUSE_ENDTIME, (Object)bean, em);
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)bean.getStatus().toString());
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("pauseTime"), (Object)bean.getPauseTimestamp());
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("endTime"), (Object)bean.getEndTimestamp());
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
        query = BundleJobQueryExecutor.getInstance().getUpdateQuery((Enum)BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB_PAUSE_KICKOFF, (Object)bean, em);
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("pauseTime"), (Object)bean.getPauseTimestamp());
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("kickoffTime"), (Object)bean.getKickoffTimestamp());
        TestBundleJobQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
        em.close();
    }

    public void testExecuteUpdate() throws Exception {
        BundleJobBean bean = this.addRecordToBundleJobTable(Job.Status.PREP, false);
        bean.setStatus(Job.Status.RUNNING);
        BundleJobQueryExecutor.getInstance().executeUpdate((Enum)BundleJobQueryExecutor.BundleJobQuery.UPDATE_BUNDLE_JOB_STATUS, (Object)bean);
        BundleJobBean retBean = (BundleJobBean)BundleJobQueryExecutor.getInstance().get((Enum)BundleJobQueryExecutor.BundleJobQuery.GET_BUNDLE_JOB, new Object[]{bean.getId()});
        TestBundleJobQueryExecutor.assertEquals((Object)retBean.getStatus(), (Object)Job.Status.RUNNING);
    }

    public void testGet() throws Exception {
        BundleJobBean bean = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        BundleJobBean retBean = (BundleJobBean)BundleJobQueryExecutor.getInstance().get((Enum)BundleJobQueryExecutor.BundleJobQuery.GET_BUNDLE_JOB_ID_STATUS_PENDING_MOD_PAUSE_SUSPEND_TIME, new Object[]{bean.getId()});
        TestBundleJobQueryExecutor.assertEquals((String)bean.getId(), (String)retBean.getId());
        TestBundleJobQueryExecutor.assertEquals((String)bean.getStatusStr(), (String)retBean.getStatusStr());
        TestBundleJobQueryExecutor.assertEquals((int)bean.getPending(), (int)retBean.getPending());
        TestBundleJobQueryExecutor.assertEquals((long)bean.getLastModifiedTime().getTime(), (long)retBean.getLastModifiedTime().getTime());
        retBean = (BundleJobBean)BundleJobQueryExecutor.getInstance().get((Enum)BundleJobQueryExecutor.BundleJobQuery.GET_BUNDLE_JOB_ID_JOBXML_CONF, new Object[]{bean.getId()});
        TestBundleJobQueryExecutor.assertEquals((String)bean.getId(), (String)retBean.getId());
        TestBundleJobQueryExecutor.assertEquals((String)bean.getJobXml(), (String)retBean.getJobXml());
        TestBundleJobQueryExecutor.assertEquals((String)bean.getConf(), (String)retBean.getConf());
        retBean = (BundleJobBean)BundleJobQueryExecutor.getInstance().get((Enum)BundleJobQueryExecutor.BundleJobQuery.GET_BUNDLE_JOB_STATUS, new Object[]{bean.getId()});
        TestBundleJobQueryExecutor.assertEquals((Object)bean.getStatus(), (Object)retBean.getStatus());
        TestBundleJobQueryExecutor.assertEquals((String)bean.getId(), (String)retBean.getId());
    }

    public void testBundleIDsForStatusTransit() throws Exception {
        BundleJobBean job1 = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        BundleJobBean job2 = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        BundleJobBean job3 = this.addRecordToBundleJobTable(Job.Status.RUNNING, false);
        BundleActionBean bean1 = this.addRecordToBundleActionTable(job1.getId(), "coord1", 0, Job.Status.PREP);
        BundleActionBean bean2 = this.addRecordToBundleActionTable(job2.getId(), "coord2", 1, Job.Status.RUNNING);
        BundleActionBean bean3 = this.addRecordToBundleActionTable(job3.getId(), "coord3", 1, Job.Status.RUNNING);
        Date timeBefore = new Date(bean1.getLastModifiedTime().getTime() - 60000L);
        List jobBean = BundleJobQueryExecutor.getInstance().getList((Enum)BundleJobQueryExecutor.BundleJobQuery.GET_BUNDLE_IDS_FOR_STATUS_TRANSIT, new Object[]{timeBefore});
        TestBundleJobQueryExecutor.assertEquals((int)3, (int)jobBean.size());
        Date timeAfter = new Date(bean3.getLastModifiedTime().getTime() + 6000L);
        jobBean = BundleJobQueryExecutor.getInstance().getList((Enum)BundleJobQueryExecutor.BundleJobQuery.GET_BUNDLE_IDS_FOR_STATUS_TRANSIT, new Object[]{timeAfter});
        TestBundleJobQueryExecutor.assertEquals((int)0, (int)jobBean.size());
    }

    public void testGetList() throws Exception {
    }

    public void testInsert() throws Exception {
        BundleJobBean bean = new BundleJobBean();
        bean.setId("test-oozie");
        bean.setAppName("testApp");
        bean.setUser("oozie");
        BundleJobQueryExecutor.getInstance().insert((JsonBean)bean);
        BundleJobBean retBean = (BundleJobBean)BundleJobQueryExecutor.getInstance().get((Enum)BundleJobQueryExecutor.BundleJobQuery.GET_BUNDLE_JOB, new Object[]{"test-oozie"});
        TestBundleJobQueryExecutor.assertEquals((String)retBean.getAppName(), (String)"testApp");
        TestBundleJobQueryExecutor.assertEquals((String)retBean.getUser(), (String)"oozie");
    }
}

