/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.ArrayList;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.FaultInjection;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.BundleActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobsDeleteJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;

public class TestBundleJobsDeleteJPAExecutor
extends XDataTestCase {
    Services services;
    private String[] excludedServices = new String[]{"org.apache.oozie.service.StatusTransitService", "org.apache.oozie.service.PauseTransitService", "org.apache.oozie.service.PurgeService", "org.apache.oozie.service.CoordMaterializeTriggerService", "org.apache.oozie.service.RecoveryService"};

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testDeleteBundles() throws Exception {
        BundleJobBean jobA = this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, false);
        BundleActionBean actionA1 = this.addRecordToBundleActionTable(jobA.getId(), "actionA1", 0, Job.Status.SUCCEEDED);
        BundleActionBean actionA2 = this.addRecordToBundleActionTable(jobA.getId(), "actionA2", 0, Job.Status.SUCCEEDED);
        BundleJobBean jobB = this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, false);
        BundleActionBean actionB1 = this.addRecordToBundleActionTable(jobB.getId(), "actionB1", 0, Job.Status.SUCCEEDED);
        BundleActionBean actionB2 = this.addRecordToBundleActionTable(jobB.getId(), "actionB2", 0, Job.Status.SUCCEEDED);
        BundleJobBean jobC = this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, false);
        BundleActionBean actionC1 = this.addRecordToBundleActionTable(jobC.getId(), "actionC1", 0, Job.Status.SUCCEEDED);
        BundleActionBean actionC2 = this.addRecordToBundleActionTable(jobC.getId(), "actionC2", 0, Job.Status.SUCCEEDED);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleJobsDeleteJPAExecutor.assertNotNull((Object)jpaService);
        ArrayList<String> deleteList = new ArrayList<String>();
        deleteList.add(jobA.getId());
        deleteList.add(jobB.getId());
        deleteList.add(jobC.getId());
        jpaService.execute((JPAExecutor)new BundleJobsDeleteJPAExecutor(deleteList));
        try {
            jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(jobA.getId()));
            TestBundleJobsDeleteJPAExecutor.fail((String)"Bundle Job A should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestBundleJobsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)new BundleActionGetJPAExecutor(actionA1.getBundleId(), actionA1.getCoordName()));
            TestBundleJobsDeleteJPAExecutor.fail((String)"Bundle Action A1 should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestBundleJobsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)new BundleActionGetJPAExecutor(actionA2.getBundleId(), actionA2.getCoordName()));
            TestBundleJobsDeleteJPAExecutor.fail((String)"Bundle Action A2 should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestBundleJobsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(jobB.getId()));
            TestBundleJobsDeleteJPAExecutor.fail((String)"Bundle Job B should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestBundleJobsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)new BundleActionGetJPAExecutor(actionB1.getBundleId(), actionB1.getCoordName()));
            TestBundleJobsDeleteJPAExecutor.fail((String)"Bundle Action B1 should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestBundleJobsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)new BundleActionGetJPAExecutor(actionB2.getBundleId(), actionB2.getCoordName()));
            TestBundleJobsDeleteJPAExecutor.fail((String)"Bundle Action B2 should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestBundleJobsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(jobC.getId()));
            TestBundleJobsDeleteJPAExecutor.fail((String)"Bundle Job C should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestBundleJobsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)new BundleActionGetJPAExecutor(actionC1.getBundleId(), actionC1.getCoordName()));
            TestBundleJobsDeleteJPAExecutor.fail((String)"Bundle Action C1 should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestBundleJobsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)new BundleActionGetJPAExecutor(actionC2.getBundleId(), actionC2.getCoordName()));
            TestBundleJobsDeleteJPAExecutor.fail((String)"Bundle Action C2 should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestBundleJobsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteBundlesRollback() throws Exception {
        BundleJobBean jobA = this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, false);
        BundleActionBean actionA1 = this.addRecordToBundleActionTable(jobA.getId(), "actionA1", 0, Job.Status.SUCCEEDED);
        BundleActionBean actionA2 = this.addRecordToBundleActionTable(jobA.getId(), "actionA2", 0, Job.Status.SUCCEEDED);
        BundleJobBean jobB = this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, false);
        BundleActionBean actionB1 = this.addRecordToBundleActionTable(jobB.getId(), "actionB1", 0, Job.Status.SUCCEEDED);
        BundleActionBean actionB2 = this.addRecordToBundleActionTable(jobB.getId(), "actionB2", 0, Job.Status.SUCCEEDED);
        BundleJobBean jobC = this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, false);
        BundleActionBean actionC1 = this.addRecordToBundleActionTable(jobC.getId(), "actionC1", 0, Job.Status.SUCCEEDED);
        BundleActionBean actionC2 = this.addRecordToBundleActionTable(jobC.getId(), "actionC2", 0, Job.Status.SUCCEEDED);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleJobsDeleteJPAExecutor.assertNotNull((Object)jpaService);
        try {
            this.setSystemProperty("oozie.fault.injection", "true");
            this.setSystemProperty("oozie.fault.injection.action.failover", "true");
            ArrayList<String> deleteList = new ArrayList<String>();
            deleteList.add(jobA.getId());
            deleteList.add(jobB.getId());
            deleteList.add(jobC.getId());
            try {
                jpaService.execute((JPAExecutor)new BundleJobsDeleteJPAExecutor(deleteList));
                TestBundleJobsDeleteJPAExecutor.fail((String)"Should have skipped commit for failover testing");
            }
            catch (JPAExecutorException jee) {
                TestBundleJobsDeleteJPAExecutor.assertTrue((boolean)jee.getMessage().contains("Skipping Commit for Failover Testing"));
            }
        }
        finally {
            FaultInjection.deactivate((String)"org.apache.oozie.command.SkipCommitFaultInjection");
        }
        try {
            jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(jobA.getId()));
        }
        catch (JPAExecutorException je) {
            TestBundleJobsDeleteJPAExecutor.fail((String)"Bundle Job A should not have been deleted");
        }
        try {
            jpaService.execute((JPAExecutor)new BundleActionGetJPAExecutor(actionA1.getBundleId(), actionA1.getCoordName()));
        }
        catch (JPAExecutorException je) {
            TestBundleJobsDeleteJPAExecutor.fail((String)"Bundle Action A1 should not have been deleted");
        }
        try {
            jpaService.execute((JPAExecutor)new BundleActionGetJPAExecutor(actionA2.getBundleId(), actionA2.getCoordName()));
        }
        catch (JPAExecutorException je) {
            TestBundleJobsDeleteJPAExecutor.fail((String)"Bundle Action A2 should not have been deleted");
        }
        try {
            jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(jobB.getId()));
        }
        catch (JPAExecutorException je) {
            TestBundleJobsDeleteJPAExecutor.fail((String)"Bundle Job B should not have been deleted");
        }
        try {
            jpaService.execute((JPAExecutor)new BundleActionGetJPAExecutor(actionB1.getBundleId(), actionB1.getCoordName()));
        }
        catch (JPAExecutorException je) {
            TestBundleJobsDeleteJPAExecutor.fail((String)"Bundle Action B1 should not have been deleted");
        }
        try {
            jpaService.execute((JPAExecutor)new BundleActionGetJPAExecutor(actionB2.getBundleId(), actionB2.getCoordName()));
        }
        catch (JPAExecutorException je) {
            TestBundleJobsDeleteJPAExecutor.fail((String)"Bundle Action B2 should not have been deleted");
        }
        try {
            jpaService.execute((JPAExecutor)new BundleJobGetJPAExecutor(jobC.getId()));
        }
        catch (JPAExecutorException je) {
            TestBundleJobsDeleteJPAExecutor.fail((String)"Bundle Job C should not have been deleted");
        }
        try {
            jpaService.execute((JPAExecutor)new BundleActionGetJPAExecutor(actionC1.getBundleId(), actionC1.getCoordName()));
        }
        catch (JPAExecutorException je) {
            TestBundleJobsDeleteJPAExecutor.fail((String)"Bundle Action C1 should not have been deleted");
        }
        try {
            jpaService.execute((JPAExecutor)new BundleActionGetJPAExecutor(actionC2.getBundleId(), actionC2.getCoordName()));
        }
        catch (JPAExecutorException je) {
            TestBundleJobsDeleteJPAExecutor.fail((String)"Bundle Action C2 should not have been deleted");
        }
    }
}

