/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.BundleJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.BundleJobsGetForPurgeJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.DateUtils;

public class TestBundleJobsGetForPurgeJPAExecutor
extends XDataTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testBundleJobsGetForPurgeJPAExecutorTooMany() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestBundleJobsGetForPurgeJPAExecutor.assertNotNull((Object)jpaService);
        BundleJobBean job1 = this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, DateUtils.parseDateOozieTZ((String)"2011-01-01T01:00Z"));
        BundleJobBean job2 = this.addRecordToBundleJobTable(Job.Status.FAILED, DateUtils.parseDateOozieTZ((String)"2011-01-01T01:00Z"));
        BundleJobBean job3 = this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, DateUtils.parseDateOozieTZ((String)"2011-01-01T01:00Z"));
        BundleJobBean job4 = this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, DateUtils.parseDateOozieTZ((String)"2011-01-01T01:00Z"));
        BundleJobBean job5 = this.addRecordToBundleJobTable(Job.Status.SUCCEEDED, DateUtils.parseDateOozieTZ((String)"2011-01-01T01:00Z"));
        ArrayList<String> list = new ArrayList<String>();
        list.addAll((Collection)jpaService.execute((JPAExecutor)new BundleJobsGetForPurgeJPAExecutor(1L, 3)));
        TestBundleJobsGetForPurgeJPAExecutor.assertEquals((int)3, (int)list.size());
        list.addAll((Collection)jpaService.execute((JPAExecutor)new BundleJobsGetForPurgeJPAExecutor(1L, 3, 3)));
        TestBundleJobsGetForPurgeJPAExecutor.assertEquals((int)5, (int)list.size());
        this.checkBundles(list, job1.getId(), job2.getId(), job3.getId(), job4.getId(), job5.getId());
    }

    protected BundleJobBean addRecordToBundleJobTable(Job.Status jobStatus, Date lastModifiedTime) throws Exception {
        BundleJobBean bundle = this.createBundleJob(jobStatus, false);
        bundle.setLastModifiedTime(lastModifiedTime);
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestBundleJobsGetForPurgeJPAExecutor.assertNotNull((Object)jpaService);
            BundleJobInsertJPAExecutor bundleInsertjpa = new BundleJobInsertJPAExecutor(bundle);
            jpaService.execute((JPAExecutor)bundleInsertjpa);
        }
        catch (JPAExecutorException ce) {
            ce.printStackTrace();
            TestBundleJobsGetForPurgeJPAExecutor.fail((String)"Unable to insert the test bundle job record to table");
            throw ce;
        }
        return bundle;
    }

    private void checkBundles(List<String> bundles, String ... bundleJobIDs) {
        TestBundleJobsGetForPurgeJPAExecutor.assertEquals((int)bundleJobIDs.length, (int)bundles.size());
        Arrays.sort(bundleJobIDs);
        Collections.sort(bundles);
        for (int i = 0; i < bundleJobIDs.length; ++i) {
            TestBundleJobsGetForPurgeJPAExecutor.assertEquals((String)bundleJobIDs[i], (String)bundles.get(i));
        }
    }
}

