/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.CoordActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionRemoveJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;

public class TestCoordActionRemoveJPAExecutor
extends XDataTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testCoordActionRemove() throws Exception {
        int actionNum = 1;
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        CoordinatorActionBean action = this.addRecordToCoordActionTable(job.getId(), actionNum, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0);
        this._testCoordActionRemove(job.getId(), action.getId());
    }

    private void _testCoordActionRemove(String jobId, String actionId) throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordActionRemoveJPAExecutor.assertNotNull((Object)jpaService);
        CoordActionRemoveJPAExecutor coordRmvCmd = new CoordActionRemoveJPAExecutor(actionId);
        jpaService.execute((JPAExecutor)coordRmvCmd);
        try {
            CoordActionGetJPAExecutor coordGetCmd = new CoordActionGetJPAExecutor(actionId);
            CoordinatorActionBean newAction = (CoordinatorActionBean)jpaService.execute((JPAExecutor)coordGetCmd);
            TestCoordActionRemoveJPAExecutor.fail((String)("Action " + actionId + " Should be removed"));
        }
        catch (JPAExecutorException jPAExecutorException) {
            // empty catch block
        }
    }

    public void testRunningActionDelete() throws Exception {
        block2: {
            CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
            CoordinatorActionBean action = this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestCoordActionRemoveJPAExecutor.assertNotNull((Object)jpaService);
            CoordActionRemoveJPAExecutor coordRmvCmd = new CoordActionRemoveJPAExecutor(action.getId());
            try {
                jpaService.execute((JPAExecutor)coordRmvCmd);
                TestCoordActionRemoveJPAExecutor.fail((String)"Should have thrown JPAExecutorException");
            }
            catch (JPAExecutorException e) {
                System.out.println(e.getErrorCode());
                e.printStackTrace();
                if (e.getErrorCode() == ErrorCode.E1022) break block2;
                TestCoordActionRemoveJPAExecutor.fail((String)"Error code should be E1022");
            }
        }
    }
}

