/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.CoordActionsActiveCountJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;

public class TestCoordActionsActiveCountJPAExecutor
extends XDataTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testCoordActionGet() throws Exception {
        int actionNum = 1;
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        this.addRecordToCoordActionTable(job.getId(), actionNum++, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0);
        this._testActiveActionsCount(job.getId(), 1);
        this.addRecordToCoordActionTable(job.getId(), actionNum++, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        this.addRecordToCoordActionTable(job.getId(), actionNum, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0);
        this._testActiveActionsCount(job.getId(), 2);
    }

    private void _testActiveActionsCount(String jobId, int expected) throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordActionsActiveCountJPAExecutor.assertNotNull((Object)jpaService);
        CoordActionsActiveCountJPAExecutor actionActiveCmd = new CoordActionsActiveCountJPAExecutor(jobId);
        int cnt = (Integer)jpaService.execute((JPAExecutor)actionActiveCmd);
        TestCoordActionsActiveCountJPAExecutor.assertEquals((int)cnt, (int)expected);
    }
}

