/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.Date;
import java.util.List;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.CoordJobGetReadyActionsJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;

public class TestCoordJobGetReadyActionsJPAExecutor
extends XDataTestCase {
    Services services;
    private final String[] excludedServices = new String[]{"org.apache.oozie.service.StatusTransitService", "org.apache.oozie.service.PauseTransitService", "org.apache.oozie.service.CoordMaterializeTriggerService", "org.apache.oozie.service.RecoveryService"};

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testCoordActionGetFIFO() throws Exception {
        this._testGetReadyActions("FIFO", false);
    }

    public void testCoordActionGetLIFO() throws Exception {
        this._testGetReadyActions("LIFO", true);
    }

    public void testCoordActionGetLAST_ONLY() throws Exception {
        this._testGetReadyActions("LAST_ONLY", true);
    }

    public void testCoordActionGetNONE() throws Exception {
        this._testGetReadyActions("NONE", true);
    }

    private void _testGetReadyActions(String execution, boolean reverseOrder) throws Exception {
        int[] nArray;
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        Date nomTime = new Date();
        this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0, nomTime);
        nomTime.setTime(nomTime.getTime() + 1000L);
        this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0, nomTime);
        nomTime.setTime(nomTime.getTime() + 1000L);
        this.addRecordToCoordActionTable(job.getId(), 3, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0, nomTime);
        this.getReadyActions(job.getId(), 0, execution);
        this.cleanUpDBTables();
        job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        if (reverseOrder) {
            int[] nArray2 = new int[2];
            nArray2[0] = 1;
            nArray = nArray2;
            nArray2[1] = 0;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 0;
            nArray = nArray3;
            nArray3[1] = 1;
        }
        int[] actionIndexes = nArray;
        nomTime = new Date();
        Date[] createdTimes = new Date[2];
        Date[] nomTimes = new Date[2];
        nomTimes[actionIndexes[0]] = new Date(nomTime.getTime());
        createdTimes[actionIndexes[0]] = this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.READY, "coord-action-get.xml", 0, nomTime).getCreatedTime();
        nomTime.setTime(nomTime.getTime() + 1000L);
        nomTimes[actionIndexes[1]] = new Date(nomTime.getTime());
        createdTimes[actionIndexes[1]] = this.addRecordToCoordActionTable(job.getId(), 2, CoordinatorAction.Status.READY, "coord-action-get.xml", 0, nomTime).getCreatedTime();
        nomTime.setTime(nomTime.getTime() + 1000L);
        this.addRecordToCoordActionTable(job.getId(), 3, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0, nomTime);
        List<CoordinatorActionBean> actions = this.getReadyActions(job.getId(), 2, execution);
        for (int i : actionIndexes) {
            TestCoordJobGetReadyActionsJPAExecutor.assertEquals((String)(job.getId() + "@" + (actionIndexes[i] + 1)), (String)actions.get(i).getId());
            TestCoordJobGetReadyActionsJPAExecutor.assertEquals((int)(actionIndexes[i] + 1), (int)actions.get(i).getActionNumber());
            TestCoordJobGetReadyActionsJPAExecutor.assertEquals((String)job.getId(), (String)actions.get(i).getJobId());
            TestCoordJobGetReadyActionsJPAExecutor.assertEquals((Object)CoordinatorAction.Status.READY, (Object)actions.get(i).getStatus());
            TestCoordJobGetReadyActionsJPAExecutor.assertEquals((Object)nomTimes[i], (Object)actions.get(i).getNominalTime());
            TestCoordJobGetReadyActionsJPAExecutor.assertEquals((Object)createdTimes[i], (Object)actions.get(i).getCreatedTime());
        }
    }

    private List<CoordinatorActionBean> getReadyActions(String jobId, int expected, String execution) throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobGetReadyActionsJPAExecutor.assertNotNull((Object)jpaService);
        CoordJobGetReadyActionsJPAExecutor actionGetCmd = new CoordJobGetReadyActionsJPAExecutor(jobId, execution);
        List actions = (List)jpaService.execute((JPAExecutor)actionGetCmd);
        TestCoordJobGetReadyActionsJPAExecutor.assertEquals((int)expected, (int)actions.size());
        return actions;
    }
}

