/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.executor.jpa.CoordJobGetRunningActionsCountJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;

public class TestCoordJobGetRunningActionsCountJPAExecutor
extends XDataTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testCoordActionGet() throws Exception {
        int actionNum = 1;
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        this.addRecordToCoordActionTable(job.getId(), actionNum, CoordinatorAction.Status.WAITING, "coord-action-get.xml", 0);
        this._testGetRunningActionsCount(job.getId(), 0);
        this.cleanUpDBTables();
        job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        this.addRecordToCoordActionTable(job.getId(), actionNum, CoordinatorAction.Status.SUBMITTED, "coord-action-get.xml", 0);
        this._testGetRunningActionsCount(job.getId(), 1);
        this.cleanUpDBTables();
        job = this.addRecordToCoordJobTable(Job.Status.RUNNING, false, false);
        this.addRecordToCoordActionTable(job.getId(), actionNum, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", 0);
        this._testGetRunningActionsCount(job.getId(), 1);
    }

    private void _testGetRunningActionsCount(String jobId, int expected) throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestCoordJobGetRunningActionsCountJPAExecutor.assertNotNull((Object)jpaService);
        CoordJobGetRunningActionsCountJPAExecutor actionGetCmd = new CoordJobGetRunningActionsCountJPAExecutor(jobId);
        int cnt = (Integer)jpaService.execute((JPAExecutor)actionGetCmd);
        TestCoordJobGetRunningActionsCountJPAExecutor.assertEquals((int)cnt, (int)expected);
    }
}

