/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.oozie.client.SLAEvent;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.SLAEventsGetForFilterJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;

public class TestSLAEventsGetForFilterJPAExecutor
extends XDataTestCase {
    Services services;
    String coordId1;
    String coordActionId1;
    String appName1;
    String coordId2;
    String coordActionId2;
    String appName2;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        this.populateDB();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    private void populateDB() throws Exception {
        Date current = new Date();
        long currentTime = current.getTime();
        this.coordId1 = "0000001-" + currentTime + "-TestSLAEventsGetForFilterJPAExecutor-C";
        this.coordActionId1 = "0000001-" + currentTime + "-TestSLAEventsGetForFilterJPAExecutor-C@1";
        this.appName1 = "app-1";
        this.coordId2 = "0000002-" + currentTime + "-TestSLAEventsGetForFilterJPAExecutor-C";
        this.coordActionId2 = "0000002-" + currentTime + "-TestSLAEventsGetForFilterJPAExecutor-C@1";
        this.appName2 = "app-2";
        this.addRecordToSLAEventTable(this.coordId1, this.appName1, SLAEvent.Status.CREATED, current);
        this.addRecordToSLAEventTable(this.coordActionId1, this.appName1, SLAEvent.Status.CREATED, current);
        this.addRecordToSLAEventTable(this.coordActionId1, this.appName1, SLAEvent.Status.STARTED, current);
        this.addRecordToSLAEventTable(this.coordActionId1, this.appName1, SLAEvent.Status.SUCCEEDED, current);
        this.addRecordToSLAEventTable(this.coordId2, this.appName2, SLAEvent.Status.CREATED, current);
        this.addRecordToSLAEventTable(this.coordActionId2, this.appName2, SLAEvent.Status.CREATED, current);
    }

    private Map<String, List<String>> createFilterList(String name, String ... vals) {
        HashMap<String, List<String>> filterList = new HashMap<String, List<String>>();
        List<String> valList = Arrays.asList(vals);
        filterList.put(name, valList);
        return filterList;
    }

    public void testGetSLAEventsForCoordJobId() throws Exception {
        Map<String, List<String>> filterListJob1 = this.createFilterList("jobid", this.coordId1);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestSLAEventsGetForFilterJPAExecutor.assertNotNull((Object)jpaService);
        SLAEventsGetForFilterJPAExecutor slaEventsGetCmd = new SLAEventsGetForFilterJPAExecutor(-1L, 100, filterListJob1, new long[1]);
        List list = (List)jpaService.execute((JPAExecutor)slaEventsGetCmd);
        TestSLAEventsGetForFilterJPAExecutor.assertNotNull((Object)list);
        TestSLAEventsGetForFilterJPAExecutor.assertEquals((int)1, (int)list.size());
    }

    public void testGetSLAEventsForCoordActionId() throws Exception {
        Map<String, List<String>> filterListAction1 = this.createFilterList("jobid", this.coordActionId1);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestSLAEventsGetForFilterJPAExecutor.assertNotNull((Object)jpaService);
        SLAEventsGetForFilterJPAExecutor slaEventsGetCmd = new SLAEventsGetForFilterJPAExecutor(-1L, 100, filterListAction1, new long[1]);
        List list = (List)jpaService.execute((JPAExecutor)slaEventsGetCmd);
        TestSLAEventsGetForFilterJPAExecutor.assertNotNull((Object)list);
        TestSLAEventsGetForFilterJPAExecutor.assertEquals((int)3, (int)list.size());
    }

    public void testGetSLAEventsForAppName() throws Exception {
        Map<String, List<String>> filterListApp2 = this.createFilterList("appname", this.appName2);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestSLAEventsGetForFilterJPAExecutor.assertNotNull((Object)jpaService);
        SLAEventsGetForFilterJPAExecutor slaEventsGetCmd = new SLAEventsGetForFilterJPAExecutor(0L, 100, filterListApp2, new long[1]);
        List list = (List)jpaService.execute((JPAExecutor)slaEventsGetCmd);
        TestSLAEventsGetForFilterJPAExecutor.assertNotNull((Object)list);
        TestSLAEventsGetForFilterJPAExecutor.assertEquals((int)2, (int)list.size());
    }

    public void testGetSLAEventsForOR() throws Exception {
        Map<String, List<String>> filterList = this.createFilterList("jobid", this.coordId1, this.coordActionId1);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestSLAEventsGetForFilterJPAExecutor.assertNotNull((Object)jpaService);
        SLAEventsGetForFilterJPAExecutor slaEventsGetCmd = new SLAEventsGetForFilterJPAExecutor(-1L, 100, filterList, new long[1]);
        List list = (List)jpaService.execute((JPAExecutor)slaEventsGetCmd);
        TestSLAEventsGetForFilterJPAExecutor.assertNotNull((Object)list);
        TestSLAEventsGetForFilterJPAExecutor.assertEquals((int)4, (int)list.size());
    }

    public void testGetSLAEventsForCombined() throws Exception {
        Map<String, List<String>> filterList = this.createFilterList("jobid", this.coordId1, this.coordActionId1);
        filterList.put("appname", Arrays.asList(this.appName1));
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestSLAEventsGetForFilterJPAExecutor.assertNotNull((Object)jpaService);
        long[] lastSeqId = new long[]{-1L};
        SLAEventsGetForFilterJPAExecutor slaEventsGetCmd = new SLAEventsGetForFilterJPAExecutor(-1L, 100, filterList, lastSeqId);
        List list = (List)jpaService.execute((JPAExecutor)slaEventsGetCmd);
        TestSLAEventsGetForFilterJPAExecutor.assertNotNull((Object)list);
        TestSLAEventsGetForFilterJPAExecutor.assertEquals((int)4, (int)list.size());
    }

    public void testGetSLAEventsWithRange() throws Exception {
        HashMap filterList = new HashMap();
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestSLAEventsGetForFilterJPAExecutor.assertNotNull((Object)jpaService);
        long[] lastSeqId = new long[]{-1L};
        SLAEventsGetForFilterJPAExecutor slaEventsGetCmd = new SLAEventsGetForFilterJPAExecutor(1L, 3, filterList, lastSeqId);
        List list = (List)jpaService.execute((JPAExecutor)slaEventsGetCmd);
        TestSLAEventsGetForFilterJPAExecutor.assertNotNull((Object)list);
        TestSLAEventsGetForFilterJPAExecutor.assertEquals((int)3, (int)list.size());
    }

    public void testGetSLAEventsForCombinedWithRange() throws Exception {
        Map<String, List<String>> filterList = this.createFilterList("jobid", this.coordId1, this.coordActionId1, this.coordId2, this.coordActionId2);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestSLAEventsGetForFilterJPAExecutor.assertNotNull((Object)jpaService);
        long[] lastSeqId = new long[]{-1L};
        SLAEventsGetForFilterJPAExecutor slaEventsGetCmd = new SLAEventsGetForFilterJPAExecutor(1L, 3, filterList, lastSeqId);
        List list = (List)jpaService.execute((JPAExecutor)slaEventsGetCmd);
        TestSLAEventsGetForFilterJPAExecutor.assertNotNull((Object)list);
        TestSLAEventsGetForFilterJPAExecutor.assertEquals((int)3, (int)list.size());
    }
}

