/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.Date;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.client.event.SLAEvent;
import org.apache.oozie.executor.jpa.SLASummaryQueryExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLASummaryBean;
import org.apache.oozie.test.XDataTestCase;

public class TestSLASummaryQueryExecutor
extends XDataTestCase {
    Services services;
    JPAService jpaService;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        this.jpaService = (JPAService)Services.get().get(JPAService.class);
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testGetQuery() throws Exception {
        EntityManager em = this.jpaService.getEntityManager();
        SLASummaryBean bean = this.addRecordToSLASummaryTable("test-sla-summary", SLAEvent.SLAStatus.IN_PROCESS);
        Query query = SLASummaryQueryExecutor.getInstance().getSelectQuery((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, em, new Object[]{bean.getId()});
        TestSLASummaryQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
        query = SLASummaryQueryExecutor.getInstance().getSelectQuery((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY_EVENTPROCESSED, em, new Object[]{bean.getId()});
        TestSLASummaryQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
    }

    public void testUpdateQuery() throws Exception {
        EntityManager em = this.jpaService.getEntityManager();
        SLASummaryBean bean = this.addRecordToSLASummaryTable("test-sla-summary", SLAEvent.SLAStatus.IN_PROCESS);
        Query query = SLASummaryQueryExecutor.getInstance().getUpdateQuery((Enum)SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_FOR_STATUS_ACTUAL_TIMES, (Object)bean, em);
        TestSLASummaryQueryExecutor.assertEquals((Object)query.getParameterValue("jobId"), (Object)bean.getId());
        TestSLASummaryQueryExecutor.assertEquals((Object)query.getParameterValue("slaStatus"), (Object)bean.getSLAStatus().toString());
        TestSLASummaryQueryExecutor.assertEquals((Object)query.getParameterValue("lastModifiedTS"), (Object)bean.getLastModifiedTimestamp());
        TestSLASummaryQueryExecutor.assertEquals((Object)query.getParameterValue("eventStatus"), (Object)bean.getEventStatus().toString());
        TestSLASummaryQueryExecutor.assertEquals((Object)query.getParameterValue("jobStatus"), (Object)bean.getJobStatus());
        TestSLASummaryQueryExecutor.assertEquals((Object)query.getParameterValue("eventProcessed"), (Object)bean.getEventProcessed());
        TestSLASummaryQueryExecutor.assertEquals((Object)query.getParameterValue("actualStartTS"), (Object)bean.getActualStartTimestamp());
        TestSLASummaryQueryExecutor.assertEquals((Object)query.getParameterValue("actualEndTS"), (Object)bean.getActualEndTimestamp());
        TestSLASummaryQueryExecutor.assertEquals((Object)query.getParameterValue("actualDuration"), (Object)bean.getActualDuration());
        query = SLASummaryQueryExecutor.getInstance().getUpdateQuery((Enum)SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_ALL, (Object)bean, em);
        TestSLASummaryQueryExecutor.assertEquals((Object)query.getParameterValue("appName"), (Object)bean.getAppName());
        TestSLASummaryQueryExecutor.assertEquals((Object)query.getParameterValue("appType"), (Object)bean.getAppType().toString());
        TestSLASummaryQueryExecutor.assertEquals((Object)query.getParameterValue("nominalTime"), (Object)bean.getNominalTimestamp());
        TestSLASummaryQueryExecutor.assertEquals((Object)query.getParameterValue("expectedStartTime"), (Object)bean.getExpectedStartTimestamp());
        TestSLASummaryQueryExecutor.assertEquals((Object)query.getParameterValue("expectedEndTime"), (Object)bean.getExpectedEndTimestamp());
        TestSLASummaryQueryExecutor.assertEquals((Object)query.getParameterValue("expectedDuration"), (Object)bean.getExpectedDuration());
        TestSLASummaryQueryExecutor.assertEquals((Object)query.getParameterValue("jobStatus"), (Object)bean.getJobStatus());
        TestSLASummaryQueryExecutor.assertEquals((Object)query.getParameterValue("slaStatus"), (Object)bean.getSLAStatus().toString());
        TestSLASummaryQueryExecutor.assertEquals((Object)query.getParameterValue("eventStatus"), (Object)bean.getEventStatus().toString());
        TestSLASummaryQueryExecutor.assertEquals((Object)query.getParameterValue("lastModTime"), (Object)bean.getLastModifiedTimestamp());
        TestSLASummaryQueryExecutor.assertEquals((Object)query.getParameterValue("user"), (Object)bean.getUser());
        TestSLASummaryQueryExecutor.assertEquals((Object)query.getParameterValue("parentId"), (Object)bean.getParentId());
        TestSLASummaryQueryExecutor.assertEquals((Object)query.getParameterValue("eventProcessed"), (Object)bean.getEventProcessed());
        TestSLASummaryQueryExecutor.assertEquals((Object)query.getParameterValue("actualDuration"), (Object)bean.getActualDuration());
        TestSLASummaryQueryExecutor.assertEquals((Object)query.getParameterValue("actualEndTS"), (Object)bean.getActualEndTimestamp());
        TestSLASummaryQueryExecutor.assertEquals((Object)query.getParameterValue("actualStartTS"), (Object)bean.getActualStartTimestamp());
        TestSLASummaryQueryExecutor.assertEquals((Object)query.getParameterValue("jobId"), (Object)bean.getId());
        em.close();
    }

    public void testExecuteUpdate() throws Exception {
        SLASummaryBean bean = this.addRecordToSLASummaryTable("test-sla-summary", SLAEvent.SLAStatus.IN_PROCESS);
        SLASummaryBean retBean = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{bean.getId()});
        Date createdTime = retBean.getCreatedTime();
        TestSLASummaryQueryExecutor.assertNotNull((Object)createdTime);
        Date startTime = new Date(System.currentTimeMillis() - 0x6DDD00L);
        Date endTime = new Date(System.currentTimeMillis() - 3600000L);
        bean.setActualStart(startTime);
        bean.setActualEnd(endTime);
        bean.setSLAStatus(SLAEvent.SLAStatus.MET);
        bean.setCreatedTime(startTime);
        SLASummaryQueryExecutor.getInstance().executeUpdate((Enum)SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_ALL, (Object)bean);
        retBean = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{bean.getId()});
        TestSLASummaryQueryExecutor.assertEquals((Object)bean.getActualStartTimestamp(), (Object)retBean.getActualStartTimestamp());
        TestSLASummaryQueryExecutor.assertEquals((Object)bean.getActualEndTimestamp(), (Object)retBean.getActualEndTimestamp());
        TestSLASummaryQueryExecutor.assertEquals((Object)SLAEvent.SLAStatus.MET, (Object)retBean.getSLAStatus());
        TestSLASummaryQueryExecutor.assertEquals((Object)createdTime, (Object)retBean.getCreatedTime());
        bean = this.addRecordToSLASummaryTable("test-sla-summary", SLAEvent.SLAStatus.IN_PROCESS);
        bean.setActualStart(startTime);
        bean.setActualStart(endTime);
        bean.setActualDuration(endTime.getTime() - startTime.getTime());
        bean.setLastModifiedTime(new Date());
        bean.setEventProcessed(8);
        SLASummaryQueryExecutor.getInstance().executeUpdate((Enum)SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_FOR_STATUS_ACTUAL_TIMES, (Object)bean);
        retBean = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{bean.getId()});
        TestSLASummaryQueryExecutor.assertEquals((Object)bean.getActualStartTimestamp(), (Object)retBean.getActualStartTimestamp());
        TestSLASummaryQueryExecutor.assertEquals((Object)bean.getActualEndTimestamp(), (Object)retBean.getActualEndTimestamp());
        TestSLASummaryQueryExecutor.assertEquals((long)bean.getActualDuration(), (long)retBean.getActualDuration());
        TestSLASummaryQueryExecutor.assertEquals((Object)bean.getLastModifiedTimestamp(), (Object)retBean.getLastModifiedTimestamp());
        TestSLASummaryQueryExecutor.assertEquals((byte)bean.getEventProcessed(), (byte)retBean.getEventProcessed());
    }

    public void testGet() throws Exception {
        SLASummaryBean bean = this.addRecordToSLASummaryTable("test-sla-summary", SLAEvent.SLAStatus.IN_PROCESS);
        SLASummaryBean sBean = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY_EVENTPROCESSED, new Object[]{bean.getId()});
        TestSLASummaryQueryExecutor.assertEquals((byte)bean.getEventProcessed(), (byte)sBean.getEventProcessed());
    }

    public void testGetValue() throws Exception {
        SLASummaryBean bean = this.addRecordToSLASummaryTable("test-sla-summary", SLAEvent.SLAStatus.IN_PROCESS);
        Object ret = ((SLASummaryQueryExecutor)SLASummaryQueryExecutor.getInstance()).getSingleValue(SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY_EVENTPROCESSED, new Object[]{bean.getId()});
        TestSLASummaryQueryExecutor.assertEquals((byte)bean.getEventProcessed(), (byte)((Byte)ret));
    }

    public void testGetList() throws Exception {
    }

    public void testInsert() throws Exception {
    }
}

