/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.Date;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.executor.jpa.WorkflowActionQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.workflow.WorkflowInstance;

public class TestWorkflowActionQueryExecutor
extends XDataTestCase {
    Services services;
    JPAService jpaService;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        this.jpaService = (JPAService)Services.get().get(JPAService.class);
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testGetUpdateQuery() throws Exception {
        EntityManager em = this.jpaService.getEntityManager();
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean bean = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.PREP);
        Query query = WorkflowActionQueryExecutor.getInstance().getUpdateQuery((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION, (Object)bean, em);
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("conf"), (Object)bean.getConfBlob());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("consoleUrl"), (Object)bean.getConsoleUrl());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("data"), (Object)bean.getDataBlob());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("stats"), (Object)bean.getStatsBlob());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("externalChildIDs"), (Object)bean.getExternalChildIDsBlob());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("errorCode"), (Object)bean.getErrorCode());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("errorMessage"), (Object)bean.getErrorMessage());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("externalId"), (Object)bean.getExternalId());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("externalStatus"), (Object)bean.getExternalStatus());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("name"), (Object)bean.getName());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("cred"), (Object)bean.getCred());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("retries"), (Object)bean.getRetries());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("trackerUri"), (Object)bean.getTrackerUri());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("transition"), (Object)bean.getTransition());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("type"), (Object)bean.getType());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("endTime"), (Object)bean.getEndTimestamp());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("executionPath"), (Object)bean.getExecutionPath());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("lastCheckTime"), (Object)bean.getLastCheckTimestamp());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("logToken"), (Object)bean.getLogToken());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("pending"), (Object)bean.getPending());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("pendingAge"), (Object)bean.getPendingAge());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("signalValue"), (Object)bean.getSignalValue());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("slaXml"), (Object)bean.getSlaXmlBlob());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("startTime"), (Object)bean.getStartTimestamp());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)bean.getStatus().toString());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("wfId"), (Object)bean.getWfId());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
        query = WorkflowActionQueryExecutor.getInstance().getUpdateQuery((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION, (Object)bean, em);
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("lastCheckTime"), (Object)bean.getLastCheckTimestamp());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
        query = WorkflowActionQueryExecutor.getInstance().getUpdateQuery((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_PENDING, (Object)bean, em);
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("pending"), (Object)bean.getPending());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("pendingAge"), (Object)bean.getPendingAgeTimestamp());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
        query = WorkflowActionQueryExecutor.getInstance().getUpdateQuery((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_STATUS_PENDING, (Object)bean, em);
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("pending"), (Object)bean.getPending());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("pendingAge"), (Object)bean.getPendingAgeTimestamp());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)bean.getStatus().toString());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
        query = WorkflowActionQueryExecutor.getInstance().getUpdateQuery((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_PENDING_TRANS, (Object)bean, em);
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("pending"), (Object)bean.getPending());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("pendingAge"), (Object)bean.getPendingAgeTimestamp());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("transition"), (Object)bean.getTransition());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
        query = WorkflowActionQueryExecutor.getInstance().getUpdateQuery((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_PENDING_TRANS_ERROR, (Object)bean, em);
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("pending"), (Object)bean.getPending());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("pendingAge"), (Object)bean.getPendingAgeTimestamp());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("transition"), (Object)bean.getTransition());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("errorCode"), (Object)bean.getErrorCode());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("errorMessage"), (Object)bean.getErrorMessage());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)bean.getStatusStr());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
        query = WorkflowActionQueryExecutor.getInstance().getUpdateQuery((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_START, (Object)bean, em);
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("startTime"), (Object)bean.getStartTimestamp());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("externalChildIDs"), (Object)bean.getExternalChildIDsBlob());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("conf"), (Object)bean.getConfBlob());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("errorCode"), (Object)bean.getErrorCode());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("errorMessage"), (Object)bean.getErrorMessage());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("externalId"), (Object)bean.getExternalId());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("trackerUri"), (Object)bean.getTrackerUri());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("consoleUrl"), (Object)bean.getConsoleUrl());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("lastCheckTime"), (Object)bean.getLastCheckTimestamp());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)bean.getStatus().toString());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("externalStatus"), (Object)bean.getExternalStatus());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("data"), (Object)bean.getDataBlob());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("retries"), (Object)bean.getRetries());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("pending"), (Object)bean.getPending());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("pendingAge"), (Object)bean.getPendingAgeTimestamp());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("userRetryCount"), (Object)bean.getUserRetryCount());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
        query = WorkflowActionQueryExecutor.getInstance().getUpdateQuery((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_CHECK, (Object)bean, em);
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("externalChildIDs"), (Object)bean.getExternalChildIDsBlob());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("externalStatus"), (Object)bean.getExternalStatus());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)bean.getStatus().toString());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("data"), (Object)bean.getDataBlob());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("pending"), (Object)bean.getPending());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("errorCode"), (Object)bean.getErrorCode());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("errorMessage"), (Object)bean.getErrorMessage());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("lastCheckTime"), (Object)bean.getLastCheckTimestamp());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("retries"), (Object)bean.getRetries());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("pendingAge"), (Object)bean.getPendingAgeTimestamp());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("startTime"), (Object)bean.getStartTimestamp());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("stats"), (Object)bean.getStatsBlob());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("userRetryCount"), (Object)bean.getUserRetryCount());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
        query = WorkflowActionQueryExecutor.getInstance().getUpdateQuery((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_END, (Object)bean, em);
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("errorCode"), (Object)bean.getErrorCode());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("errorMessage"), (Object)bean.getErrorMessage());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("retries"), (Object)bean.getRetries());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("endTime"), (Object)bean.getEndTimestamp());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)bean.getStatus().toString());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("retries"), (Object)bean.getRetries());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("pending"), (Object)bean.getPending());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("pendingAge"), (Object)bean.getPendingAgeTimestamp());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("signalValue"), (Object)bean.getSignalValue());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("userRetryCount"), (Object)bean.getUserRetryCount());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("externalStatus"), (Object)bean.getExternalStatus());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("stats"), (Object)bean.getStatsBlob());
        TestWorkflowActionQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
        em.close();
    }

    public void testExecuteUpdate() throws Exception {
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        WorkflowActionBean bean = this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.PREP);
        bean.setStatus(WorkflowAction.Status.RUNNING);
        bean.setName("test-name");
        WorkflowActionQueryExecutor.getInstance().executeUpdate((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION, (Object)bean);
        WorkflowActionBean retBean = (WorkflowActionBean)WorkflowActionQueryExecutor.getInstance().get((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION, new Object[]{bean.getId()});
        TestWorkflowActionQueryExecutor.assertEquals((String)"test-name", (String)retBean.getName());
        TestWorkflowActionQueryExecutor.assertEquals((Object)retBean.getStatus(), (Object)WorkflowAction.Status.RUNNING);
    }

    public void testGet() throws Exception {
        WorkflowActionBean bean = this.addRecordToWfActionTable("workflowId", "testAction", WorkflowAction.Status.PREP, "", true);
        WorkflowActionBean retBean = (WorkflowActionBean)WorkflowActionQueryExecutor.getInstance().get((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION_ID_TYPE_LASTCHECK, new Object[]{bean.getId()});
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getId(), (String)retBean.getId());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getType(), (String)retBean.getType());
        TestWorkflowActionQueryExecutor.assertEquals((Object)bean.getLastCheckTime(), (Object)retBean.getLastCheckTime());
        retBean = (WorkflowActionBean)WorkflowActionQueryExecutor.getInstance().get((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION_FAIL, new Object[]{bean.getId()});
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getId(), (String)retBean.getId());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getJobId(), (String)retBean.getJobId());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getName(), (String)retBean.getName());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getStatusStr(), (String)retBean.getStatusStr());
        TestWorkflowActionQueryExecutor.assertEquals((int)bean.getPending(), (int)retBean.getPending());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getType(), (String)retBean.getType());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getLogToken(), (String)retBean.getLogToken());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getTransition(), (String)retBean.getTransition());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getErrorCode(), (String)retBean.getErrorCode());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getErrorMessage(), (String)retBean.getErrorMessage());
        TestWorkflowActionQueryExecutor.assertNull((Object)retBean.getConf());
        TestWorkflowActionQueryExecutor.assertNull((Object)retBean.getSlaXml());
        TestWorkflowActionQueryExecutor.assertNull((Object)retBean.getData());
        TestWorkflowActionQueryExecutor.assertNull((Object)retBean.getStats());
        TestWorkflowActionQueryExecutor.assertNull((Object)retBean.getExternalChildIDs());
        retBean = (WorkflowActionBean)WorkflowActionQueryExecutor.getInstance().get((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION_SIGNAL, new Object[]{bean.getId()});
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getId(), (String)retBean.getId());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getJobId(), (String)retBean.getJobId());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getName(), (String)retBean.getName());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getStatusStr(), (String)retBean.getStatusStr());
        TestWorkflowActionQueryExecutor.assertEquals((int)bean.getPending(), (int)retBean.getPending());
        TestWorkflowActionQueryExecutor.assertEquals((long)bean.getPendingAge().getTime(), (long)retBean.getPendingAge().getTime());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getType(), (String)retBean.getType());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getLogToken(), (String)retBean.getLogToken());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getTransition(), (String)retBean.getTransition());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getErrorCode(), (String)retBean.getErrorCode());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getErrorMessage(), (String)retBean.getErrorMessage());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getExecutionPath(), (String)retBean.getExecutionPath());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getSignalValue(), (String)retBean.getSignalValue());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getSlaXml(), (String)retBean.getSlaXml());
        TestWorkflowActionQueryExecutor.assertNull((Object)retBean.getConf());
        TestWorkflowActionQueryExecutor.assertNull((Object)retBean.getData());
        TestWorkflowActionQueryExecutor.assertNull((Object)retBean.getStats());
        TestWorkflowActionQueryExecutor.assertNull((Object)retBean.getExternalChildIDs());
        retBean = (WorkflowActionBean)WorkflowActionQueryExecutor.getInstance().get((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION_CHECK, new Object[]{bean.getId()});
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getId(), (String)retBean.getId());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getJobId(), (String)retBean.getJobId());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getName(), (String)retBean.getName());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getStatusStr(), (String)retBean.getStatusStr());
        TestWorkflowActionQueryExecutor.assertEquals((int)bean.getPending(), (int)retBean.getPending());
        TestWorkflowActionQueryExecutor.assertEquals((long)bean.getPendingAge().getTime(), (long)retBean.getPendingAge().getTime());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getType(), (String)retBean.getType());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getLogToken(), (String)retBean.getLogToken());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getTransition(), (String)retBean.getTransition());
        TestWorkflowActionQueryExecutor.assertEquals((int)bean.getRetries(), (int)retBean.getRetries());
        TestWorkflowActionQueryExecutor.assertEquals((int)bean.getUserRetryCount(), (int)retBean.getUserRetryCount());
        TestWorkflowActionQueryExecutor.assertEquals((int)bean.getUserRetryMax(), (int)retBean.getUserRetryMax());
        TestWorkflowActionQueryExecutor.assertEquals((int)bean.getUserRetryInterval(), (int)retBean.getUserRetryInterval());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getTrackerUri(), (String)retBean.getTrackerUri());
        TestWorkflowActionQueryExecutor.assertEquals((long)bean.getStartTime().getTime(), (long)retBean.getStartTime().getTime());
        TestWorkflowActionQueryExecutor.assertEquals((long)bean.getEndTime().getTime(), (long)retBean.getEndTime().getTime());
        TestWorkflowActionQueryExecutor.assertEquals((long)bean.getLastCheckTime().getTime(), (long)retBean.getLastCheckTime().getTime());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getErrorCode(), (String)retBean.getErrorCode());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getErrorMessage(), (String)retBean.getErrorMessage());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getExternalId(), (String)retBean.getExternalId());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getExternalStatus(), (String)retBean.getExternalStatus());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getExternalChildIDs(), (String)retBean.getExternalChildIDs());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getConf(), (String)retBean.getConf());
        TestWorkflowActionQueryExecutor.assertNull((Object)retBean.getData());
        TestWorkflowActionQueryExecutor.assertNull((Object)retBean.getStats());
        TestWorkflowActionQueryExecutor.assertNull((Object)retBean.getSlaXml());
        retBean = (WorkflowActionBean)WorkflowActionQueryExecutor.getInstance().get((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION_END, new Object[]{bean.getId()});
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getId(), (String)retBean.getId());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getJobId(), (String)retBean.getJobId());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getName(), (String)retBean.getName());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getStatusStr(), (String)retBean.getStatusStr());
        TestWorkflowActionQueryExecutor.assertEquals((int)bean.getPending(), (int)retBean.getPending());
        TestWorkflowActionQueryExecutor.assertEquals((long)bean.getPendingAge().getTime(), (long)retBean.getPendingAge().getTime());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getType(), (String)retBean.getType());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getLogToken(), (String)retBean.getLogToken());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getTransition(), (String)retBean.getTransition());
        TestWorkflowActionQueryExecutor.assertEquals((int)bean.getRetries(), (int)retBean.getRetries());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getTrackerUri(), (String)retBean.getTrackerUri());
        TestWorkflowActionQueryExecutor.assertEquals((int)bean.getUserRetryCount(), (int)retBean.getUserRetryCount());
        TestWorkflowActionQueryExecutor.assertEquals((int)bean.getUserRetryMax(), (int)retBean.getUserRetryMax());
        TestWorkflowActionQueryExecutor.assertEquals((int)bean.getUserRetryInterval(), (int)retBean.getUserRetryInterval());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getExternalId(), (String)retBean.getExternalId());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getExternalStatus(), (String)retBean.getExternalStatus());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getExternalChildIDs(), (String)retBean.getExternalChildIDs());
        TestWorkflowActionQueryExecutor.assertEquals((long)bean.getStartTime().getTime(), (long)retBean.getStartTime().getTime());
        TestWorkflowActionQueryExecutor.assertEquals((long)bean.getEndTime().getTime(), (long)retBean.getEndTime().getTime());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getErrorCode(), (String)retBean.getErrorCode());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getErrorMessage(), (String)retBean.getErrorMessage());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getConf(), (String)retBean.getConf());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getData(), (String)retBean.getData());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getStats(), (String)retBean.getStats());
        TestWorkflowActionQueryExecutor.assertNull((Object)retBean.getSlaXml());
        retBean = (WorkflowActionBean)WorkflowActionQueryExecutor.getInstance().get((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION_COMPLETED, new Object[]{bean.getId()});
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getId(), (String)retBean.getId());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getJobId(), (String)retBean.getJobId());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getStatusStr(), (String)retBean.getStatusStr());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getType(), (String)retBean.getType());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getLogToken(), (String)retBean.getLogToken());
        TestWorkflowActionQueryExecutor.assertNull((Object)retBean.getSlaXml());
        TestWorkflowActionQueryExecutor.assertNull((Object)retBean.getConf());
        TestWorkflowActionQueryExecutor.assertNull((Object)retBean.getData());
        TestWorkflowActionQueryExecutor.assertNull((Object)retBean.getStats());
        TestWorkflowActionQueryExecutor.assertNull((Object)retBean.getExternalChildIDs());
        retBean = (WorkflowActionBean)WorkflowActionQueryExecutor.getInstance().get((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION, new Object[]{bean.getId()});
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getId(), (String)retBean.getId());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getJobId(), (String)retBean.getJobId());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getName(), (String)retBean.getName());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getStatusStr(), (String)retBean.getStatusStr());
        TestWorkflowActionQueryExecutor.assertEquals((int)bean.getPending(), (int)retBean.getPending());
        TestWorkflowActionQueryExecutor.assertEquals((long)bean.getPendingAge().getTime(), (long)retBean.getPendingAge().getTime());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getType(), (String)retBean.getType());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getLogToken(), (String)retBean.getLogToken());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getTransition(), (String)retBean.getTransition());
        TestWorkflowActionQueryExecutor.assertEquals((int)bean.getRetries(), (int)retBean.getRetries());
        TestWorkflowActionQueryExecutor.assertEquals((int)bean.getUserRetryCount(), (int)retBean.getUserRetryCount());
        TestWorkflowActionQueryExecutor.assertEquals((int)bean.getUserRetryMax(), (int)retBean.getUserRetryMax());
        TestWorkflowActionQueryExecutor.assertEquals((int)bean.getUserRetryInterval(), (int)retBean.getUserRetryInterval());
        TestWorkflowActionQueryExecutor.assertEquals((long)bean.getStartTime().getTime(), (long)retBean.getStartTime().getTime());
        TestWorkflowActionQueryExecutor.assertEquals((long)bean.getEndTime().getTime(), (long)retBean.getEndTime().getTime());
        TestWorkflowActionQueryExecutor.assertEquals((long)bean.getCreatedTime().getTime(), (long)retBean.getCreatedTime().getTime());
        TestWorkflowActionQueryExecutor.assertEquals((long)bean.getLastCheckTime().getTime(), (long)retBean.getLastCheckTime().getTime());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getErrorCode(), (String)retBean.getErrorCode());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getErrorMessage(), (String)retBean.getErrorMessage());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getExecutionPath(), (String)retBean.getExecutionPath());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getSignalValue(), (String)retBean.getSignalValue());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getCred(), (String)retBean.getCred());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getConf(), (String)retBean.getConf());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getSlaXml(), (String)retBean.getSlaXml());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getData(), (String)retBean.getData());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getStats(), (String)retBean.getStats());
        TestWorkflowActionQueryExecutor.assertEquals((String)bean.getExternalChildIDs(), (String)retBean.getExternalChildIDs());
    }

    public void testGetList() throws Exception {
        this.addRecordToWfActionTable("wrkflow", "1", WorkflowAction.Status.RUNNING, true);
        this.addRecordToWfActionTable("wrkflow", "2", WorkflowAction.Status.RUNNING, true);
        this.addRecordToWfActionTable("wrkflow", "3", WorkflowAction.Status.RUNNING, true);
        this.addRecordToWfActionTable("wrkflow", "4", WorkflowAction.Status.PREP, true);
        this.addRecordToWfActionTable("wrkflow", "5", WorkflowAction.Status.FAILED, true);
        this.addRecordToWfActionTable("wrkflow", "6", WorkflowAction.Status.FAILED, false);
        List retList = WorkflowActionQueryExecutor.getInstance().getList((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.GET_RUNNING_ACTIONS, new Object[]{0});
        TestWorkflowActionQueryExecutor.assertEquals((int)3, (int)retList.size());
        for (WorkflowActionBean bean : retList) {
            TestWorkflowActionQueryExecutor.assertTrue((bean.getId().equals("wrkflow@1") || bean.getId().equals("wrkflow@2") || bean.getId().equals("wrkflow@3") ? 1 : 0) != 0);
        }
        this.sleep(10);
        long olderThan = 1L;
        long createdTimeInterval = new Date().getTime() - 3600000L;
        retList = WorkflowActionQueryExecutor.getInstance().getList((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.GET_PENDING_ACTIONS, new Object[]{olderThan, createdTimeInterval});
        TestWorkflowActionQueryExecutor.assertEquals((int)2, (int)retList.size());
        for (WorkflowActionBean bean : retList) {
            TestWorkflowActionQueryExecutor.assertTrue((bean.getId().equals("wrkflow@4") || bean.getId().equals("wrkflow@5") ? 1 : 0) != 0);
        }
        olderThan = 10000L;
        retList = WorkflowActionQueryExecutor.getInstance().getList((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.GET_PENDING_ACTIONS, new Object[]{olderThan, createdTimeInterval});
        TestWorkflowActionQueryExecutor.assertEquals((int)0, (int)retList.size());
    }

    public void testInsert() throws Exception {
        WorkflowActionBean bean = new WorkflowActionBean();
        bean.setId("test-oozie-action");
        bean.setName("test");
        WorkflowJobQueryExecutor.getInstance().insert((JsonBean)bean);
        WorkflowActionBean retBean = (WorkflowActionBean)WorkflowActionQueryExecutor.getInstance().get((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.GET_ACTION, new Object[]{"test-oozie-action"});
        TestWorkflowActionQueryExecutor.assertEquals((String)retBean.getName(), (String)"test");
    }
}

