/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.List;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionsGetForJobJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.workflow.WorkflowInstance;

public class TestWorkflowActionsGetForJobJPAExecutor
extends XDataTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testWfActionsGet() throws Exception {
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        this.addRecordToWfActionTable(job.getId(), "1", WorkflowAction.Status.OK);
        this.addRecordToWfActionTable(job.getId(), "2", WorkflowAction.Status.OK);
        this.addRecordToWfActionTable(job.getId(), "3", WorkflowAction.Status.PREP);
        this._testGetActions(job.getId());
    }

    private void _testGetActions(String jobId) throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestWorkflowActionsGetForJobJPAExecutor.assertNotNull((Object)jpaService);
        WorkflowActionsGetForJobJPAExecutor actionsGetExe = new WorkflowActionsGetForJobJPAExecutor(jobId);
        List list = (List)jpaService.execute((JPAExecutor)actionsGetExe);
        TestWorkflowActionsGetForJobJPAExecutor.assertNotNull((Object)list);
        TestWorkflowActionsGetForJobJPAExecutor.assertEquals((int)list.size(), (int)3);
    }
}

