/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowIdGetForExternalIdJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobInsertJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.LiteWorkflowStoreService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.workflow.WorkflowApp;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.lite.EndNodeDef;
import org.apache.oozie.workflow.lite.LiteWorkflowApp;
import org.apache.oozie.workflow.lite.NodeDef;
import org.apache.oozie.workflow.lite.StartNodeDef;

public class TestWorkflowIdGetForExternalIdJPAExecutor
extends XDataTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testWfJobIdForExternalId() throws Exception {
        WorkflowJobBean job = this.addRecordToWfJobTable(WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        this._testGetJobIdForExternalId(job.getId());
    }

    private void _testGetJobIdForExternalId(String jobId) throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestWorkflowIdGetForExternalIdJPAExecutor.assertNotNull((Object)jpaService);
        WorkflowIdGetForExternalIdJPAExecutor wfIdGetCmd = new WorkflowIdGetForExternalIdJPAExecutor("external-id");
        String ret = (String)jpaService.execute((JPAExecutor)wfIdGetCmd);
        TestWorkflowIdGetForExternalIdJPAExecutor.assertNotNull((Object)ret);
        TestWorkflowIdGetForExternalIdJPAExecutor.assertEquals((String)jobId, (String)ret);
    }

    @Override
    protected WorkflowJobBean addRecordToWfJobTable(WorkflowJob.Status jobStatus, WorkflowInstance.Status instanceStatus) throws Exception {
        LiteWorkflowApp app = new LiteWorkflowApp("testApp", "<workflow-app/>", new StartNodeDef(LiteWorkflowStoreService.LiteControlNodeHandler.class, "end")).addNode((NodeDef)new EndNodeDef("end", LiteWorkflowStoreService.LiteControlNodeHandler.class));
        Configuration conf = new Configuration();
        conf.set("oozie.wf.application.path", "testPath");
        conf.set("oozie.wf.log.token", "testToken");
        conf.set("user.name", TestWorkflowIdGetForExternalIdJPAExecutor.getTestUser());
        WorkflowJobBean wfBean = this.createWorkflow((WorkflowApp)app, conf, jobStatus, instanceStatus);
        wfBean.setExternalId("external-id");
        try {
            JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
            TestWorkflowIdGetForExternalIdJPAExecutor.assertNotNull((Object)jpaService);
            WorkflowJobInsertJPAExecutor wfInsertCmd = new WorkflowJobInsertJPAExecutor(wfBean);
            jpaService.execute((JPAExecutor)wfInsertCmd);
        }
        catch (JPAExecutorException je) {
            je.printStackTrace();
            TestWorkflowIdGetForExternalIdJPAExecutor.fail((String)"Unable to insert the test wf job record to table");
            throw je;
        }
        return wfBean;
    }
}

