/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorEngine;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.workflow.WorkflowInstance;

public class TestWorkflowJobQueryExecutor
extends XDataTestCase {
    Services services;
    JPAService jpaService;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        this.jpaService = (JPAService)Services.get().get(JPAService.class);
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testGetUpdateQuery() throws Exception {
        EntityManager em = this.jpaService.getEntityManager();
        WorkflowJobBean bean = this.addRecordToWfJobTable(WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        Query query = WorkflowJobQueryExecutor.getInstance().getUpdateQuery((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW, (Object)bean, em);
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("appName"), (Object)bean.getAppName());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("appPath"), (Object)bean.getAppPath());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("conf"), (Object)bean.getConfBlob());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("groupName"), (Object)bean.getGroup());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("run"), (Object)bean.getRun());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("user"), (Object)bean.getUser());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("createdTime"), (Object)bean.getCreatedTimestamp());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("endTime"), (Object)bean.getEndTimestamp());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("externalId"), (Object)bean.getExternalId());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("lastModTime"), (Object)bean.getLastModifiedTimestamp());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("logToken"), (Object)bean.getLogToken());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("protoActionConf"), (Object)bean.getProtoActionConfBlob());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("slaXml"), (Object)bean.getSlaXmlBlob());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("startTime"), (Object)bean.getStartTimestamp());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)bean.getStatus().toString());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("wfInstance"), (Object)bean.getWfInstanceBlob());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
        query = WorkflowJobQueryExecutor.getInstance().getUpdateQuery((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_MODTIME, (Object)bean, em);
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("lastModTime"), (Object)bean.getLastModifiedTimestamp());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
        query = WorkflowJobQueryExecutor.getInstance().getUpdateQuery((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_MODTIME, (Object)bean, em);
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)bean.getStatus().toString());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("lastModTime"), (Object)bean.getLastModifiedTimestamp());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
        query = WorkflowJobQueryExecutor.getInstance().getUpdateQuery((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_PARENT_MODIFIED, (Object)bean, em);
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("parentId"), (Object)bean.getParentId());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("lastModTime"), (Object)bean.getLastModifiedTimestamp());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
        query = WorkflowJobQueryExecutor.getInstance().getUpdateQuery((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MODIFIED, (Object)bean, em);
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)bean.getStatus().toString());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("wfInstance"), (Object)bean.getWfInstanceBlob());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("lastModTime"), (Object)bean.getLastModifiedTimestamp());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
        query = WorkflowJobQueryExecutor.getInstance().getUpdateQuery((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_END, (Object)bean, em);
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)bean.getStatus().toString());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("wfInstance"), (Object)bean.getWfInstanceBlob());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("lastModTime"), (Object)bean.getLastModifiedTimestamp());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("endTime"), (Object)bean.getEndTimestamp());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
        query = WorkflowJobQueryExecutor.getInstance().getUpdateQuery((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_END, (Object)bean, em);
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)bean.getStatus().toString());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("wfInstance"), (Object)bean.getWfInstanceBlob());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("lastModTime"), (Object)bean.getLastModifiedTimestamp());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("endTime"), (Object)bean.getEndTimestamp());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
        query = WorkflowJobQueryExecutor.getInstance().getUpdateQuery((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_START_END, (Object)bean, em);
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)bean.getStatus().toString());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("wfInstance"), (Object)bean.getWfInstanceBlob());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("lastModTime"), (Object)bean.getLastModifiedTimestamp());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("startTime"), (Object)bean.getStartTimestamp());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("endTime"), (Object)bean.getEndTimestamp());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
        query = WorkflowJobQueryExecutor.getInstance().getUpdateQuery((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_RERUN, (Object)bean, em);
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("appName"), (Object)bean.getAppName());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("protoActionConf"), (Object)bean.getProtoActionConfBlob());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("appPath"), (Object)bean.getAppPath());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("conf"), (Object)bean.getConfBlob());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("logToken"), (Object)bean.getLogToken());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("user"), (Object)bean.getUser());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("group"), (Object)bean.getGroup());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("externalId"), (Object)bean.getExternalId());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("endTime"), (Object)bean.getEndTimestamp());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("run"), (Object)bean.getRun());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("status"), (Object)bean.getStatus().toString());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("wfInstance"), (Object)bean.getWfInstanceBlob());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("lastModTime"), (Object)bean.getLastModifiedTimestamp());
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
    }

    public void testExecuteUpdate() throws Exception {
        WorkflowJobBean bean = this.addRecordToWfJobTable(WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        bean.setStatus(WorkflowJob.Status.RUNNING);
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW, (Object)bean);
        WorkflowJobBean bean2 = (WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW, new Object[]{bean.getId()});
        TestWorkflowJobQueryExecutor.assertEquals((Object)bean2.getStatus(), (Object)WorkflowJob.Status.RUNNING);
    }

    public void testGetSelectQuery() throws Exception {
        EntityManager em = this.jpaService.getEntityManager();
        WorkflowJobBean bean = this.addRecordToWfJobTable(WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        Query query = WorkflowJobQueryExecutor.getInstance().getSelectQuery((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW, em, new Object[]{bean.getId()});
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
        query = WorkflowJobQueryExecutor.getInstance().getSelectQuery((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_SUSPEND, em, new Object[]{bean.getId()});
        TestWorkflowJobQueryExecutor.assertEquals((Object)query.getParameterValue("id"), (Object)bean.getId());
    }

    public void testInsert() throws Exception {
        WorkflowJobBean bean = new WorkflowJobBean();
        bean.setId("test-oozie-wrk");
        bean.setAppName("test");
        bean.setUser("oozie");
        WorkflowJobQueryExecutor.getInstance().insert((JsonBean)bean);
        WorkflowJobBean retBean = (WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW, new Object[]{"test-oozie-wrk"});
        TestWorkflowJobQueryExecutor.assertNotNull((Object)retBean);
        TestWorkflowJobQueryExecutor.assertEquals((String)retBean.getAppName(), (String)"test");
        TestWorkflowJobQueryExecutor.assertEquals((String)retBean.getUser(), (String)"oozie");
    }

    public void testGet() throws Exception {
        WorkflowJobBean bean = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING);
        TestWorkflowJobQueryExecutor.assertNotNull((Object)bean.getProtoActionConf());
        bean.setStartTime(new Date(System.currentTimeMillis() - 10L));
        bean.setEndTime(new Date());
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW, (Object)bean);
        WorkflowJobBean retBean = (WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_STARTTIME, new Object[]{bean.getId()});
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getId(), (String)retBean.getId());
        TestWorkflowJobQueryExecutor.assertEquals((long)bean.getStartTime().getTime(), (long)retBean.getStartTime().getTime());
        TestWorkflowJobQueryExecutor.assertNull((Object)retBean.getWorkflowInstance());
        TestWorkflowJobQueryExecutor.assertNull((Object)retBean.getProtoActionConf());
        TestWorkflowJobQueryExecutor.assertNull((Object)retBean.getSlaXml());
        TestWorkflowJobQueryExecutor.assertNull((Object)retBean.getConf());
        retBean = (WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_START_END_TIME, new Object[]{bean.getId()});
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getId(), (String)retBean.getId());
        TestWorkflowJobQueryExecutor.assertEquals((long)bean.getStartTime().getTime(), (long)retBean.getStartTime().getTime());
        TestWorkflowJobQueryExecutor.assertEquals((long)bean.getEndTime().getTime(), (long)retBean.getEndTime().getTime());
        TestWorkflowJobQueryExecutor.assertNull((Object)retBean.getWorkflowInstance());
        TestWorkflowJobQueryExecutor.assertNull((Object)retBean.getProtoActionConf());
        TestWorkflowJobQueryExecutor.assertNull((Object)retBean.getSlaXml());
        TestWorkflowJobQueryExecutor.assertNull((Object)retBean.getConf());
        retBean = (WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_USER_GROUP, new Object[]{bean.getId()});
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getUser(), (String)retBean.getUser());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getGroup(), (String)retBean.getGroup());
        TestWorkflowJobQueryExecutor.assertNull((Object)retBean.getWorkflowInstance());
        TestWorkflowJobQueryExecutor.assertNull((Object)retBean.getProtoActionConf());
        TestWorkflowJobQueryExecutor.assertNull((Object)retBean.getSlaXml());
        TestWorkflowJobQueryExecutor.assertNull((Object)retBean.getConf());
        retBean = (WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_SUSPEND, new Object[]{bean.getId()});
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getId(), (String)retBean.getId());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getUser(), (String)retBean.getUser());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getGroup(), (String)retBean.getGroup());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getAppName(), (String)retBean.getAppName());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getStatusStr(), (String)retBean.getStatusStr());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getParentId(), (String)retBean.getParentId());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getLogToken(), (String)retBean.getLogToken());
        TestWorkflowJobQueryExecutor.assertEquals((int)ByteBuffer.wrap(bean.getWfInstanceBlob().getBytes()).getInt(), (int)ByteBuffer.wrap(retBean.getWfInstanceBlob().getBytes()).getInt());
        TestWorkflowJobQueryExecutor.assertEquals((long)bean.getStartTime().getTime(), (long)retBean.getStartTime().getTime());
        TestWorkflowJobQueryExecutor.assertEquals((long)bean.getEndTime().getTime(), (long)retBean.getEndTime().getTime());
        TestWorkflowJobQueryExecutor.assertNull((Object)retBean.getProtoActionConf());
        TestWorkflowJobQueryExecutor.assertNull((Object)retBean.getSlaXml());
        TestWorkflowJobQueryExecutor.assertNull((Object)retBean.getConf());
        retBean = (WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_ACTION_OP, new Object[]{bean.getId()});
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getId(), (String)retBean.getId());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getUser(), (String)retBean.getUser());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getGroup(), (String)retBean.getGroup());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getAppName(), (String)retBean.getAppName());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getAppPath(), (String)retBean.getAppPath());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getStatusStr(), (String)retBean.getStatusStr());
        TestWorkflowJobQueryExecutor.assertEquals((int)bean.getRun(), (int)retBean.getRun());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getParentId(), (String)retBean.getParentId());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getLogToken(), (String)retBean.getLogToken());
        TestWorkflowJobQueryExecutor.assertEquals((int)ByteBuffer.wrap(bean.getWfInstanceBlob().getBytes()).getInt(), (int)ByteBuffer.wrap(retBean.getWfInstanceBlob().getBytes()).getInt());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getProtoActionConf(), (String)retBean.getProtoActionConf());
        TestWorkflowJobQueryExecutor.assertNull((Object)retBean.getSlaXml());
        TestWorkflowJobQueryExecutor.assertNull((Object)retBean.getConf());
        retBean = (WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_RERUN, new Object[]{bean.getId()});
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getId(), (String)retBean.getId());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getUser(), (String)retBean.getUser());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getGroup(), (String)retBean.getGroup());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getAppName(), (String)retBean.getAppName());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getStatusStr(), (String)retBean.getStatusStr());
        TestWorkflowJobQueryExecutor.assertEquals((int)bean.getRun(), (int)retBean.getRun());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getLogToken(), (String)retBean.getLogToken());
        TestWorkflowJobQueryExecutor.assertEquals((int)ByteBuffer.wrap(bean.getWfInstanceBlob().getBytes()).getInt(), (int)ByteBuffer.wrap(retBean.getWfInstanceBlob().getBytes()).getInt());
        TestWorkflowJobQueryExecutor.assertNull((Object)retBean.getProtoActionConf());
        TestWorkflowJobQueryExecutor.assertNull((Object)retBean.getSlaXml());
        TestWorkflowJobQueryExecutor.assertNull((Object)retBean.getConf());
        retBean = (WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_DEFINITION, new Object[]{bean.getId()});
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getId(), (String)retBean.getId());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getUser(), (String)retBean.getUser());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getGroup(), (String)retBean.getGroup());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getAppName(), (String)retBean.getAppName());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getLogToken(), (String)retBean.getLogToken());
        TestWorkflowJobQueryExecutor.assertEquals((int)ByteBuffer.wrap(bean.getWfInstanceBlob().getBytes()).getInt(), (int)ByteBuffer.wrap(retBean.getWfInstanceBlob().getBytes()).getInt());
        TestWorkflowJobQueryExecutor.assertNull((Object)retBean.getProtoActionConf());
        TestWorkflowJobQueryExecutor.assertNull((Object)retBean.getSlaXml());
        TestWorkflowJobQueryExecutor.assertNull((Object)retBean.getConf());
        retBean = (WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_KILL, new Object[]{bean.getId()});
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getId(), (String)retBean.getId());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getUser(), (String)retBean.getUser());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getGroup(), (String)retBean.getGroup());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getAppName(), (String)retBean.getAppName());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getAppPath(), (String)retBean.getAppPath());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getStatusStr(), (String)retBean.getStatusStr());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getParentId(), (String)retBean.getParentId());
        TestWorkflowJobQueryExecutor.assertEquals((long)bean.getStartTime().getTime(), (long)retBean.getStartTime().getTime());
        TestWorkflowJobQueryExecutor.assertEquals((long)bean.getEndTime().getTime(), (long)retBean.getEndTime().getTime());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getLogToken(), (String)retBean.getLogToken());
        TestWorkflowJobQueryExecutor.assertEquals((int)ByteBuffer.wrap(bean.getWfInstanceBlob().getBytes()).getInt(), (int)ByteBuffer.wrap(retBean.getWfInstanceBlob().getBytes()).getInt());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getSlaXml(), (String)retBean.getSlaXml());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getProtoActionConf(), (String)retBean.getProtoActionConf());
        TestWorkflowJobQueryExecutor.assertNull((Object)retBean.getConf());
        retBean = (WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_RESUME, new Object[]{bean.getId()});
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getId(), (String)retBean.getId());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getUser(), (String)retBean.getUser());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getGroup(), (String)retBean.getGroup());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getAppName(), (String)retBean.getAppName());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getAppPath(), (String)retBean.getAppPath());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getStatusStr(), (String)retBean.getStatusStr());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getParentId(), (String)retBean.getParentId());
        TestWorkflowJobQueryExecutor.assertEquals((long)bean.getStartTime().getTime(), (long)retBean.getStartTime().getTime());
        TestWorkflowJobQueryExecutor.assertEquals((long)bean.getEndTime().getTime(), (long)retBean.getEndTime().getTime());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getLogToken(), (String)retBean.getLogToken());
        TestWorkflowJobQueryExecutor.assertEquals((int)ByteBuffer.wrap(bean.getWfInstanceBlob().getBytes()).getInt(), (int)ByteBuffer.wrap(retBean.getWfInstanceBlob().getBytes()).getInt());
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getProtoActionConf(), (String)retBean.getProtoActionConf());
        TestWorkflowJobQueryExecutor.assertNull((Object)retBean.getConf());
        TestWorkflowJobQueryExecutor.assertNull((Object)retBean.getSlaXml());
        retBean = (WorkflowJobBean)WorkflowJobQueryExecutor.getInstance().get((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_WORKFLOW_STATUS, new Object[]{bean.getId()});
        TestWorkflowJobQueryExecutor.assertEquals((String)bean.getId(), (String)retBean.getId());
        TestWorkflowJobQueryExecutor.assertEquals((Object)bean.getStatus(), (Object)retBean.getStatus());
    }

    public void testGetList() throws Exception {
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, null, null, false, false, 1);
        WorkflowJobBean wfJob1 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, coordJob.getId() + "@2");
        CoordinatorActionBean coordAction1 = this.addRecordToCoordActionTable(coordJob.getId(), 2, CoordinatorAction.Status.SUCCEEDED, "coord-action-get.xml", wfJob1.getId(), "SUCCEEDED", 0);
        WorkflowJobBean wfJob2 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, coordJob.getId() + "@2");
        CoordinatorEngine ce = new CoordinatorEngine(TestWorkflowJobQueryExecutor.getTestUser());
        List wfsForRerun = ce.getReruns(coordAction1.getId());
        TestWorkflowJobQueryExecutor.assertEquals((int)2, (int)wfsForRerun.size());
        TestWorkflowJobQueryExecutor.assertEquals((String)wfJob1.getId(), (String)((WorkflowJobBean)wfsForRerun.get(0)).getId());
        TestWorkflowJobQueryExecutor.assertEquals((String)wfJob2.getId(), (String)((WorkflowJobBean)wfsForRerun.get(1)).getId());
        coordJob = this.addRecordToCoordJobTable(Job.Status.RUNNING, null, null, false, false, 1);
        wfJob1 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, coordJob.getId() + "@1");
        wfJob1.setEndTime(DateUtils.parseDateOozieTZ((String)"2009-12-18T03:00Z"));
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW, (Object)wfJob1);
        wfJob2 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, coordJob.getId() + "@2");
        wfJob2.setEndTime(DateUtils.parseDateOozieTZ((String)"2009-12-18T03:00Z"));
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW, (Object)wfJob2);
        long olderthan = 30L;
        List jobBeans = WorkflowJobQueryExecutor.getInstance().getList((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.GET_COMPLETED_COORD_WORKFLOWS_OLDER_THAN, new Object[]{olderthan, 0, 10});
        HashSet<String> jobIds = new HashSet<String>(Arrays.asList(wfJob1.getId(), wfJob2.getId()));
        TestWorkflowJobQueryExecutor.assertEquals((int)2, (int)jobBeans.size());
        TestWorkflowJobQueryExecutor.assertTrue((boolean)jobIds.contains(((WorkflowJobBean)jobBeans.get(0)).getId()));
        TestWorkflowJobQueryExecutor.assertTrue((boolean)jobIds.contains(((WorkflowJobBean)jobBeans.get(1)).getId()));
    }
}

