/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobsBasicInfoFromCoordParentIdJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.workflow.WorkflowInstance;

public class TestWorkflowJobsBasicInfoFromCoordParentIdJPAExecutor
extends XDataTestCase {
    Services services;
    private String[] excludedServices = new String[]{"org.apache.oozie.service.StatusTransitService", "org.apache.oozie.service.PauseTransitService", "org.apache.oozie.service.PurgeService", "org.apache.oozie.service.CoordMaterializeTriggerService", "org.apache.oozie.service.RecoveryService"};

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testGetCoordinatorParent() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestWorkflowJobsBasicInfoFromCoordParentIdJPAExecutor.assertNotNull((Object)jpaService);
        HashMap<String, WorkflowJobBean> wflist = new HashMap<String, WorkflowJobBean>();
        CoordinatorJobBean coordJobA = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        CoordinatorJobBean coordJobB = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        WorkflowJobBean wfJobA1 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, coordJobA.getId() + "@1");
        WorkflowJobBean wfJobA2 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, coordJobA.getId() + "@2");
        WorkflowJobBean wfJobB = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, coordJobB.getId() + "@1");
        ArrayList<Object> children = new ArrayList<WorkflowJobBean>();
        children.addAll((Collection)jpaService.execute((JPAExecutor)new WorkflowJobsBasicInfoFromCoordParentIdJPAExecutor(coordJobA.getId(), 10)));
        wflist.put(wfJobA1.getId(), wfJobA1);
        wflist.put(wfJobA2.getId(), wfJobA2);
        this.checkChildren(children, wflist);
        children = new ArrayList();
        children.addAll((Collection)jpaService.execute((JPAExecutor)new WorkflowJobsBasicInfoFromCoordParentIdJPAExecutor(coordJobB.getId(), 10)));
        wflist.clear();
        wflist.put(wfJobB.getId(), wfJobB);
        this.checkChildren(children, wflist);
    }

    public void testGetWorkflowParentTooMany() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestWorkflowJobsBasicInfoFromCoordParentIdJPAExecutor.assertNotNull((Object)jpaService);
        HashMap<String, WorkflowJobBean> wflist = new HashMap<String, WorkflowJobBean>();
        CoordinatorJobBean coordJob = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, false, false);
        WorkflowJobBean wfJob1 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, coordJob.getId());
        WorkflowJobBean wfJob2 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, coordJob.getId());
        WorkflowJobBean wfJob3 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, coordJob.getId());
        WorkflowJobBean wfJob4 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, coordJob.getId());
        WorkflowJobBean wfJob5 = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED, coordJob.getId());
        ArrayList<WorkflowJobBean> children = new ArrayList<WorkflowJobBean>();
        children.addAll((Collection)jpaService.execute((JPAExecutor)new WorkflowJobsBasicInfoFromCoordParentIdJPAExecutor(coordJob.getId(), 3)));
        TestWorkflowJobsBasicInfoFromCoordParentIdJPAExecutor.assertEquals((int)3, (int)children.size());
        children.addAll((Collection)jpaService.execute((JPAExecutor)new WorkflowJobsBasicInfoFromCoordParentIdJPAExecutor(coordJob.getId(), 3, 3)));
        TestWorkflowJobsBasicInfoFromCoordParentIdJPAExecutor.assertEquals((int)5, (int)children.size());
        wflist.put(wfJob1.getId(), wfJob1);
        wflist.put(wfJob2.getId(), wfJob2);
        wflist.put(wfJob3.getId(), wfJob3);
        wflist.put(wfJob4.getId(), wfJob4);
        wflist.put(wfJob5.getId(), wfJob5);
        this.checkChildren(children, wflist);
    }

    private void checkChildren(List<WorkflowJobBean> children, HashMap<String, WorkflowJobBean> wfJobBaselist) {
        TestWorkflowJobsBasicInfoFromCoordParentIdJPAExecutor.assertEquals((int)wfJobBaselist.size(), (int)children.size());
        for (int i = 0; i < children.size(); ++i) {
            WorkflowJobBean wfJobBase = wfJobBaselist.get(children.get(i).getId());
            TestWorkflowJobsBasicInfoFromCoordParentIdJPAExecutor.assertNotNull((Object)wfJobBase);
            TestWorkflowJobsBasicInfoFromCoordParentIdJPAExecutor.assertEquals((Object)wfJobBase.getStatus(), (Object)children.get(i).getStatus());
        }
    }
}

