/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.ArrayList;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.FaultInjection;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobGetJPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobsDeleteJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.workflow.WorkflowInstance;

public class TestWorkflowJobsDeleteJPAExecutor
extends XDataTestCase {
    Services services;
    private String[] excludedServices = new String[]{"org.apache.oozie.service.StatusTransitService", "org.apache.oozie.service.PauseTransitService", "org.apache.oozie.service.PurgeService", "org.apache.oozie.service.CoordMaterializeTriggerService", "org.apache.oozie.service.RecoveryService"};

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testDeleteWorkflows() throws Exception {
        WorkflowJobBean jobA = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean actionA1 = this.addRecordToWfActionTable(jobA.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean actionA2 = this.addRecordToWfActionTable(jobA.getId(), "2", WorkflowAction.Status.OK);
        WorkflowJobBean jobB = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean actionB1 = this.addRecordToWfActionTable(jobB.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean actionB2 = this.addRecordToWfActionTable(jobB.getId(), "2", WorkflowAction.Status.OK);
        WorkflowJobBean jobC = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean actionC1 = this.addRecordToWfActionTable(jobC.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean actionC2 = this.addRecordToWfActionTable(jobC.getId(), "2", WorkflowAction.Status.OK);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestWorkflowJobsDeleteJPAExecutor.assertNotNull((Object)jpaService);
        ArrayList<String> deleteList = new ArrayList<String>();
        deleteList.add(jobA.getId());
        deleteList.add(jobB.getId());
        deleteList.add(jobC.getId());
        jpaService.execute((JPAExecutor)new WorkflowJobsDeleteJPAExecutor(deleteList));
        try {
            jpaService.execute((JPAExecutor)new WorkflowJobGetJPAExecutor(jobA.getId()));
            TestWorkflowJobsDeleteJPAExecutor.fail((String)"Workflow Job A should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestWorkflowJobsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)new WorkflowActionGetJPAExecutor(actionA1.getId()));
            TestWorkflowJobsDeleteJPAExecutor.fail((String)"Workflow Action A1 should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestWorkflowJobsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)new WorkflowActionGetJPAExecutor(actionA2.getId()));
            TestWorkflowJobsDeleteJPAExecutor.fail((String)"Workflow Action A2 should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestWorkflowJobsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)new WorkflowJobGetJPAExecutor(jobB.getId()));
            TestWorkflowJobsDeleteJPAExecutor.fail((String)"Workflow Job B should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestWorkflowJobsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)new WorkflowActionGetJPAExecutor(actionB1.getId()));
            TestWorkflowJobsDeleteJPAExecutor.fail((String)"Workflow Action B1 should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestWorkflowJobsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)new WorkflowActionGetJPAExecutor(actionB2.getId()));
            TestWorkflowJobsDeleteJPAExecutor.fail((String)"Workflow Action B2 should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestWorkflowJobsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)new WorkflowJobGetJPAExecutor(jobC.getId()));
            TestWorkflowJobsDeleteJPAExecutor.fail((String)"Workflow Job C should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestWorkflowJobsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0604, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)new WorkflowActionGetJPAExecutor(actionC1.getId()));
            TestWorkflowJobsDeleteJPAExecutor.fail((String)"Workflow Action C1 should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestWorkflowJobsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
        try {
            jpaService.execute((JPAExecutor)new WorkflowActionGetJPAExecutor(actionC2.getId()));
            TestWorkflowJobsDeleteJPAExecutor.fail((String)"Workflow Action C2 should have been deleted");
        }
        catch (JPAExecutorException je) {
            TestWorkflowJobsDeleteJPAExecutor.assertEquals((Object)ErrorCode.E0605, (Object)je.getErrorCode());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testDeleteWorkflowsRollback() throws Exception {
        WorkflowJobBean jobA = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean actionA1 = this.addRecordToWfActionTable(jobA.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean actionA2 = this.addRecordToWfActionTable(jobA.getId(), "2", WorkflowAction.Status.OK);
        WorkflowJobBean jobB = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean actionB1 = this.addRecordToWfActionTable(jobB.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean actionB2 = this.addRecordToWfActionTable(jobB.getId(), "2", WorkflowAction.Status.OK);
        WorkflowJobBean jobC = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        WorkflowActionBean actionC1 = this.addRecordToWfActionTable(jobC.getId(), "1", WorkflowAction.Status.OK);
        WorkflowActionBean actionC2 = this.addRecordToWfActionTable(jobC.getId(), "2", WorkflowAction.Status.OK);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestWorkflowJobsDeleteJPAExecutor.assertNotNull((Object)jpaService);
        try {
            this.setSystemProperty("oozie.fault.injection", "true");
            this.setSystemProperty("oozie.fault.injection.action.failover", "true");
            ArrayList<String> deleteList = new ArrayList<String>();
            deleteList.add(jobA.getId());
            deleteList.add(jobB.getId());
            deleteList.add(jobC.getId());
            try {
                jpaService.execute((JPAExecutor)new WorkflowJobsDeleteJPAExecutor(deleteList));
                TestWorkflowJobsDeleteJPAExecutor.fail((String)"Should have skipped commit for failover testing");
            }
            catch (JPAExecutorException jee) {
                TestWorkflowJobsDeleteJPAExecutor.assertTrue((boolean)jee.getMessage().contains("Skipping Commit for Failover Testing"));
            }
        }
        finally {
            FaultInjection.deactivate((String)"org.apache.oozie.command.SkipCommitFaultInjection");
        }
        try {
            jpaService.execute((JPAExecutor)new WorkflowJobGetJPAExecutor(jobA.getId()));
        }
        catch (JPAExecutorException je) {
            TestWorkflowJobsDeleteJPAExecutor.fail((String)"Workflow Job A should not have been deleted");
        }
        try {
            jpaService.execute((JPAExecutor)new WorkflowActionGetJPAExecutor(actionA1.getId()));
        }
        catch (JPAExecutorException je) {
            TestWorkflowJobsDeleteJPAExecutor.fail((String)"Workflow Action A1 should not have been deleted");
        }
        try {
            jpaService.execute((JPAExecutor)new WorkflowActionGetJPAExecutor(actionA2.getId()));
        }
        catch (JPAExecutorException je) {
            TestWorkflowJobsDeleteJPAExecutor.fail((String)"Workflow Action A2 should not have been deleted");
        }
        try {
            jpaService.execute((JPAExecutor)new WorkflowJobGetJPAExecutor(jobB.getId()));
        }
        catch (JPAExecutorException je) {
            TestWorkflowJobsDeleteJPAExecutor.fail((String)"Workflow Job B should not have been deleted");
        }
        try {
            jpaService.execute((JPAExecutor)new WorkflowActionGetJPAExecutor(actionB1.getId()));
        }
        catch (JPAExecutorException je) {
            TestWorkflowJobsDeleteJPAExecutor.fail((String)"Workflow Action B1 should not have been deleted");
        }
        try {
            jpaService.execute((JPAExecutor)new WorkflowActionGetJPAExecutor(actionB2.getId()));
        }
        catch (JPAExecutorException je) {
            TestWorkflowJobsDeleteJPAExecutor.fail((String)"Workflow Action B2 should not have been deleted");
        }
        try {
            jpaService.execute((JPAExecutor)new WorkflowJobGetJPAExecutor(jobC.getId()));
        }
        catch (JPAExecutorException je) {
            TestWorkflowJobsDeleteJPAExecutor.fail((String)"Workflow Job C should not have been deleted");
        }
        try {
            jpaService.execute((JPAExecutor)new WorkflowActionGetJPAExecutor(actionC1.getId()));
        }
        catch (JPAExecutorException je) {
            TestWorkflowJobsDeleteJPAExecutor.fail((String)"Workflow Action C1 should not have been deleted");
        }
        try {
            jpaService.execute((JPAExecutor)new WorkflowActionGetJPAExecutor(actionC2.getId()));
        }
        catch (JPAExecutorException je) {
            TestWorkflowJobsDeleteJPAExecutor.fail((String)"Workflow Action C2 should not have been deleted");
        }
    }
}

