/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.executor.jpa;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.WorkflowsInfo;
import org.apache.oozie.XException;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowsJobGetJPAExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.workflow.WorkflowInstance;

public class TestWorkflowsJobGetJPAExecutor
extends XDataTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testWfJobsGet() throws Exception {
        WorkflowJobBean workflowJob = this.addRecordToWfJobTable(WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        this.addRecordToWfJobTable(WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        this._testGetWFInfos();
        this._testGetWFInfoForId(workflowJob);
        System.out.println("testWfJobsGet Successful");
    }

    private void _testGetWFInfos() throws JPAExecutorException {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestWorkflowsJobGetJPAExecutor.assertNotNull((Object)jpaService);
        HashMap filter = new HashMap();
        WorkflowsJobGetJPAExecutor wfGetCmd = new WorkflowsJobGetJPAExecutor(filter, 1, 1);
        WorkflowsInfo wfInfo = (WorkflowsInfo)jpaService.execute((JPAExecutor)wfGetCmd);
        System.out.println("got WorkflowsInfo " + wfInfo.getLen());
        List wfBeans = wfInfo.getWorkflows();
        TestWorkflowsJobGetJPAExecutor.assertEquals((int)1, (int)wfBeans.size());
        filter = new HashMap();
        wfGetCmd = new WorkflowsJobGetJPAExecutor(filter, 1, 2);
        wfInfo = (WorkflowsInfo)jpaService.execute((JPAExecutor)wfGetCmd);
        wfBeans = wfInfo.getWorkflows();
        TestWorkflowsJobGetJPAExecutor.assertEquals((int)2, (int)wfBeans.size());
    }

    private void _testGetWFInfoForId(WorkflowJobBean wfBean) throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestWorkflowsJobGetJPAExecutor.assertNotNull((Object)jpaService);
        HashMap filter = new HashMap();
        wfBean.setParentId("test-parent-C");
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_PARENT_MODIFIED, (Object)wfBean);
        ArrayList<String> jobIdList = new ArrayList<String>();
        jobIdList.add(wfBean.getId());
        filter.put("id", jobIdList);
        WorkflowsJobGetJPAExecutor wfGetCmd = new WorkflowsJobGetJPAExecutor(filter, 1, 1);
        WorkflowsInfo wfInfo = (WorkflowsInfo)jpaService.execute((JPAExecutor)wfGetCmd);
        TestWorkflowsJobGetJPAExecutor.assertNotNull((Object)wfInfo);
        TestWorkflowsJobGetJPAExecutor.assertEquals((int)wfInfo.getWorkflows().size(), (int)1);
        WorkflowJobBean retBean = (WorkflowJobBean)wfInfo.getWorkflows().get(0);
        this.compareWf(wfBean, retBean);
    }

    private void compareWf(WorkflowJobBean wfBean, WorkflowJobBean retBean) {
        TestWorkflowsJobGetJPAExecutor.assertEquals((String)wfBean.getId(), (String)retBean.getId());
        TestWorkflowsJobGetJPAExecutor.assertEquals((String)wfBean.getAppName(), (String)retBean.getAppName());
        TestWorkflowsJobGetJPAExecutor.assertEquals((String)wfBean.getStatusStr(), (String)retBean.getStatusStr());
        TestWorkflowsJobGetJPAExecutor.assertEquals((int)wfBean.getRun(), (int)retBean.getRun());
        TestWorkflowsJobGetJPAExecutor.assertEquals((String)wfBean.getUser(), (String)retBean.getUser());
        TestWorkflowsJobGetJPAExecutor.assertEquals((String)wfBean.getGroup(), (String)retBean.getGroup());
        TestWorkflowsJobGetJPAExecutor.assertEquals((Object)wfBean.getCreatedTime(), (Object)retBean.getCreatedTime());
        TestWorkflowsJobGetJPAExecutor.assertEquals((Object)wfBean.getStartTime(), (Object)retBean.getStartTime());
        TestWorkflowsJobGetJPAExecutor.assertEquals((Object)wfBean.getLastModifiedTime(), (Object)retBean.getLastModifiedTime());
        TestWorkflowsJobGetJPAExecutor.assertEquals((Object)wfBean.getEndTime(), (Object)retBean.getEndTime());
        TestWorkflowsJobGetJPAExecutor.assertEquals((String)wfBean.getExternalId(), (String)retBean.getExternalId());
        TestWorkflowsJobGetJPAExecutor.assertEquals((String)wfBean.getParentId(), (String)retBean.getParentId());
    }

    public void testWfJobsSortBy() throws Exception {
        WorkflowJobBean workflowJob1 = this.addRecordToWfJobTable(WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        WorkflowJobBean workflowJob2 = this.addRecordToWfJobTable(WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        workflowJob1.setAppName("update-app-name-1");
        workflowJob1.setLastModifiedTime(DateUtils.parseDateUTC((String)"2012-01-04T10:00Z"));
        workflowJob1.setCreatedTime(DateUtils.parseDateUTC((String)"2012-01-03T10:00Z"));
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW, (Object)workflowJob1);
        workflowJob2.setAppName("update-app-name-2");
        workflowJob2.setLastModifiedTime(DateUtils.parseDateUTC((String)"2012-01-05T10:00Z"));
        workflowJob2.setCreatedTime(DateUtils.parseDateUTC((String)"2012-01-02T10:00Z"));
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW, (Object)workflowJob2);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestWorkflowsJobGetJPAExecutor.assertNotNull((Object)jpaService);
        HashMap filter = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        list.add("lastModifiedTime");
        filter.put("sortby", list);
        WorkflowsJobGetJPAExecutor wfGetCmd = new WorkflowsJobGetJPAExecutor(filter, 1, 20);
        WorkflowsInfo wfInfo = (WorkflowsInfo)jpaService.execute((JPAExecutor)wfGetCmd);
        TestWorkflowsJobGetJPAExecutor.assertNotNull((Object)wfInfo);
        TestWorkflowsJobGetJPAExecutor.assertEquals((int)2, (int)wfInfo.getWorkflows().size());
        WorkflowJobBean retBean = (WorkflowJobBean)wfInfo.getWorkflows().get(0);
        this.compareWf(workflowJob2, retBean);
        filter.clear();
        list.clear();
        list.add("dummyField");
        filter.put("sortby", list);
        wfGetCmd = new WorkflowsJobGetJPAExecutor(filter, 1, 20);
        wfInfo = (WorkflowsInfo)jpaService.execute((JPAExecutor)wfGetCmd);
        TestWorkflowsJobGetJPAExecutor.assertNotNull((Object)wfInfo);
        TestWorkflowsJobGetJPAExecutor.assertEquals((int)2, (int)wfInfo.getWorkflows().size());
        retBean = (WorkflowJobBean)wfInfo.getWorkflows().get(0);
        this.compareWf(workflowJob1, retBean);
    }

    public void testGetWFInfoForText() throws Exception {
        WorkflowJobBean workflowJob1 = this.addRecordToWfJobTable(WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        WorkflowJobBean workflowJob2 = this.addRecordToWfJobTable(WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        workflowJob1.setAppName("wf-name-1");
        workflowJob2.setAppName("wf-name-2");
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW, (Object)workflowJob1);
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW, (Object)workflowJob2);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestWorkflowsJobGetJPAExecutor.assertNotNull((Object)jpaService);
        HashMap filter = new HashMap();
        ArrayList<String> list = new ArrayList<String>();
        WorkflowsJobGetJPAExecutor wfGetCmd = new WorkflowsJobGetJPAExecutor(filter, 1, 20);
        WorkflowsInfo wfInfo = (WorkflowsInfo)jpaService.execute((JPAExecutor)wfGetCmd);
        TestWorkflowsJobGetJPAExecutor.assertNotNull((Object)wfInfo);
        TestWorkflowsJobGetJPAExecutor.assertEquals((int)2, (int)wfInfo.getWorkflows().size());
        WorkflowJobBean retBean = (WorkflowJobBean)wfInfo.getWorkflows().get(0);
        this.compareWf(workflowJob2, retBean);
        list.add("wf-name");
        filter.put("text", list);
        wfGetCmd = new WorkflowsJobGetJPAExecutor(filter, 1, 20);
        wfInfo = (WorkflowsInfo)jpaService.execute((JPAExecutor)wfGetCmd);
        TestWorkflowsJobGetJPAExecutor.assertNotNull((Object)wfInfo);
        TestWorkflowsJobGetJPAExecutor.assertEquals((int)2, (int)wfInfo.getWorkflows().size());
        list.clear();
        list.add("wf-name-1");
        filter.put("text", list);
        wfGetCmd = new WorkflowsJobGetJPAExecutor(filter, 1, 20);
        wfInfo = (WorkflowsInfo)jpaService.execute((JPAExecutor)wfGetCmd);
        TestWorkflowsJobGetJPAExecutor.assertNotNull((Object)wfInfo);
        TestWorkflowsJobGetJPAExecutor.assertEquals((int)1, (int)wfInfo.getWorkflows().size());
        list.add("extra-param");
        filter.put("text", list);
        wfGetCmd = new WorkflowsJobGetJPAExecutor(filter, 1, 2);
        try {
            jpaService.execute((JPAExecutor)wfGetCmd);
            TestWorkflowsJobGetJPAExecutor.fail((String)"WorkflowsJobGetJPAExecutor should have thrown E0302 exception.");
        }
        catch (XException e) {
            TestWorkflowsJobGetJPAExecutor.assertEquals((Object)ErrorCode.E0302, (Object)e.getErrorCode());
            TestWorkflowsJobGetJPAExecutor.assertEquals((String)e.getMessage(), (String)"E0302: Invalid parameter [cannot specify multiple strings to search]");
        }
        workflowJob1.setAppName("updated-name-1");
        workflowJob2.setAppName("updated-name-2");
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW, (Object)workflowJob1);
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW, (Object)workflowJob2);
        list.clear();
        list.add("wf-name-1");
        filter.put("text", list);
        wfGetCmd = new WorkflowsJobGetJPAExecutor(filter, 1, 20);
        wfInfo = (WorkflowsInfo)jpaService.execute((JPAExecutor)wfGetCmd);
        TestWorkflowsJobGetJPAExecutor.assertNotNull((Object)wfInfo);
        TestWorkflowsJobGetJPAExecutor.assertEquals((int)0, (int)wfInfo.getWorkflows().size());
        list.clear();
        list.add("updated-name");
        filter.put("text", list);
        wfGetCmd = new WorkflowsJobGetJPAExecutor(filter, 1, 20);
        wfInfo = (WorkflowsInfo)jpaService.execute((JPAExecutor)wfGetCmd);
        TestWorkflowsJobGetJPAExecutor.assertNotNull((Object)wfInfo);
        TestWorkflowsJobGetJPAExecutor.assertEquals((int)2, (int)wfInfo.getWorkflows().size());
    }

    public void testGetWFInfoForTextAndStatus() throws Exception {
        WorkflowJobBean workflowJob = this.addRecordToWfJobTable(WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        workflowJob.setAppName("wf-name-1");
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW, (Object)workflowJob);
        HashMap filter = new HashMap();
        ArrayList<String> textFilterList = new ArrayList<String>();
        textFilterList.add("wf-name-1");
        ArrayList<String> textStatusList = new ArrayList<String>();
        textStatusList.add(WorkflowJob.Status.PREP.toString());
        filter.put("text", textFilterList);
        filter.put("status", textStatusList);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        WorkflowsJobGetJPAExecutor wfGetCmd = new WorkflowsJobGetJPAExecutor(filter, 1, 20);
        WorkflowsInfo wfInfo = (WorkflowsInfo)jpaService.execute((JPAExecutor)wfGetCmd);
        TestWorkflowsJobGetJPAExecutor.assertEquals((int)1, (int)wfInfo.getWorkflows().size());
    }

    public void testWfJobsGetWithCreatedTime() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        Date createdTime1 = DateUtils.parseDateUTC((String)"2012-01-01T10:00Z");
        Date createdTime2 = DateUtils.parseDateUTC((String)"2012-02-01T10:00Z");
        Date createdTime3 = DateUtils.parseDateUTC((String)"2012-03-01T10:00Z");
        Date createdTime4 = DateUtils.parseDateUTC((String)"2012-04-01T10:00Z");
        Date createdTime5 = org.apache.commons.lang.time.DateUtils.addHours((Date)new Date(), (int)-5);
        WorkflowJobBean wrkJob = this.addRecordToWfJobTable(WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        wrkJob.setCreatedTime(createdTime1);
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW, (Object)wrkJob);
        wrkJob = this.addRecordToWfJobTable(WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        wrkJob.setCreatedTime(createdTime2);
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW, (Object)wrkJob);
        wrkJob = this.addRecordToWfJobTable(WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        wrkJob.setCreatedTime(createdTime3);
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW, (Object)wrkJob);
        wrkJob = this.addRecordToWfJobTable(WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        wrkJob.setCreatedTime(createdTime4);
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW, (Object)wrkJob);
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW, (Object)wrkJob);
        wrkJob = this.addRecordToWfJobTable(WorkflowJob.Status.PREP, WorkflowInstance.Status.PREP);
        wrkJob.setCreatedTime(createdTime5);
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW, (Object)wrkJob);
        HashMap filter = new HashMap();
        ArrayList<String> timeList = new ArrayList<String>();
        timeList.add("2012-02-01T00:00Z");
        filter.put("startcreatedtime", timeList);
        timeList = new ArrayList();
        timeList.add("2012-03-02T00:00Z");
        filter.put("endcreatedtime", timeList);
        WorkflowsJobGetJPAExecutor wfGetCmd = new WorkflowsJobGetJPAExecutor(filter, 1, 10);
        WorkflowsInfo wfInfo = (WorkflowsInfo)jpaService.execute((JPAExecutor)wfGetCmd);
        TestWorkflowsJobGetJPAExecutor.assertNotNull((Object)wfInfo);
        TestWorkflowsJobGetJPAExecutor.assertEquals((int)2, (int)wfInfo.getWorkflows().size());
        for (WorkflowJobBean jobBean : wfInfo.getWorkflows()) {
            TestWorkflowsJobGetJPAExecutor.assertTrue((jobBean.getCreatedTime().equals(createdTime2) || jobBean.getCreatedTime().equals(createdTime3) ? 1 : 0) != 0);
        }
        filter = new HashMap();
        timeList = new ArrayList();
        timeList.add("2012-02-01T00:00");
        filter.put("startcreatedtime", timeList);
        wfGetCmd = new WorkflowsJobGetJPAExecutor(filter, 1, 10);
        try {
            wfInfo = (WorkflowsInfo)jpaService.execute((JPAExecutor)wfGetCmd);
        }
        catch (XException e) {
            TestWorkflowsJobGetJPAExecutor.assertEquals((Object)ErrorCode.E0302, (Object)e.getErrorCode());
        }
        filter = new HashMap();
        timeList = new ArrayList();
        timeList.add("2012-04-01T00:00Z");
        filter.put("startcreatedtime", timeList);
        wfGetCmd = new WorkflowsJobGetJPAExecutor(filter, 1, 10);
        wfInfo = (WorkflowsInfo)jpaService.execute((JPAExecutor)wfGetCmd);
        TestWorkflowsJobGetJPAExecutor.assertNotNull((Object)wfInfo);
        TestWorkflowsJobGetJPAExecutor.assertEquals((int)2, (int)wfInfo.getWorkflows().size());
        for (WorkflowJobBean jobBean : wfInfo.getWorkflows()) {
            TestWorkflowsJobGetJPAExecutor.assertTrue((jobBean.getCreatedTime().equals(createdTime4) || jobBean.getCreatedTime().equals(createdTime5) ? 1 : 0) != 0);
        }
        filter = new HashMap();
        timeList = new ArrayList();
        timeList.add("2012-02-01T00:00Z");
        filter.put("endcreatedtime", timeList);
        wfGetCmd = new WorkflowsJobGetJPAExecutor(filter, 1, 10);
        wfInfo = (WorkflowsInfo)jpaService.execute((JPAExecutor)wfGetCmd);
        TestWorkflowsJobGetJPAExecutor.assertNotNull((Object)wfInfo);
        TestWorkflowsJobGetJPAExecutor.assertEquals((int)1, (int)wfInfo.getWorkflows().size());
        TestWorkflowsJobGetJPAExecutor.assertTrue((boolean)((WorkflowJobBean)wfInfo.getWorkflows().get(0)).getCreatedTime().equals(createdTime1));
        filter = new HashMap();
        timeList = new ArrayList();
        timeList.add("2012-02-01T00:00Z");
        timeList.add("2012-04-01T00:00Z");
        filter.put("endcreatedtime", timeList);
        wfGetCmd = new WorkflowsJobGetJPAExecutor(filter, 1, 10);
        try {
            wfInfo = (WorkflowsInfo)jpaService.execute((JPAExecutor)wfGetCmd);
        }
        catch (XException e) {
            TestWorkflowsJobGetJPAExecutor.assertEquals((Object)ErrorCode.E0302, (Object)e.getErrorCode());
        }
        filter = new HashMap();
        timeList = new ArrayList();
        timeList.add("-2d");
        filter.put("startcreatedtime", timeList);
        wfGetCmd = new WorkflowsJobGetJPAExecutor(filter, 1, 10);
        wfInfo = (WorkflowsInfo)jpaService.execute((JPAExecutor)wfGetCmd);
        TestWorkflowsJobGetJPAExecutor.assertNotNull((Object)wfInfo);
        TestWorkflowsJobGetJPAExecutor.assertEquals((int)1, (int)wfInfo.getWorkflows().size());
        TestWorkflowsJobGetJPAExecutor.assertTrue((boolean)((WorkflowJobBean)wfInfo.getWorkflows().get(0)).getCreatedTime().equals(createdTime5));
        filter = new HashMap();
        timeList = new ArrayList();
        timeList.add("-10h");
        filter.put("startcreatedtime", timeList);
        wfGetCmd = new WorkflowsJobGetJPAExecutor(filter, 1, 10);
        wfInfo = (WorkflowsInfo)jpaService.execute((JPAExecutor)wfGetCmd);
        TestWorkflowsJobGetJPAExecutor.assertNotNull((Object)wfInfo);
        TestWorkflowsJobGetJPAExecutor.assertEquals((int)1, (int)wfInfo.getWorkflows().size());
        TestWorkflowsJobGetJPAExecutor.assertTrue((boolean)((WorkflowJobBean)wfInfo.getWorkflows().get(0)).getCreatedTime().equals(createdTime5));
        filter = new HashMap();
        timeList = new ArrayList();
        timeList.add("-600m");
        filter.put("startcreatedtime", timeList);
        wfGetCmd = new WorkflowsJobGetJPAExecutor(filter, 1, 10);
        wfInfo = (WorkflowsInfo)jpaService.execute((JPAExecutor)wfGetCmd);
        TestWorkflowsJobGetJPAExecutor.assertNotNull((Object)wfInfo);
        TestWorkflowsJobGetJPAExecutor.assertEquals((int)1, (int)wfInfo.getWorkflows().size());
        TestWorkflowsJobGetJPAExecutor.assertTrue((boolean)((WorkflowJobBean)wfInfo.getWorkflows().get(0)).getCreatedTime().equals(createdTime5));
        filter = new HashMap();
        timeList = new ArrayList();
        timeList.add("-3d");
        filter.put("endcreatedtime", timeList);
        wfGetCmd = new WorkflowsJobGetJPAExecutor(filter, 1, 10);
        wfInfo = (WorkflowsInfo)jpaService.execute((JPAExecutor)wfGetCmd);
        TestWorkflowsJobGetJPAExecutor.assertNotNull((Object)wfInfo);
        TestWorkflowsJobGetJPAExecutor.assertEquals((int)4, (int)wfInfo.getWorkflows().size());
        for (WorkflowJobBean jobBean : wfInfo.getWorkflows()) {
            TestWorkflowsJobGetJPAExecutor.assertTrue((jobBean.getCreatedTime().equals(createdTime1) || jobBean.getCreatedTime().equals(createdTime2) || jobBean.getCreatedTime().equals(createdTime3) || jobBean.getCreatedTime().equals(createdTime4) ? 1 : 0) != 0);
        }
        filter = new HashMap();
        timeList = new ArrayList();
        timeList.add("-2h");
        filter.put("endcreatedtime", timeList);
        wfGetCmd = new WorkflowsJobGetJPAExecutor(filter, 1, 10);
        wfInfo = (WorkflowsInfo)jpaService.execute((JPAExecutor)wfGetCmd);
        TestWorkflowsJobGetJPAExecutor.assertNotNull((Object)wfInfo);
        TestWorkflowsJobGetJPAExecutor.assertEquals((int)5, (int)wfInfo.getWorkflows().size());
        for (WorkflowJobBean jobBean : wfInfo.getWorkflows()) {
            TestWorkflowsJobGetJPAExecutor.assertTrue((jobBean.getCreatedTime().equals(createdTime1) || jobBean.getCreatedTime().equals(createdTime2) || jobBean.getCreatedTime().equals(createdTime3) || jobBean.getCreatedTime().equals(createdTime4) || jobBean.getCreatedTime().equals(createdTime5) ? 1 : 0) != 0);
        }
        filter = new HashMap();
        timeList = new ArrayList();
        timeList.add("-60m");
        filter.put("endcreatedtime", timeList);
        wfGetCmd = new WorkflowsJobGetJPAExecutor(filter, 1, 10);
        wfInfo = (WorkflowsInfo)jpaService.execute((JPAExecutor)wfGetCmd);
        TestWorkflowsJobGetJPAExecutor.assertNotNull((Object)wfInfo);
        TestWorkflowsJobGetJPAExecutor.assertEquals((int)5, (int)wfInfo.getWorkflows().size());
        for (WorkflowJobBean jobBean : wfInfo.getWorkflows()) {
            TestWorkflowsJobGetJPAExecutor.assertTrue((jobBean.getCreatedTime().equals(createdTime1) || jobBean.getCreatedTime().equals(createdTime2) || jobBean.getCreatedTime().equals(createdTime3) || jobBean.getCreatedTime().equals(createdTime4) || jobBean.getCreatedTime().equals(createdTime5) ? 1 : 0) != 0);
        }
        filter = new HashMap();
        timeList = new ArrayList();
        timeList.add("-5M");
        filter.put("endcreatedtime", timeList);
        wfGetCmd = new WorkflowsJobGetJPAExecutor(filter, 1, 10);
        try {
            wfInfo = (WorkflowsInfo)jpaService.execute((JPAExecutor)wfGetCmd);
        }
        catch (XException e) {
            TestWorkflowsJobGetJPAExecutor.assertEquals((Object)ErrorCode.E0302, (Object)e.getErrorCode());
        }
        filter = new HashMap();
        timeList = new ArrayList();
        timeList.add("5D");
        filter.put("endcreatedtime", timeList);
        wfGetCmd = new WorkflowsJobGetJPAExecutor(filter, 1, 10);
        try {
            wfInfo = (WorkflowsInfo)jpaService.execute((JPAExecutor)wfGetCmd);
        }
        catch (XException e) {
            TestWorkflowsJobGetJPAExecutor.assertEquals((Object)ErrorCode.E0302, (Object)e.getErrorCode());
        }
    }
}

