/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.jms;

import java.text.ParseException;
import java.util.Date;
import java.util.Random;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.activemq.broker.BrokerService;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.AppType;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.event.Event;
import org.apache.oozie.client.event.JobEvent;
import org.apache.oozie.client.event.jms.JMSMessagingUtils;
import org.apache.oozie.client.event.message.CoordinatorActionMessage;
import org.apache.oozie.client.event.message.WorkflowJobMessage;
import org.apache.oozie.event.CoordinatorActionEvent;
import org.apache.oozie.event.WorkflowJobEvent;
import org.apache.oozie.jms.ConnectionContext;
import org.apache.oozie.jms.JMSConnectionInfo;
import org.apache.oozie.jms.JMSJobEventListener;
import org.apache.oozie.service.JMSAccessorService;
import org.apache.oozie.service.JMSTopicService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.DateUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestJMSJobEventListener
extends XTestCase {
    private Services services;
    private Configuration conf;

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.conf = this.services.getConf();
        this.conf.set("oozie.services.ext", JMSAccessorService.class.getName() + "," + JMSTopicService.class.getName());
        this.conf.set("oozie.jms.producer.connection.properties", "java.naming.factory.initial#org.apache.activemq.jndi.ActiveMQInitialContextFactory;java.naming.provider.url#vm://localhost?broker.persistent=false;connectionFactoryNames#ConnectionFactory");
        this.services.init();
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    @Test
    public void testOnWorkflowJobStartedEvent() throws ParseException {
        JMSJobEventListener wfEventListener = new JMSJobEventListener();
        wfEventListener.init(this.conf);
        Date startDate = DateUtils.parseDateUTC((String)"2012-07-22T00:00Z");
        WorkflowJobEvent wfe = new WorkflowJobEvent("wfId1", "caId1", WorkflowJob.Status.RUNNING, "user1", "wf-app-name1", startDate, null);
        ConnectionContext jmsContext = this.getConnectionContext();
        try {
            Session session = jmsContext.createSession(1);
            MessageConsumer consumer = jmsContext.createConsumer(session, wfEventListener.getTopic(wfe));
            wfEventListener.onWorkflowJobEvent(wfe);
            TextMessage message = (TextMessage)consumer.receive(5000L);
            TestJMSJobEventListener.assertFalse((boolean)message.getText().contains("endTime"));
            WorkflowJobMessage wfStartMessage = (WorkflowJobMessage)JMSMessagingUtils.getEventMessage((Message)message);
            TestJMSJobEventListener.assertEquals((Object)WorkflowJob.Status.RUNNING, (Object)wfStartMessage.getStatus());
            TestJMSJobEventListener.assertEquals((Object)startDate, (Object)wfStartMessage.getStartTime());
            TestJMSJobEventListener.assertEquals((String)"wfId1", (String)wfStartMessage.getId());
            TestJMSJobEventListener.assertEquals((String)"caId1", (String)wfStartMessage.getParentId());
            TestJMSJobEventListener.assertEquals((Object)Event.MessageType.JOB, (Object)wfStartMessage.getMessageType());
            TestJMSJobEventListener.assertEquals((Object)AppType.WORKFLOW_JOB, (Object)wfStartMessage.getAppType());
            TestJMSJobEventListener.assertEquals((Object)JobEvent.EventStatus.STARTED, (Object)wfStartMessage.getEventStatus());
            TestJMSJobEventListener.assertEquals((String)"user1", (String)wfStartMessage.getUser());
            TestJMSJobEventListener.assertEquals((String)"wf-app-name1", (String)wfStartMessage.getAppName());
            wfEventListener.destroy();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestJMSJobEventListener.fail((String)e.getMessage());
        }
    }

    @Test
    public void testOnWorkflowJobSuccessEvent() throws ParseException {
        JMSJobEventListener wfEventListener = new JMSJobEventListener();
        wfEventListener.init(this.conf);
        Date startDate = DateUtils.parseDateUTC((String)"2012-07-22T00:00Z");
        Date endDate = new Date();
        WorkflowJobEvent wfe = new WorkflowJobEvent("wfId1", "caId1", WorkflowJob.Status.SUCCEEDED, "user1", "wf-app-name1", startDate, endDate);
        ConnectionContext jmsContext = this.getConnectionContext();
        try {
            Session session = jmsContext.createSession(1);
            MessageConsumer consumer = jmsContext.createConsumer(session, wfEventListener.getTopic(wfe));
            wfEventListener.onWorkflowJobEvent(wfe);
            TextMessage message = (TextMessage)consumer.receive(5000L);
            WorkflowJobMessage wfSuccMessage = (WorkflowJobMessage)JMSMessagingUtils.getEventMessage((Message)message);
            TestJMSJobEventListener.assertEquals((Object)WorkflowJob.Status.SUCCEEDED, (Object)wfSuccMessage.getStatus());
            TestJMSJobEventListener.assertEquals((Object)startDate, (Object)wfSuccMessage.getStartTime());
            TestJMSJobEventListener.assertEquals((Object)endDate, (Object)wfSuccMessage.getEndTime());
            TestJMSJobEventListener.assertEquals((String)"wfId1", (String)wfSuccMessage.getId());
            TestJMSJobEventListener.assertEquals((String)"caId1", (String)wfSuccMessage.getParentId());
            TestJMSJobEventListener.assertEquals((Object)Event.MessageType.JOB, (Object)wfSuccMessage.getMessageType());
            TestJMSJobEventListener.assertEquals((Object)AppType.WORKFLOW_JOB, (Object)wfSuccMessage.getAppType());
            TestJMSJobEventListener.assertEquals((Object)JobEvent.EventStatus.SUCCESS, (Object)wfSuccMessage.getEventStatus());
            TestJMSJobEventListener.assertEquals((String)"user1", (String)wfSuccMessage.getUser());
            TestJMSJobEventListener.assertEquals((String)"wf-app-name1", (String)wfSuccMessage.getAppName());
            wfEventListener.destroy();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestJMSJobEventListener.fail((String)e.getMessage());
        }
    }

    @Test
    public void testOnWorkflowJobFailureEvent() throws ParseException {
        JMSJobEventListener wfEventListener = new JMSJobEventListener();
        wfEventListener.init(this.conf);
        Date startDate = DateUtils.parseDateUTC((String)"2012-07-22T00:00Z");
        Date endDate = new Date();
        WorkflowJobEvent wfe = new WorkflowJobEvent("wfId1", "caId1", WorkflowJob.Status.FAILED, "user1", "wf-app-name1", startDate, endDate);
        wfe.setErrorCode("dummyErrorCode");
        wfe.setErrorMessage("dummyErrorMessage");
        ConnectionContext jmsContext = this.getConnectionContext();
        try {
            Session session = jmsContext.createSession(1);
            MessageConsumer consumer = jmsContext.createConsumer(session, wfEventListener.getTopic(wfe));
            wfEventListener.onWorkflowJobEvent(wfe);
            TextMessage message = (TextMessage)consumer.receive(5000L);
            WorkflowJobMessage wfFailMessage = (WorkflowJobMessage)JMSMessagingUtils.getEventMessage((Message)message);
            TestJMSJobEventListener.assertEquals((Object)WorkflowJob.Status.FAILED, (Object)wfFailMessage.getStatus());
            TestJMSJobEventListener.assertEquals((Object)startDate, (Object)wfFailMessage.getStartTime());
            TestJMSJobEventListener.assertEquals((Object)endDate, (Object)wfFailMessage.getEndTime());
            TestJMSJobEventListener.assertEquals((String)"wfId1", (String)wfFailMessage.getId());
            TestJMSJobEventListener.assertEquals((String)"caId1", (String)wfFailMessage.getParentId());
            TestJMSJobEventListener.assertEquals((Object)Event.MessageType.JOB, (Object)wfFailMessage.getMessageType());
            TestJMSJobEventListener.assertEquals((Object)AppType.WORKFLOW_JOB, (Object)wfFailMessage.getAppType());
            TestJMSJobEventListener.assertEquals((Object)JobEvent.EventStatus.FAILURE, (Object)wfFailMessage.getEventStatus());
            TestJMSJobEventListener.assertEquals((String)"user1", (String)wfFailMessage.getUser());
            TestJMSJobEventListener.assertEquals((String)"wf-app-name1", (String)wfFailMessage.getAppName());
            TestJMSJobEventListener.assertEquals((String)"dummyErrorCode", (String)wfFailMessage.getErrorCode());
            TestJMSJobEventListener.assertEquals((String)"dummyErrorMessage", (String)wfFailMessage.getErrorMessage());
            wfEventListener.destroy();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestJMSJobEventListener.fail((String)e.getMessage());
        }
    }

    @Test
    public void testOnWorkflowJobSuspendEvent() throws ParseException {
        JMSJobEventListener wfEventListener = new JMSJobEventListener();
        wfEventListener.init(this.conf);
        Date startDate = DateUtils.parseDateUTC((String)"2012-07-22T00:00Z");
        WorkflowJobEvent wfe = new WorkflowJobEvent("wfId1", "caId1", WorkflowJob.Status.SUSPENDED, "user1", "wf-app-name1", startDate, null);
        ConnectionContext jmsContext = this.getConnectionContext();
        try {
            Session session = jmsContext.createSession(1);
            MessageConsumer consumer = jmsContext.createConsumer(session, wfEventListener.getTopic(wfe));
            wfEventListener.onWorkflowJobEvent(wfe);
            TextMessage message = (TextMessage)consumer.receive(5000L);
            TestJMSJobEventListener.assertFalse((boolean)message.getText().contains("endTime"));
            WorkflowJobMessage wfFailMessage = (WorkflowJobMessage)JMSMessagingUtils.getEventMessage((Message)message);
            TestJMSJobEventListener.assertEquals((Object)WorkflowJob.Status.SUSPENDED, (Object)wfFailMessage.getStatus());
            TestJMSJobEventListener.assertEquals((Object)startDate, (Object)wfFailMessage.getStartTime());
            TestJMSJobEventListener.assertEquals((String)"wfId1", (String)wfFailMessage.getId());
            TestJMSJobEventListener.assertEquals((String)"caId1", (String)wfFailMessage.getParentId());
            TestJMSJobEventListener.assertEquals((Object)Event.MessageType.JOB, (Object)wfFailMessage.getMessageType());
            TestJMSJobEventListener.assertEquals((Object)AppType.WORKFLOW_JOB, (Object)wfFailMessage.getAppType());
            TestJMSJobEventListener.assertEquals((Object)JobEvent.EventStatus.SUSPEND, (Object)wfFailMessage.getEventStatus());
            TestJMSJobEventListener.assertEquals((String)"user1", (String)wfFailMessage.getUser());
            TestJMSJobEventListener.assertEquals((String)"wf-app-name1", (String)wfFailMessage.getAppName());
            TestJMSJobEventListener.assertNull((Object)wfFailMessage.getErrorCode());
            TestJMSJobEventListener.assertNull((Object)wfFailMessage.getErrorMessage());
            wfEventListener.destroy();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestJMSJobEventListener.fail((String)e.getMessage());
        }
    }

    @Test
    public void testWorkflowJobSelectors() throws ParseException {
        JMSJobEventListener wfEventListener = new JMSJobEventListener();
        wfEventListener.init(this.conf);
        WorkflowJobEvent wfe = new WorkflowJobEvent("wfId1", "caId1", WorkflowJob.Status.FAILED, "user_1", "wf-app-name1", new Date(), new Date());
        ConnectionContext jmsContext = this.getConnectionContext();
        try {
            Session session = jmsContext.createSession(1);
            String selector = "user='user_1'";
            MessageConsumer consumer = jmsContext.createConsumer(session, wfEventListener.getTopic(wfe), selector);
            wfEventListener.onWorkflowJobEvent(wfe);
            TextMessage message = (TextMessage)consumer.receive(5000L);
            WorkflowJobMessage wfFailMessage = (WorkflowJobMessage)JMSMessagingUtils.getEventMessage((Message)message);
            Assert.assertEquals((Object)WorkflowJob.Status.FAILED, (Object)wfFailMessage.getStatus());
            TestJMSJobEventListener.assertEquals((String)"user_1", (String)wfFailMessage.getUser());
            TestJMSJobEventListener.assertEquals((Object)Event.MessageType.JOB, (Object)wfFailMessage.getMessageType());
            wfEventListener.destroy();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestJMSJobEventListener.fail((String)e.getMessage());
        }
    }

    @Test
    public void testWorkflowJobSelectorsNegative() {
        JMSJobEventListener wfEventListener = new JMSJobEventListener();
        wfEventListener.init(this.conf);
        WorkflowJobEvent wfe = new WorkflowJobEvent("wfId1", "caId1", WorkflowJob.Status.FAILED, "user1", "wf-app-name1", new Date(), new Date());
        ConnectionContext jmsContext = this.getConnectionContext();
        try {
            Session session = jmsContext.createSession(1);
            String selector = "user='Non_matching_user'";
            MessageConsumer consumer = jmsContext.createConsumer(session, wfEventListener.getTopic(wfe), selector);
            wfEventListener.onWorkflowJobEvent(wfe);
            TextMessage message = (TextMessage)consumer.receive(5000L);
            TestJMSJobEventListener.assertNull((Object)message);
            wfEventListener.destroy();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestJMSJobEventListener.fail((String)e.getMessage());
        }
    }

    @Test
    public void testWorkflowJobSelectorsOr() {
        JMSJobEventListener wfEventListener = new JMSJobEventListener();
        wfEventListener.init(this.conf);
        WorkflowJobEvent wfe = new WorkflowJobEvent("wfId1", "caId1", WorkflowJob.Status.FAILED, "user1", "wf-app-name1", new Date(), new Date());
        ConnectionContext jmsContext = this.getConnectionContext();
        try {
            Session session = jmsContext.createSession(1);
            String selector = "user='Non_matching_user' OR appName='wf-app-name1'";
            MessageConsumer consumer = jmsContext.createConsumer(session, wfEventListener.getTopic(wfe), selector);
            wfEventListener.onWorkflowJobEvent(wfe);
            TextMessage message = (TextMessage)consumer.receive(5000L);
            WorkflowJobMessage wfFailMessage = (WorkflowJobMessage)JMSMessagingUtils.getEventMessage((Message)message);
            Assert.assertEquals((Object)WorkflowJob.Status.FAILED, (Object)wfFailMessage.getStatus());
            TestJMSJobEventListener.assertEquals((String)"user1", (String)wfFailMessage.getUser());
            TestJMSJobEventListener.assertEquals((Object)Event.MessageType.JOB, (Object)wfFailMessage.getMessageType());
            wfEventListener.destroy();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestJMSJobEventListener.fail((String)e.getMessage());
        }
    }

    @Test
    public void testWorkflowJobSelectorsAnd() {
        JMSJobEventListener wfEventListener = new JMSJobEventListener();
        wfEventListener.init(this.conf);
        WorkflowJobEvent wfe = new WorkflowJobEvent("wfId1", "caId1", WorkflowJob.Status.FAILED, "user1", "wf-app-name1", new Date(), new Date());
        ConnectionContext jmsContext = this.getConnectionContext();
        try {
            Session session = jmsContext.createSession(1);
            String selector = "eventStatus='FAILURE' AND appType='WORKFLOW_JOB' AND msgType='JOB'";
            MessageConsumer consumer = jmsContext.createConsumer(session, wfEventListener.getTopic(wfe), selector);
            wfEventListener.onWorkflowJobEvent(wfe);
            TextMessage message = (TextMessage)consumer.receive(5000L);
            WorkflowJobMessage wfFailMessage = (WorkflowJobMessage)JMSMessagingUtils.getEventMessage((Message)message);
            Assert.assertEquals((Object)WorkflowJob.Status.FAILED, (Object)wfFailMessage.getStatus());
            TestJMSJobEventListener.assertEquals((String)"user1", (String)wfFailMessage.getUser());
            TestJMSJobEventListener.assertEquals((Object)Event.MessageType.JOB, (Object)wfFailMessage.getMessageType());
            wfEventListener.destroy();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestJMSJobEventListener.fail((String)e.getMessage());
        }
    }

    @Test
    public void testConnectionDrop() {
        Random random = new Random();
        try {
            this.services.destroy();
            this.services = new Services();
            Configuration conf = this.services.getConf();
            conf.set("oozie.services.ext", JMSAccessorService.class.getName() + "," + JMSTopicService.class.getName());
            int randomPort = 30000 + random.nextInt(10000);
            String brokerURl = "tcp://localhost:" + randomPort;
            conf.set("oozie.jms.producer.connection.properties", "java.naming.factory.initial#org.apache.activemq.jndi.ActiveMQInitialContextFactory;java.naming.provider.url#" + brokerURl + ";connectionFactoryNames#ConnectionFactory");
            this.services.init();
            JMSJobEventListener wfEventListener = new JMSJobEventListener();
            wfEventListener.init(conf);
            BrokerService broker = new BrokerService();
            broker.setDataDirectory(this.getTestCaseDir());
            broker.addConnector(brokerURl);
            broker.start();
            ConnectionContext jmsContext = this.getConnectionContext();
            TestJMSJobEventListener.assertNotNull((Object)jmsContext);
            broker.stop();
            jmsContext = this.getConnectionContext();
            TestJMSJobEventListener.assertNull((Object)jmsContext);
            broker = new BrokerService();
            broker.setDataDirectory(this.getTestCaseDir());
            broker.addConnector(brokerURl);
            broker.start();
            WorkflowJobEvent wfe = new WorkflowJobEvent("wfId1", "caId1", WorkflowJob.Status.FAILED, "user1", "wf-app-name1", new Date(), new Date());
            jmsContext = this.getConnectionContext();
            Session session = jmsContext.createSession(1);
            MessageConsumer consumer = jmsContext.createConsumer(session, wfEventListener.getTopic(wfe));
            wfEventListener.onWorkflowJobEvent(wfe);
            TextMessage message = (TextMessage)consumer.receive(5000L);
            TestJMSJobEventListener.assertNotNull((Object)message);
            broker.stop();
            wfEventListener.destroy();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestJMSJobEventListener.fail((String)e.getMessage());
        }
    }

    @Test
    public void testOnCoordinatorActionWaitingEvent() throws ParseException {
        JMSJobEventListener wfEventListner = new JMSJobEventListener();
        wfEventListner.init(this.conf);
        Date startDate = DateUtils.parseDateUTC((String)"2012-07-22T00:00Z");
        Date nominalTime = DateUtils.parseDateUTC((String)"2011-07-11T00:00Z");
        CoordinatorActionEvent cae = new CoordinatorActionEvent("caId1", "caJobId1", CoordinatorAction.Status.WAITING, "user1", "wf-app-name1", nominalTime, startDate, "missingDep1");
        ConnectionContext jmsContext = this.getConnectionContext();
        try {
            Session session = jmsContext.createSession(1);
            MessageConsumer consumer = jmsContext.createConsumer(session, wfEventListner.getTopic(cae));
            wfEventListner.onCoordinatorActionEvent(cae);
            TextMessage message = (TextMessage)consumer.receive(5000L);
            TestJMSJobEventListener.assertFalse((boolean)message.getText().contains("endTime"));
            TestJMSJobEventListener.assertFalse((boolean)message.getText().contains("errorCode"));
            TestJMSJobEventListener.assertFalse((boolean)message.getText().contains("errorMessage"));
            CoordinatorActionMessage coordActionWaitingMessage = (CoordinatorActionMessage)JMSMessagingUtils.getEventMessage((Message)message);
            TestJMSJobEventListener.assertEquals((Object)CoordinatorAction.Status.WAITING, (Object)coordActionWaitingMessage.getStatus());
            TestJMSJobEventListener.assertEquals((Object)startDate, (Object)coordActionWaitingMessage.getStartTime());
            TestJMSJobEventListener.assertEquals((Object)nominalTime, (Object)coordActionWaitingMessage.getNominalTime());
            TestJMSJobEventListener.assertEquals((String)"caJobId1", (String)coordActionWaitingMessage.getParentId());
            TestJMSJobEventListener.assertEquals((String)"caId1", (String)coordActionWaitingMessage.getId());
            TestJMSJobEventListener.assertEquals((Object)Event.MessageType.JOB, (Object)coordActionWaitingMessage.getMessageType());
            TestJMSJobEventListener.assertEquals((Object)AppType.COORDINATOR_ACTION, (Object)coordActionWaitingMessage.getAppType());
            TestJMSJobEventListener.assertEquals((Object)JobEvent.EventStatus.WAITING, (Object)coordActionWaitingMessage.getEventStatus());
            TestJMSJobEventListener.assertEquals((String)"user1", (String)coordActionWaitingMessage.getUser());
            TestJMSJobEventListener.assertEquals((String)"wf-app-name1", (String)coordActionWaitingMessage.getAppName());
            TestJMSJobEventListener.assertEquals((String)"missingDep1", (String)coordActionWaitingMessage.getMissingDependency());
        }
        catch (Exception e) {
            e.printStackTrace();
            TestJMSJobEventListener.fail((String)e.getMessage());
        }
    }

    @Test
    public void testOnCoordinatorActionStartEvent() throws ParseException {
        JMSJobEventListener coordEventListener = new JMSJobEventListener();
        coordEventListener.init(this.conf);
        Date startDate = DateUtils.parseDateUTC((String)"2012-07-22T00:00Z");
        Date nominalTime = DateUtils.parseDateUTC((String)"2011-07-11T00:00Z");
        CoordinatorActionEvent cae = new CoordinatorActionEvent("caId1", "caJobId1", CoordinatorAction.Status.RUNNING, "user1", "wf-app-name1", nominalTime, startDate, null);
        ConnectionContext jmsContext = this.getConnectionContext();
        try {
            Session session = jmsContext.createSession(1);
            MessageConsumer consumer = jmsContext.createConsumer(session, coordEventListener.getTopic(cae));
            coordEventListener.onCoordinatorActionEvent(cae);
            TextMessage message = (TextMessage)consumer.receive(5000L);
            TestJMSJobEventListener.assertFalse((boolean)message.getText().contains("endTime"));
            TestJMSJobEventListener.assertFalse((boolean)message.getText().contains("errorCode"));
            TestJMSJobEventListener.assertFalse((boolean)message.getText().contains("errorMessage"));
            TestJMSJobEventListener.assertFalse((boolean)message.getText().contains("missingDependency"));
            CoordinatorActionMessage coordActionStartMessage = (CoordinatorActionMessage)JMSMessagingUtils.getEventMessage((Message)message);
            TestJMSJobEventListener.assertEquals((Object)CoordinatorAction.Status.RUNNING, (Object)coordActionStartMessage.getStatus());
            TestJMSJobEventListener.assertEquals((Object)startDate, (Object)coordActionStartMessage.getStartTime());
            TestJMSJobEventListener.assertEquals((String)"caJobId1", (String)coordActionStartMessage.getParentId());
            TestJMSJobEventListener.assertEquals((String)"caId1", (String)coordActionStartMessage.getId());
            TestJMSJobEventListener.assertEquals((Object)Event.MessageType.JOB, (Object)coordActionStartMessage.getMessageType());
            TestJMSJobEventListener.assertEquals((Object)AppType.COORDINATOR_ACTION, (Object)coordActionStartMessage.getAppType());
            TestJMSJobEventListener.assertEquals((Object)JobEvent.EventStatus.STARTED, (Object)coordActionStartMessage.getEventStatus());
            TestJMSJobEventListener.assertEquals((String)"user1", (String)coordActionStartMessage.getUser());
            TestJMSJobEventListener.assertEquals((String)"wf-app-name1", (String)coordActionStartMessage.getAppName());
        }
        catch (Exception e) {
            e.printStackTrace();
            TestJMSJobEventListener.fail((String)e.getMessage());
        }
    }

    @Test
    public void testOnCoordinatorJobSuccessEvent() throws ParseException {
        JMSJobEventListener coordEventListener = new JMSJobEventListener();
        coordEventListener.init(this.conf);
        Date startDate = DateUtils.parseDateUTC((String)"2012-07-22T00:00Z");
        Date nominalTime = DateUtils.parseDateUTC((String)"2011-07-11T00:00Z");
        Date endDate = new Date();
        CoordinatorActionEvent cae = new CoordinatorActionEvent("caId1", "caJobId1", CoordinatorAction.Status.SUCCEEDED, "user1", "wf-app-name1", nominalTime, startDate, null);
        cae.setEndTime(endDate);
        ConnectionContext jmsContext = this.getConnectionContext();
        try {
            Session session = jmsContext.createSession(1);
            MessageConsumer consumer = jmsContext.createConsumer(session, coordEventListener.getTopic(cae));
            coordEventListener.onCoordinatorActionEvent(cae);
            TextMessage message = (TextMessage)consumer.receive(5000L);
            TestJMSJobEventListener.assertFalse((boolean)message.getText().contains("errorCode"));
            TestJMSJobEventListener.assertFalse((boolean)message.getText().contains("errorMessage"));
            TestJMSJobEventListener.assertFalse((boolean)message.getText().contains("missingDependency"));
            CoordinatorActionMessage coordActionSuccessMessage = (CoordinatorActionMessage)JMSMessagingUtils.getEventMessage((Message)message);
            TestJMSJobEventListener.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)coordActionSuccessMessage.getStatus());
            TestJMSJobEventListener.assertEquals((Object)startDate, (Object)coordActionSuccessMessage.getStartTime());
            TestJMSJobEventListener.assertEquals((Object)endDate, (Object)coordActionSuccessMessage.getEndTime());
            TestJMSJobEventListener.assertEquals((String)"caJobId1", (String)coordActionSuccessMessage.getParentId());
            TestJMSJobEventListener.assertEquals((String)"caId1", (String)coordActionSuccessMessage.getId());
            TestJMSJobEventListener.assertEquals((Object)Event.MessageType.JOB, (Object)coordActionSuccessMessage.getMessageType());
            TestJMSJobEventListener.assertEquals((Object)AppType.COORDINATOR_ACTION, (Object)coordActionSuccessMessage.getAppType());
            TestJMSJobEventListener.assertEquals((Object)JobEvent.EventStatus.SUCCESS, (Object)coordActionSuccessMessage.getEventStatus());
            TestJMSJobEventListener.assertEquals((String)"user1", (String)coordActionSuccessMessage.getUser());
            TestJMSJobEventListener.assertEquals((String)"wf-app-name1", (String)coordActionSuccessMessage.getAppName());
        }
        catch (Exception e) {
            e.printStackTrace();
            TestJMSJobEventListener.fail((String)e.getMessage());
        }
    }

    @Test
    public void testOnCoordinatorJobFailureEvent() throws ParseException {
        JMSJobEventListener coordEventListener = new JMSJobEventListener();
        coordEventListener.init(this.conf);
        Date startDate = DateUtils.parseDateUTC((String)"2012-07-22T00:00Z");
        Date nominalTime = DateUtils.parseDateUTC((String)"2011-07-11T00:00Z");
        Date endDate = new Date();
        CoordinatorActionEvent cae = new CoordinatorActionEvent("caId1", "caJobId1", CoordinatorAction.Status.FAILED, "user1", "wf-app-name1", nominalTime, startDate, null);
        cae.setEndTime(endDate);
        cae.setErrorCode("E0101");
        cae.setErrorMessage("dummyError");
        ConnectionContext jmsContext = this.getConnectionContext();
        try {
            Session session = jmsContext.createSession(1);
            MessageConsumer consumer = jmsContext.createConsumer(session, coordEventListener.getTopic(cae));
            coordEventListener.onCoordinatorActionEvent(cae);
            TextMessage message = (TextMessage)consumer.receive(5000L);
            TestJMSJobEventListener.assertFalse((boolean)message.getText().contains("missingDependency"));
            CoordinatorActionMessage coordActionFailMessage = (CoordinatorActionMessage)JMSMessagingUtils.getEventMessage((Message)message);
            TestJMSJobEventListener.assertEquals((Object)CoordinatorAction.Status.FAILED, (Object)coordActionFailMessage.getStatus());
            TestJMSJobEventListener.assertEquals((Object)startDate, (Object)coordActionFailMessage.getStartTime());
            TestJMSJobEventListener.assertEquals((Object)endDate, (Object)coordActionFailMessage.getEndTime());
            TestJMSJobEventListener.assertEquals((String)"caJobId1", (String)coordActionFailMessage.getParentId());
            TestJMSJobEventListener.assertEquals((String)"caId1", (String)coordActionFailMessage.getId());
            TestJMSJobEventListener.assertEquals((Object)Event.MessageType.JOB, (Object)coordActionFailMessage.getMessageType());
            TestJMSJobEventListener.assertEquals((Object)AppType.COORDINATOR_ACTION, (Object)coordActionFailMessage.getAppType());
            TestJMSJobEventListener.assertEquals((Object)JobEvent.EventStatus.FAILURE, (Object)coordActionFailMessage.getEventStatus());
            TestJMSJobEventListener.assertEquals((String)"user1", (String)coordActionFailMessage.getUser());
            TestJMSJobEventListener.assertEquals((String)"wf-app-name1", (String)coordActionFailMessage.getAppName());
            TestJMSJobEventListener.assertEquals((String)"E0101", (String)coordActionFailMessage.getErrorCode());
            TestJMSJobEventListener.assertEquals((String)"dummyError", (String)coordActionFailMessage.getErrorMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            TestJMSJobEventListener.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCoordinatorActionSelectors() throws ParseException {
        JMSJobEventListener coordEventListener = new JMSJobEventListener();
        coordEventListener.init(this.conf);
        Date startDate = DateUtils.parseDateUTC((String)"2012-07-22T00:00Z");
        Date nominalTime = DateUtils.parseDateUTC((String)"2011-07-11T00:00Z");
        CoordinatorActionEvent cae = new CoordinatorActionEvent("caId1", "caJobId1", CoordinatorAction.Status.FAILED, "user1", "wf-app-name1", nominalTime, startDate, null);
        ConnectionContext jmsContext = this.getConnectionContext();
        try {
            Session session = jmsContext.createSession(1);
            String selector = "user='user1'";
            MessageConsumer consumer = jmsContext.createConsumer(session, coordEventListener.getTopic(cae), selector);
            coordEventListener.onCoordinatorActionEvent(cae);
            TextMessage message = (TextMessage)consumer.receive(5000L);
            CoordinatorActionMessage coordActionFailMessage = (CoordinatorActionMessage)JMSMessagingUtils.getEventMessage((Message)message);
            Assert.assertEquals((Object)CoordinatorAction.Status.FAILED, (Object)coordActionFailMessage.getStatus());
            TestJMSJobEventListener.assertEquals((String)"user1", (String)coordActionFailMessage.getUser());
            TestJMSJobEventListener.assertEquals((Object)Event.MessageType.JOB, (Object)coordActionFailMessage.getMessageType());
        }
        catch (Exception e) {
            e.printStackTrace();
            TestJMSJobEventListener.fail((String)e.getMessage());
        }
    }

    @Test
    public void testCoordinatorActionSelectorsNegative() throws ParseException {
        JMSJobEventListener coordEventListener = new JMSJobEventListener();
        coordEventListener.init(this.conf);
        Date startDate = DateUtils.parseDateUTC((String)"2012-07-22T00:00Z");
        Date nominalTime = DateUtils.parseDateUTC((String)"2011-07-11T00:00Z");
        CoordinatorActionEvent cae = new CoordinatorActionEvent("caId1", "caJobId1", CoordinatorAction.Status.FAILED, "user1", "wf-app-name1", nominalTime, startDate, null);
        ConnectionContext jmsContext = this.getConnectionContext();
        try {
            Session session = jmsContext.createSession(1);
            String selector = "user='Non_matching_user'";
            MessageConsumer consumer = jmsContext.createConsumer(session, coordEventListener.getTopic(cae), selector);
            coordEventListener.onCoordinatorActionEvent(cae);
            TextMessage message = (TextMessage)consumer.receive(5000L);
            TestJMSJobEventListener.assertNull((Object)message);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestJMSJobEventListener.fail((String)e.getMessage());
        }
    }

    private ConnectionContext getConnectionContext() {
        Configuration conf = this.services.getConf();
        String jmsProps = conf.get("oozie.jms.producer.connection.properties");
        JMSConnectionInfo connInfo = new JMSConnectionInfo(jmsProps);
        JMSAccessorService jmsService = (JMSAccessorService)Services.get().get(JMSAccessorService.class);
        ConnectionContext jmsContext = jmsService.createProducerConnectionContext(connInfo);
        return jmsContext;
    }
}

