/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.jms;

import java.util.Date;
import javax.jms.Message;
import javax.jms.MessageConsumer;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.AppType;
import org.apache.oozie.client.event.Event;
import org.apache.oozie.client.event.SLAEvent;
import org.apache.oozie.client.event.jms.JMSMessagingUtils;
import org.apache.oozie.client.event.message.SLAMessage;
import org.apache.oozie.jms.ConnectionContext;
import org.apache.oozie.jms.JMSConnectionInfo;
import org.apache.oozie.jms.JMSSLAEventListener;
import org.apache.oozie.service.JMSAccessorService;
import org.apache.oozie.service.JMSTopicService;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLACalcStatus;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.DateUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestJMSSLAEventListener
extends XTestCase {
    private Services services;
    private Configuration conf;

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.conf = this.services.getConf();
        this.conf.set("oozie.services.ext", JMSAccessorService.class.getName() + "," + JMSTopicService.class.getName());
        this.conf.set("oozie.jms.producer.connection.properties", "java.naming.factory.initial#org.apache.activemq.jndi.ActiveMQInitialContextFactory;java.naming.provider.url#vm://localhost?broker.persistent=false;connectionFactoryNames#ConnectionFactory");
        this.services.init();
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    private ConnectionContext getConnectionContext() {
        Configuration conf = this.services.getConf();
        String jmsProps = conf.get("oozie.jms.producer.connection.properties");
        JMSConnectionInfo connInfo = new JMSConnectionInfo(jmsProps);
        JMSAccessorService jmsService = (JMSAccessorService)Services.get().get(JMSAccessorService.class);
        ConnectionContext jmsContext = jmsService.createConnectionContext(connInfo);
        return jmsContext;
    }

    @Test
    public void testOnSLAStartMissEvent() throws Exception {
        JMSSLAEventListener slaListener = new JMSSLAEventListener();
        slaListener.init(this.conf);
        String id = "0000000-000000000000001-oozie-wrkf-C@1";
        SLACalcStatus startMiss = this._createSLACalcStatus(id);
        SLARegistrationBean startMissBean = startMiss.getSLARegistrationBean();
        Date startDate = DateUtils.parseDateUTC((String)"2013-01-01T00:00Z");
        startMiss.setId(id);
        startMissBean.setParentId("0000000-000000000000001-oozie-wrkf-C");
        startMissBean.setAppName("Test-SLA-Start-Miss");
        startMissBean.setUser("dummyuser");
        startMissBean.setExpectedStart(startDate);
        startMissBean.setNotificationMsg("notification of start miss");
        startMissBean.setJobData("random job data");
        startMiss.setEventStatus(SLAEvent.EventStatus.START_MISS);
        startMiss.setSLAStatus(SLAEvent.SLAStatus.NOT_STARTED);
        startMissBean.setAppType(AppType.COORDINATOR_ACTION);
        startMiss.setActualStart(DateUtils.parseDateUTC((String)"2013-01-01T01:00Z"));
        ConnectionContext jmsContext = this.getConnectionContext();
        Session session = jmsContext.createSession(1);
        MessageConsumer consumer = jmsContext.createConsumer(session, slaListener.getTopic((SLAEvent)startMiss));
        slaListener.onStartMiss((SLAEvent)startMiss);
        TextMessage message = (TextMessage)consumer.receive(5000L);
        SLAMessage slaStartMissMsg = (SLAMessage)JMSMessagingUtils.getEventMessage((Message)message);
        TestJMSSLAEventListener.assertEquals((Object)SLAEvent.EventStatus.START_MISS, (Object)slaStartMissMsg.getEventStatus());
        TestJMSSLAEventListener.assertEquals((Object)SLAEvent.SLAStatus.NOT_STARTED, (Object)slaStartMissMsg.getSLAStatus());
        TestJMSSLAEventListener.assertEquals((Object)AppType.COORDINATOR_ACTION, (Object)slaStartMissMsg.getAppType());
        TestJMSSLAEventListener.assertEquals((Object)Event.MessageType.SLA, (Object)slaStartMissMsg.getMessageType());
        TestJMSSLAEventListener.assertEquals((String)"Test-SLA-Start-Miss", (String)slaStartMissMsg.getAppName());
        TestJMSSLAEventListener.assertEquals((String)"dummyuser", (String)slaStartMissMsg.getUser());
        TestJMSSLAEventListener.assertEquals((String)"0000000-000000000000001-oozie-wrkf-C@1", (String)slaStartMissMsg.getId());
        TestJMSSLAEventListener.assertEquals((String)"0000000-000000000000001-oozie-wrkf-C", (String)slaStartMissMsg.getParentId());
        TestJMSSLAEventListener.assertEquals((Object)startDate, (Object)slaStartMissMsg.getExpectedStartTime());
        TestJMSSLAEventListener.assertEquals((String)"notification of start miss", (String)slaStartMissMsg.getNotificationMessage());
    }

    public void testOnSLAEndMissEvent() throws Exception {
        JMSSLAEventListener slaListener = new JMSSLAEventListener();
        slaListener.init(this.conf);
        String id = "0000000-000000000000001-oozie-wrkf-C@1";
        SLACalcStatus endMiss = this._createSLACalcStatus(id);
        SLARegistrationBean endMissBean = endMiss.getSLARegistrationBean();
        Date expectedEndDate = DateUtils.parseDateUTC((String)"2013-01-01T00:00Z");
        Date actualEndDate = DateUtils.parseDateUTC((String)"2013-01-01T01:00Z");
        endMiss.setId(id);
        endMissBean.setParentId("0000000-000000000000001-oozie-wrkf-C");
        endMissBean.setAppName("Test-SLA-End-Miss");
        endMiss.setEventStatus(SLAEvent.EventStatus.END_MISS);
        endMiss.setSLAStatus(SLAEvent.SLAStatus.IN_PROCESS);
        endMissBean.setAppType(AppType.COORDINATOR_ACTION);
        endMissBean.setUser("dummyuser");
        endMissBean.setNotificationMsg("notification of end miss");
        endMissBean.setExpectedEnd(expectedEndDate);
        endMiss.setActualEnd(actualEndDate);
        ConnectionContext jmsContext = this.getConnectionContext();
        Session session = jmsContext.createSession(1);
        MessageConsumer consumer = jmsContext.createConsumer(session, slaListener.getTopic((SLAEvent)endMiss));
        slaListener.onEndMiss((SLAEvent)endMiss);
        TextMessage message = (TextMessage)consumer.receive(5000L);
        SLAMessage slaEndMissMsg = (SLAMessage)JMSMessagingUtils.getEventMessage((Message)message);
        TestJMSSLAEventListener.assertEquals((Object)SLAEvent.EventStatus.END_MISS, (Object)slaEndMissMsg.getEventStatus());
        TestJMSSLAEventListener.assertEquals((Object)SLAEvent.SLAStatus.IN_PROCESS, (Object)slaEndMissMsg.getSLAStatus());
        TestJMSSLAEventListener.assertEquals((Object)AppType.COORDINATOR_ACTION, (Object)slaEndMissMsg.getAppType());
        TestJMSSLAEventListener.assertEquals((Object)Event.MessageType.SLA, (Object)slaEndMissMsg.getMessageType());
        TestJMSSLAEventListener.assertEquals((String)"Test-SLA-End-Miss", (String)slaEndMissMsg.getAppName());
        TestJMSSLAEventListener.assertEquals((String)"dummyuser", (String)slaEndMissMsg.getUser());
        TestJMSSLAEventListener.assertEquals((String)"0000000-000000000000001-oozie-wrkf-C@1", (String)slaEndMissMsg.getId());
        TestJMSSLAEventListener.assertEquals((String)"0000000-000000000000001-oozie-wrkf-C", (String)slaEndMissMsg.getParentId());
        TestJMSSLAEventListener.assertEquals((Object)expectedEndDate, (Object)slaEndMissMsg.getExpectedEndTime());
        TestJMSSLAEventListener.assertEquals((Object)actualEndDate, (Object)slaEndMissMsg.getActualEndTime());
        TestJMSSLAEventListener.assertEquals((String)"notification of end miss", (String)slaEndMissMsg.getNotificationMessage());
    }

    public void testOnSLADurationMissEvent() throws Exception {
        JMSSLAEventListener slaListener = new JMSSLAEventListener();
        slaListener.init(this.conf);
        String id = "0000000-000000000000001-oozie-wrkf-C@1";
        SLACalcStatus durationMiss = this._createSLACalcStatus(id);
        SLARegistrationBean durationMissBean = durationMiss.getSLARegistrationBean();
        Date expectedStartDate = DateUtils.parseDateUTC((String)"2013-01-01T00:00Z");
        Date actualStartDate = DateUtils.parseDateUTC((String)"2013-01-01T01:00Z");
        Date expectedEndDate = DateUtils.parseDateUTC((String)"2013-01-01T12:00Z");
        Date actualEndDate = DateUtils.parseDateUTC((String)"2013-01-01T14:00Z");
        long expectedDuration = (expectedEndDate.getTime() - actualStartDate.getTime()) / 60000L;
        durationMiss.setId(id);
        durationMissBean.setParentId("0000000-000000000000001-oozie-wrkf-C");
        durationMissBean.setAppName("Test-SLA-Duration-Miss");
        durationMiss.setEventStatus(SLAEvent.EventStatus.DURATION_MISS);
        durationMiss.setSLAStatus(SLAEvent.SLAStatus.IN_PROCESS);
        durationMissBean.setAppType(AppType.COORDINATOR_ACTION);
        durationMissBean.setUser("dummyuser");
        durationMissBean.setNotificationMsg("notification of duration miss");
        durationMissBean.setExpectedStart(expectedStartDate);
        durationMiss.setActualStart(actualStartDate);
        durationMissBean.setExpectedEnd(expectedEndDate);
        durationMiss.setActualEnd(actualEndDate);
        durationMissBean.setExpectedDuration(expectedDuration);
        long actualDuration = actualEndDate.getTime() - actualStartDate.getTime();
        durationMiss.setActualDuration(actualDuration);
        ConnectionContext jmsContext = this.getConnectionContext();
        Session session = jmsContext.createSession(1);
        MessageConsumer consumer = jmsContext.createConsumer(session, slaListener.getTopic((SLAEvent)durationMiss));
        slaListener.onDurationMiss((SLAEvent)durationMiss);
        TextMessage message = (TextMessage)consumer.receive(5000L);
        SLAMessage durationMissMsg = (SLAMessage)JMSMessagingUtils.getEventMessage((Message)message);
        TestJMSSLAEventListener.assertEquals((Object)SLAEvent.EventStatus.DURATION_MISS, (Object)durationMissMsg.getEventStatus());
        TestJMSSLAEventListener.assertEquals((Object)SLAEvent.SLAStatus.IN_PROCESS, (Object)durationMissMsg.getSLAStatus());
        TestJMSSLAEventListener.assertEquals((Object)AppType.COORDINATOR_ACTION, (Object)durationMissMsg.getAppType());
        TestJMSSLAEventListener.assertEquals((Object)Event.MessageType.SLA, (Object)durationMissMsg.getMessageType());
        TestJMSSLAEventListener.assertEquals((String)"Test-SLA-Duration-Miss", (String)durationMissMsg.getAppName());
        TestJMSSLAEventListener.assertEquals((String)"dummyuser", (String)durationMissMsg.getUser());
        TestJMSSLAEventListener.assertEquals((String)"0000000-000000000000001-oozie-wrkf-C@1", (String)durationMissMsg.getId());
        TestJMSSLAEventListener.assertEquals((String)"0000000-000000000000001-oozie-wrkf-C", (String)durationMissMsg.getParentId());
        TestJMSSLAEventListener.assertEquals((Object)expectedStartDate, (Object)durationMissMsg.getExpectedStartTime());
        TestJMSSLAEventListener.assertEquals((Object)actualStartDate, (Object)durationMissMsg.getActualStartTime());
        TestJMSSLAEventListener.assertEquals((Object)expectedEndDate, (Object)durationMissMsg.getExpectedEndTime());
        TestJMSSLAEventListener.assertEquals((Object)actualEndDate, (Object)durationMissMsg.getActualEndTime());
        TestJMSSLAEventListener.assertEquals((long)expectedDuration, (long)durationMissMsg.getExpectedDuration());
        TestJMSSLAEventListener.assertEquals((long)actualDuration, (long)durationMissMsg.getActualDuration());
        TestJMSSLAEventListener.assertEquals((String)"notification of duration miss", (String)durationMissMsg.getNotificationMessage());
    }

    @Test
    public void testSLAJobSelectors() throws Exception {
        JMSSLAEventListener slaListener = new JMSSLAEventListener();
        slaListener.init(this.conf);
        String id = "0000000-000000000000001-oozie-wrkf-C@1";
        SLACalcStatus startMiss = this._createSLACalcStatus(id);
        SLARegistrationBean startMissBean = startMiss.getSLARegistrationBean();
        startMiss.setId(id);
        startMissBean.setAppName("Test-SLA-Start-Miss");
        startMissBean.setAppType(AppType.COORDINATOR_ACTION);
        startMissBean.setUser("dummyuser");
        startMiss.setEventStatus(SLAEvent.EventStatus.START_MISS);
        startMiss.setSLAStatus(SLAEvent.SLAStatus.NOT_STARTED);
        startMiss.setMsgType(Event.MessageType.SLA);
        ConnectionContext jmsContext = this.getConnectionContext();
        Session session = jmsContext.createSession(1);
        String selector = "eventStatus='START_MISS'";
        MessageConsumer consumer = jmsContext.createConsumer(session, slaListener.getTopic((SLAEvent)startMiss), selector);
        slaListener.onStartMiss((SLAEvent)startMiss);
        TextMessage message = (TextMessage)consumer.receive(5000L);
        System.out.println("\n Text " + message.getText());
        SLAMessage startMissMsg = (SLAMessage)JMSMessagingUtils.getEventMessage((Message)message);
        TestJMSSLAEventListener.assertEquals((String)"dummyuser", (String)startMissMsg.getUser());
        TestJMSSLAEventListener.assertEquals((Object)SLAEvent.EventStatus.START_MISS, (Object)startMissMsg.getEventStatus());
        TestJMSSLAEventListener.assertEquals((Object)Event.MessageType.SLA, (Object)startMissMsg.getMessageType());
    }

    @Test
    public void testSLAJobSelectorsNegative() throws Exception {
        JMSSLAEventListener slaListener = new JMSSLAEventListener();
        slaListener.init(this.conf);
        String id = "0000000-000000000000001-oozie-wrkf-C@1";
        SLACalcStatus startMiss = this._createSLACalcStatus(id);
        SLARegistrationBean startMissBean = startMiss.getSLARegistrationBean();
        startMiss.setId(id);
        startMissBean.setAppName("Test-SLA-Start-Miss");
        startMissBean.setAppType(AppType.COORDINATOR_ACTION);
        startMissBean.setUser("dummyuser");
        startMiss.setEventStatus(SLAEvent.EventStatus.START_MISS);
        startMiss.setSLAStatus(SLAEvent.SLAStatus.NOT_STARTED);
        startMiss.setMsgType(Event.MessageType.SLA);
        ConnectionContext jmsContext = this.getConnectionContext();
        Session session = jmsContext.createSession(1);
        String selector = "eventStatus='SLA_END_MISS'";
        MessageConsumer consumer = jmsContext.createConsumer(session, slaListener.getTopic((SLAEvent)startMiss), selector);
        slaListener.onStartMiss((SLAEvent)startMiss);
        TextMessage message = (TextMessage)consumer.receive(5000L);
        TestJMSSLAEventListener.assertNull((Object)message);
    }

    @Test
    public void testOnSLAStartMetEvent() throws Exception {
        JMSSLAEventListener slaListener = new JMSSLAEventListener();
        slaListener.init(this.conf);
        String id = "0000000-000000000000001-oozie-wrkf-C@1";
        SLACalcStatus startMet = this._createSLACalcStatus(id);
        SLARegistrationBean startMetBean = startMet.getSLARegistrationBean();
        Date expectedStartDate = DateUtils.parseDateUTC((String)"2013-01-01T10:00Z");
        Date actualStartDate = DateUtils.parseDateUTC((String)"2013-01-01T09:55Z");
        startMetBean.setAppName("Test-SLA-Start-Met");
        startMet.setEventStatus(SLAEvent.EventStatus.START_MET);
        startMet.setSLAStatus(SLAEvent.SLAStatus.IN_PROCESS);
        startMetBean.setAppType(AppType.COORDINATOR_ACTION);
        startMet.setId(id);
        startMetBean.setParentId("0000000-000000000000001-oozie-wrkf-C");
        startMetBean.setUser("dummyuser");
        startMetBean.setNotificationMsg("notification of start miss");
        startMetBean.setJobData("random job data");
        startMetBean.setExpectedStart(expectedStartDate);
        startMet.setActualStart(actualStartDate);
        ConnectionContext jmsContext = this.getConnectionContext();
        Session session = jmsContext.createSession(1);
        MessageConsumer consumer = jmsContext.createConsumer(session, slaListener.getTopic((SLAEvent)startMet));
        slaListener.onStartMet((SLAEvent)startMet);
        TextMessage message = (TextMessage)consumer.receive(5000L);
        SLAMessage slaStartMissMsg = (SLAMessage)JMSMessagingUtils.getEventMessage((Message)message);
        TestJMSSLAEventListener.assertEquals((Object)SLAEvent.EventStatus.START_MET, (Object)slaStartMissMsg.getEventStatus());
        TestJMSSLAEventListener.assertEquals((Object)SLAEvent.SLAStatus.IN_PROCESS, (Object)slaStartMissMsg.getSLAStatus());
        TestJMSSLAEventListener.assertEquals((Object)AppType.COORDINATOR_ACTION, (Object)slaStartMissMsg.getAppType());
        TestJMSSLAEventListener.assertEquals((Object)Event.MessageType.SLA, (Object)slaStartMissMsg.getMessageType());
        TestJMSSLAEventListener.assertEquals((String)"Test-SLA-Start-Met", (String)slaStartMissMsg.getAppName());
        TestJMSSLAEventListener.assertEquals((String)"dummyuser", (String)slaStartMissMsg.getUser());
        TestJMSSLAEventListener.assertEquals((String)"0000000-000000000000001-oozie-wrkf-C@1", (String)slaStartMissMsg.getId());
        TestJMSSLAEventListener.assertEquals((String)"0000000-000000000000001-oozie-wrkf-C", (String)slaStartMissMsg.getParentId());
        TestJMSSLAEventListener.assertEquals((Object)expectedStartDate, (Object)slaStartMissMsg.getExpectedStartTime());
        TestJMSSLAEventListener.assertEquals((Object)actualStartDate, (Object)slaStartMissMsg.getActualStartTime());
    }

    public void testOnSLAEndMetEvent() throws Exception {
        JMSSLAEventListener slaListener = new JMSSLAEventListener();
        slaListener.init(this.conf);
        String id = "0000000-000000000000001-oozie-wrkf-C@1";
        SLACalcStatus endMet = this._createSLACalcStatus(id);
        SLARegistrationBean endMetBean = endMet.getSLARegistrationBean();
        Date expectedEndDate = DateUtils.parseDateUTC((String)"2013-01-01T12:00Z");
        Date actualEndDate = DateUtils.parseDateUTC((String)"2013-01-01T11:00Z");
        endMet.setId(id);
        endMetBean.setParentId("0000000-000000000000001-oozie-wrkf-C");
        endMetBean.setAppName("Test-SLA-End-Met");
        endMet.setEventStatus(SLAEvent.EventStatus.END_MET);
        endMet.setSLAStatus(SLAEvent.SLAStatus.MET);
        endMetBean.setAppType(AppType.COORDINATOR_ACTION);
        endMetBean.setUser("dummyuser");
        endMetBean.setNotificationMsg("notification of end met");
        endMetBean.setExpectedEnd(expectedEndDate);
        endMet.setActualEnd(actualEndDate);
        ConnectionContext jmsContext = this.getConnectionContext();
        Session session = jmsContext.createSession(1);
        MessageConsumer consumer = jmsContext.createConsumer(session, slaListener.getTopic((SLAEvent)endMet));
        slaListener.onEndMet((SLAEvent)endMet);
        TextMessage message = (TextMessage)consumer.receive(5000L);
        SLAMessage slaEndMissMsg = (SLAMessage)JMSMessagingUtils.getEventMessage((Message)message);
        TestJMSSLAEventListener.assertEquals((Object)SLAEvent.EventStatus.END_MET, (Object)slaEndMissMsg.getEventStatus());
        TestJMSSLAEventListener.assertEquals((Object)SLAEvent.SLAStatus.MET, (Object)slaEndMissMsg.getSLAStatus());
        TestJMSSLAEventListener.assertEquals((Object)AppType.COORDINATOR_ACTION, (Object)slaEndMissMsg.getAppType());
        TestJMSSLAEventListener.assertEquals((Object)Event.MessageType.SLA, (Object)slaEndMissMsg.getMessageType());
        TestJMSSLAEventListener.assertEquals((String)"Test-SLA-End-Met", (String)slaEndMissMsg.getAppName());
        TestJMSSLAEventListener.assertEquals((String)"dummyuser", (String)slaEndMissMsg.getUser());
        TestJMSSLAEventListener.assertEquals((String)"0000000-000000000000001-oozie-wrkf-C@1", (String)slaEndMissMsg.getId());
        TestJMSSLAEventListener.assertEquals((String)"0000000-000000000000001-oozie-wrkf-C", (String)slaEndMissMsg.getParentId());
        TestJMSSLAEventListener.assertEquals((Object)expectedEndDate, (Object)slaEndMissMsg.getExpectedEndTime());
        TestJMSSLAEventListener.assertEquals((Object)actualEndDate, (Object)slaEndMissMsg.getActualEndTime());
        TestJMSSLAEventListener.assertEquals((String)"notification of end met", (String)slaEndMissMsg.getNotificationMessage());
    }

    public void testOnSLADurationMetEvent() throws Exception {
        JMSSLAEventListener slaListener = new JMSSLAEventListener();
        slaListener.init(this.conf);
        String id = "0000000-000000000000001-oozie-wrkf-C@1";
        SLACalcStatus durationMet = this._createSLACalcStatus(id);
        SLARegistrationBean durationMetBean = durationMet.getSLARegistrationBean();
        Date expectedStartDate = DateUtils.parseDateUTC((String)"2013-01-01T00:00Z");
        Date actualStartDate = DateUtils.parseDateUTC((String)"2013-01-01T01:00Z");
        Date expectedEndDate = DateUtils.parseDateUTC((String)"2013-01-01T12:00Z");
        Date actualEndDate = DateUtils.parseDateUTC((String)"2013-01-01T14:00Z");
        long expectedDuration = (expectedEndDate.getTime() - actualStartDate.getTime()) / 60000L;
        durationMet.setId(id);
        durationMetBean.setParentId("0000000-000000000000001-oozie-wrkf-C");
        durationMetBean.setAppName("Test-SLA-Duration-Met");
        durationMet.setEventStatus(SLAEvent.EventStatus.DURATION_MET);
        durationMet.setSLAStatus(SLAEvent.SLAStatus.MET);
        durationMetBean.setAppType(AppType.COORDINATOR_ACTION);
        durationMetBean.setUser("dummyuser");
        durationMetBean.setNotificationMsg("notification of duration met");
        durationMetBean.setExpectedStart(expectedStartDate);
        durationMet.setActualStart(actualStartDate);
        durationMetBean.setExpectedEnd(expectedEndDate);
        durationMet.setActualEnd(actualEndDate);
        durationMetBean.setExpectedDuration(expectedDuration);
        long actualDuration = actualEndDate.getTime() - actualStartDate.getTime();
        durationMet.setActualDuration(actualDuration);
        ConnectionContext jmsContext = this.getConnectionContext();
        Session session = jmsContext.createSession(1);
        MessageConsumer consumer = jmsContext.createConsumer(session, slaListener.getTopic((SLAEvent)durationMet));
        slaListener.onDurationMet((SLAEvent)durationMet);
        TextMessage message = (TextMessage)consumer.receive(5000L);
        SLAMessage durationMissMsg = (SLAMessage)JMSMessagingUtils.getEventMessage((Message)message);
        TestJMSSLAEventListener.assertEquals((Object)SLAEvent.EventStatus.DURATION_MET, (Object)durationMissMsg.getEventStatus());
        TestJMSSLAEventListener.assertEquals((Object)SLAEvent.SLAStatus.MET, (Object)durationMissMsg.getSLAStatus());
        TestJMSSLAEventListener.assertEquals((Object)AppType.COORDINATOR_ACTION, (Object)durationMissMsg.getAppType());
        TestJMSSLAEventListener.assertEquals((Object)Event.MessageType.SLA, (Object)durationMissMsg.getMessageType());
        TestJMSSLAEventListener.assertEquals((String)"Test-SLA-Duration-Met", (String)durationMissMsg.getAppName());
        TestJMSSLAEventListener.assertEquals((String)"dummyuser", (String)durationMissMsg.getUser());
        TestJMSSLAEventListener.assertEquals((String)"0000000-000000000000001-oozie-wrkf-C@1", (String)durationMissMsg.getId());
        TestJMSSLAEventListener.assertEquals((String)"0000000-000000000000001-oozie-wrkf-C", (String)durationMissMsg.getParentId());
        TestJMSSLAEventListener.assertEquals((Object)expectedStartDate, (Object)durationMissMsg.getExpectedStartTime());
        TestJMSSLAEventListener.assertEquals((Object)actualStartDate, (Object)durationMissMsg.getActualStartTime());
        TestJMSSLAEventListener.assertEquals((Object)expectedEndDate, (Object)durationMissMsg.getExpectedEndTime());
        TestJMSSLAEventListener.assertEquals((Object)actualEndDate, (Object)durationMissMsg.getActualEndTime());
        TestJMSSLAEventListener.assertEquals((long)expectedDuration, (long)durationMissMsg.getExpectedDuration());
        TestJMSSLAEventListener.assertEquals((long)actualDuration, (long)durationMissMsg.getActualDuration());
        TestJMSSLAEventListener.assertEquals((String)"notification of duration met", (String)durationMissMsg.getNotificationMessage());
    }

    private SLACalcStatus _createSLACalcStatus(String actionId) {
        SLARegistrationBean reg = new SLARegistrationBean();
        reg.setId(actionId);
        reg.setAppType(AppType.COORDINATOR_ACTION);
        return new SLACalcStatus(reg);
    }
}

