/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.lock;

import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.oozie.lock.LockToken;
import org.apache.oozie.lock.MemoryLocks;
import org.apache.oozie.service.MemoryLocksService;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.XLog;

public class TestMemoryLocks
extends XTestCase {
    private static final int LATCH_TIMEOUT = 10;
    private XLog log = XLog.getLog(((Object)((Object)this)).getClass());
    public static final int DEFAULT_LOCK_TIMEOUT = 5000;
    private MemoryLocks locks;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.locks = new MemoryLocks();
    }

    @Override
    protected void tearDown() throws Exception {
        this.locks = null;
        super.tearDown();
    }

    public void testWaitWriteLock() throws Exception {
        StringBuffer sb = new StringBuffer("");
        WriteLocker l1 = new WriteLocker("a", 1, -1L, sb);
        WriteLocker l2 = new WriteLocker("a", 2, -1L, sb);
        new Thread(l1).start();
        l1.awaitLockAcquire();
        new Thread(l2).start();
        l2.awaitStart();
        l1.proceed();
        l2.proceed();
        l1.awaitTermination();
        l2.awaitTermination();
        TestMemoryLocks.assertEquals((String)"a:1-L a:1-U a:2-L a:2-U", (String)sb.toString().trim());
    }

    public void testNoWaitWriteLock() throws Exception {
        StringBuffer sb = new StringBuffer("");
        WriteLocker l1 = new WriteLocker("a", 1, 0L, sb);
        WriteLocker l2 = new WriteLocker("a", 2, 0L, sb);
        new Thread(l1).start();
        l1.awaitLockAcquire();
        new Thread(l2).start();
        l2.awaitStart();
        l2.proceed();
        l2.awaitTermination();
        l1.proceed();
        l1.awaitTermination();
        TestMemoryLocks.assertEquals((String)"a:1-L a:2-N a:1-U", (String)sb.toString().trim());
    }

    public void testTimeoutWaitingWriteLock() throws Exception {
        StringBuffer sb = new StringBuffer("");
        WriteLocker l1 = new WriteLocker("a", 1, 0L, sb);
        WriteLocker l2 = new WriteLocker("a", 2, 10000L, sb);
        new Thread(l1).start();
        l1.awaitLockAcquire();
        new Thread(l2).start();
        l2.awaitStart();
        l1.proceed();
        l1.awaitTermination();
        l2.proceed();
        l2.awaitTermination();
        TestMemoryLocks.assertEquals((String)"a:1-L a:1-U a:2-L a:2-U", (String)sb.toString().trim());
    }

    public void testTimeoutTimingOutWriteLock() throws Exception {
        StringBuffer sb = new StringBuffer("");
        WriteLocker l1 = new WriteLocker("a", 1, 0L, sb);
        WriteLocker l2 = new WriteLocker("a", 2, 50L, sb);
        new Thread(l1).start();
        l1.awaitLockAcquire();
        new Thread(l2).start();
        l2.awaitStart();
        l2.proceed();
        l2.awaitTermination();
        l1.proceed();
        l1.awaitTermination();
        TestMemoryLocks.assertEquals((String)"a:1-L a:2-N a:1-U", (String)sb.toString().trim());
    }

    public void testReadLock() throws Exception {
        StringBuffer sb = new StringBuffer("");
        ReadLocker l1 = new ReadLocker("a", 1, -1L, sb);
        ReadLocker l2 = new ReadLocker("a", 2, -1L, sb);
        new Thread(l1).start();
        l1.awaitLockAcquire();
        new Thread(l2).start();
        l2.awaitLockAcquire();
        l1.proceed();
        l1.awaitTermination();
        l2.proceed();
        l2.awaitTermination();
        TestMemoryLocks.assertEquals((String)"a:1-L a:2-L a:1-U a:2-U", (String)sb.toString().trim());
    }

    public void testReadWriteLock() throws Exception {
        StringBuffer sb = new StringBuffer("");
        ReadLocker l1 = new ReadLocker("a", 1, -1L, sb);
        WriteLocker l2 = new WriteLocker("a", 2, -1L, sb);
        new Thread(l1).start();
        l1.awaitLockAcquire();
        new Thread(l2).start();
        l2.awaitStart();
        l1.proceed();
        l1.awaitTermination();
        l2.proceed();
        l2.awaitTermination();
        TestMemoryLocks.assertEquals((String)"a:1-L a:1-U a:2-L a:2-U", (String)sb.toString().trim());
    }

    public void testWriteReadLock() throws Exception {
        StringBuffer sb = new StringBuffer("");
        WriteLocker l1 = new WriteLocker("a", 1, -1L, sb);
        ReadLocker l2 = new ReadLocker("a", 2, -1L, sb);
        new Thread(l1).start();
        l1.awaitLockAcquire();
        new Thread(l2).start();
        l2.awaitStart();
        l1.proceed();
        l1.awaitTermination();
        l2.proceed();
        l2.awaitTermination();
        TestMemoryLocks.assertEquals((String)"a:1-L a:1-U a:2-L a:2-U", (String)sb.toString().trim());
    }

    public void testWriteLockSameThreadNoWait() throws Exception {
        StringBuffer sb = new StringBuffer("");
        SameThreadWriteLocker l1 = new SameThreadWriteLocker("a", 1, 0L, sb);
        WriteLocker l2 = new WriteLocker("a", 2, 0L, sb);
        new Thread(l1).start();
        l1.awaitLockAcquire();
        new Thread(l2).start();
        l1.awaitStart();
        l2.proceed();
        l2.awaitTermination();
        l1.proceed();
        l1.awaitTermination();
        TestMemoryLocks.assertEquals((String)"a:1-L1 a:1-L2 a:1-U1 a:2-N a:1-U2", (String)sb.toString().trim());
    }

    public void testWriteLockSameThreadWait() throws Exception {
        StringBuffer sb = new StringBuffer("");
        SameThreadWriteLocker l1 = new SameThreadWriteLocker("a", 1, 0L, sb);
        WriteLocker l2 = new WriteLocker("a", 2, 10000L, sb);
        new Thread(l1).start();
        l1.awaitLockAcquire();
        new Thread(l2).start();
        l1.awaitStart();
        l1.proceed();
        l1.awaitTermination();
        l2.proceed();
        l2.awaitTermination();
        TestMemoryLocks.assertEquals((String)"a:1-L1 a:1-L2 a:1-U1 a:1-U2 a:2-L a:2-U", (String)sb.toString().trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLockReentrant() throws ServiceException, InterruptedException {
        String path = UUID.randomUUID().toString();
        MemoryLocksService lockService = new MemoryLocksService();
        try {
            lockService.init(Services.get());
            LockToken lock = lockService.getWriteLock(path, 5000L);
            lock = lockService.getWriteLock(path, 5000L);
            lock = lockService.getWriteLock(path, 5000L);
            TestMemoryLocks.assertEquals((int)lockService.getMemoryLocks().size(), (int)1);
            lock.release();
            TestMemoryLocks.assertEquals((int)lockService.getMemoryLocks().size(), (int)1);
            lock.release();
            TestMemoryLocks.assertEquals((int)lockService.getMemoryLocks().size(), (int)1);
            lock.release();
            this.checkLockRelease(path, lockService);
        }
        catch (Exception e) {
            TestMemoryLocks.fail((String)"Reentrant property, it should have acquired lock");
        }
        finally {
            lockService.destroy();
        }
    }

    public void testLocksAreGarbageCollected() throws ServiceException, InterruptedException {
        String path = new String("a");
        String path1 = new String("a");
        MemoryLocksService lockService = new MemoryLocksService();
        lockService.init(Services.get());
        LockToken lock = lockService.getWriteLock(path, 5000L);
        int oldHash = ((ReentrantReadWriteLock)lockService.getMemoryLocks().getLockMap().get(path)).hashCode();
        lock.release();
        lock = lockService.getWriteLock(path1, 5000L);
        int newHash = ((ReentrantReadWriteLock)lockService.getMemoryLocks().getLockMap().get(path1)).hashCode();
        TestMemoryLocks.assertTrue((oldHash == newHash ? 1 : 0) != 0);
        lock.release();
        lock = null;
        System.gc();
        path = "a";
        lock = lockService.getWriteLock(path, 5000L);
        newHash = ((ReentrantReadWriteLock)lockService.getMemoryLocks().getLockMap().get(path)).hashCode();
        TestMemoryLocks.assertFalse((oldHash == newHash ? 1 : 0) != 0);
    }

    public void testLocksAreReused() throws ServiceException, InterruptedException {
        String path = "a";
        MemoryLocksService lockService = new MemoryLocksService();
        lockService.init(Services.get());
        LockToken lock = lockService.getWriteLock(path, 5000L);
        int oldHash = System.identityHashCode(lockService.getMemoryLocks().getLockMap().get(path));
        System.gc();
        lock.release();
        lock = lockService.getWriteLock(path, 5000L);
        TestMemoryLocks.assertEquals((int)lockService.getMemoryLocks().size(), (int)1);
        int newHash = System.identityHashCode(lockService.getMemoryLocks().getLockMap().get(path));
        TestMemoryLocks.assertTrue((oldHash == newHash ? 1 : 0) != 0);
    }

    private void checkLockRelease(String path, MemoryLocksService lockService) {
        if (lockService.getMemoryLocks().getLockMap().get(path) != null) {
            TestMemoryLocks.assertFalse((boolean)((ReentrantReadWriteLock)lockService.getMemoryLocks().getLockMap().get(path)).isWriteLocked());
        }
    }

    public class SameThreadWriteLocker
    extends LatchHandler
    implements Runnable {
        protected String name;
        private String nameIndex;
        private StringBuffer sb;
        protected long timeout;

        public SameThreadWriteLocker(String name, int nameIndex, long timeout, StringBuffer buffer) {
            this.name = name;
            this.nameIndex = name + ":" + nameIndex;
            this.sb = buffer;
            this.timeout = timeout;
        }

        @Override
        public void run() {
            try {
                this.startLatch.countDown();
                TestMemoryLocks.this.log.info("Getting lock [{0}]", new Object[]{this.nameIndex});
                MemoryLocks.MemoryLockToken token = this.getLock();
                MemoryLocks.MemoryLockToken token2 = this.getLock();
                if (token != null) {
                    this.acquireLockLatch.countDown();
                    TestMemoryLocks.this.log.info("Got lock [{0}]", new Object[]{this.nameIndex});
                    this.sb.append(this.nameIndex + "-L1 ");
                    if (token2 != null) {
                        this.sb.append(this.nameIndex + "-L2 ");
                    }
                    this.sb.append(this.nameIndex + "-U1 ");
                    this.proceedingLatch.await(10L, TimeUnit.SECONDS);
                    token.release();
                    this.sb.append(this.nameIndex + "-U2 ");
                    token2.release();
                    TestMemoryLocks.this.log.info("Release lock [{0}]", new Object[]{this.nameIndex});
                } else {
                    this.proceedingLatch.await(10L, TimeUnit.SECONDS);
                    this.sb.append(this.nameIndex + "-N ");
                    TestMemoryLocks.this.log.info("Did not get lock [{0}]", new Object[]{this.nameIndex});
                }
                this.terminationLatch.countDown();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        protected MemoryLocks.MemoryLockToken getLock() throws InterruptedException {
            return TestMemoryLocks.this.locks.getLock(this.name, MemoryLocksService.Type.WRITE, this.timeout);
        }
    }

    public class WriteLocker
    extends Locker {
        public WriteLocker(String name, int nameIndex, long timeout, StringBuffer buffer) {
            super(name, nameIndex, timeout, buffer);
        }

        @Override
        protected MemoryLocks.MemoryLockToken getLock() throws InterruptedException {
            return TestMemoryLocks.this.locks.getLock(this.name, MemoryLocksService.Type.WRITE, this.timeout);
        }
    }

    public class ReadLocker
    extends Locker {
        public ReadLocker(String name, int nameIndex, long timeout, StringBuffer buffer) {
            super(name, nameIndex, timeout, buffer);
        }

        @Override
        protected MemoryLocks.MemoryLockToken getLock() throws InterruptedException {
            return TestMemoryLocks.this.locks.getLock(this.name, MemoryLocksService.Type.READ, this.timeout);
        }
    }

    public abstract class Locker
    extends LatchHandler
    implements Runnable {
        protected String name;
        private String nameIndex;
        private StringBuffer sb;
        protected long timeout;

        public Locker(String name, int nameIndex, long timeout, StringBuffer buffer) {
            this.name = name;
            this.nameIndex = name + ":" + nameIndex;
            this.sb = buffer;
            this.timeout = timeout;
        }

        @Override
        public void run() {
            try {
                TestMemoryLocks.this.log.info("Getting lock [{0}]", new Object[]{this.nameIndex});
                this.startLatch.countDown();
                MemoryLocks.MemoryLockToken token = this.getLock();
                if (token != null) {
                    TestMemoryLocks.this.log.info("Got lock [{0}]", new Object[]{this.nameIndex});
                    this.sb.append(this.nameIndex + "-L ");
                    this.acquireLockLatch.countDown();
                    this.proceedingLatch.await(10L, TimeUnit.SECONDS);
                    this.sb.append(this.nameIndex + "-U ");
                    token.release();
                    TestMemoryLocks.this.log.info("Release lock [{0}]", new Object[]{this.nameIndex});
                } else {
                    this.proceedingLatch.await(10L, TimeUnit.SECONDS);
                    this.sb.append(this.nameIndex + "-N ");
                    TestMemoryLocks.this.log.info("Did not get lock [{0}]", new Object[]{this.nameIndex});
                }
                this.terminationLatch.countDown();
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
        }

        protected abstract MemoryLocks.MemoryLockToken getLock() throws InterruptedException;
    }

    public abstract class LatchHandler {
        protected CountDownLatch startLatch = new CountDownLatch(1);
        protected CountDownLatch acquireLockLatch = new CountDownLatch(1);
        protected CountDownLatch proceedingLatch = new CountDownLatch(1);
        protected CountDownLatch terminationLatch = new CountDownLatch(1);

        public void awaitStart() throws InterruptedException {
            this.startLatch.await(10L, TimeUnit.SECONDS);
        }

        public void awaitTermination() throws InterruptedException {
            this.terminationLatch.await(10L, TimeUnit.SECONDS);
        }

        public void awaitLockAcquire() throws InterruptedException {
            this.acquireLockLatch.await(10L, TimeUnit.SECONDS);
        }

        public void proceed() {
            this.proceedingLatch.countDown();
        }
    }
}

