/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.File;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.util.Date;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorEngine;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.DagEngine;
import org.apache.oozie.ForTestingActionExecutor;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.executor.jpa.CoordActionGetJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowActionsGetForJobJPAExecutor;
import org.apache.oozie.service.ActionCheckerService;
import org.apache.oozie.service.ActionService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.workflow.WorkflowInstance;

public class TestActionCheckerService
extends XDataTestCase {
    private Services services;
    private String[] excludedServices = new String[]{"org.apache.oozie.service.StatusTransitService", "org.apache.oozie.service.PauseTransitService", "org.apache.oozie.service.CoordMaterializeTriggerService", "org.apache.oozie.service.RecoveryService", "org.apache.oozie.service.ActionCheckerService"};

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.setSystemProperty("oozie.service.SchemaService.wf.ext.schemas", "wf-ext-schema.xsd");
        this.services = new Services();
        this.setClassesToBeExcluded(this.services.getConf(), this.excludedServices);
        this.services.init();
        ((ActionService)this.services.get(ActionService.class)).registerAndInitExecutor(ForTestingActionExecutor.class);
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    public void testActionCheckerService() throws Exception {
        Reader reader = IOUtils.getResourceAsReader((String)"wf-ext-schema-valid.xml", (int)-1);
        FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        final DagEngine engine = new DagEngine(TestActionCheckerService.getTestUser());
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.application.path", this.getTestCaseFileUri("workflow.xml"));
        conf.set("user.name", TestActionCheckerService.getTestUser());
        conf.set("oozie.wf.log.token", "t");
        conf.set("external-status", "ok");
        conf.set("signal-value", "based_on_action_status");
        conf.set("running-mode", "async");
        final String jobId = engine.submitJob((Configuration)conf, true);
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return engine.getJob(jobId).getStatus() == WorkflowJob.Status.RUNNING;
            }
        });
        this.sleep(2000);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestActionCheckerService.assertNotNull((Object)jpaService);
        WorkflowActionsGetForJobJPAExecutor actionsGetExecutor = new WorkflowActionsGetForJobJPAExecutor(jobId);
        List actions = (List)jpaService.execute((JPAExecutor)actionsGetExecutor);
        WorkflowActionBean action = null;
        for (WorkflowActionBean bean : actions) {
            if (!bean.getType().equals("test")) continue;
            action = bean;
            break;
        }
        TestActionCheckerService.assertNotNull(action);
        TestActionCheckerService.assertEquals((Object)WorkflowAction.Status.RUNNING, (Object)action.getStatus());
        this.sleep(2000);
        ActionCheckerService.ActionCheckRunnable actionCheckRunnable = new ActionCheckerService.ActionCheckRunnable(0);
        actionCheckRunnable.run();
        this.waitFor(20000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return engine.getJob(jobId).getStatus() == WorkflowJob.Status.SUCCEEDED;
            }
        });
        List actions2 = (List)jpaService.execute((JPAExecutor)actionsGetExecutor);
        WorkflowActionBean action2 = (WorkflowActionBean)actions2.get(0);
        TestActionCheckerService.assertEquals((Object)WorkflowAction.Status.OK, (Object)action2.getStatus());
    }

    public void testActionCheckerServiceDelay() throws Exception {
        Reader reader = IOUtils.getResourceAsReader((String)"wf-ext-schema-valid.xml", (int)-1);
        FileWriter writer = new FileWriter(new File(this.getTestCaseDir(), "workflow.xml"));
        IOUtils.copyCharStream((Reader)reader, (Writer)writer);
        final DagEngine engine = new DagEngine("u");
        XConfiguration conf = new XConfiguration();
        conf.set("oozie.wf.application.path", this.getTestCaseFileUri("workflow.xml"));
        conf.setStrings("user.name", new String[]{TestActionCheckerService.getTestUser()});
        conf.setStrings("group.name", new String[]{TestActionCheckerService.getTestGroup()});
        conf.set("oozie.wf.log.token", "t");
        conf.set("external-status", "ok");
        conf.set("signal-value", "based_on_action_status");
        conf.set("running-mode", "async");
        final String jobId = engine.submitJob((Configuration)conf, true);
        this.sleep(200);
        this.waitFor(5000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return engine.getJob(jobId).getStatus() == WorkflowJob.Status.RUNNING;
            }
        });
        this.sleep(100);
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestActionCheckerService.assertNotNull((Object)jpaService);
        WorkflowActionsGetForJobJPAExecutor actionsGetExecutor = new WorkflowActionsGetForJobJPAExecutor(jobId);
        List actions = (List)jpaService.execute((JPAExecutor)actionsGetExecutor);
        WorkflowActionBean action = null;
        for (WorkflowActionBean bean : actions) {
            if (!bean.getType().equals("test")) continue;
            action = bean;
            break;
        }
        TestActionCheckerService.assertNotNull(action);
        TestActionCheckerService.assertEquals((Object)WorkflowAction.Status.RUNNING, (Object)action.getStatus());
        action.setLastCheckTime(new Date());
        WorkflowActionQueryExecutor.getInstance().executeUpdate((Enum)WorkflowActionQueryExecutor.WorkflowActionQuery.UPDATE_ACTION_FOR_LAST_CHECKED_TIME, (Object)action);
        int actionCheckDelay = 20;
        ActionCheckerService.ActionCheckRunnable actionCheckRunnable = new ActionCheckerService.ActionCheckRunnable(actionCheckDelay);
        actionCheckRunnable.run();
        this.sleep(3000);
        List actions2 = (List)jpaService.execute((JPAExecutor)actionsGetExecutor);
        WorkflowActionBean action2 = null;
        for (WorkflowActionBean bean : actions2) {
            if (!bean.getType().equals("test")) continue;
            action2 = bean;
            break;
        }
        TestActionCheckerService.assertNotNull((Object)action);
        TestActionCheckerService.assertEquals((Object)WorkflowAction.Status.RUNNING, (Object)action2.getStatus());
        TestActionCheckerService.assertEquals((Object)WorkflowJob.Status.RUNNING, (Object)engine.getJob(jobId).getStatus());
    }

    public void testActionCheckerServiceCoord() throws Exception {
        boolean actionNum = true;
        final CoordinatorEngine ce = new CoordinatorEngine(TestActionCheckerService.getTestUser());
        String currentDatePlusMonth = XDataTestCase.getCurrentDateafterIncrementingInMonths(1);
        Date start = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        Date end = DateUtils.parseDateOozieTZ((String)currentDatePlusMonth);
        CoordinatorJobBean job = this.addRecordToCoordJobTable(Job.Status.RUNNING, start, end, false, false, 0);
        WorkflowJobBean wfJob = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        final CoordinatorActionBean action = this.addRecordToCoordActionTable(job.getId(), 1, CoordinatorAction.Status.RUNNING, "coord-action-get.xml", wfJob.getId(), "RUNNING", 0);
        this.sleep(3000);
        ActionCheckerService.ActionCheckRunnable actionCheckRunnable = new ActionCheckerService.ActionCheckRunnable(1);
        actionCheckRunnable.run();
        this.sleep(3000);
        this.waitFor(200000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return ce.getCoordAction(action.getId()).getStatus() == CoordinatorAction.Status.SUCCEEDED;
            }
        });
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        CoordinatorActionBean recoveredAction = (CoordinatorActionBean)jpaService.execute((JPAExecutor)new CoordActionGetJPAExecutor(action.getId()));
        TestActionCheckerService.assertEquals((Object)CoordinatorAction.Status.SUCCEEDED, (Object)recoveredAction.getStatus());
    }
}

