/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.DummyDocumentBuilderFactoryImpl;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.ConfigUtils;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XLogFilter;
import org.apache.xerces.jaxp.DocumentBuilderFactoryImpl;

public class TestConfigurationService
extends XTestCase {
    Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    private void prepareOozieConfDir(String oozieSite) throws Exception {
        this.prepareOozieConfDir(oozieSite, "oozie-site.xml");
    }

    private void prepareOozieConfDir(String oozieSite, String alternateSiteFile) throws Exception {
        if (!alternateSiteFile.equals("oozie-site.xml")) {
            this.setSystemProperty("oozie.config.file", alternateSiteFile);
        }
        File siteFile = new File(this.getTestCaseConfDir(), alternateSiteFile);
        IOUtils.copyStream((InputStream)IOUtils.getResourceAsStream((String)oozieSite, (int)-1), (OutputStream)new FileOutputStream(siteFile));
    }

    public void testValueFromDefault() throws Exception {
        this.prepareOozieConfDir("oozie-site1.xml");
        ConfigurationService cl = new ConfigurationService();
        cl.init(null);
        TestConfigurationService.assertEquals((String)("oozie-" + System.getProperty("user.name")), (String)cl.getConf().get("oozie.system.id"));
        TestConfigurationService.assertNull((Object)cl.getConf().get("oozie.dummy"));
        cl.destroy();
    }

    public void testMissingSite() throws Exception {
        this.prepareOozieConfDir("oozie-site2.xml");
        this.setSystemProperty("oozie.config.file", "oozie-site-missing.xml");
        ConfigurationService cl = new ConfigurationService();
        cl.init(null);
        TestConfigurationService.assertEquals((String)("oozie-" + System.getProperty("user.name")), (String)cl.getConf().get("oozie.system.id"));
        TestConfigurationService.assertNull((Object)cl.getConf().get("oozie.dummy"));
        cl.destroy();
    }

    public void testValueFromSite() throws Exception {
        this.prepareOozieConfDir("oozie-site2.xml");
        ConfigurationService cl = new ConfigurationService();
        cl.init(null);
        TestConfigurationService.assertEquals((String)"SITE1", (String)cl.getConf().get("oozie.system.id"));
        TestConfigurationService.assertEquals((String)"SITE2", (String)cl.getConf().get("oozie.dummy"));
        cl.destroy();
    }

    public void testValueFromSiteAlternate() throws Exception {
        this.prepareOozieConfDir("oozie-sitealternate.xml", "oozie-alternate.xml");
        ConfigurationService cl = new ConfigurationService();
        cl.init(null);
        TestConfigurationService.assertEquals((String)"ALTERNATE1", (String)cl.getConf().get("oozie.system.id"));
        TestConfigurationService.assertEquals((String)"ALTERNATE2", (String)cl.getConf().get("oozie.dummy"));
        cl.destroy();
    }

    public void testSysPropOverride() throws Exception {
        this.prepareOozieConfDir("oozie-site2.xml");
        this.setSystemProperty("oozie.dummy", "OVERRIDE");
        ConfigurationService cl = new ConfigurationService();
        cl.init(null);
        TestConfigurationService.assertEquals((String)"OVERRIDE", (String)cl.getConf().get("oozie.dummy"));
        cl.destroy();
    }

    public void testAlternateConfDir() throws Exception {
        String customConfDir = this.createTestCaseSubDir("xconf");
        this.setSystemProperty("oozie.config.dir", customConfDir);
        IOUtils.copyStream((InputStream)IOUtils.getResourceAsStream((String)"oozie-site1.xml", (int)-1), (OutputStream)new FileOutputStream(new File(customConfDir, "oozie-site.xml")));
        ConfigurationService cl = new ConfigurationService();
        cl.init(null);
        TestConfigurationService.assertEquals((String)("oozie-" + System.getProperty("user.name")), (String)cl.getConf().get("oozie.system.id"));
        TestConfigurationService.assertNull((Object)cl.getConf().get("oozie.dummy"));
        cl.destroy();
    }

    public void testMaskProperties() throws Exception {
        this.prepareOozieConfDir("oozie-site-mask.xml");
        ConfigurationService cl = new ConfigurationService();
        cl.init(null);
        Configuration conf = cl.getConf();
        TestConfigurationService.assertEquals((String)"my-secret", (String)conf.get("oozie.authentication.signature.secret"));
        TestConfigurationService.assertEquals((String)"my-password", (String)conf.get("oozie.service.JPAService.jdbc.password"));
        TestConfigurationService.assertEquals((String)"true", (String)conf.get("oozie.is.awesome"));
        conf = cl.getMaskedConfiguration();
        TestConfigurationService.assertEquals((String)"**MASKED**", (String)conf.get("oozie.authentication.signature.secret"));
        TestConfigurationService.assertEquals((String)"**MASKED**", (String)conf.get("oozie.service.JPAService.jdbc.password"));
        TestConfigurationService.assertEquals((String)"true", (String)conf.get("oozie.is.awesome"));
        cl.destroy();
    }

    public void testOozieConfig() throws Exception {
        this.prepareOozieConfDir("oozie-site2.xml");
        ConfigurationService cl = new ConfigurationService();
        cl.init(null);
        TestConfigurationService.assertEquals((String)"SITE1", (String)cl.getConf().get("oozie.system.id"));
        TestConfigurationService.assertEquals((String)"SITE2", (String)cl.getConf().get("oozie.dummy"));
        TestConfigurationService.assertEquals((String)"SITE1", (String)ConfigurationService.get((Configuration)cl.getConf(), (String)"oozie.system.id"));
        TestConfigurationService.assertEquals((String)"SITE2", (String)ConfigurationService.get((Configuration)cl.getConf(), (String)"oozie.dummy"));
        TestConfigurationService.assertNull((Object)cl.getConf().get("oozie.test.nonexist"));
        TestConfigurationService.assertEquals((String)ConfigUtils.STRING_DEFAULT, (String)ConfigurationService.get((Configuration)cl.getConf(), (String)"oozie.test.nonexist"));
        TestConfigurationService.assertEquals((boolean)ConfigUtils.BOOLEAN_DEFAULT, (boolean)ConfigurationService.getBoolean((Configuration)cl.getConf(), (String)"oozie.test.nonexist"));
        Configuration testConf = new Configuration(false);
        TestConfigurationService.assertEquals((String)ConfigUtils.STRING_DEFAULT, (String)ConfigurationService.get((String)"test.nonexist"));
        TestConfigurationService.assertEquals((String)ConfigUtils.STRING_DEFAULT, (String)ConfigurationService.get((Configuration)testConf, (String)"test.nonexist"));
        testConf.set("test.nonexist", "another-conf");
        TestConfigurationService.assertEquals((String)ConfigUtils.STRING_DEFAULT, (String)ConfigurationService.get((String)"test.nonexist"));
        TestConfigurationService.assertEquals((String)"another-conf", (String)ConfigurationService.get((Configuration)testConf, (String)"test.nonexist"));
        Services.get().getConf().set("test.nonexist", "oozie-conf");
        TestConfigurationService.assertEquals((String)"oozie-conf", (String)ConfigurationService.get((String)"test.nonexist"));
        TestConfigurationService.assertEquals((String)"another-conf", (String)ConfigurationService.get((Configuration)testConf, (String)"test.nonexist"));
        testConf.clear();
        TestConfigurationService.assertEquals((String)"oozie-conf", (String)ConfigurationService.get((String)"test.nonexist"));
        TestConfigurationService.assertEquals((String)ConfigUtils.STRING_DEFAULT, (String)ConfigurationService.get((Configuration)testConf, (String)"test.nonexist"));
        TestConfigurationService.assertEquals((String)"http://0.0.0.0:11000/oozie/callback", (String)ConfigurationService.get((String)"oozie.service.CallbackService.base.url"));
        TestConfigurationService.assertEquals((int)5, (int)ConfigurationService.getInt((String)"oozie.service.CallbackService.early.requeue.max.retries"));
        TestConfigurationService.assertEquals((String)"gz", (String)ConfigurationService.get((String)"oozie.output.compression.codec"));
        TestConfigurationService.assertEquals((int)4096, (int)ConfigurationService.getInt((String)"oozie.service.XLogStreamingService.buffer.len"));
        TestConfigurationService.assertEquals((long)10000L, (long)ConfigurationService.getLong((String)"oozie.service.JvmPauseMonitorService.warn-threshold.ms"));
        TestConfigurationService.assertEquals((int)60, (int)ConfigurationService.getInt((String)"oozie.service.InstrumentationService.logging.interval"));
        TestConfigurationService.assertEquals((int)30, (int)ConfigurationService.getInt((String)"oozie.service.PurgeService.older.than"));
        TestConfigurationService.assertEquals((int)7, (int)ConfigurationService.getInt((String)"oozie.service.PurgeService.coord.older.than"));
        TestConfigurationService.assertEquals((int)7, (int)ConfigurationService.getInt((String)"oozie.service.PurgeService.bundle.older.than"));
        TestConfigurationService.assertEquals((int)100, (int)ConfigurationService.getInt((String)"oozie.service.PurgeService.purge.limit"));
        TestConfigurationService.assertEquals((int)3600, (int)ConfigurationService.getInt((String)"oozie.service.PurgeService.purge.interval"));
        TestConfigurationService.assertEquals((int)300, (int)ConfigurationService.getInt((String)"oozie.service.CoordMaterializeTriggerService.lookup.interval"));
        TestConfigurationService.assertEquals((int)0, (int)ConfigurationService.getInt((String)"oozie.service.CoordMaterializeTriggerService.scheduling.interval"));
        TestConfigurationService.assertEquals((int)300, (int)cl.getConf().getInt("oozie.service.CoordMaterializeTriggerService.scheduling.interval", ConfigurationService.getInt((String)"oozie.service.CoordMaterializeTriggerService.lookup.interval")));
        TestConfigurationService.assertEquals((int)3600, (int)ConfigurationService.getInt((String)"oozie.service.CoordMaterializeTriggerService.materialization.window"));
        TestConfigurationService.assertEquals((int)10, (int)ConfigurationService.getInt((String)"oozie.service.CoordMaterializeTriggerService.callable.batch.size"));
        TestConfigurationService.assertEquals((int)50, (int)ConfigurationService.getInt((String)"oozie.service.CoordMaterializeTriggerService.materialization.system.limit"));
        TestConfigurationService.assertEquals((Object)Float.valueOf(0.05f), (Object)Float.valueOf(ConfigurationService.getFloat((String)"oozie.service.coord.materialization.throttling.factor")));
        TestConfigurationService.assertEquals((String)"oozie", (String)ConfigurationService.get((String)"oozie.db.schema.name"));
        TestConfigurationService.assertEquals((String)"jdbc:hsqldb:mem:oozie-db;create=true", (String)ConfigurationService.get((String)"oozie.service.JPAService.jdbc.url"));
        TestConfigurationService.assertEquals((String)"org.hsqldb.jdbcDriver", (String)ConfigurationService.get((String)"oozie.service.JPAService.jdbc.driver"));
        TestConfigurationService.assertEquals((String)"sa", (String)ConfigurationService.get((String)"oozie.service.JPAService.jdbc.username"));
        TestConfigurationService.assertEquals((String)"", (String)ConfigurationService.get((String)"oozie.service.JPAService.jdbc.password").trim());
        TestConfigurationService.assertEquals((String)"10", (String)ConfigurationService.get((String)"oozie.service.JPAService.pool.max.active.conn").trim());
        TestConfigurationService.assertEquals((String)"org.apache.oozie.util.db.BasicDataSourceWrapper", (String)ConfigurationService.get((String)"oozie.service.JPAService.connection.data.source"));
        TestConfigurationService.assertEquals((String)"", (String)ConfigurationService.get((String)"oozie.service.JPAService.connection.properties").trim());
        TestConfigurationService.assertEquals((String)"300000", (String)ConfigurationService.get((String)"oozie.service.JPAService.validate.db.connection.eviction.interval").trim());
        TestConfigurationService.assertEquals((String)"10", (String)ConfigurationService.get((String)"oozie.service.JPAService.validate.db.connection.eviction.num").trim());
        TestConfigurationService.assertEquals((int)2048, (int)ConfigurationService.getInt((String)"oozie.action.max.output.data"));
        TestConfigurationService.assertEquals((String)"http://0.0.0.0:11000/oozie?job=", (String)ConfigurationService.get((String)"oozie.JobCommand.job.console.url"));
        TestConfigurationService.assertEquals((boolean)false, (boolean)ConfigurationService.getBoolean((String)"oozie.service.HadoopAccessorService.kerberos.enabled"));
        TestConfigurationService.assertEquals((int)0, (int)ConfigurationService.getStrings((String)"no.defined").length);
        TestConfigurationService.assertEquals((int)0, (int)ConfigurationService.getStrings((String)"oozie.credentials.credentialclasses").length);
        TestConfigurationService.assertEquals((int)1, (int)ConfigurationService.getStrings((String)"oozie.actions.main.classnames").length);
        TestConfigurationService.assertEquals((String)"distcp=org.apache.hadoop.tools.DistCp", (String)ConfigurationService.getStrings((String)"oozie.actions.main.classnames")[0]);
        TestConfigurationService.assertEquals((int)1, (int)ConfigurationService.getInt((String)"oozie.coord.execution.none.tolerance"));
        TestConfigurationService.assertEquals((int)1000, (int)ConfigurationService.getInt((String)"oozie.coord.actions.default.length"));
        TestConfigurationService.assertEquals((String)cl.getConf().get("oozie.service.LiteWorkflowStoreService.user.retry.error.code"), (String)ConfigurationService.get((String)"oozie.service.LiteWorkflowStoreService.user.retry.error.code"));
        TestConfigurationService.assertEquals((String)cl.getConf().get("oozie.service.LiteWorkflowStoreService.user.retry.error.code.ext"), (String)ConfigurationService.get((String)"oozie.service.LiteWorkflowStoreService.user.retry.error.code.ext"));
        TestConfigurationService.assertEquals((String)"simple", (String)cl.getConf().get("oozie.authentication.type"));
        TestConfigurationService.assertEquals((String)"36000", (String)cl.getConf().get("oozie.authentication.token.validity"));
        TestConfigurationService.assertNull((Object)cl.getConf().get("oozie.authentication.cookie.domain"));
        TestConfigurationService.assertEquals((String)"true", (String)cl.getConf().get("oozie.authentication.simple.anonymous.allowed"));
        TestConfigurationService.assertEquals((String)"HTTP/localhost@LOCALHOST", (String)cl.getConf().get("oozie.authentication.kerberos.principal"));
        TestConfigurationService.assertEquals((String)cl.getConf().get("oozie.service.HadoopAccessorService.keytab.file"), (String)cl.getConf().get("oozie.authentication.kerberos.keytab"));
        TestConfigurationService.assertEquals((String)"DEFAULT", (String)cl.getConf().get("oozie.authentication.kerberos.name.rules"));
        TestConfigurationService.assertEquals((boolean)true, (boolean)ConfigurationService.getBoolean((String)"oozie.validate.ForkJoin"));
        TestConfigurationService.assertEquals((boolean)false, (boolean)ConfigurationService.getBoolean((String)"oozie.coord.action.get.all.attributes"));
        TestConfigurationService.assertEquals((int)1, (int)ConfigurationService.getStrings((String)"oozie.service.URIHandlerService.uri.handlers").length);
        TestConfigurationService.assertEquals((String)"org.apache.oozie.dependency.FSURIHandler", (String)ConfigurationService.getStrings((String)"oozie.service.URIHandlerService.uri.handlers")[0]);
        TestConfigurationService.assertEquals((boolean)cl.getConf().getBoolean("oozie.hadoop-2.0.2-alpha.workaround.for.distributed.cache", false), (boolean)ConfigurationService.getBoolean((String)"oozie.hadoop-2.0.2-alpha.workaround.for.distributed.cache"));
        TestConfigurationService.assertEquals((String)"org.apache.oozie.event.MemoryEventQueue", (String)ConfigurationService.getClass((Configuration)cl.getConf(), (String)"oozie.service.EventHandlerService.event.queue").getName());
        TestConfigurationService.assertEquals((int)-1, (int)ConfigurationService.getInt((String)XLogFilter.MAX_SCAN_DURATION));
        TestConfigurationService.assertEquals((int)-1, (int)ConfigurationService.getInt((String)XLogFilter.MAX_ACTIONLIST_SCAN_DURATION));
        TestConfigurationService.assertEquals((long)10000L, (long)ConfigurationService.getLong((String)"oozie.service.JvmPauseMonitorService.warn-threshold.ms"));
        TestConfigurationService.assertEquals((long)1000L, (long)ConfigurationService.getLong((String)"oozie.service.JvmPauseMonitorService.info-threshold.ms"));
        TestConfigurationService.assertEquals((int)10000, (int)ConfigurationService.getInt((String)"oozie.service.CallableQueueService.queue.size"));
        TestConfigurationService.assertEquals((int)10, (int)ConfigurationService.getInt((String)"oozie.service.CallableQueueService.threads"));
        TestConfigurationService.assertEquals((int)3, (int)ConfigurationService.getInt((String)"oozie.service.CallableQueueService.callable.concurrency"));
        TestConfigurationService.assertEquals((int)120, (int)ConfigurationService.getInt((String)"oozie.service.coord.normal.default.timeout"));
        TestConfigurationService.assertEquals((int)300, (int)ConfigurationService.getInt((String)"oozie.service.ZKLocksService.locks.reaper.threshold"));
        TestConfigurationService.assertEquals((int)2, (int)ConfigurationService.getInt((String)"oozie.service.ZKLocksService.locks.reaper.threads"));
        TestConfigurationService.assertEquals((int)10000, (int)ConfigurationService.getInt((String)"oozie.command.default.requeue.delay"));
        TestConfigurationService.assertEquals((int)0, (int)ConfigurationService.getStrings((String)"oozie.service.AbandonedCoordCheckerService.email.address").length);
        TestConfigurationService.assertEquals((int)25, (int)ConfigurationService.getInt((String)"oozie.service.AbandonedCoordCheckerService.failure.limit"));
        TestConfigurationService.assertEquals((boolean)false, (boolean)ConfigurationService.getBoolean((String)"oozie.service.AbandonedCoordCheckerService.kill.jobs"));
        TestConfigurationService.assertEquals((int)60, (int)ConfigurationService.getInt((String)"oozie.service.AbandonedCoordCheckerService.check.delay"));
        TestConfigurationService.assertEquals((int)1440, (int)ConfigurationService.getInt((String)"oozie.service.AbandonedCoordCheckerService.check.interval"));
        TestConfigurationService.assertEquals((int)2880, (int)ConfigurationService.getInt((String)"oozie.service.AbandonedCoordCheckerService.job.older.than"));
        TestConfigurationService.assertEquals((boolean)true, (boolean)ConfigurationService.getBoolean((String)"oozie.zookeeper.server.shutdown.ontimeout"));
        TestConfigurationService.assertEquals((int)7, (int)ConfigurationService.getInt((String)"oozie.service.ShareLibService.temp.sharelib.retention.days"));
        TestConfigurationService.assertEquals((int)5000, (int)ConfigurationService.getInt((String)"oozie.sla.service.SLAService.capacity"));
        TestConfigurationService.assertEquals((int)11000, (int)ConfigurationService.getInt((String)"oozie.http.port"));
        TestConfigurationService.assertEquals((int)11443, (int)ConfigurationService.getInt((String)"oozie.https.port"));
        TestConfigurationService.assertFalse((boolean)ConfigurationService.getBoolean((String)"oozie.https.enabled"));
        TestConfigurationService.assertEquals((int)65536, (int)ConfigurationService.getInt((String)"oozie.http.response.header.size"));
        TestConfigurationService.assertEquals((int)65536, (int)ConfigurationService.getInt((String)"oozie.http.request.header.size"));
        TestConfigurationService.assertEquals((String)"TLSv1,SSLv2Hello,TLSv1.1,TLSv1.2", (String)ConfigurationService.get((String)"oozie.https.include.protocols"));
        TestConfigurationService.assertEquals((String)"", (String)ConfigurationService.get((String)"oozie.https.exclude.protocols"));
        TestConfigurationService.assertEquals((String)"", (String)ConfigurationService.get((String)"oozie.https.include.cipher.suites"));
        TestConfigurationService.assertEquals((String)"TLS_ECDHE_RSA_WITH_RC4_128_SHA,SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA,SSL_RSA_WITH_DES_CBC_SHA,SSL_DHE_RSA_WITH_DES_CBC_SHA,SSL_RSA_EXPORT_WITH_RC4_40_MD5,SSL_RSA_EXPORT_WITH_DES40_CBC_SHA,SSL_RSA_WITH_RC4_128_MD5", (String)ConfigurationService.get((String)"oozie.https.exclude.cipher.suites"));
        TestConfigurationService.assertEquals((int)150, (int)ConfigurationService.getInt((String)"oozie.server.threadpool.max.threads"));
        cl.destroy();
    }

    public void testDocumentBuilderFactorySystemPropertyDefault() throws Exception {
        this.verifyDocumentBuilderFactoryClass(DocumentBuilderFactoryImpl.class.getName(), DocumentBuilderFactoryImpl.class);
    }

    public void testDocumentBuilderFactorySystemPropertyCustom() throws Exception {
        this.prepareOozieConfDir("oozie-site-documentbuilderfactory.xml");
        this.verifyDocumentBuilderFactoryClass(DummyDocumentBuilderFactoryImpl.class.getName(), DummyDocumentBuilderFactoryImpl.class);
    }

    public void testDocumentBuilderFactorySystemPropertyEmpty() throws Exception {
        this.setSystemProperty("javax.xml.parsers.DocumentBuilderFactory", null);
        TestConfigurationService.assertNull((Object)System.getProperty("javax.xml.parsers.DocumentBuilderFactory"));
        Class<?> dbfClass = DocumentBuilderFactory.newInstance().getClass();
        this.prepareOozieConfDir("oozie-site-documentbuilderfactory-empty.xml");
        this.verifyDocumentBuilderFactoryClass(null, dbfClass);
    }

    private void verifyDocumentBuilderFactoryClass(String expectedPropertyValue, Class<?> expectedClass) throws Exception {
        this.setSystemProperty("javax.xml.parsers.DocumentBuilderFactory", null);
        TestConfigurationService.assertNull((Object)System.getProperty("javax.xml.parsers.DocumentBuilderFactory"));
        ConfigurationService cl = new ConfigurationService();
        cl.init(null);
        TestConfigurationService.assertEquals((String)expectedPropertyValue, (String)System.getProperty("javax.xml.parsers.DocumentBuilderFactory"));
        DocumentBuilderFactory docFac = DocumentBuilderFactory.newInstance();
        TestConfigurationService.assertTrue((String)("Expected DocumentBuilderFactory to be of class [" + expectedClass.getName() + "] but was [" + docFac.getClass().getName() + "]"), (boolean)expectedClass.isInstance(docFac));
        cl.destroy();
    }
}

