/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.log4j.Appender;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.event.Event;
import org.apache.oozie.event.BundleJobEvent;
import org.apache.oozie.event.CoordinatorActionEvent;
import org.apache.oozie.event.CoordinatorJobEvent;
import org.apache.oozie.event.MemoryEventQueue;
import org.apache.oozie.event.WorkflowActionEvent;
import org.apache.oozie.event.WorkflowJobEvent;
import org.apache.oozie.event.listener.JobEventListener;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.test.XTestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestEventHandlerService
extends XDataTestCase {
    static StringBuilder output = new StringBuilder();

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        Services services = new Services();
        Configuration conf = services.getConf();
        conf.set("oozie.services.ext", "org.apache.oozie.service.EventHandlerService");
        conf.setClass("oozie.service.EventHandlerService.event.listeners", DummyJobEventListener.class, JobEventListener.class);
        services.init();
        output.setLength(0);
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        Services.get().destroy();
        super.tearDown();
    }

    @Test
    public void testService() throws Exception {
        EventHandlerService ehs = this._testEventHandlerService();
        TestEventHandlerService.assertTrue((boolean)(ehs.getEventQueue() instanceof MemoryEventQueue));
        Set jobtypes = ehs.getAppTypes();
        TestEventHandlerService.assertTrue((boolean)jobtypes.contains("workflow_job"));
        TestEventHandlerService.assertTrue((boolean)jobtypes.contains("coordinator_action"));
        Services services = Services.get();
        services.destroy();
        services = new Services();
        Configuration conf = services.getConf();
        conf.set("oozie.services.ext", "");
        services.init();
        TestEventHandlerService.assertFalse((boolean)EventHandlerService.isEnabled());
    }

    @Test
    public void testEventListener() throws Exception {
        EventHandlerService ehs = this._testEventHandlerService();
        WorkflowJobEvent event = new WorkflowJobEvent("jobid", "parentid", WorkflowJob.Status.RUNNING, TestEventHandlerService.getTestUser(), "myapp", null, null);
        ehs.queueEvent((Event)event);
        new EventHandlerService.EventWorker(ehs).run();
        TestEventHandlerService.assertTrue((boolean)output.toString().contains("Workflow Job event STARTED"));
        output.setLength(0);
        event.setStatus(WorkflowJob.Status.SUSPENDED);
        ehs.queueEvent((Event)event);
        new EventHandlerService.EventWorker(ehs).run();
        TestEventHandlerService.assertTrue((boolean)output.toString().contains("Workflow Job event SUSPEND"));
        output.setLength(0);
        event.setStatus(WorkflowJob.Status.SUCCEEDED);
        ehs.queueEvent((Event)event);
        new EventHandlerService.EventWorker(ehs).run();
        TestEventHandlerService.assertTrue((boolean)output.toString().contains("Workflow Job event SUCCESS"));
        output.setLength(0);
        event.setStatus(WorkflowJob.Status.KILLED);
        ehs.queueEvent((Event)event);
        new EventHandlerService.EventWorker(ehs).run();
        TestEventHandlerService.assertTrue((boolean)output.toString().contains("Workflow Job event FAILURE"));
        output.setLength(0);
        CoordinatorActionEvent event2 = new CoordinatorActionEvent("parentid@1", "parentid", CoordinatorAction.Status.WAITING, TestEventHandlerService.getTestUser(), "myapp", null, null, null);
        ehs.queueEvent((Event)event2);
        new EventHandlerService.EventWorker(ehs).run();
        TestEventHandlerService.assertTrue((boolean)output.toString().contains("Coord Action event WAITING"));
        output.setLength(0);
        event2.setStatus(CoordinatorAction.Status.RUNNING);
        ehs.queueEvent((Event)event2);
        new EventHandlerService.EventWorker(ehs).run();
        TestEventHandlerService.assertTrue((boolean)output.toString().contains("Coord Action event STARTED"));
        output.setLength(0);
        event2.setStatus(CoordinatorAction.Status.SUSPENDED);
        ehs.queueEvent((Event)event2);
        new EventHandlerService.EventWorker(ehs).run();
        TestEventHandlerService.assertTrue((boolean)output.toString().contains("Coord Action event SUSPEND"));
        output.setLength(0);
        event2.setStatus(CoordinatorAction.Status.SUCCEEDED);
        ehs.queueEvent((Event)event2);
        new EventHandlerService.EventWorker(ehs).run();
        TestEventHandlerService.assertTrue((boolean)output.toString().contains("Coord Action event SUCCESS"));
        output.setLength(0);
        event2.setStatus(CoordinatorAction.Status.TIMEDOUT);
        ehs.queueEvent((Event)event2);
        new EventHandlerService.EventWorker(ehs).run();
        TestEventHandlerService.assertTrue((boolean)output.toString().contains("Coord Action event FAILURE"));
        output.setLength(0);
        event2.setStatus(CoordinatorAction.Status.KILLED);
        ehs.queueEvent((Event)event2);
        new EventHandlerService.EventWorker(ehs).run();
        TestEventHandlerService.assertTrue((boolean)output.toString().contains("Coord Action event FAILURE"));
        output.setLength(0);
        WorkflowActionEvent event3 = new WorkflowActionEvent("parentid@wfaction", "parentid", WorkflowAction.Status.RUNNING, TestEventHandlerService.getTestUser(), "myapp", null, null);
        ehs.queueEvent((Event)event3);
        new EventHandlerService.EventWorker(ehs).run();
        TestEventHandlerService.assertTrue((boolean)output.toString().contains("Workflow Action event STARTED"));
        output.setLength(0);
        event3.setStatus(WorkflowAction.Status.START_MANUAL);
        ehs.queueEvent((Event)event3);
        new EventHandlerService.EventWorker(ehs).run();
        TestEventHandlerService.assertTrue((boolean)output.toString().contains("Workflow Action event SUSPEND"));
        output.setLength(0);
        event3.setStatus(WorkflowAction.Status.OK);
        ehs.queueEvent((Event)event3);
        new EventHandlerService.EventWorker(ehs).run();
        TestEventHandlerService.assertTrue((boolean)output.toString().contains("Workflow Action event SUCCESS"));
        output.setLength(0);
        event3.setStatus(WorkflowAction.Status.ERROR);
        ehs.queueEvent((Event)event3);
        new EventHandlerService.EventWorker(ehs).run();
        TestEventHandlerService.assertTrue((boolean)output.toString().contains("Workflow Action event FAILURE"));
        output.setLength(0);
        event3.setStatus(WorkflowAction.Status.KILLED);
        ehs.queueEvent((Event)event3);
        new EventHandlerService.EventWorker(ehs).run();
        TestEventHandlerService.assertTrue((boolean)output.toString().contains("Workflow Action event FAILURE"));
        output.setLength(0);
        event3.setStatus(WorkflowAction.Status.FAILED);
        ehs.queueEvent((Event)event3);
        new EventHandlerService.EventWorker(ehs).run();
        TestEventHandlerService.assertTrue((boolean)output.toString().contains("Workflow Action event FAILURE"));
        output.setLength(0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEventLogging() throws Exception {
        EventHandlerService ehs = this._testEventHandlerService();
        WorkflowJobEvent event = new WorkflowJobEvent("jobid", "parentid", WorkflowJob.Status.RUNNING, TestEventHandlerService.getTestUser(), "myapp", null, null);
        XTestCase.TestLogAppender appender = null;
        Logger logger = null;
        try {
            appender = this.getTestLogAppender();
            logger = Logger.getLogger(EventHandlerService.class);
            logger.addAppender((Appender)appender);
            logger.setLevel(Level.DEBUG);
            ehs.queueEvent((Event)event);
            List<LoggingEvent> log = appender.getLog();
            LoggingEvent logEntry = log.get(0);
            TestEventHandlerService.assertEquals((Object)Level.DEBUG, (Object)logEntry.getLevel());
            TestEventHandlerService.assertTrue((boolean)logEntry.getMessage().toString().contains("APP[myapp] JOB[jobid] ACTION[-] Queueing event : ID: jobid"));
            TestEventHandlerService.assertEquals((String)"org.apache.oozie.service.EventHandlerService", (String)logEntry.getLoggerName());
            new EventHandlerService.EventWorker(ehs).run();
            log = appender.getLog();
            logEntry = log.get(1);
            TestEventHandlerService.assertEquals((Object)Level.DEBUG, (Object)logEntry.getLevel());
            TestEventHandlerService.assertTrue((boolean)logEntry.getMessage().toString().contains("APP[myapp] JOB[jobid] ACTION[-] Processing event : ID: jobid"));
            CoordinatorActionEvent event2 = new CoordinatorActionEvent("jobid2@1", "parentid", CoordinatorAction.Status.WAITING, TestEventHandlerService.getTestUser(), "myapp", null, null, null);
            ehs.queueEvent((Event)event2);
            log = appender.getLog();
            logEntry = log.get(2);
            TestEventHandlerService.assertTrue((boolean)logEntry.getMessage().toString().contains("APP[myapp] JOB[jobid2] ACTION[jobid2@1] Queueing event : ID: jobid2@1"));
            WorkflowJobEvent event3 = new WorkflowJobEvent("jobid-other", "parentid", WorkflowJob.Status.RUNNING, TestEventHandlerService.getTestUser(), "myapp-other", null, null);
            ehs.queueEvent((Event)event3);
            log = appender.getLog();
            logEntry = log.get(3);
            TestEventHandlerService.assertTrue((boolean)logEntry.getMessage().toString().contains("APP[myapp-other] JOB[jobid-other] ACTION[-] Queueing event : ID: jobid-other"));
        }
        finally {
            logger.removeAppender((Appender)appender);
        }
    }

    private EventHandlerService _testEventHandlerService() throws Exception {
        Services services = Services.get();
        EventHandlerService ehs = (EventHandlerService)services.get(EventHandlerService.class);
        TestEventHandlerService.assertNotNull((Object)ehs);
        TestEventHandlerService.assertTrue((boolean)EventHandlerService.isEnabled());
        return ehs;
    }

    static class DummyJobEventListener
    extends JobEventListener {
        DummyJobEventListener() {
        }

        public void onWorkflowJobEvent(WorkflowJobEvent wje) {
            if (wje != null) {
                output.append("Dummy Workflow Job event " + wje.getEventStatus());
            }
        }

        public void onWorkflowActionEvent(WorkflowActionEvent wae) {
            if (wae != null) {
                output.append("Dummy Workflow Action event " + wae.getEventStatus());
            }
        }

        public void onCoordinatorJobEvent(CoordinatorJobEvent cje) {
            if (cje != null) {
                output.append("Dummy Coord Job event " + cje.getEventStatus());
            }
        }

        public void onCoordinatorActionEvent(CoordinatorActionEvent cae) {
            if (cae != null) {
                output.append("Dummy Coord Action event " + cae.getEventStatus());
            }
        }

        public void onBundleJobEvent(BundleJobEvent bje) {
            if (bje != null) {
                output.append("Dummy Bundle Job event " + bje.getEventStatus());
            }
        }

        public void init(Configuration conf) {
        }

        public void destroy() {
        }
    }
}

