/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.AppType;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.event.JobEvent;
import org.apache.oozie.client.event.SLAEvent;
import org.apache.oozie.event.EventQueue;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.CoordActionQueryExecutor;
import org.apache.oozie.executor.jpa.JPAExecutorException;
import org.apache.oozie.executor.jpa.SLASummaryQueryExecutor;
import org.apache.oozie.executor.jpa.WorkflowJobQueryExecutor;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.DummySLACalculatorMemory;
import org.apache.oozie.service.EventHandlerService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.ZKJobsConcurrencyService;
import org.apache.oozie.sla.SLACalcStatus;
import org.apache.oozie.sla.SLACalculatorMemory;
import org.apache.oozie.sla.SLARegistrationBean;
import org.apache.oozie.sla.SLASummaryBean;
import org.apache.oozie.sla.TestSLAService;
import org.apache.oozie.sla.listener.SLAEventListener;
import org.apache.oozie.sla.service.SLAService;
import org.apache.oozie.test.ZKXTestCase;
import org.apache.oozie.util.JobUtils;
import org.apache.oozie.util.Pair;
import org.apache.oozie.workflow.WorkflowInstance;

public class TestHASLAService
extends ZKXTestCase {
    private static StringBuilder output = new StringBuilder();

    @Override
    protected void setUp() throws Exception {
        Configuration conf = new Configuration(false);
        conf.set("oozie.services.ext", "org.apache.oozie.service.EventHandlerService,org.apache.oozie.sla.service.SLAService");
        conf.setClass("oozie.service.EventHandlerService.event.listeners", DummySLAEventListener.class, SLAEventListener.class);
        conf.setLong("oozie.sla.service.SLAService.job.event.latency", 0L);
        conf.setInt("oozie.sla.service.SLAService.check.initial.delay", 100000);
        conf.setInt("oozie.sla.service.SLAService.check.interval", 100000);
        conf.setInt("oozie.service.EventHandlerService.worker.threads", 0);
        super.setUp(conf);
        Services.get().setService(ZKJobsConcurrencyService.class);
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSLAFailOverWithHA() throws Exception {
        SLAService slas = (SLAService)Services.get().get(SLAService.class);
        SLACalculatorMemory slaCalcMem = (SLACalculatorMemory)slas.getSLACalculator();
        EventHandlerService ehs = (EventHandlerService)Services.get().get(EventHandlerService.class);
        ZKXTestCase.DummyZKOozie dummyOozie_1 = null;
        try {
            dummyOozie_1 = new ZKXTestCase.DummyZKOozie("a", "http://blah");
            DummySLACalculatorMemory dummyCalc = new DummySLACalculatorMemory();
            EventHandlerService dummyEhs = new EventHandlerService();
            dummyCalc.setEventHandlerService(dummyEhs);
            dummyEhs.init(Services.get());
            dummyCalc.init(Services.get().getConf());
            WorkflowJobBean wfJob1 = this.createWorkflow("job-1-W");
            SLARegistrationBean sla1 = TestSLAService._createSLARegistration("job-1-W", AppType.WORKFLOW_JOB);
            sla1.setExpectedStart(new Date(System.currentTimeMillis() - 0x6DDD00L));
            sla1.setExpectedEnd(new Date(System.currentTimeMillis() - 3600000L));
            sla1.setExpectedDuration(600000L);
            dummyCalc.addRegistration(sla1.getId(), sla1);
            dummyCalc.updateAllSlaStatus();
            WorkflowJobBean wfJob2 = this.createWorkflow("job-2-W");
            SLARegistrationBean sla2 = TestSLAService._createSLARegistration("job-2-W", AppType.WORKFLOW_JOB);
            sla2.setExpectedStart(new Date(System.currentTimeMillis() - 0x6DDD00L));
            sla2.setExpectedEnd(new Date(System.currentTimeMillis() + 3600000L));
            sla2.setExpectedDuration(600000L);
            dummyCalc.addRegistration(sla2.getId(), sla2);
            dummyCalc.addJobStatus(sla2.getId(), WorkflowJob.Status.RUNNING.name(), JobEvent.EventStatus.STARTED, new Date(), new Date());
            dummyCalc.updateAllSlaStatus();
            new EventHandlerService.EventWorker(dummyEhs).run();
            TestHASLAService.assertTrue((boolean)output.toString().contains(sla2.getId() + " Sla START - MISS!!!"));
            dummyCalc.clear();
            dummyCalc = null;
            dummyOozie_1.teardown();
            slaCalcMem.updateAllSlaStatus();
            slaCalcMem.addJobStatus(sla1.getId(), WorkflowJob.Status.RUNNING.name(), JobEvent.EventStatus.STARTED, new Date(), new Date());
            TestHASLAService.assertNotNull((Object)slaCalcMem.get(sla1.getId()));
            new EventHandlerService.EventWorker(ehs).run();
            TestHASLAService.assertTrue((boolean)output.toString().contains(sla1.getId() + " Sla START - MISS!!!"));
            wfJob1.setStatus(WorkflowJob.Status.SUCCEEDED);
            wfJob1.setEndTime(new Date());
            wfJob1.setStartTime(new Date());
            WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_START_END, (Object)wfJob1);
            slaCalcMem.addJobStatus(sla1.getId(), WorkflowJob.Status.SUCCEEDED.name(), JobEvent.EventStatus.SUCCESS, new Date(), new Date());
            new EventHandlerService.EventWorker(ehs).run();
            TestHASLAService.assertTrue((boolean)output.toString().contains(sla1.getId() + " Sla DURATION - MET!!!"));
            TestHASLAService.assertTrue((boolean)output.toString().contains(sla1.getId() + " Sla END - MISS!!!"));
            wfJob2.setStatus(WorkflowJob.Status.SUCCEEDED);
            wfJob2.setEndTime(new Date());
            wfJob2.setStartTime(new Date());
            WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_START_END, (Object)wfJob2);
            slaCalcMem.addJobStatus(sla2.getId(), WorkflowJob.Status.SUCCEEDED.name(), JobEvent.EventStatus.SUCCESS, new Date(), new Date());
            TestHASLAService.assertNull((Object)slaCalcMem.get(sla2.getId()));
            new EventHandlerService.EventWorker(ehs).run();
            TestHASLAService.assertTrue((boolean)output.toString().contains(sla2.getId() + " Sla DURATION - MET!!!"));
            TestHASLAService.assertTrue((boolean)output.toString().contains(sla2.getId() + " Sla END - MET!!!"));
        }
        finally {
            if (dummyOozie_1 != null) {
                dummyOozie_1.teardown();
            }
        }
    }

    public CoordinatorActionBean updateCoordAction(String id, String status) throws JPAExecutorException {
        CoordinatorActionBean action = new CoordinatorActionBean();
        action.setId(id);
        action.setStatusStr(status);
        action.setLastModifiedTime(new Date());
        CoordActionQueryExecutor.getInstance().executeUpdate((Enum)CoordActionQueryExecutor.CoordActionQuery.UPDATE_COORD_ACTION_STATUS_PENDING_TIME, (Object)action);
        return action;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSLAUpdateWithHA() throws Exception {
        String id1 = "0000001-130521183438837-oozie-test-C@1";
        String id2 = "0000002-130521183438837-oozie-test-C@1";
        String id3 = "0000003-130521183438837-oozie-test-C@1";
        String id4 = "0000004-130521183438837-oozie-test-C@1";
        String id5 = "0000005-130521183438837-oozie-test-C@1";
        String id6 = "0000006-130521183438837-oozie-test-C@1";
        Date expectedStartTS = new Date(System.currentTimeMillis() - 0x6DDD00L);
        Date expectedEndTS1 = new Date(System.currentTimeMillis() + 3600000L);
        Date expectedEndTS2 = new Date(System.currentTimeMillis() - 3600000L);
        this.createDBEntry(id1, expectedStartTS, expectedEndTS1);
        this.createDBEntry(id2, expectedStartTS, expectedEndTS1);
        this.createDBEntry(id3, expectedStartTS, expectedEndTS1);
        this.createDBEntry(id4, expectedStartTS, expectedEndTS1);
        this.createDBEntryForStarted(id5, expectedStartTS, expectedEndTS2, 1);
        this.createDBEntryForStarted(id6, expectedStartTS, expectedEndTS2, 1);
        SLAService slas = (SLAService)Services.get().get(SLAService.class);
        SLACalculatorMemory slaCalcMem = (SLACalculatorMemory)slas.getSLACalculator();
        slaCalcMem.init(Services.get().getConf());
        slaCalcMem.updateAllSlaStatus();
        ArrayList slaMapKeys = new ArrayList();
        Iterator itr = slaCalcMem.iterator();
        while (itr.hasNext()) {
            slaMapKeys.add(itr.next());
        }
        TestHASLAService.assertEquals((int)4, (int)slaMapKeys.size());
        TestHASLAService.assertEquals((int)2, (int)slaCalcMem.getHistorySet().size());
        ZKXTestCase.DummyZKOozie dummyOozie_1 = null;
        try {
            dummyOozie_1 = new ZKXTestCase.DummyZKOozie("a", "http://blah");
            DummySLACalculatorMemory dummySlaCalcMem = new DummySLACalculatorMemory();
            EventHandlerService dummyEhs = new EventHandlerService();
            dummySlaCalcMem.setEventHandlerService(dummyEhs);
            dummyEhs.init(Services.get());
            dummySlaCalcMem.init(Services.get().getConf());
            dummySlaCalcMem.updateAllSlaStatus();
            slaMapKeys = new ArrayList();
            itr = dummySlaCalcMem.iterator();
            while (itr.hasNext()) {
                slaMapKeys.add(itr.next());
            }
            TestHASLAService.assertEquals((int)4, (int)slaMapKeys.size());
            TestHASLAService.assertEquals((int)2, (int)dummySlaCalcMem.getHistorySet().size());
            this.updateCoordAction(id1, "RUNNING");
            slaCalcMem.addJobStatus(id1, CoordinatorAction.Status.RUNNING.name(), JobEvent.EventStatus.STARTED, new Date(), null);
            this.updateCoordAction(id3, "FAILED");
            slaCalcMem.addJobStatus(id3, CoordinatorAction.Status.FAILED.name(), JobEvent.EventStatus.FAILURE, null, new Date());
            this.updateCoordAction(id2, "RUNNING");
            dummySlaCalcMem.addJobStatus(id2, CoordinatorAction.Status.RUNNING.name(), JobEvent.EventStatus.STARTED, new Date(), null);
            this.updateCoordAction(id4, "FAILED");
            dummySlaCalcMem.addJobStatus(id4, CoordinatorAction.Status.FAILED.name(), JobEvent.EventStatus.FAILURE, null, new Date());
            slaCalcMem.updateAllSlaStatus();
            dummySlaCalcMem.updateAllSlaStatus();
            SLACalcStatus sla1_nodummy = slaCalcMem.get(id1);
            SLACalcStatus sla1_dummy = dummySlaCalcMem.get(id1);
            SLACalcStatus sla2_nodummy = slaCalcMem.get(id2);
            SLACalcStatus sla2_dummy = dummySlaCalcMem.get(id2);
            TestHASLAService.assertEquals((int)1, (int)sla1_nodummy.getEventProcessed());
            TestHASLAService.assertEquals((int)1, (int)sla1_dummy.getEventProcessed());
            TestHASLAService.assertEquals((int)1, (int)sla2_dummy.getEventProcessed());
            TestHASLAService.assertEquals((int)1, (int)sla2_nodummy.getEventProcessed());
            TestHASLAService.assertFalse((boolean)slaCalcMem.isJobIdInSLAMap(id3));
            TestHASLAService.assertFalse((boolean)dummySlaCalcMem.isJobIdInSLAMap(id3));
            TestHASLAService.assertFalse((boolean)slaCalcMem.isJobIdInSLAMap(id4));
            TestHASLAService.assertFalse((boolean)dummySlaCalcMem.isJobIdInSLAMap(id4));
            Byte eventProc = (Byte)SLASummaryQueryExecutor.getInstance().getSingleValue((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY_EVENTPROCESSED, new Object[]{id3});
            TestHASLAService.assertEquals((int)8, (int)eventProc.byteValue());
            eventProc = (Byte)SLASummaryQueryExecutor.getInstance().getSingleValue((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY_EVENTPROCESSED, new Object[]{id4});
            TestHASLAService.assertEquals((int)8, (int)eventProc.byteValue());
            TestHASLAService.assertTrue((boolean)slaCalcMem.isJobIdInHistorySet(id5));
            TestHASLAService.assertTrue((boolean)dummySlaCalcMem.isJobIdInHistorySet(id6));
            TestHASLAService.assertTrue((boolean)slaCalcMem.isJobIdInHistorySet(id5));
            TestHASLAService.assertTrue((boolean)dummySlaCalcMem.isJobIdInHistorySet(id6));
            eventProc = (Byte)SLASummaryQueryExecutor.getInstance().getSingleValue((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY_EVENTPROCESSED, new Object[]{id5});
            TestHASLAService.assertEquals((int)7, (int)eventProc.byteValue());
            eventProc = (Byte)SLASummaryQueryExecutor.getInstance().getSingleValue((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY_EVENTPROCESSED, new Object[]{id6});
            TestHASLAService.assertEquals((int)7, (int)eventProc.byteValue());
            this.updateCoordAction(id1, "SUCCEEDED");
            slaCalcMem.addJobStatus(id1, CoordinatorAction.Status.SUCCEEDED.name(), JobEvent.EventStatus.SUCCESS, new Date(System.currentTimeMillis() - 1800000L), new Date());
            this.updateCoordAction(id2, "SUCCEEDED");
            dummySlaCalcMem.addJobStatus(id2, CoordinatorAction.Status.SUCCEEDED.name(), JobEvent.EventStatus.SUCCESS, new Date(System.currentTimeMillis() - 1800000L), new Date());
            slaCalcMem.updateAllSlaStatus();
            dummySlaCalcMem.updateAllSlaStatus();
            TestHASLAService.assertNull((Object)slaCalcMem.get(id1));
            TestHASLAService.assertNull((Object)dummySlaCalcMem.get(id1));
            TestHASLAService.assertNull((Object)slaCalcMem.get(id2));
            TestHASLAService.assertNull((Object)dummySlaCalcMem.get(id2));
            eventProc = (Byte)SLASummaryQueryExecutor.getInstance().getSingleValue((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY_EVENTPROCESSED, new Object[]{id1});
            TestHASLAService.assertEquals((int)8, (int)eventProc.byteValue());
            eventProc = (Byte)SLASummaryQueryExecutor.getInstance().getSingleValue((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY_EVENTPROCESSED, new Object[]{id2});
            TestHASLAService.assertEquals((int)8, (int)eventProc.byteValue());
            this.updateCoordAction(id5, "SUCCEEDED");
            new SLACalculatorMemory.HistoryPurgeWorker(slaCalcMem).run();
            TestHASLAService.assertFalse((boolean)slaCalcMem.isJobIdInHistorySet(id5));
            this.updateCoordAction(id6, "SUCCEEDED");
            new SLACalculatorMemory.HistoryPurgeWorker((SLACalculatorMemory)dummySlaCalcMem).run();
            TestHASLAService.assertFalse((boolean)dummySlaCalcMem.isJobIdInHistorySet(id6));
        }
        finally {
            if (dummyOozie_1 != null) {
                dummyOozie_1.teardown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testNoDuplicateEventsInHA() throws Exception {
        String id1 = "0000001-130521183438837-oozie-test-C@1";
        SLAService slas = (SLAService)Services.get().get(SLAService.class);
        SLACalculatorMemory slaCalcMem = (SLACalculatorMemory)slas.getSLACalculator();
        slaCalcMem.init(Services.get().getConf());
        EventHandlerService ehs = (EventHandlerService)Services.get().get(EventHandlerService.class);
        EventQueue ehs_q = ehs.getEventQueue();
        ZKXTestCase.DummyZKOozie dummyOozie_1 = null;
        try {
            dummyOozie_1 = new ZKXTestCase.DummyZKOozie("a", "http://blah");
            DummySLACalculatorMemory dummySlaCalcMem = new DummySLACalculatorMemory();
            dummySlaCalcMem.init(Services.get().getConf());
            EventHandlerService dummyEhs = new EventHandlerService();
            dummySlaCalcMem.setEventHandlerService(dummyEhs);
            dummyEhs.init(Services.get());
            EventQueue dummyEhs_q = dummyEhs.getEventQueue();
            Date expectedStartTS = new Date(System.currentTimeMillis() + 0x6DDD00L);
            Date expectedEndTS = new Date(System.currentTimeMillis() + 3600000L);
            SLASummaryBean sla = this.createDBEntryForStarted(id1, expectedStartTS, expectedEndTS, 0);
            sla.setExpectedDuration(-1L);
            sla.setLastModifiedTime(new Date());
            SLASummaryQueryExecutor.getInstance().executeUpdate((Enum)SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_FOR_EXPECTED_TIMES, (Object)sla);
            this.updateCoordAction(id1, "RUNNING");
            slaCalcMem.addJobStatus(id1, CoordinatorAction.Status.RUNNING.name(), JobEvent.EventStatus.STARTED, new Date(), null);
            TestHASLAService.assertEquals((int)1, (int)ehs_q.size());
            SLACalcStatus s1 = (SLACalcStatus)ehs_q.poll();
            TestHASLAService.assertEquals((Object)SLAEvent.SLAStatus.IN_PROCESS, (Object)s1.getSLAStatus());
            this.updateCoordAction(id1, "FAILED");
            dummySlaCalcMem.addJobStatus(id1, CoordinatorAction.Status.FAILED.name(), JobEvent.EventStatus.FAILURE, new Date(System.currentTimeMillis() - 1800000L), new Date());
            SLACalcStatus s2 = (SLACalcStatus)dummyEhs_q.poll();
            TestHASLAService.assertEquals((Object)SLAEvent.SLAStatus.MISS, (Object)s2.getSLAStatus());
            slaCalcMem.updateAllSlaStatus();
            dummySlaCalcMem.updateAllSlaStatus();
            TestHASLAService.assertEquals((int)0, (int)ehs_q.size());
        }
        finally {
            if (dummyOozie_1 != null) {
                dummyOozie_1.teardown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testSLAAlertCommandWithHA() throws Exception {
        String id = "0000001-130521183438837-oozie-test-C@1";
        Date expectedStartTS = new Date(System.currentTimeMillis() - 0x6DDD00L);
        Date expectedEndTS1 = new Date(System.currentTimeMillis() + 3600000L);
        this.createDBEntry(id, expectedStartTS, expectedEndTS1);
        SLAService slas = (SLAService)Services.get().get(SLAService.class);
        SLACalculatorMemory slaCalcMem1 = (SLACalculatorMemory)slas.getSLACalculator();
        slaCalcMem1.init(((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf());
        slaCalcMem1.updateAllSlaStatus();
        ArrayList<String> idList = new ArrayList<String>();
        idList.add(id);
        slaCalcMem1.disableAlert(idList);
        TestHASLAService.assertTrue((boolean)slaCalcMem1.get(id).getSLAConfigMap().containsKey("oozie.sla.disable.alerts"));
        ZKXTestCase.DummyZKOozie dummyOozie_1 = null;
        try {
            dummyOozie_1 = new ZKXTestCase.DummyZKOozie("a", "http://blah");
            DummySLACalculatorMemory slaCalcMem2 = new DummySLACalculatorMemory();
            EventHandlerService dummyEhs = new EventHandlerService();
            slaCalcMem2.setEventHandlerService(dummyEhs);
            ((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf().setInt("oozie.sla.service.SLAService.check.interval", 100000);
            ((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf().setInt("oozie.sla.service.SLAService.check.initial.delay", 100000);
            dummyEhs.init(Services.get());
            slaCalcMem2.init(((ConfigurationService)Services.get().get(ConfigurationService.class)).getConf());
            slaCalcMem2.updateAllSlaStatus();
            TestHASLAService.assertTrue((boolean)slaCalcMem2.get(id).getSLAConfigMap().containsKey("oozie.sla.disable.alerts"));
            String newParams = "sla-max-duration=5";
            ArrayList<Pair> jobIdsSLAPair = new ArrayList<Pair>();
            jobIdsSLAPair.add(new Pair((Object)id, (Object)JobUtils.parseChangeValue((String)newParams)));
            slaCalcMem1.changeDefinition(jobIdsSLAPair);
            TestHASLAService.assertEquals((long)slaCalcMem1.get(id).getExpectedDuration(), (long)300000L);
            TestHASLAService.assertEquals((long)slaCalcMem2.get(id).getExpectedDuration(), (long)600000L);
            slaCalcMem2.updateAllSlaStatus();
            TestHASLAService.assertEquals((long)slaCalcMem2.get(id).getExpectedDuration(), (long)300000L);
            newParams = "sla-max-duration=15";
            jobIdsSLAPair.clear();
            jobIdsSLAPair.add(new Pair((Object)id, (Object)JobUtils.parseChangeValue((String)newParams)));
            slaCalcMem1.changeDefinition(jobIdsSLAPair);
            TestHASLAService.assertEquals((long)slaCalcMem2.get(id).getExpectedDuration(), (long)300000L);
            slaCalcMem2.updateAllSlaStatus();
            TestHASLAService.assertEquals((long)slaCalcMem2.get(id).getExpectedDuration(), (long)900000L);
        }
        finally {
            if (dummyOozie_1 != null) {
                dummyOozie_1.teardown();
            }
        }
    }

    private void createDBEntry(String actionId, Date expectedStartTS, Date expectedEndTS) throws Exception {
        ArrayList<Object> insertList = new ArrayList<Object>();
        CoordinatorActionBean coordAction = new CoordinatorActionBean();
        Date modTime = new Date(System.currentTimeMillis() - 0x6DDD00L);
        coordAction.setId(actionId);
        coordAction.setJobId(actionId.split("@", -1)[0]);
        coordAction.setStatusStr("WAITING");
        coordAction.setLastModifiedTime(modTime);
        CoordinatorJobBean coordJob = new CoordinatorJobBean();
        coordJob.setId(actionId.split("@", -1)[0]);
        coordJob.setUser("dummy");
        coordJob.setAppName("dummy");
        coordJob.setStatusStr("RUNNING");
        coordJob.setAppNamespace("dummy");
        SLASummaryBean sla = new SLASummaryBean();
        sla.setId(actionId);
        sla.setAppType(AppType.COORDINATOR_ACTION);
        sla.setJobStatus("WAITING");
        sla.setSLAStatus(SLAEvent.SLAStatus.NOT_STARTED);
        sla.setEventProcessed(0);
        sla.setLastModifiedTime(modTime);
        sla.setExpectedStart(expectedStartTS);
        sla.setExpectedEnd(expectedEndTS);
        sla.setExpectedDuration(600000L);
        SLARegistrationBean reg = new SLARegistrationBean();
        reg.setId(actionId);
        insertList.add(coordAction);
        insertList.add(coordJob);
        insertList.add(sla);
        insertList.add(reg);
        BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(insertList, null, null);
    }

    private SLASummaryBean createDBEntryForStarted(String actionId, Date expectedStartTS, Date expectedEndTS, int eventProcessed) throws Exception {
        ArrayList<Object> insertList = new ArrayList<Object>();
        Date modTime = new Date();
        WorkflowJobBean wf = this.addRecordToWfJobTable(WorkflowJob.Status.RUNNING, WorkflowInstance.Status.RUNNING, actionId);
        wf.setStatus(wf.getStatus());
        wf.setStartTime(expectedStartTS);
        wf.setLastModifiedTime(modTime);
        WorkflowJobQueryExecutor.getInstance().executeUpdate((Enum)WorkflowJobQueryExecutor.WorkflowJobQuery.UPDATE_WORKFLOW_STATUS_INSTANCE_MOD_START_END, (Object)wf);
        CoordinatorActionBean coordAction = new CoordinatorActionBean();
        coordAction.setId(actionId);
        coordAction.setJobId(actionId.split("@", -1)[0]);
        coordAction.setStatusStr("RUNNING");
        coordAction.setLastModifiedTime(modTime);
        coordAction.setExternalId(wf.getId());
        CoordinatorJobBean coordJob = new CoordinatorJobBean();
        coordJob.setId(actionId.split("@", -1)[0]);
        coordJob.setUser("dummy");
        coordJob.setAppName("dummy");
        coordJob.setStatusStr("RUNNING");
        coordJob.setAppNamespace("dummy");
        SLASummaryBean sla = new SLASummaryBean();
        sla.setId(actionId);
        sla.setAppType(AppType.COORDINATOR_ACTION);
        sla.setJobStatus("RUNNING");
        sla.setSLAStatus(SLAEvent.SLAStatus.IN_PROCESS);
        sla.setEventProcessed(eventProcessed);
        sla.setLastModifiedTime(modTime);
        sla.setExpectedStart(expectedStartTS);
        sla.setActualStart(expectedStartTS);
        sla.setExpectedEnd(expectedEndTS);
        sla.setExpectedDuration(600000L);
        SLARegistrationBean reg = new SLARegistrationBean();
        reg.setId(actionId);
        insertList.add(coordAction);
        insertList.add(coordJob);
        insertList.add(sla);
        insertList.add(reg);
        BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(insertList, null, null);
        return sla;
    }

    private WorkflowJobBean createWorkflow(String id) throws Exception {
        ArrayList<WorkflowJobBean> insertList = new ArrayList<WorkflowJobBean>();
        WorkflowJobBean workflow = new WorkflowJobBean();
        workflow.setId(id);
        workflow.setStatusStr("PREP");
        workflow.setStartTime(new Date());
        workflow.setSlaXml("<sla></sla>");
        insertList.add(workflow);
        BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(insertList, null, null);
        return workflow;
    }

    public static class DummySLAEventListener
    extends SLAEventListener {
        public void onStartMet(SLAEvent sla) {
            output.append(sla.getId() + " Sla START - MET!!!");
        }

        public void onStartMiss(SLAEvent sla) {
            output.append(sla.getId() + " Sla START - MISS!!!");
        }

        public void onEndMet(SLAEvent sla) {
            output.append(sla.getId() + " Sla END - MET!!!");
        }

        public void onEndMiss(SLAEvent sla) {
            output.append(sla.getId() + " Sla END - MISS!!!");
        }

        public void onDurationMet(SLAEvent sla) {
            output.append(sla.getId() + " Sla DURATION - MET!!!");
        }

        public void onDurationMiss(SLAEvent sla) {
            output.append(sla.getId() + " Sla DURATION - MISS!!!");
        }

        public void init(Configuration conf) {
        }

        public void destroy() {
        }
    }
}

