/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.util.Date;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.service.DummyV2AdminServlet;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.ShareLibService;
import org.apache.oozie.service.WorkflowAppService;
import org.apache.oozie.service.ZKJobsConcurrencyService;
import org.apache.oozie.servlet.HostnameFilter;
import org.apache.oozie.servlet.V2AdminServlet;
import org.apache.oozie.test.EmbeddedServletContainer;
import org.apache.oozie.test.ZKXTestCase;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class TestHAShareLibService
extends ZKXTestCase {
    EmbeddedServletContainer container;
    FileSystem fs;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.container = new EmbeddedServletContainer("oozie");
        this.container.addServletEndpoint("/v2/admin/*", V2AdminServlet.class);
        this.container.addServletEndpoint("/other-oozie-server/*", DummyV2AdminServlet.class);
        this.container.addFilter("*", HostnameFilter.class);
        this.container.start();
        Services.get().setService(ShareLibService.class);
        Services.get().getConf().setBoolean("oozie.service.AuthorizationService.security.enabled", false);
        Services.get().setService(ZKJobsConcurrencyService.class);
        Path launcherlibPath = ((WorkflowAppService)Services.get().get(WorkflowAppService.class)).getSystemLibPath();
        HadoopAccessorService has = (HadoopAccessorService)Services.get().get(HadoopAccessorService.class);
        URI uri = launcherlibPath.toUri();
        this.fs = FileSystem.get((Configuration)has.createConfiguration(uri.getAuthority()));
        Date time = new Date(System.currentTimeMillis());
        Path basePath = new Path(Services.get().getConf().get("oozie.service.WorkflowAppService.system.libpath"));
        Path libpath = new Path(basePath, "lib_" + ShareLibService.dateFormat.format(time));
        this.fs.mkdirs(libpath);
        Path pigPath = new Path(libpath.toString() + "/" + "pig");
        Path pigPath1 = new Path(libpath.toString() + "/" + "pig_9");
        Path pigPath2 = new Path(libpath.toString() + "/" + "pig_10");
        this.fs.mkdirs(pigPath);
        this.fs.mkdirs(pigPath1);
        this.fs.mkdirs(pigPath2);
        this.fs.create(new Path(libpath.toString() + "/" + "pig_10" + "/" + "pig-10.jar")).close();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testShareLibWithHA() throws Exception {
        ZKJobsConcurrencyService zkjcs = new ZKJobsConcurrencyService();
        zkjcs.init(Services.get());
        ZKXTestCase.DummyZKOozie dummyOozie_1 = null;
        ZKXTestCase.DummyZKOozie dummyOozie_2 = null;
        try {
            dummyOozie_1 = new ZKXTestCase.DummyZKOozie(this, "9876", this.container.getServletURL("/other-oozie-server/*"));
            String url = this.container.getServletURL("/v2/admin/*") + "update_sharelib?" + "allservers" + "=true";
            HttpClient client = new HttpClient();
            GetMethod method = new GetMethod(url);
            int statusCode = client.executeMethod((HttpMethod)method);
            TestHAShareLibService.assertEquals((int)200, (int)statusCode);
            InputStreamReader reader = new InputStreamReader(method.getResponseBodyAsStream());
            JSONArray sharelib = (JSONArray)JSONValue.parse((Reader)reader);
            TestHAShareLibService.assertEquals((int)2, (int)sharelib.size());
            JSONObject obj = (JSONObject)sharelib.get(0);
            TestHAShareLibService.assertEquals((Object)"Successful", (Object)((JSONObject)obj.get((Object)"sharelibUpdate")).get((Object)"status"));
            obj = (JSONObject)sharelib.get(1);
            TestHAShareLibService.assertEquals((Object)"Successful", (Object)((JSONObject)obj.get((Object)"sharelibUpdate")).get((Object)"status"));
            dummyOozie_2 = new ZKXTestCase.DummyZKOozie(this, "9873", this.container.getServletURL("/") + "not-defined/");
            statusCode = client.executeMethod((HttpMethod)method);
            TestHAShareLibService.assertEquals((int)200, (int)statusCode);
            reader = new InputStreamReader(method.getResponseBodyAsStream());
            sharelib = (JSONArray)JSONValue.parse((Reader)reader);
            TestHAShareLibService.assertEquals((int)3, (int)sharelib.size());
            obj = (JSONObject)sharelib.get(0);
            String status1 = ((JSONObject)obj.get((Object)"sharelibUpdate")).get((Object)"status").toString();
            obj = (JSONObject)sharelib.get(1);
            String status2 = ((JSONObject)obj.get((Object)"sharelibUpdate")).get((Object)"status").toString();
            obj = (JSONObject)sharelib.get(2);
            String status3 = ((JSONObject)obj.get((Object)"sharelibUpdate")).get((Object)"status").toString();
            int success = 0;
            int notSuccess = 0;
            if (status1.equals("Successful")) {
                ++success;
            } else {
                ++notSuccess;
            }
            if (status2.equals("Successful")) {
                ++success;
            } else {
                ++notSuccess;
            }
            if (status3.equals("Successful")) {
                ++success;
            } else {
                ++notSuccess;
            }
            TestHAShareLibService.assertEquals((int)1, (int)notSuccess);
            TestHAShareLibService.assertEquals((int)2, (int)success);
        }
        finally {
            if (dummyOozie_1 != null) {
                dummyOozie_1.teardown();
            }
            if (dummyOozie_2 != null) {
                dummyOozie_2.teardown();
            }
            zkjcs.destroy();
            this.container.stop();
        }
    }

    static {
        new V2AdminServlet();
    }
}

