/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.jms.JMSConnectionInfo;
import org.apache.oozie.service.HCatAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XHCatTestCase;
import org.junit.Test;

public class TestHCatAccessorService
extends XHCatTestCase {
    private Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = super.setupServicesForHCatalog();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.services != null) {
            this.services.destroy();
        }
        super.tearDown();
    }

    @Test
    public void testGetJMSConnectionInfoNoDefault() throws Exception {
        this.services.destroy();
        this.services = super.setupServicesForHCatalog();
        Configuration conf = this.services.getConf();
        String server2 = "hcat://${1}.${2}.server.com:8020=java.naming.factory.initial#Dummy.Factory;java.naming.provider.url#tcp://broker.${2}:61616";
        String server3 = "hcat://xyz.corp.dummy.com=java.naming.factory.initial#Dummy.Factory;java.naming.provider.url#tcp:localhost:61616";
        String jmsConnectionURL = server2 + "," + server3;
        conf.set("oozie.service.HCatAccessorService.jmsconnections", jmsConnectionURL);
        this.services.init();
        HCatAccessorService hcatService = (HCatAccessorService)this.services.get(HCatAccessorService.class);
        JMSConnectionInfo connInfo = hcatService.getJMSConnectionInfo(new URI("http://unknown:9999/fs"));
        TestHCatAccessorService.assertNull((Object)connInfo);
        connInfo = hcatService.getJMSConnectionInfo(new URI("hcat://server1.colo1.server.com:8020/db/table/pk1=val1;pk2=val2"));
        TestHCatAccessorService.assertEquals((String)"java.naming.factory.initial#Dummy.Factory;java.naming.provider.url#tcp://broker.colo1:61616", (String)connInfo.getJNDIPropertiesString());
        connInfo = hcatService.getJMSConnectionInfo(new URI("hcat://xyz.corp.dummy.com/db/table"));
        TestHCatAccessorService.assertEquals((String)"java.naming.factory.initial#Dummy.Factory;java.naming.provider.url#tcp:localhost:61616", (String)connInfo.getJNDIPropertiesString());
    }

    @Test
    public void testGetJMSConnectionInfo() throws Exception {
        this.services.destroy();
        this.services = super.setupServicesForHCatalog();
        Configuration conf = this.services.getConf();
        String server1 = "default=java.naming.factory.initial#org.apache.activemq.jndi.ActiveMQInitialContextFactory;java.naming.provider.url#vm://localhost?broker.persistent=false";
        String server2 = "hcat://${1}.${2}.server.com:8020=java.naming.factory.initial#Dummy.Factory;java.naming.provider.url#tcp://broker.${2}:61616";
        String server3 = "hcat://xyz.corp.dummy.com=java.naming.factory.initial#Dummy.Factory;java.naming.provider.url#tcp:localhost:61616";
        String jmsConnectionURL = server1 + "," + server2 + "," + server3;
        conf.set("oozie.service.HCatAccessorService.jmsconnections", jmsConnectionURL);
        this.services.init();
        HCatAccessorService hcatService = (HCatAccessorService)this.services.get(HCatAccessorService.class);
        JMSConnectionInfo connInfo = hcatService.getJMSConnectionInfo(new URI("hcat://hcatserver.blue.server.com:8020"));
        TestHCatAccessorService.assertEquals((String)"java.naming.factory.initial#Dummy.Factory;java.naming.provider.url#tcp://broker.blue:61616", (String)connInfo.getJNDIPropertiesString());
        connInfo = hcatService.getJMSConnectionInfo(new URI("http://unknown:9999/fs"));
        TestHCatAccessorService.assertEquals((String)"java.naming.factory.initial#org.apache.activemq.jndi.ActiveMQInitialContextFactory;java.naming.provider.url#vm://localhost?broker.persistent=false", (String)connInfo.getJNDIPropertiesString());
        connInfo = hcatService.getJMSConnectionInfo(new URI("hcat://xyz.corp.dummy.com"));
        TestHCatAccessorService.assertEquals((String)"java.naming.factory.initial#Dummy.Factory;java.naming.provider.url#tcp:localhost:61616", (String)connInfo.getJNDIPropertiesString());
    }

    @Test
    public void testGetHCatConfLocal() throws Exception {
        File hcatConfFile = new File(this.getTestCaseConfDir(), "hive-site.xml");
        TestHCatAccessorService.assertFalse((boolean)hcatConfFile.exists());
        TestHCatAccessorService.assertNull((Object)((HCatAccessorService)this.services.get(HCatAccessorService.class)).getHCatConf());
        Configuration hcatConf = new Configuration(false);
        hcatConf.set("A", "a");
        hcatConf.writeXml((OutputStream)new FileOutputStream(hcatConfFile));
        TestHCatAccessorService.assertTrue((boolean)hcatConfFile.exists());
        this.services.destroy();
        this.services = super.setupServicesForHCatalog();
        Configuration conf = this.services.getConf();
        conf.set("oozie.service.HCatAccessorService.hcat.configuration", hcatConfFile.getAbsolutePath());
        this.services.init();
        Configuration hcatConfLoaded = ((HCatAccessorService)this.services.get(HCatAccessorService.class)).getHCatConf();
        TestHCatAccessorService.assertEquals((String)"a", (String)hcatConfLoaded.get("A"));
    }

    @Test
    public void testGetHCatConfHDFS() throws Exception {
        Path hcatConfPath = new Path(this.getFsTestCaseDir(), "hive-site.xml");
        TestHCatAccessorService.assertFalse((boolean)this.getFileSystem().exists(hcatConfPath));
        TestHCatAccessorService.assertNull((Object)((HCatAccessorService)this.services.get(HCatAccessorService.class)).getHCatConf());
        Configuration hcatConf = new Configuration(false);
        hcatConf.set("A", "a");
        FSDataOutputStream out = this.getFileSystem().create(hcatConfPath);
        hcatConf.writeXml((OutputStream)out);
        out.close();
        TestHCatAccessorService.assertTrue((boolean)this.getFileSystem().exists(hcatConfPath));
        this.services.destroy();
        this.services = super.setupServicesForHCatalog();
        Configuration conf = this.services.getConf();
        conf.set("oozie.service.HCatAccessorService.hcat.configuration", hcatConfPath.toUri().toString());
        this.services.init();
        Configuration hcatConfLoaded = ((HCatAccessorService)this.services.get(HCatAccessorService.class)).getHCatConf();
        TestHCatAccessorService.assertEquals((String)"a", (String)hcatConfLoaded.get("A"));
    }
}

