/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.ipc.RemoteException;
import org.apache.hadoop.mapred.JobClient;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.authorize.AuthorizationException;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.hadoop.yarn.api.records.LocalResourceType;
import org.apache.hadoop.yarn.api.records.LocalResourceVisibility;
import org.apache.hadoop.yarn.api.records.URL;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.hadoop.yarn.util.ConverterUtils;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.service.HadoopAccessorException;
import org.apache.oozie.service.HadoopAccessorService;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XFsTestCase;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;

public class TestHadoopAccessorService
extends XFsTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        new File(this.getTestCaseConfDir(), "hadoop-confx").mkdir();
        File actConfXDir = new File(this.getTestCaseConfDir(), "action-confx");
        actConfXDir.mkdir();
        new File(actConfXDir, "action").mkdir();
        new File(actConfXDir, "default").mkdir();
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("test-hadoop-config.xml");
        FileOutputStream os = new FileOutputStream(new File(this.getTestCaseConfDir() + "/hadoop-confx", "core-site.xml"));
        IOUtils.copyStream((InputStream)is, (OutputStream)os);
        is = Thread.currentThread().getContextClassLoader().getResourceAsStream("test-action-config.xml");
        os = new FileOutputStream(new File(actConfXDir, "action.xml"));
        IOUtils.copyStream((InputStream)is, (OutputStream)os);
        is = Thread.currentThread().getContextClassLoader().getResourceAsStream("test-default-config.xml");
        os = new FileOutputStream(new File(actConfXDir, "default.xml"));
        IOUtils.copyStream((InputStream)is, (OutputStream)os);
        is = Thread.currentThread().getContextClassLoader().getResourceAsStream("test-action-config-1.xml");
        os = new FileOutputStream(new File(actConfXDir + "/action", "a-conf.xml"));
        IOUtils.copyStream((InputStream)is, (OutputStream)os);
        is = Thread.currentThread().getContextClassLoader().getResourceAsStream("test-action-config-2.xml");
        os = new FileOutputStream(new File(actConfXDir + "/action", "b-conf.xml"));
        IOUtils.copyStream((InputStream)is, (OutputStream)os);
        is = Thread.currentThread().getContextClassLoader().getResourceAsStream("test-action-config-3.xml");
        os = new FileOutputStream(new File(actConfXDir + "/action", "c-conf-3.xml"));
        IOUtils.copyStream((InputStream)is, (OutputStream)os);
        is = Thread.currentThread().getContextClassLoader().getResourceAsStream("test-default-config-1.xml");
        os = new FileOutputStream(new File(actConfXDir + "/default", "z-conf.xml"));
        IOUtils.copyStream((InputStream)is, (OutputStream)os);
        is = Thread.currentThread().getContextClassLoader().getResourceAsStream("test-custom-log4j.properties");
        os = new FileOutputStream(new File(actConfXDir + "/action", "test-custom-log4j.properties"));
        IOUtils.copyStream((InputStream)is, (OutputStream)os);
        this.setSystemProperty("oozie.service.HadoopAccessorService.hadoop.configurations", "*=hadoop-conf,jt=hadoop-confx");
        this.setSystemProperty("oozie.service.HadoopAccessorService.action.configurations", "*=hadoop-conf,jt=action-confx");
        if (System.getProperty("oozie.test.hadoop.security", "simple").equals("kerberos")) {
            this.setSystemProperty("oozie.service.HadoopAccessorService.kerberos.enabled", "true");
            this.setSystemProperty("oozie.service.HadoopAccessorService.keytab.file", this.getKeytabFile());
            this.setSystemProperty("oozie.service.HadoopAccessorService.kerberos.principal", this.getOoziePrincipal());
        }
        Services services = new Services();
        services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        Services.get().destroy();
        super.tearDown();
    }

    public void testService() throws Exception {
        Services services = Services.get();
        HadoopAccessorService has = (HadoopAccessorService)services.get(HadoopAccessorService.class);
        TestHadoopAccessorService.assertNotNull((Object)has);
        TestHadoopAccessorService.assertNotNull((Object)has.createConfiguration("*"));
        TestHadoopAccessorService.assertNotNull((Object)has.createConfiguration("jt"));
        TestHadoopAccessorService.assertEquals((String)"bar", (String)has.createConfiguration("jt").get("foo"));
        TestHadoopAccessorService.assertNotNull((Object)has.createActionDefaultConf("*", "action"));
        TestHadoopAccessorService.assertNotNull((Object)has.createActionDefaultConf("jt", "action"));
        TestHadoopAccessorService.assertNotNull((Object)has.createActionDefaultConf("jt", "actionx"));
        TestHadoopAccessorService.assertNotNull((Object)has.createActionDefaultConf("jtx", "action"));
        TestHadoopAccessorService.assertNull((Object)has.createActionDefaultConf("*", "action").get("action.foo"));
    }

    public void testActionConfigurations() throws Exception {
        Services services = Services.get();
        HadoopAccessorService has = (HadoopAccessorService)services.get(HadoopAccessorService.class);
        TestHadoopAccessorService.assertNotNull((Object)has);
        XConfiguration conf = has.createActionDefaultConf("jt", "action");
        TestHadoopAccessorService.assertNotNull((Object)conf);
        TestHadoopAccessorService.assertEquals((String)"default.bar", (String)conf.get("default.foo"));
        TestHadoopAccessorService.assertEquals((String)"default.bus", (String)conf.get("default.car"));
        TestHadoopAccessorService.assertEquals((String)"action.bar", (String)conf.get("action.foo"));
        TestHadoopAccessorService.assertEquals((String)"action.car", (String)conf.get("action.boo"));
        TestHadoopAccessorService.assertEquals((String)"action.carcar", (String)conf.get("oozie.launcher.action.booboo"));
        TestHadoopAccessorService.assertEquals((String)"100", (String)conf.get("action.testprop"));
        TestHadoopAccessorService.assertEquals((String)"1", (String)conf.get("default.testprop"));
        TestHadoopAccessorService.assertEquals((String)"org.apache.log4j.ConsoleAppender", (String)conf.get("log4j.appender.oozie"));
        TestHadoopAccessorService.assertEquals((String)"NONE, null", (String)conf.get("log4j.logger.a"));
    }

    public void testCreateJobClient() throws Exception {
        HadoopAccessorService has = (HadoopAccessorService)Services.get().get(HadoopAccessorService.class);
        Configuration conf = has.createConfiguration(this.getJobTrackerUri());
        JobClient jc = has.createJobClient(TestHadoopAccessorService.getTestUser(), conf);
        TestHadoopAccessorService.assertNotNull((Object)jc);
        jc.getAllJobs();
        JobConf conf2 = new JobConf(false);
        conf2.set("mapred.job.tracker", this.getJobTrackerUri());
        try {
            has.createJobClient(TestHadoopAccessorService.getTestUser(), conf2);
            TestHadoopAccessorService.fail((String)"Should have thrown exception because Configuration not created by HadoopAccessorService");
        }
        catch (HadoopAccessorException ex) {
            TestHadoopAccessorService.assertEquals((Object)ErrorCode.E0903, (Object)ex.getErrorCode());
        }
    }

    public void testCreateYarnClient() throws Exception {
        HadoopAccessorService has = (HadoopAccessorService)Services.get().get(HadoopAccessorService.class);
        Configuration conf = has.createConfiguration(this.getJobTrackerUri());
        YarnClient yc = has.createYarnClient(TestHadoopAccessorService.getTestUser(), conf);
        TestHadoopAccessorService.assertNotNull((Object)yc);
        yc.getApplications();
        try {
            yc = has.createYarnClient("invalid-user", conf);
            TestHadoopAccessorService.assertNotNull((Object)yc);
            yc.getApplications();
            TestHadoopAccessorService.fail((String)"Should have thrown exception because not allowed to impersonate 'invalid-user'");
        }
        catch (AuthorizationException authorizationException) {
            // empty catch block
        }
        JobConf conf2 = new JobConf(false);
        conf2.set("yarn.resourcemanager.address", this.getJobTrackerUri());
        try {
            has.createYarnClient(TestHadoopAccessorService.getTestUser(), (Configuration)conf2);
            TestHadoopAccessorService.fail((String)"Should have thrown exception because Configuration not created by HadoopAccessorService");
        }
        catch (HadoopAccessorException ex) {
            TestHadoopAccessorService.assertEquals((Object)ErrorCode.E0903, (Object)ex.getErrorCode());
        }
    }

    public void testCreateFileSystem() throws Exception {
        HadoopAccessorService has = (HadoopAccessorService)Services.get().get(HadoopAccessorService.class);
        Configuration conf = has.createConfiguration(this.getJobTrackerUri());
        FileSystem fs = has.createFileSystem(TestHadoopAccessorService.getTestUser(), new URI(this.getNameNodeUri()), conf);
        TestHadoopAccessorService.assertNotNull((Object)fs);
        fs.exists(new Path(this.getNameNodeUri(), "/foo"));
        try {
            fs = has.createFileSystem("invalid-user", new URI(this.getNameNodeUri()), conf);
            TestHadoopAccessorService.assertNotNull((Object)fs);
            fs.exists(new Path(this.getNameNodeUri(), "/foo"));
            TestHadoopAccessorService.fail((String)"Should have thrown exception because not allowed to impersonate 'invalid-user'");
        }
        catch (RemoteException ex) {
            TestHadoopAccessorService.assertEquals((String)AuthorizationException.class.getName(), (String)ex.getClassName());
        }
        JobConf conf2 = new JobConf(false);
        conf2.set("fs.default.name", this.getNameNodeUri());
        try {
            has.createFileSystem(TestHadoopAccessorService.getTestUser(), new URI(this.getNameNodeUri()), (Configuration)conf2);
            TestHadoopAccessorService.fail((String)"Should have thrown exception because Configuration not created by HadoopAccessorService");
        }
        catch (HadoopAccessorException ex) {
            TestHadoopAccessorService.assertEquals((Object)ErrorCode.E0903, (Object)ex.getErrorCode());
        }
    }

    public void testCheckSupportedFilesystem() throws Exception {
        Configuration hConf = Services.get().getConf();
        HadoopAccessorService has = new HadoopAccessorService();
        hConf.set("oozie.service.HadoopAccessorService.supported.filesystems", "hdfs,foo");
        has.init(hConf);
        has.checkSupportedFilesystem(new URI("hdfs://localhost:1234/blah"));
        has.checkSupportedFilesystem(new URI("foo://localhost:1234/blah"));
        try {
            has.checkSupportedFilesystem(new URI("file://localhost:1234/blah"));
            TestHadoopAccessorService.fail((String)"Should have thrown an exception because 'file' scheme isn't allowed");
        }
        catch (HadoopAccessorException hae) {
            TestHadoopAccessorService.assertEquals((Object)ErrorCode.E0904, (Object)hae.getErrorCode());
        }
        has.checkSupportedFilesystem(new URI("/blah"));
        has = new HadoopAccessorService();
        hConf.set("oozie.service.HadoopAccessorService.supported.filesystems", "*");
        has.init(hConf);
        has.checkSupportedFilesystem(new URI("hdfs://localhost:1234/blah"));
        has.checkSupportedFilesystem(new URI("foo://localhost:1234/blah"));
        has.checkSupportedFilesystem(new URI("file://localhost:1234/blah"));
        has.checkSupportedFilesystem(new URI("/blah"));
    }

    public void testValidateJobTracker() throws Exception {
        HadoopAccessorService has = new HadoopAccessorService();
        Configuration conf = new Configuration(false);
        conf.set("oozie.service.HadoopAccessorService.jobTracker.whitelist", " ");
        has.init(conf);
        has.validateJobTracker("foo");
        has.validateJobTracker("bar");
        has.validateJobTracker("blah");
        conf.set("oozie.service.HadoopAccessorService.jobTracker.whitelist", "foo,bar");
        has.init(conf);
        has.validateJobTracker("foo");
        has.validateJobTracker("bar");
        try {
            has.validateJobTracker("blah");
            TestHadoopAccessorService.fail((String)"Should have gotten an exception");
        }
        catch (HadoopAccessorException hae) {
            TestHadoopAccessorService.assertEquals((Object)ErrorCode.E0900, (Object)hae.getErrorCode());
            String s1 = "E0900: JobTracker [blah] not allowed, not in Oozie's whitelist. Allowed values are: [foo, bar]";
            String s2 = "E0900: JobTracker [blah] not allowed, not in Oozie's whitelist. Allowed values are: [bar, foo]";
            TestHadoopAccessorService.assertTrue((String)("expected:<" + s1 + "> or <" + s2 + "> but was:<" + hae.getMessage() + ">"), (s1.equals(hae.getMessage()) || s2.equals(hae.getMessage()) ? 1 : 0) != 0);
        }
        has.destroy();
    }

    public void testValidateNameNode() throws Exception {
        HadoopAccessorService has = new HadoopAccessorService();
        Configuration conf = new Configuration(false);
        conf.set("oozie.service.HadoopAccessorService.nameNode.whitelist", " ");
        has.init(conf);
        has.validateNameNode("foo");
        has.validateNameNode("bar");
        has.validateNameNode("blah");
        conf.set("oozie.service.HadoopAccessorService.nameNode.whitelist", "foo,bar");
        has.init(conf);
        has.validateNameNode("foo");
        has.validateNameNode("bar");
        try {
            has.validateNameNode("blah");
            TestHadoopAccessorService.fail((String)"Should have gotten an exception");
        }
        catch (HadoopAccessorException hae) {
            TestHadoopAccessorService.assertEquals((Object)ErrorCode.E0901, (Object)hae.getErrorCode());
            String s1 = "E0901: NameNode [blah] not allowed, not in Oozie's whitelist. Allowed values are: [foo, bar]";
            String s2 = "E0901: NameNode [blah] not allowed, not in Oozie's whitelist. Allowed values are: [bar, foo]";
            TestHadoopAccessorService.assertTrue((String)("expected:<" + s1 + "> or <" + s2 + "> but was:<" + hae.getMessage() + ">"), (s1.equals(hae.getMessage()) || s2.equals(hae.getMessage()) ? 1 : 0) != 0);
        }
        has.destroy();
    }

    public void testCreateLocalResourceForConfigurationFile() throws Exception {
        HadoopAccessorService has = (HadoopAccessorService)Services.get().get(HadoopAccessorService.class);
        String filename = "foo.xml";
        Configuration conf = has.createConfiguration(this.getNameNodeUri());
        conf.set("foo", "bar");
        LocalResource lRes = has.createLocalResourceForConfigurationFile(filename, TestHadoopAccessorService.getTestUser(), conf, this.getFileSystem().getUri(), this.getFsTestCaseDir());
        TestHadoopAccessorService.assertNotNull((Object)lRes);
        TestHadoopAccessorService.assertEquals((Object)LocalResourceType.FILE, (Object)lRes.getType());
        TestHadoopAccessorService.assertEquals((Object)LocalResourceVisibility.APPLICATION, (Object)lRes.getVisibility());
        Path resPath = ConverterUtils.getPathFromYarnURL((URL)lRes.getResource());
        TestHadoopAccessorService.assertEquals((Object)new Path(this.getFsTestCaseDir(), "foo.xml"), (Object)resPath);
        Configuration conf2 = new Configuration(false);
        conf2.addResource((InputStream)this.getFileSystem().open(resPath));
        TestHadoopAccessorService.assertEquals((String)"bar", (String)conf2.get("foo"));
    }
}

