/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import org.apache.oozie.service.InstrumentationService;
import org.apache.oozie.service.MetricsInstrumentationService;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.MetricsInstrumentation;

public class TestInstrumentationService
extends XTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        new Services().init();
    }

    @Override
    protected void tearDown() throws Exception {
        Services.get().destroy();
        super.tearDown();
    }

    public void testInstrumentation() throws Exception {
        TestInstrumentationService.assertNotNull((Object)Services.get().get(InstrumentationService.class));
        TestInstrumentationService.assertNotNull((Object)((InstrumentationService)Services.get().get(InstrumentationService.class)).get());
        Instrumentation instr = ((InstrumentationService)Services.get().get(InstrumentationService.class)).get();
        TestInstrumentationService.assertTrue((String)"Metrics is enabled by default since 5.0.0", (boolean)(instr instanceof MetricsInstrumentation));
    }

    public void testIsDisabledByDefault() {
        TestInstrumentationService.assertFalse((String)"Instrumentation is disabled by default since 5.0.0", (boolean)InstrumentationService.isEnabled());
        TestInstrumentationService.assertTrue((String)"Metrics is enabled by default since 5.0.0", (boolean)MetricsInstrumentationService.isEnabled());
    }

    public void testEnable() throws ServiceException {
        Services.get().destroy();
        this.setSystemProperty("oozie.services.ext", InstrumentationService.class.getName());
        new Services().init();
        TestInstrumentationService.assertTrue((String)"Instrumentation is enabled successfully", (boolean)InstrumentationService.isEnabled());
        TestInstrumentationService.assertFalse((String)"Metrics is disabled successfully", (boolean)MetricsInstrumentationService.isEnabled());
    }
}

