/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.net.URI;
import java.util.Random;
import org.apache.activemq.broker.BrokerService;
import org.apache.hadoop.conf.Configuration;
import org.apache.oozie.dependency.hcat.HCatMessageHandler;
import org.apache.oozie.jms.ConnectionContext;
import org.apache.oozie.jms.DefaultConnectionContext;
import org.apache.oozie.jms.JMSConnectionInfo;
import org.apache.oozie.jms.MessageHandler;
import org.apache.oozie.jms.MessageReceiver;
import org.apache.oozie.service.HCatAccessorService;
import org.apache.oozie.service.JMSAccessorService;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XTestCase;
import org.junit.Test;

public class TestJMSAccessorService
extends XTestCase {
    private Services services;
    private static Random random = new Random();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = super.setupServicesForHCatalog();
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    @Test
    public void testConnection() throws Exception {
        HCatAccessorService hcatService = (HCatAccessorService)this.services.get(HCatAccessorService.class);
        JMSAccessorService jmsService = (JMSAccessorService)this.services.get(JMSAccessorService.class);
        JMSConnectionInfo connInfo = hcatService.getJMSConnectionInfo(new URI("hcat://hcatserver.blue.server.com:8020"));
        ConnectionContext ctxt1 = jmsService.createConnectionContext(connInfo);
        TestJMSAccessorService.assertTrue((boolean)ctxt1.isConnectionInitialized());
        JMSConnectionInfo connInfo1 = hcatService.getJMSConnectionInfo(new URI("http://unknown:80"));
        ConnectionContext ctxt2 = jmsService.createConnectionContext(connInfo1);
        TestJMSAccessorService.assertTrue((boolean)ctxt2.isConnectionInitialized());
        TestJMSAccessorService.assertEquals((Object)ctxt1, (Object)ctxt2);
        ctxt1.close();
    }

    @Test
    public void testRegisterSingleConsumerPerTopic() {
        try {
            HCatAccessorService hcatService = (HCatAccessorService)this.services.get(HCatAccessorService.class);
            JMSAccessorService jmsService = (JMSAccessorService)this.services.get(JMSAccessorService.class);
            String server = "hcat.server.com:5080";
            String topic = "hcat.mydb.mytable";
            JMSConnectionInfo connInfo = hcatService.getJMSConnectionInfo(new URI("hcat://hcat.server.com:8020"));
            jmsService.registerForNotification(connInfo, topic, (MessageHandler)new HCatMessageHandler(server));
            MessageReceiver receiver1 = jmsService.getMessageReceiver(connInfo, topic);
            jmsService.registerForNotification(connInfo, topic, (MessageHandler)new HCatMessageHandler(server));
            MessageReceiver receiver2 = jmsService.getMessageReceiver(connInfo, topic);
            TestJMSAccessorService.assertEquals((Object)receiver1, (Object)receiver2);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestJMSAccessorService.fail((String)("Exception encountered : " + e));
        }
    }

    @Test
    public void testUnRegisterTopic() {
        try {
            HCatAccessorService hcatService = (HCatAccessorService)this.services.get(HCatAccessorService.class);
            JMSAccessorService jmsService = (JMSAccessorService)this.services.get(JMSAccessorService.class);
            String server = "hcat.server.com:5080";
            String topic = "hcatalog.mydb.mytable";
            JMSConnectionInfo connInfo = hcatService.getJMSConnectionInfo(new URI("hcat://hcat.server.com:8020"));
            jmsService.registerForNotification(connInfo, topic, (MessageHandler)new HCatMessageHandler(server));
            MessageReceiver receiver1 = jmsService.getMessageReceiver(connInfo, topic);
            TestJMSAccessorService.assertNotNull((Object)receiver1);
            jmsService.unregisterFromNotification(connInfo, topic);
            receiver1 = jmsService.getMessageReceiver(connInfo, topic);
            TestJMSAccessorService.assertEquals(null, (Object)receiver1);
        }
        catch (Exception e) {
            e.printStackTrace();
            TestJMSAccessorService.fail((String)("Exception encountered : " + e));
        }
    }

    @Test
    public void testConnectionContext() throws ServiceException {
        try {
            this.services.destroy();
            this.services = super.setupServicesForHCatalog();
            Configuration conf = this.services.getConf();
            String jmsURL = "hcat://${1}.${2}.server.com:8020=java.naming.factory.initial#org.apache.activemq.jndi.ActiveMQInitialContextFactory;java.naming.provider.url#vm://localhost?broker.persistent=false;connectionFactoryNames#dynamicFactories/hcat.prod.${1}";
            conf.set("oozie.service.HCatAccessorService.jmsconnections", jmsURL);
            this.services.init();
            HCatAccessorService hcatService = (HCatAccessorService)this.services.get(HCatAccessorService.class);
            JMSConnectionInfo connInfo = hcatService.getJMSConnectionInfo(new URI("hcat://hcatserver.blue.server.com:8020"));
            TestJMSAccessorService.assertEquals((String)"java.naming.factory.initial#org.apache.activemq.jndi.ActiveMQInitialContextFactory;java.naming.provider.url#vm://localhost?broker.persistent=false;connectionFactoryNames#dynamicFactories/hcat.prod.hcatserver", (String)connInfo.getJNDIPropertiesString());
            DefaultConnectionContext ctx1 = new DefaultConnectionContext();
            ctx1.createConnection(connInfo.getJNDIProperties());
            BrokerService broker = new BrokerService();
            broker.setDataDirectory(this.getTestCaseDir());
            broker.stop();
        }
        catch (Exception e) {
            e.printStackTrace();
            TestJMSAccessorService.fail((String)("Unexpected exception " + e));
        }
    }

    @Test
    public void testConnectionRetry() throws Exception {
        this.services.destroy();
        this.services = super.setupServicesForHCatalog();
        int randomPort = 30000 + random.nextInt(10000);
        String brokerURl = "tcp://localhost:" + randomPort;
        Configuration servicesConf = this.services.getConf();
        servicesConf.set("oozie.service.JMSAccessorService.retry.initial.delay", "1");
        servicesConf.set("oozie.service.JMSAccessorService.retry.max.attempts", "3");
        servicesConf.set("oozie.service.HCatAccessorService.jmsconnections", "default=java.naming.factory.initial#org.apache.activemq.jndi.ActiveMQInitialContextFactory;java.naming.provider.url#" + brokerURl + ";connectionFactoryNames#ConnectionFactory");
        this.services.init();
        HCatAccessorService hcatService = (HCatAccessorService)Services.get().get(HCatAccessorService.class);
        JMSAccessorService jmsService = (JMSAccessorService)Services.get().get(JMSAccessorService.class);
        String publisherAuthority = "hcat.server.com:5080";
        String topic = "topic.topic1";
        JMSConnectionInfo connInfo = hcatService.getJMSConnectionInfo(new URI("hcat://hcat.server.com:8020"));
        jmsService.registerForNotification(connInfo, topic, (MessageHandler)new HCatMessageHandler(publisherAuthority));
        TestJMSAccessorService.assertFalse((boolean)jmsService.isListeningToTopic(connInfo, topic));
        TestJMSAccessorService.assertTrue((boolean)jmsService.isConnectionInRetryList(connInfo));
        TestJMSAccessorService.assertTrue((boolean)jmsService.isTopicInRetryList(connInfo, topic));
        BrokerService broker = new BrokerService();
        broker.addConnector(brokerURl);
        broker.setDataDirectory(this.getTestCaseDir());
        broker.start();
        Thread.sleep(1000L);
        TestJMSAccessorService.assertTrue((boolean)jmsService.isListeningToTopic(connInfo, topic));
        TestJMSAccessorService.assertFalse((boolean)jmsService.isConnectionInRetryList(connInfo));
        TestJMSAccessorService.assertFalse((boolean)jmsService.isTopicInRetryList(connInfo, topic));
        broker.stop();
        jmsService.destroy();
    }

    @Test
    public void testConnectionRetryExceptionListener() throws Exception {
        this.services.destroy();
        this.services = super.setupServicesForHCatalog();
        int randomPort = 30000 + random.nextInt(10000);
        String brokerURL = "tcp://localhost:" + randomPort;
        String jndiPropertiesString = "java.naming.factory.initial#org.apache.activemq.jndi.ActiveMQInitialContextFactory;java.naming.provider.url#" + brokerURL + ";connectionFactoryNames#ConnectionFactory";
        Configuration servicesConf = this.services.getConf();
        servicesConf.set("oozie.service.JMSAccessorService.retry.initial.delay", "1");
        servicesConf.set("oozie.service.JMSAccessorService.retry.max.attempts", "3");
        servicesConf.set("oozie.service.HCatAccessorService.jmsconnections", "default=" + jndiPropertiesString);
        this.services.init();
        HCatAccessorService hcatService = (HCatAccessorService)Services.get().get(HCatAccessorService.class);
        JMSAccessorService jmsService = (JMSAccessorService)Services.get().get(JMSAccessorService.class);
        String publisherAuthority = "hcat.server.com:5080";
        String topic = "topic.topic1";
        BrokerService broker = new BrokerService();
        broker.addConnector(brokerURL);
        broker.setDataDirectory(this.getTestCaseDir());
        broker.start();
        JMSConnectionInfo connInfo = hcatService.getJMSConnectionInfo(new URI("hcat://hcat.server.com:8020"));
        jmsService.registerForNotification(connInfo, topic, (MessageHandler)new HCatMessageHandler(publisherAuthority));
        TestJMSAccessorService.assertTrue((boolean)jmsService.isListeningToTopic(connInfo, topic));
        TestJMSAccessorService.assertFalse((boolean)jmsService.isConnectionInRetryList(connInfo));
        TestJMSAccessorService.assertFalse((boolean)jmsService.isTopicInRetryList(connInfo, topic));
        ConnectionContext connCtxt = jmsService.createConnectionContext(connInfo);
        broker.stop();
        try {
            connCtxt.createSession(1);
            TestJMSAccessorService.fail((String)"Exception expected");
        }
        catch (Exception e) {
            Thread.sleep(100L);
            TestJMSAccessorService.assertFalse((boolean)jmsService.isListeningToTopic(connInfo, topic));
            TestJMSAccessorService.assertTrue((boolean)jmsService.isConnectionInRetryList(connInfo));
            TestJMSAccessorService.assertTrue((boolean)jmsService.isTopicInRetryList(connInfo, topic));
        }
        broker = new BrokerService();
        broker.addConnector(brokerURL);
        broker.setDataDirectory(this.getTestCaseDir());
        broker.start();
        Thread.sleep(1000L);
        TestJMSAccessorService.assertTrue((boolean)jmsService.isListeningToTopic(connInfo, topic));
        TestJMSAccessorService.assertFalse((boolean)jmsService.isConnectionInRetryList(connInfo));
        TestJMSAccessorService.assertFalse((boolean)jmsService.isTopicInRetryList(connInfo, topic));
        broker.stop();
        jmsService.destroy();
    }

    @Test
    public void testConnectionRetryMaxAttempt() throws Exception {
        this.services.destroy();
        this.services = super.setupServicesForHCatalog();
        String jndiPropertiesString = "java.naming.factory.initial#org.apache.activemq.jndi.ActiveMQInitialContextFactory;java.naming.provider.url#tcp://localhost:12345;connectionFactoryNames#ConnectionFactory";
        Configuration servicesConf = this.services.getConf();
        servicesConf.set("oozie.service.JMSAccessorService.retry.initial.delay", "1");
        servicesConf.set("oozie.service.JMSAccessorService.retry.max.attempts", "1");
        servicesConf.set("oozie.service.HCatAccessorService.jmsconnections", "default=" + jndiPropertiesString);
        this.services.init();
        HCatAccessorService hcatService = (HCatAccessorService)Services.get().get(HCatAccessorService.class);
        JMSAccessorService jmsService = (JMSAccessorService)Services.get().get(JMSAccessorService.class);
        String publisherAuthority = "hcat.server.com:5080";
        String topic = "topic.topic1";
        JMSConnectionInfo connInfo = hcatService.getJMSConnectionInfo(new URI("hcat://hcat.server.com:8020"));
        jmsService.registerForNotification(connInfo, topic, (MessageHandler)new HCatMessageHandler(publisherAuthority));
        TestJMSAccessorService.assertTrue((boolean)jmsService.isConnectionInRetryList(connInfo));
        TestJMSAccessorService.assertTrue((boolean)jmsService.isTopicInRetryList(connInfo, topic));
        TestJMSAccessorService.assertFalse((boolean)jmsService.isListeningToTopic(connInfo, topic));
        Thread.sleep(1100L);
        TestJMSAccessorService.assertTrue((boolean)jmsService.isConnectionInRetryList(connInfo));
        TestJMSAccessorService.assertTrue((boolean)jmsService.isTopicInRetryList(connInfo, topic));
        TestJMSAccessorService.assertFalse((boolean)jmsService.isListeningToTopic(connInfo, topic));
        TestJMSAccessorService.assertEquals((int)1, (int)jmsService.getNumConnectionAttempts(connInfo));
        TestJMSAccessorService.assertFalse((boolean)jmsService.retryConnection(connInfo));
        jmsService.destroy();
    }
}

