/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.util.Properties;
import org.apache.oozie.AppType;
import org.apache.oozie.BundleActionBean;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.CoordinatorJobBean;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.WorkflowAction;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.service.JMSTopicService;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.workflow.WorkflowInstance;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestJMSTopicService
extends XDataTestCase {
    private Services services;

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    private Services setupServicesForTopic() throws ServiceException {
        Services services = new Services();
        services.getConf().set("oozie.services.ext", JMSTopicService.class.getName());
        return services;
    }

    @Test
    public void testTopicAsUser() throws Exception {
        this.services = this.setupServicesForTopic();
        this.services.init();
        JMSTopicService jmsTopicService = (JMSTopicService)Services.get().get(JMSTopicService.class);
        WorkflowJobBean wfj = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        TestJMSTopicService.assertEquals((String)wfj.getUser(), (String)jmsTopicService.getTopic(wfj.getId()));
        TestJMSTopicService.assertEquals((String)wfj.getUser(), (String)jmsTopicService.getTopic(AppType.WORKFLOW_JOB, wfj.getUser(), wfj.getId(), null));
        WorkflowActionBean wab = this.addRecordToWfActionTable(wfj.getId(), "1", WorkflowAction.Status.RUNNING);
        TestJMSTopicService.assertEquals((String)wfj.getUser(), (String)jmsTopicService.getTopic(wab.getId()));
        TestJMSTopicService.assertEquals((String)wfj.getUser(), (String)jmsTopicService.getTopic(AppType.WORKFLOW_ACTION, wfj.getUser(), wab.getId(), wab.getWfId()));
        CoordinatorJobBean cjb = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, true, true);
        TestJMSTopicService.assertEquals((String)cjb.getUser(), (String)jmsTopicService.getTopic(cjb.getId()));
        TestJMSTopicService.assertEquals((String)cjb.getUser(), (String)jmsTopicService.getTopic(AppType.COORDINATOR_JOB, cjb.getUser(), cjb.getId(), null));
        CoordinatorActionBean cab = this.addRecordToCoordActionTable(cjb.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-for-action-input-check.xml", 0);
        TestJMSTopicService.assertEquals((String)cjb.getUser(), (String)jmsTopicService.getTopic(cab.getId()));
        TestJMSTopicService.assertEquals((String)cjb.getUser(), (String)jmsTopicService.getTopic(AppType.COORDINATOR_ACTION, cjb.getUser(), cab.getId(), cab.getJobId()));
        BundleJobBean bjb = this.addRecordToBundleJobTable(Job.Status.RUNNING, true);
        TestJMSTopicService.assertEquals((String)bjb.getUser(), (String)jmsTopicService.getTopic(bjb.getId()));
        TestJMSTopicService.assertEquals((String)bjb.getUser(), (String)jmsTopicService.getTopic(AppType.BUNDLE_JOB, bjb.getUser(), bjb.getId(), null));
        BundleActionBean bab = this.addRecordToBundleActionTable(bjb.getId(), "1", 1, Job.Status.RUNNING);
        TestJMSTopicService.assertEquals((String)bjb.getUser(), (String)jmsTopicService.getTopic(bab.getBundleActionId()));
        TestJMSTopicService.assertEquals((String)bjb.getUser(), (String)jmsTopicService.getTopic(AppType.BUNDLE_ACTION, bjb.getUser(), bab.getBundleActionId(), bab.getBundleId()));
    }

    @Test
    public void testTopicAsJobId() throws Exception {
        String TOPIC_PREFIX = "oozie.";
        this.services = this.setupServicesForTopic();
        this.services.getConf().set("oozie.service.JMSTopicService.topic.name", "default=" + JMSTopicService.TopicType.JOBID.getValue());
        this.services.getConf().set("oozie.service.JMSTopicService.topic.prefix", "oozie.");
        this.services.init();
        JMSTopicService jmsTopicService = (JMSTopicService)Services.get().get(JMSTopicService.class);
        WorkflowJobBean wfj = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        TestJMSTopicService.assertEquals((String)"oozie.", (String)jmsTopicService.getTopicPrefix());
        TestJMSTopicService.assertEquals((String)("oozie." + wfj.getId()), (String)jmsTopicService.getTopic(wfj.getId()));
        TestJMSTopicService.assertEquals((String)("oozie." + wfj.getId()), (String)jmsTopicService.getTopic(AppType.WORKFLOW_JOB, wfj.getUser(), wfj.getId(), null));
        WorkflowActionBean wab = this.addRecordToWfActionTable(wfj.getId(), "1", WorkflowAction.Status.RUNNING);
        TestJMSTopicService.assertEquals((String)("oozie." + wfj.getId()), (String)jmsTopicService.getTopic(wab.getId()));
        TestJMSTopicService.assertEquals((String)("oozie." + wfj.getId()), (String)jmsTopicService.getTopic(AppType.WORKFLOW_ACTION, wfj.getUser(), wab.getId(), wab.getWfId()));
        CoordinatorJobBean cjb = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, true, true);
        TestJMSTopicService.assertEquals((String)("oozie." + cjb.getId()), (String)jmsTopicService.getTopic(cjb.getId()));
        TestJMSTopicService.assertEquals((String)("oozie." + cjb.getId()), (String)jmsTopicService.getTopic(AppType.COORDINATOR_JOB, cjb.getUser(), cjb.getId(), null));
        CoordinatorActionBean cab = this.addRecordToCoordActionTable(cjb.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-for-action-input-check.xml", 0);
        TestJMSTopicService.assertEquals((String)("oozie." + cjb.getId()), (String)jmsTopicService.getTopic(cab.getId()));
        TestJMSTopicService.assertEquals((String)("oozie." + cjb.getId()), (String)jmsTopicService.getTopic(AppType.COORDINATOR_ACTION, cjb.getUser(), cab.getId(), cab.getJobId()));
        BundleJobBean bjb = this.addRecordToBundleJobTable(Job.Status.RUNNING, true);
        TestJMSTopicService.assertEquals((String)("oozie." + bjb.getId()), (String)jmsTopicService.getTopic(bjb.getId()));
        TestJMSTopicService.assertEquals((String)("oozie." + bjb.getId()), (String)jmsTopicService.getTopic(AppType.BUNDLE_JOB, bjb.getUser(), bjb.getId(), null));
        BundleActionBean bab = this.addRecordToBundleActionTable(bjb.getId(), "1", 1, Job.Status.RUNNING);
        TestJMSTopicService.assertEquals((String)("oozie." + bjb.getId()), (String)jmsTopicService.getTopic(bab.getBundleActionId()));
        TestJMSTopicService.assertEquals((String)("oozie." + bjb.getId()), (String)jmsTopicService.getTopic(AppType.BUNDLE_ACTION, bjb.getUser(), bab.getBundleActionId(), bab.getBundleId()));
    }

    @Test
    public void testTopicAsFixedString() throws Exception {
        this.services = this.setupServicesForTopic();
        this.services.getConf().set("oozie.service.JMSTopicService.topic.name", JMSTopicService.JobType.WORKFLOW.getValue() + " =workflow," + JMSTopicService.JobType.COORDINATOR.getValue() + "=coord," + JMSTopicService.JobType.BUNDLE.getValue() + "=bundle");
        this.services.init();
        JMSTopicService jmsTopicService = (JMSTopicService)Services.get().get(JMSTopicService.class);
        WorkflowJobBean wfj = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        TestJMSTopicService.assertEquals((String)"workflow", (String)jmsTopicService.getTopic(wfj.getId()));
        TestJMSTopicService.assertEquals((String)"workflow", (String)jmsTopicService.getTopic(AppType.WORKFLOW_JOB, wfj.getUser(), wfj.getId(), null));
        WorkflowActionBean wab = this.addRecordToWfActionTable(wfj.getId(), "1", WorkflowAction.Status.RUNNING);
        TestJMSTopicService.assertEquals((String)"workflow", (String)jmsTopicService.getTopic(wab.getId()));
        TestJMSTopicService.assertEquals((String)"workflow", (String)jmsTopicService.getTopic(AppType.WORKFLOW_ACTION, wfj.getUser(), wab.getId(), wab.getWfId()));
        CoordinatorJobBean cjb = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, true, true);
        TestJMSTopicService.assertEquals((String)"coord", (String)jmsTopicService.getTopic(cjb.getId()));
        TestJMSTopicService.assertEquals((String)"coord", (String)jmsTopicService.getTopic(AppType.COORDINATOR_JOB, cjb.getUser(), cjb.getId(), null));
        CoordinatorActionBean cab = this.addRecordToCoordActionTable(cjb.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-for-action-input-check.xml", 0);
        TestJMSTopicService.assertEquals((String)"coord", (String)jmsTopicService.getTopic(cab.getId()));
        TestJMSTopicService.assertEquals((String)"coord", (String)jmsTopicService.getTopic(AppType.COORDINATOR_ACTION, cjb.getUser(), cab.getId(), cab.getJobId()));
        BundleJobBean bjb = this.addRecordToBundleJobTable(Job.Status.RUNNING, true);
        TestJMSTopicService.assertEquals((String)"bundle", (String)jmsTopicService.getTopic(bjb.getId()));
        TestJMSTopicService.assertEquals((String)"bundle", (String)jmsTopicService.getTopic(AppType.BUNDLE_JOB, bjb.getUser(), bjb.getId(), null));
        BundleActionBean bab = this.addRecordToBundleActionTable(bjb.getId(), "1", 1, Job.Status.RUNNING);
        TestJMSTopicService.assertEquals((String)"bundle", (String)jmsTopicService.getTopic(bab.getBundleActionId()));
        TestJMSTopicService.assertEquals((String)"bundle", (String)jmsTopicService.getTopic(AppType.BUNDLE_ACTION, bjb.getUser(), bab.getBundleActionId(), bab.getBundleId()));
    }

    @Test
    public void testMixedTopic1() throws Exception {
        this.services = this.setupServicesForTopic();
        this.services.getConf().set("oozie.service.JMSTopicService.topic.name", JMSTopicService.JobType.WORKFLOW.getValue() + " = workflow," + JMSTopicService.JobType.COORDINATOR.getValue() + "=coord, default = " + JMSTopicService.TopicType.JOBID.getValue());
        this.services.init();
        JMSTopicService jmsTopicService = (JMSTopicService)Services.get().get(JMSTopicService.class);
        WorkflowJobBean wfj = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        TestJMSTopicService.assertEquals((String)"workflow", (String)jmsTopicService.getTopic(wfj.getId()));
        TestJMSTopicService.assertEquals((String)"workflow", (String)jmsTopicService.getTopic(AppType.WORKFLOW_JOB, wfj.getUser(), wfj.getId(), null));
        WorkflowActionBean wab = this.addRecordToWfActionTable(wfj.getId(), "1", WorkflowAction.Status.RUNNING);
        TestJMSTopicService.assertEquals((String)"workflow", (String)jmsTopicService.getTopic(wab.getId()));
        TestJMSTopicService.assertEquals((String)"workflow", (String)jmsTopicService.getTopic(AppType.WORKFLOW_ACTION, wfj.getUser(), wab.getId(), wab.getWfId()));
        CoordinatorJobBean cjb = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, true, true);
        TestJMSTopicService.assertEquals((String)"coord", (String)jmsTopicService.getTopic(cjb.getId()));
        TestJMSTopicService.assertEquals((String)"coord", (String)jmsTopicService.getTopic(AppType.COORDINATOR_JOB, cjb.getUser(), cjb.getId(), null));
        CoordinatorActionBean cab = this.addRecordToCoordActionTable(cjb.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-for-action-input-check.xml", 0);
        TestJMSTopicService.assertEquals((String)"coord", (String)jmsTopicService.getTopic(cab.getId()));
        TestJMSTopicService.assertEquals((String)"coord", (String)jmsTopicService.getTopic(AppType.COORDINATOR_ACTION, cjb.getUser(), cab.getId(), cab.getJobId()));
        BundleJobBean bjb = this.addRecordToBundleJobTable(Job.Status.RUNNING, true);
        TestJMSTopicService.assertEquals((String)bjb.getId(), (String)jmsTopicService.getTopic(bjb.getId()));
        TestJMSTopicService.assertEquals((String)bjb.getId(), (String)jmsTopicService.getTopic(AppType.BUNDLE_JOB, bjb.getUser(), bjb.getId(), null));
        BundleActionBean bab = this.addRecordToBundleActionTable(bjb.getId(), "1", 1, Job.Status.RUNNING);
        TestJMSTopicService.assertEquals((String)bjb.getId(), (String)jmsTopicService.getTopic(bab.getBundleActionId()));
        TestJMSTopicService.assertEquals((String)bjb.getId(), (String)jmsTopicService.getTopic(AppType.BUNDLE_ACTION, bjb.getUser(), bab.getBundleActionId(), bab.getBundleId()));
    }

    @Test
    public void testMixedTopic2() throws Exception {
        this.services = this.setupServicesForTopic();
        this.services.getConf().set("oozie.service.JMSTopicService.topic.name", JMSTopicService.JobType.WORKFLOW.getValue() + " = workflow," + JMSTopicService.JobType.COORDINATOR.getValue() + "=coord");
        this.services.init();
        JMSTopicService jmsTopicService = (JMSTopicService)Services.get().get(JMSTopicService.class);
        WorkflowJobBean wfj = this.addRecordToWfJobTable(WorkflowJob.Status.SUCCEEDED, WorkflowInstance.Status.SUCCEEDED);
        TestJMSTopicService.assertEquals((String)"workflow", (String)jmsTopicService.getTopic(wfj.getId()));
        TestJMSTopicService.assertEquals((String)"workflow", (String)jmsTopicService.getTopic(AppType.WORKFLOW_JOB, wfj.getUser(), wfj.getId(), null));
        WorkflowActionBean wab = this.addRecordToWfActionTable(wfj.getId(), "1", WorkflowAction.Status.RUNNING);
        TestJMSTopicService.assertEquals((String)"workflow", (String)jmsTopicService.getTopic(wab.getId()));
        TestJMSTopicService.assertEquals((String)"workflow", (String)jmsTopicService.getTopic(AppType.WORKFLOW_ACTION, wfj.getUser(), wab.getId(), wab.getWfId()));
        CoordinatorJobBean cjb = this.addRecordToCoordJobTable(Job.Status.SUCCEEDED, true, true);
        TestJMSTopicService.assertEquals((String)"coord", (String)jmsTopicService.getTopic(cjb.getId()));
        CoordinatorActionBean cab = this.addRecordToCoordActionTable(cjb.getId(), 1, CoordinatorAction.Status.SUCCEEDED, "coord-action-for-action-input-check.xml", 0);
        TestJMSTopicService.assertEquals((String)"coord", (String)jmsTopicService.getTopic(cab.getId()));
        TestJMSTopicService.assertEquals((String)"coord", (String)jmsTopicService.getTopic(AppType.COORDINATOR_ACTION, cjb.getUser(), cab.getId(), cab.getJobId()));
        BundleJobBean bjb = this.addRecordToBundleJobTable(Job.Status.RUNNING, true);
        TestJMSTopicService.assertEquals((String)bjb.getUser(), (String)jmsTopicService.getTopic(bjb.getId()));
        TestJMSTopicService.assertEquals((String)bjb.getUser(), (String)jmsTopicService.getTopic(AppType.BUNDLE_JOB, bjb.getUser(), bjb.getId(), null));
        BundleActionBean bab = this.addRecordToBundleActionTable(bjb.getId(), "1", 1, Job.Status.RUNNING);
        TestJMSTopicService.assertEquals((String)bjb.getUser(), (String)jmsTopicService.getTopic(bab.getBundleActionId()));
        TestJMSTopicService.assertEquals((String)bjb.getUser(), (String)jmsTopicService.getTopic(AppType.BUNDLE_ACTION, bjb.getUser(), bab.getBundleActionId(), bab.getBundleId()));
    }

    @Test
    public void testIncorrectConfigurationJobType() {
        try {
            this.services = this.setupServicesForTopic();
            this.services.getConf().set("oozie.service.JMSTopicService.topic.name", "InvalidJobType = workflow," + JMSTopicService.JobType.COORDINATOR.getValue() + "=coord");
            this.services.init();
            TestJMSTopicService.fail((String)"Expected Service Exception");
        }
        catch (ServiceException se) {
            TestJMSTopicService.assertTrue((boolean)se.getMessage().contains("Incorrect job type"));
        }
    }

    @Test
    public void testIncorrectConfigurationDefault() {
        try {
            this.services = this.setupServicesForTopic();
            this.services.getConf().set("oozie.service.JMSTopicService.topic.name", "default=invalidvalue");
            this.services.init();
            TestJMSTopicService.fail((String)"Expected Service Exception");
        }
        catch (ServiceException se) {
            TestJMSTopicService.assertTrue((boolean)se.getMessage().contains("not allowed in default"));
        }
    }

    @Test
    public void testTopicProperties1() throws Exception {
        this.services = this.setupServicesForTopic();
        this.services.init();
        JMSTopicService jmsTopicService = (JMSTopicService)Services.get().get(JMSTopicService.class);
        Properties props = jmsTopicService.getTopicPatternProperties();
        TestJMSTopicService.assertEquals((Object)"${username}", (Object)props.get(AppType.WORKFLOW_JOB));
        TestJMSTopicService.assertEquals((Object)"${username}", (Object)props.get(AppType.WORKFLOW_ACTION));
        TestJMSTopicService.assertEquals((Object)"${username}", (Object)props.get(AppType.COORDINATOR_JOB));
        TestJMSTopicService.assertEquals((Object)"${username}", (Object)props.get(AppType.COORDINATOR_ACTION));
        TestJMSTopicService.assertEquals((Object)"${username}", (Object)props.get(AppType.BUNDLE_JOB));
        TestJMSTopicService.assertEquals((Object)"${username}", (Object)props.get(AppType.BUNDLE_ACTION));
    }

    @Test
    public void testTopicProperties2() throws Exception {
        this.services = this.setupServicesForTopic();
        this.services.getConf().set("oozie.service.JMSTopicService.topic.name", JMSTopicService.JobType.WORKFLOW.getValue() + " = workflow," + JMSTopicService.JobType.COORDINATOR.getValue() + "=coord");
        this.services.init();
        JMSTopicService jmsTopicService = (JMSTopicService)Services.get().get(JMSTopicService.class);
        Properties props = jmsTopicService.getTopicPatternProperties();
        TestJMSTopicService.assertEquals((Object)"workflow", (Object)props.get(AppType.WORKFLOW_JOB));
        TestJMSTopicService.assertEquals((Object)"workflow", (Object)props.get(AppType.WORKFLOW_ACTION));
        TestJMSTopicService.assertEquals((Object)"coord", (Object)props.get(AppType.COORDINATOR_JOB));
        TestJMSTopicService.assertEquals((Object)"coord", (Object)props.get(AppType.COORDINATOR_ACTION));
        TestJMSTopicService.assertEquals((Object)"${username}", (Object)props.get(AppType.BUNDLE_JOB));
        TestJMSTopicService.assertEquals((Object)"${username}", (Object)props.get(AppType.BUNDLE_ACTION));
    }
}

