/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.util.Collection;
import org.apache.oozie.dependency.hcat.EhcacheHCatDependencyCache;
import org.apache.oozie.service.PartitionDependencyManagerService;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.TestPartitionDependencyManagerService;
import org.apache.oozie.util.HCatURI;
import org.apache.oozie.util.XLog;
import org.junit.Test;

public class TestPartitionDependencyManagerEhcache
extends TestPartitionDependencyManagerService {
    private static XLog LOG = XLog.getLog(TestPartitionDependencyManagerEhcache.class);

    private void setupServices(String cacheName) throws ServiceException {
        Services.get().destroy();
        this.services = super.setupServicesForHCatalog();
        this.services.getConf().set("oozie.service.PartitionDependencyManagerService.cache.manager.impl", EhcacheHCatDependencyCache.class.getName());
        if (cacheName != null) {
            this.services.getConf().set(EhcacheHCatDependencyCache.CONF_CACHE_NAME, cacheName);
        }
        this.services.init();
    }

    @Override
    @Test
    public void testPartitionDependency() throws Exception {
        this.setupServices(null);
        super.testPartitionDependency();
    }

    @Test
    public void testEvictionOnTimeToIdle() throws Exception {
        int i;
        this.setupServices("testevictionontimetoidle");
        PartitionDependencyManagerService pdms = (PartitionDependencyManagerService)Services.get().get(PartitionDependencyManagerService.class);
        int numItems = 50;
        long startTime = System.currentTimeMillis();
        for (i = 0; i < numItems; ++i) {
            HCatURI dep = new HCatURI("hcat://hcat.server.com:5080/mydb/mytbl/id=" + i);
            pdms.addMissingDependency(dep, "" + i);
        }
        this.verifyWaitingAction(pdms, numItems);
        LOG.info((Object)("Time taken to insert and retrive " + numItems + " items is " + (System.currentTimeMillis() - startTime)));
        Thread.sleep(1100L);
        for (i = 0; i < numItems; ++i) {
            TestPartitionDependencyManagerEhcache.assertNull((Object)pdms.getWaitingActions(new HCatURI("hcat://hcat.server.com:5080/mydb/mytbl/id=" + i)));
        }
    }

    @Test
    public void testEvictionOnTimeToLive() throws Exception {
        int i;
        this.setupServices("testevictionontimetolive");
        PartitionDependencyManagerService pdms = (PartitionDependencyManagerService)Services.get().get(PartitionDependencyManagerService.class);
        int numItems = 50;
        long startTime = System.currentTimeMillis();
        for (i = 0; i < numItems; ++i) {
            HCatURI dep = new HCatURI("hcat://hcat.server.com:5080/mydb/mytbl/id=" + i);
            pdms.addMissingDependency(dep, "" + i);
        }
        this.verifyWaitingAction(pdms, numItems);
        LOG.info((Object)("Time taken to insert and retrive " + numItems + " items is " + (System.currentTimeMillis() - startTime)));
        Thread.sleep(1100L);
        for (i = 0; i < numItems; ++i) {
            TestPartitionDependencyManagerEhcache.assertNull((Object)pdms.getWaitingActions(new HCatURI("hcat://hcat.server.com:5080/mydb/mytbl/id=" + i)));
        }
    }

    @Test
    public void testMaxElementsInMemory() throws Exception {
        int i;
        int i2;
        this.setupServices("testmaxelementsinmemory");
        PartitionDependencyManagerService pdms = (PartitionDependencyManagerService)Services.get().get(PartitionDependencyManagerService.class);
        int numItems = 1000;
        for (i2 = 0; i2 < numItems; ++i2) {
            HCatURI dep = new HCatURI("hcat://hcat.server.com:5080/mydb/mytbl/id=" + i2);
            pdms.addMissingDependency(dep, "" + i2);
        }
        for (i2 = 0; i2 < 150; ++i2) {
            TestPartitionDependencyManagerEhcache.assertNull((Object)pdms.getWaitingActions(new HCatURI("hcat://hcat.server.com:5080/mydb/mytbl/id=" + i2)));
        }
        int evicted = 0;
        for (i = 150; i < 750; ++i) {
            if (pdms.getWaitingActions(new HCatURI("hcat://hcat.server.com:5080/mydb/mytbl/id=" + i)) != null) continue;
            ++evicted;
        }
        TestPartitionDependencyManagerEhcache.assertEquals((int)350, (int)evicted);
        for (i = 750; i < 1000; ++i) {
            String actionID = "" + i;
            HCatURI dep = new HCatURI("hcat://hcat.server.com:5080/mydb/mytbl/id=" + actionID);
            Collection waitingActions = pdms.getWaitingActions(dep);
            TestPartitionDependencyManagerEhcache.assertNotNull((String)(dep.toURIString() + " is missing in cache"), (Object)waitingActions);
            TestPartitionDependencyManagerEhcache.assertTrue((String)(dep.toURIString() + " is missing in cache"), (boolean)waitingActions.contains(actionID));
        }
    }
}

