/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import org.apache.oozie.dependency.hcat.HCatMessageHandler;
import org.apache.oozie.jms.JMSConnectionInfo;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.EhcacheHCatDependencyCacheExtended;
import org.apache.oozie.service.HCatAccessorService;
import org.apache.oozie.service.JMSAccessorService;
import org.apache.oozie.service.PartitionDependencyManagerService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.SimpleHCatDependencyCacheExtended;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.HCatURI;
import org.apache.oozie.util.XLog;
import org.junit.Test;

public class TestPartitionDependencyManagerService
extends XDataTestCase {
    private static XLog LOG = XLog.getLog(TestPartitionDependencyManagerService.class);
    protected Services services;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = super.setupServicesForHCatalog();
        this.services.getConf().setInt("oozie.service.PartitionDependencyManagerService.cache.purge.interval", 1000000);
        this.services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        Services.get().destroy();
        super.tearDown();
    }

    @Test
    public void testPartitionDependency() throws Exception {
        String actionId1 = "1234465451";
        String actionId2 = "1234465452";
        String actionId3 = "1234465453";
        String actionId4 = "1234465454";
        String server1 = "hcat-server1.domain.com:5080";
        String server2 = "hcat-server2.domain.com:5080";
        String db = "mydb";
        String table1 = "mytbl1";
        String table2 = "mytbl2";
        HCatURI dep1 = new HCatURI("hcat://hcat-server1.domain.com:5080/mydb/mytbl1/dt=20120101;country=us");
        HCatURI dep2 = new HCatURI("hcat://hcat-server1.domain.com:5080/mydb/mytbl1/country=us;dt=20120101");
        HCatURI dep3 = new HCatURI("hcat://hcat-server2.domain.com:5080/mydb/mytbl2/dt=20120102;country=us");
        HCatURI dep4 = new HCatURI("hcat://hcat-server2.domain.com:5080/mydb/mytbl2/dt=20120102;country=us;state=CA");
        PartitionDependencyManagerService pdms = (PartitionDependencyManagerService)Services.get().get(PartitionDependencyManagerService.class);
        this.addMissingDependencyAndRegister(dep1, actionId1, pdms);
        this.addMissingDependencyAndRegister(dep2, actionId1, pdms);
        this.addMissingDependencyAndRegister(dep2, actionId2, pdms);
        this.addMissingDependencyAndRegister(dep2, actionId3, pdms);
        this.addMissingDependencyAndRegister(dep3, actionId3, pdms);
        this.addMissingDependencyAndRegister(dep4, actionId4, pdms);
        this.addMissingDependencyAndRegister(dep4, actionId4, pdms);
        this.addMissingDependencyAndRegister(dep4, actionId4, pdms);
        HCatAccessorService hcatService = (HCatAccessorService)Services.get().get(HCatAccessorService.class);
        JMSAccessorService jmsService = (JMSAccessorService)Services.get().get(JMSAccessorService.class);
        JMSConnectionInfo connInfo = hcatService.getJMSConnectionInfo(dep1.getURI());
        TestPartitionDependencyManagerService.assertTrue((boolean)hcatService.isRegisteredForNotification(dep1));
        TestPartitionDependencyManagerService.assertTrue((boolean)hcatService.isRegisteredForNotification(dep3));
        TestPartitionDependencyManagerService.assertTrue((boolean)jmsService.isListeningToTopic(connInfo, dep1.getDb() + "." + dep1.getTable()));
        TestPartitionDependencyManagerService.assertTrue((boolean)jmsService.isListeningToTopic(connInfo, dep3.getDb() + "." + dep3.getTable()));
        TestPartitionDependencyManagerService.assertTrue((boolean)pdms.getWaitingActions(dep1).contains(actionId1));
        TestPartitionDependencyManagerService.assertTrue((boolean)pdms.getWaitingActions(dep2).contains(actionId1));
        TestPartitionDependencyManagerService.assertTrue((boolean)pdms.getWaitingActions(dep2).contains(actionId2));
        TestPartitionDependencyManagerService.assertTrue((boolean)pdms.getWaitingActions(dep2).contains(actionId2));
        TestPartitionDependencyManagerService.assertTrue((boolean)pdms.getWaitingActions(dep3).contains(actionId3));
        TestPartitionDependencyManagerService.assertTrue((boolean)pdms.getWaitingActions(dep4).contains(actionId4));
        TestPartitionDependencyManagerService.assertEquals((int)1, (int)pdms.getWaitingActions(dep4).size());
        pdms.removeMissingDependency(dep2, actionId1);
        TestPartitionDependencyManagerService.assertTrue((boolean)pdms.getWaitingActions(dep1).contains(actionId1));
        TestPartitionDependencyManagerService.assertEquals((int)2, (int)pdms.getWaitingActions(dep2).size());
        TestPartitionDependencyManagerService.assertTrue((!pdms.getWaitingActions(dep2).contains(actionId1) ? 1 : 0) != 0);
        TestPartitionDependencyManagerService.assertNull((Object)pdms.getAvailableDependencyURIs(actionId1));
        pdms.partitionAvailable(server2, db, table2, this.getPartitionMap("dt=20120102;country=us;state=NY"));
        TestPartitionDependencyManagerService.assertNull((Object)pdms.getWaitingActions(dep3));
        TestPartitionDependencyManagerService.assertTrue((boolean)pdms.getAvailableDependencyURIs(actionId3).contains(dep3.getURI().toString()));
        pdms.partitionAvailable(server2, db, table2, this.getPartitionMap("dt=20120102;country=us;state=CA"));
        TestPartitionDependencyManagerService.assertNull((Object)pdms.getWaitingActions(dep4));
        TestPartitionDependencyManagerService.assertTrue((boolean)pdms.getAvailableDependencyURIs(actionId4).contains(dep4.getURI().toString()));
        pdms.partitionAvailable(server1, db, table1, this.getPartitionMap("dt=20120101;country=us"));
        TestPartitionDependencyManagerService.assertNull((Object)pdms.getWaitingActions(dep1));
        TestPartitionDependencyManagerService.assertNull((Object)pdms.getWaitingActions(dep2));
        TestPartitionDependencyManagerService.assertTrue((boolean)pdms.getAvailableDependencyURIs(actionId2).contains(dep2.getURI().toString()));
        TestPartitionDependencyManagerService.assertTrue((boolean)pdms.getAvailableDependencyURIs(actionId3).contains(dep2.getURI().toString()));
        TestPartitionDependencyManagerService.assertTrue((boolean)pdms.getAvailableDependencyURIs(actionId3).contains(dep3.getURI().toString()));
        TestPartitionDependencyManagerService.assertTrue((boolean)pdms.removeAvailableDependencyURIs(actionId3, pdms.getAvailableDependencyURIs(actionId3)));
        TestPartitionDependencyManagerService.assertNull((Object)pdms.getAvailableDependencyURIs(actionId3));
        TestPartitionDependencyManagerService.assertFalse((boolean)hcatService.isRegisteredForNotification(dep1));
        TestPartitionDependencyManagerService.assertFalse((boolean)hcatService.isRegisteredForNotification(dep3));
        TestPartitionDependencyManagerService.assertFalse((boolean)jmsService.isListeningToTopic(connInfo, dep1.getDb() + "." + dep1.getTable()));
        TestPartitionDependencyManagerService.assertFalse((boolean)jmsService.isListeningToTopic(connInfo, dep3.getDb() + "." + dep3.getTable()));
    }

    @Test
    public void testHCatCanonicalHostName() throws Exception {
        ConfigurationService.setBoolean((String)"oozie.service.HCatAccessorService.jms.use.canonical.hostname", (boolean)true);
        ConfigurationService.set((String)"oozie.service.PartitionDependencyManagerService.cache.manager.impl", (String)SimpleHCatDependencyCacheExtended.class.getName());
        this.services.init();
        String actionId1 = "1";
        String server1 = "hcat-server1-A:5080";
        String server2 = "hcat-server1-B:5080";
        String db = "mydb";
        String table1 = "mytbl1";
        HCatURI dep1 = new HCatURI(new URI("hcat://" + server1 + "/" + db + "/" + table1 + "/dt=20120101;country=us"));
        HCatURI dep2 = new HCatURI(new URI("hcat://" + server2 + "/" + db + "/" + table1 + "/dt=20120101;country=us"));
        PartitionDependencyManagerService pdms = (PartitionDependencyManagerService)Services.get().get(PartitionDependencyManagerService.class);
        this.addMissingDependencyAndRegister(dep1, actionId1, pdms);
        TestPartitionDependencyManagerService.assertTrue((boolean)pdms.getWaitingActions(dep1).contains(actionId1));
        TestPartitionDependencyManagerService.assertTrue((boolean)pdms.getWaitingActions(dep2).contains(actionId1));
        ConfigurationService.set((String)"oozie.service.PartitionDependencyManagerService.cache.manager.impl", (String)EhcacheHCatDependencyCacheExtended.class.getName());
        this.services.init();
        pdms = (PartitionDependencyManagerService)Services.get().get(PartitionDependencyManagerService.class);
        this.addMissingDependencyAndRegister(dep1, actionId1, pdms);
        TestPartitionDependencyManagerService.assertTrue((boolean)pdms.getWaitingActions(dep1).contains(actionId1));
        TestPartitionDependencyManagerService.assertTrue((boolean)pdms.getWaitingActions(dep2).contains(actionId1));
    }

    protected void addMissingDependencyAndRegister(HCatURI hcatURI, String actionId, PartitionDependencyManagerService pdms) {
        pdms.addMissingDependency(hcatURI, actionId);
        HCatAccessorService hcatService = (HCatAccessorService)Services.get().get(HCatAccessorService.class);
        if (!hcatService.isRegisteredForNotification(hcatURI)) {
            hcatService.registerForNotification(hcatURI, hcatURI.getDb() + "." + hcatURI.getTable(), new HCatMessageHandler(hcatURI.getServer()));
        }
    }

    @Test
    public void testMemoryUsageAndSpeed() throws Exception {
        this.assertSpeedAndMemory(60000, 4000, 2000, 45000000L, 40000000L);
    }

    protected void assertSpeedAndMemory(int numItems, int insertTimeinMillis, int retrievalTimeinMillis, long memIncreaseAfterInsert, long memIncreaseAfterInsertAndGC) throws Exception {
        PartitionDependencyManagerService pdms = (PartitionDependencyManagerService)Services.get().get(PartitionDependencyManagerService.class);
        System.gc();
        MemoryMXBean mb = ManagementFactory.getMemoryMXBean();
        long usedMemBeforeInsert = mb.getHeapMemoryUsage().getUsed();
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < numItems; ++i) {
            HCatURI dep = new HCatURI("hcat://hcat.server.com:5080/mydb/mytbl/id=" + i);
            pdms.addMissingDependency(dep, "" + i);
        }
        long usedMemAfterInsert = mb.getHeapMemoryUsage().getUsed();
        long endTime = System.currentTimeMillis();
        LOG.info((Object)("Time taken to insert " + numItems + " items is " + (endTime - startTime)));
        TestPartitionDependencyManagerService.assertTrue((endTime - startTime < (long)insertTimeinMillis ? 1 : 0) != 0);
        LOG.info((Object)("Memory before and after insert: " + usedMemBeforeInsert + "," + usedMemAfterInsert));
        this.verifyWaitingAction(pdms, numItems);
        LOG.info((Object)("Time taken to retrieve " + numItems + " items is " + (System.currentTimeMillis() - endTime)));
        TestPartitionDependencyManagerService.assertTrue((System.currentTimeMillis() - endTime < (long)retrievalTimeinMillis ? 1 : 0) != 0);
        long usedMemAfterRetrieval = mb.getHeapMemoryUsage().getUsed();
        System.gc();
        long usedMemAfterGC = mb.getHeapMemoryUsage().getUsed();
        LOG.info((Object)("Memory before insert = " + usedMemBeforeInsert));
        LOG.info((Object)("Memory after insert = " + usedMemAfterInsert));
        LOG.info((Object)("Memory after retrieval = " + usedMemAfterRetrieval));
        LOG.info((Object)("Memory after GC = " + usedMemAfterGC));
    }

    protected void verifyWaitingAction(PartitionDependencyManagerService pdms, int numItems) throws URISyntaxException {
        for (int i = 0; i < numItems; ++i) {
            String actionID = "" + i;
            HCatURI dep = new HCatURI("hcat://hcat.server.com:5080/mydb/mytbl/id=" + actionID);
            Collection waitingActions = pdms.getWaitingActions(dep);
            TestPartitionDependencyManagerService.assertNotNull((String)(dep.toURIString() + " is missing in cache"), (Object)waitingActions);
            TestPartitionDependencyManagerService.assertTrue((String)(dep.toURIString() + " is missing in cache"), (boolean)waitingActions.contains(actionID));
        }
    }
}

