/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.File;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Service;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.XLogService;
import org.apache.oozie.test.XTestCase;

public class TestServices
extends XTestCase {
    private static final String SERVICES = S1.class.getName() + "," + S2.class.getName();
    private static final String SERVICES_EXT = S1Ext.class.getName();

    public void testDefaultServices() throws Exception {
        this.setSystemProperty("oozie.config.file", "oozie-dummy.xml");
        this.setSystemProperty("oozie.services", "");
        this.setSystemProperty("oozie.services.ext", "");
        Services services = new Services();
        services.init();
        try {
            TestServices.assertNotNull((Object)services.get(XLogService.class));
            TestServices.assertNotNull((Object)services.get(ConfigurationService.class));
            String shouldBe = "oozie-" + System.getProperty("user.name");
            TestServices.assertTrue((boolean)shouldBe.startsWith(services.getSystemId()));
            TestServices.assertNotNull((Object)services.getRuntimeDir());
            TestServices.assertTrue((boolean)new File(services.getRuntimeDir()).exists());
        }
        finally {
            services.destroy();
        }
    }

    public void testServiceExtLoading() throws Exception {
        this.setSystemProperty("oozie.services", SERVICES);
        Services services = new Services();
        services.init();
        try {
            TestServices.assertEquals(S1.class, ((S1)services.get(S1.class)).getClass());
            TestServices.assertEquals(S2.class, ((S2)services.get(S2.class)).getClass());
        }
        finally {
            services.destroy();
        }
    }

    public void testServicesExtLoading() throws Exception {
        S1.INITED_S1 = false;
        S1Ext.INITED_S1EXT = false;
        this.setSystemProperty("oozie.services", SERVICES);
        this.setSystemProperty("oozie.services.ext", SERVICES_EXT);
        Services services = new Services();
        services.init();
        try {
            TestServices.assertEquals(S1Ext.class, ((S1)services.get(S1.class)).getClass());
            TestServices.assertEquals(S2.class, ((S2)services.get(S2.class)).getClass());
            TestServices.assertFalse((boolean)S1.INITED_S1);
            TestServices.assertTrue((boolean)S1Ext.INITED_S1EXT);
        }
        finally {
            services.destroy();
        }
    }

    public static class S1Ext
    extends S1 {
        public static boolean INITED_S1EXT = false;

        @Override
        public void init(Services services) throws ServiceException {
            INITED_S1EXT = true;
        }
    }

    public static class S2
    implements Service {
        public void init(Services services) throws ServiceException {
        }

        public void destroy() {
        }

        public Class<? extends Service> getInterface() {
            return S2.class;
        }
    }

    public static class S1
    implements Service {
        public static boolean INITED_S1 = false;

        public void init(Services services) throws ServiceException {
            INITED_S1 = true;
        }

        public void destroy() {
        }

        public Class<? extends Service> getInterface() {
            return S1.class;
        }
    }
}

