/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.oozie.service.ShareLibService;
import org.apache.oozie.service.TestShareLibService;

public class TestShareLibMappingFileInput {
    final FileSystem fs;
    final String sharelibNameWithMappingFilePrefix;
    final String sharelibName;
    final String sharelibPath;
    final String baseName;

    public TestShareLibMappingFileInput(FileSystem fs, String sharelibMappingActionName, String sharelibPath) {
        this.fs = fs;
        this.sharelibName = sharelibMappingActionName;
        this.sharelibNameWithMappingFilePrefix = ShareLibService.SHARE_LIB_CONF_PREFIX + "." + sharelibMappingActionName;
        this.sharelibPath = sharelibPath;
        this.baseName = sharelibPath.substring(sharelibPath.lastIndexOf("/") + 1);
    }

    public void materialize() throws IOException {
        TestShareLibService.createFileWithDirectoryPath(this.fs, this.sharelibPath);
    }

    String getFullShareLibPathDir() {
        String fullShareLibPathDir = TestShareLibMappingFileInput.getLocalizedShareLibPath(this.fs, this.sharelibPath);
        return fullShareLibPathDir.substring(0, fullShareLibPathDir.lastIndexOf("/"));
    }

    static String getLocalizedShareLibPath(FileSystem fs, String path) {
        return fs instanceof LocalFileSystem ? "file://" + path : path;
    }
}

