/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.IOException;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.service.TestShareLibMappingFileInput;
import org.apache.oozie.util.FSUtils;

class TestShareLibMappingSymlinkInput
extends TestShareLibMappingFileInput {
    final String symlinkPath;

    public TestShareLibMappingSymlinkInput(FileSystem fs, String sharelibActionName, String sharelibPath, String symlinkPath) {
        super(fs, sharelibActionName, sharelibPath);
        this.symlinkPath = symlinkPath;
    }

    @Override
    public void materialize() throws IOException {
        super.materialize();
        FSUtils.createSymlink((FileSystem)this.fs, (Path)new Path(this.sharelibPath), (Path)new Path(this.symlinkPath), (boolean)true);
    }

    @Override
    String getFullShareLibPathDir() {
        int lastIndexOfPathSeparator = this.sharelibPath.lastIndexOf("/");
        String symlinkTargetFileName = lastIndexOfPathSeparator != -1 ? this.sharelibPath.substring(lastIndexOfPathSeparator + 1) : this.sharelibPath;
        String fullShareLibPathDir = TestShareLibMappingSymlinkInput.getLocalizedShareLibPath(this.fs, this.symlinkPath);
        return fullShareLibPathDir + "#" + symlinkTargetFileName;
    }
}

