/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import com.google.common.collect.Lists;
import com.google.common.io.Files;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.filecache.DistributedCache;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.LocalFileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.WorkflowActionBean;
import org.apache.oozie.WorkflowJobBean;
import org.apache.oozie.action.ActionExecutor;
import org.apache.oozie.action.hadoop.ActionExecutorTestCase;
import org.apache.oozie.action.hadoop.HiveActionExecutor;
import org.apache.oozie.action.hadoop.JavaActionExecutor;
import org.apache.oozie.action.hadoop.PigActionExecutor;
import org.apache.oozie.action.hadoop.TestJavaActionExecutor;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.ShareLibService;
import org.apache.oozie.service.TestShareLibMappingFileInput;
import org.apache.oozie.service.TestShareLibMappingSymlinkInput;
import org.apache.oozie.test.XFsTestCase;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.FSUtils;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XConfiguration;
import org.apache.oozie.util.XmlUtils;
import org.jdom.Element;
import org.junit.Test;

public class TestShareLibService
extends XFsTestCase {
    private static final String HDFS_SCHEME_PREFIX = "hdfs";
    private static final String TEST_HDFS_HOME = "/user/test/";
    private static final String TEST_MAPPING_FILENAME = "config.properties";
    private static final String TEST_HDFS_MAPPING_FILE_PATH = "/user/test/config.properties";
    private static final String SHARELIB_PATH = "shareLibPath/";
    Services services;
    private static String testCaseDirPath;
    SimpleDateFormat dt = new SimpleDateFormat("yyyyMMddHHmmss");

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        testCaseDirPath = this.getTestCaseDir();
        this.services = new Services();
        this.setSystemProps();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
        this.services.destroy();
    }

    private void setSystemProps() throws IOException {
        IOUtils.createJar((File)new File(this.getTestCaseDir()), (String)(MyOozie.class.getName() + ".jar"), (Class[])new Class[]{MyOozie.class});
        IOUtils.createJar((File)new File(this.getTestCaseDir()), (String)(MyPig.class.getName() + ".jar"), (Class[])new Class[]{MyPig.class});
        IOUtils.createJar((File)new File(this.getTestCaseDir()), (String)(TestHive.class.getName() + ".jar"), (Class[])new Class[]{TestHive.class});
        Configuration conf = this.getOozieConfig();
        conf.set("oozie.service.WorkflowAppService.system.libpath", this.getFsTestCaseDir() + "/share/lib");
        conf.set("oozie.services", conf.get("oozie.services") + "," + DummyShareLibService.class.getName());
        conf.setStrings("oozie.service.ActionService.executor.classes", new String[]{DummyPigActionExecutor.class.getName(), DummyHiveActionExecutor.class.getName()});
    }

    @Test
    public void testfailFast() throws Exception {
        Configuration conf = this.getOozieConfig();
        conf.set("oozie.service.ShareLibService.fail.fast.on.startup", "true");
        conf.set("oozie.service.ShareLibService.mapping.file", String.valueOf(new Date().getTime()));
        try {
            this.services.init();
            TestShareLibService.fail((String)"Should throw exception");
        }
        catch (Throwable e) {
            TestShareLibService.assertTrue((boolean)e.getMessage().contains("E0104: Could not fully initialize service"));
        }
    }

    @Test
    public void testCreateLauncherLibPath() throws Exception {
        this.setShipLauncherInOozieConfig();
        this.services.init();
        ShareLibService shareLibService = (ShareLibService)Services.get().get(ShareLibService.class);
        List launcherPath = shareLibService.getSystemLibJars("oozie");
        TestShareLibService.assertNotNull((Object)launcherPath);
        TestShareLibService.assertTrue((boolean)this.getFileSystem().exists((Path)launcherPath.get(0)));
        List pigLauncherPath = shareLibService.getSystemLibJars("pig");
        TestShareLibService.assertTrue((boolean)this.getFileSystem().exists((Path)pigLauncherPath.get(0)));
    }

    @Test
    public void testAddShareLibDistributedCache() throws Exception {
        this.setShipLauncherInOozieConfig();
        this.services.init();
        String actionXml = "<java><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node></java>";
        Element eActionXml = XmlUtils.parseXml((String)actionXml);
        XConfiguration protoConf = new XConfiguration();
        protoConf.set("user.name", TestShareLibService.getTestUser());
        WorkflowJobBean wfj = new WorkflowJobBean();
        wfj.setProtoActionConf(XmlUtils.prettyPrint((Configuration)protoConf).toString());
        wfj.setConf(XmlUtils.prettyPrint((Configuration)new XConfiguration()).toString());
        TestJavaActionExecutor testJavaActionExecutor = new TestJavaActionExecutor();
        ((Object)((Object)testJavaActionExecutor)).getClass();
        ActionExecutorTestCase.Context context = testJavaActionExecutor.new ActionExecutorTestCase.Context(wfj, new WorkflowActionBean());
        PigActionExecutor ae = new PigActionExecutor();
        Configuration jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
        ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, new Path("hdfs://dummyAppPath"), jobConf);
        this.verifyFilesInDistributedCache(DistributedCache.getCacheFiles((Configuration)jobConf), MyPig.class.getName() + ".jar", MyOozie.class.getName() + ".jar");
    }

    @Test
    public void testAddShareLib_pig() throws Exception {
        this.setShipLauncherInOozieConfig();
        this.services.init();
        String actionXml = "<pig><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node></pig>";
        Element eActionXml = XmlUtils.parseXml((String)actionXml);
        XConfiguration protoConf = new XConfiguration();
        protoConf.set("user.name", TestShareLibService.getTestUser());
        WorkflowJobBean wfj = new WorkflowJobBean();
        wfj.setProtoActionConf(XmlUtils.prettyPrint((Configuration)protoConf).toString());
        wfj.setConf(XmlUtils.prettyPrint((Configuration)new XConfiguration()).toString());
        TestJavaActionExecutor testJavaActionExecutor = new TestJavaActionExecutor();
        ((Object)((Object)testJavaActionExecutor)).getClass();
        ActionExecutorTestCase.Context context = testJavaActionExecutor.new ActionExecutorTestCase.Context(wfj, new WorkflowActionBean());
        PigActionExecutor ae = new PigActionExecutor();
        Configuration jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
        ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, new Path("hdfs://dummyAppPath"), jobConf);
        this.verifyFilesInDistributedCache(DistributedCache.getCacheFiles((Configuration)jobConf), "MyPig.jar", "MyOozie.jar");
    }

    @Test
    public void testAddShareLib_pig_withVersion() throws Exception {
        this.setShipLauncherInOozieConfig();
        FileSystem fs = this.getFileSystem();
        Date time = new Date(System.currentTimeMillis());
        Path basePath = new Path(this.getOozieConfig().get("oozie.service.WorkflowAppService.system.libpath"));
        Path libpath = new Path(basePath, "lib_" + ShareLibService.dateFormat.format(time));
        fs.mkdirs(libpath);
        Path pigPath = new Path(libpath.toString() + "/" + "pig");
        Path pigPath1 = new Path(libpath.toString() + "/" + "pig_9");
        Path pigPath2 = new Path(libpath.toString() + "/" + "pig_10");
        fs.mkdirs(pigPath);
        fs.mkdirs(pigPath1);
        fs.mkdirs(pigPath2);
        this.createFiles(libpath.toString() + "/" + "pig_10" + "/" + "pig-10.jar");
        this.services.init();
        String actionXml = "<pig><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><property><name>oozie.action.sharelib.for.pig</name><value>pig_10</value></property></pig>";
        Element eActionXml = XmlUtils.parseXml((String)actionXml);
        XConfiguration protoConf = new XConfiguration();
        protoConf.set("user.name", TestShareLibService.getTestUser());
        WorkflowJobBean wfj = new WorkflowJobBean();
        protoConf.setBoolean("oozie.use.system.libpath", true);
        wfj.setProtoActionConf(XmlUtils.prettyPrint((Configuration)protoConf).toString());
        wfj.setConf(XmlUtils.prettyPrint((Configuration)protoConf).toString());
        TestJavaActionExecutor testJavaActionExecutor = new TestJavaActionExecutor();
        ((Object)((Object)testJavaActionExecutor)).getClass();
        ActionExecutorTestCase.Context context = testJavaActionExecutor.new ActionExecutorTestCase.Context(wfj, new WorkflowActionBean());
        PigActionExecutor ae = new PigActionExecutor();
        Configuration jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
        jobConf.set("oozie.action.sharelib.for.pig", "pig_10");
        ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, new Path("hdfs://dummyAppPath"), jobConf);
        this.verifyFilesInDistributedCache(DistributedCache.getCacheFiles((Configuration)jobConf), "MyPig.jar", "MyOozie.jar", "pig-10.jar");
    }

    @Test
    public void testRetentionOverflow() throws Exception {
        this.getOozieConfig().set("oozie.service.ShareLibService.temp.sharelib.retention.days", "25");
        this.services.init();
        ShareLibService shareLibService = (ShareLibService)this.services.get(ShareLibService.class);
        TestShareLibService.assertTrue((shareLibService.retentionTime > 0L ? 1 : 0) != 0);
    }

    @Test
    public void testPurgeShareLib() throws Exception {
        this.setShipLauncherInOozieConfig();
        FileSystem fs = this.getFileSystem();
        long expiryTime = System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(this.getOozieConfig().getInt("oozie.service.ShareLibService.temp.sharelib.retention.days", 7), TimeUnit.DAYS);
        String expireTs = this.dt.format(new Date(expiryTime - TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS)));
        String noexpireTs = this.dt.format(new Date(expiryTime + TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS)));
        String noexpireTs1 = this.dt.format(new Date(expiryTime + TimeUnit.MILLISECONDS.convert(2L, TimeUnit.DAYS)));
        Path basePath = new Path(this.getOozieConfig().get("oozie.service.WorkflowAppService.system.libpath"));
        Path expirePath = new Path(basePath, "lib_" + expireTs);
        Path noexpirePath = new Path(basePath, "lib_" + noexpireTs);
        Path noexpirePath1 = new Path(basePath, "lib_" + noexpireTs1);
        this.createDirs(fs, expirePath, noexpirePath, noexpirePath1);
        this.services.init();
        TestShareLibService.assertEquals((int)4, (int)fs.listStatus(basePath).length);
        TestShareLibService.assertTrue((boolean)fs.exists(noexpirePath));
        TestShareLibService.assertTrue((boolean)fs.exists(noexpirePath1));
        TestShareLibService.assertTrue((boolean)fs.exists(expirePath));
    }

    @Test
    public void testPurgeLauncherJar() throws Exception {
        this.setShipLauncherInOozieConfig();
        FileSystem fs = this.getFileSystem();
        long expiryTime = System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(this.getOozieConfig().getInt("oozie.service.ShareLibService.temp.sharelib.retention.days", 7), TimeUnit.DAYS);
        String expireTs = this.dt.format(new Date(expiryTime - TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS)));
        String noexpireTs = this.dt.format(new Date(expiryTime + TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS)));
        String noexpireTs1 = this.dt.format(new Date(expiryTime + TimeUnit.MILLISECONDS.convert(2L, TimeUnit.DAYS)));
        Path basePath = new Path(this.getOozieConfig().get("oozie.service.WorkflowAppService.system.libpath"));
        Path expirePath = new Path(basePath, "launcher_" + expireTs);
        Path noexpirePath = new Path(basePath, "launcher_" + noexpireTs);
        Path noexpirePath1 = new Path(basePath, "launcher_" + noexpireTs1);
        this.createDirs(fs, expirePath, noexpirePath, noexpirePath1);
        this.services.init();
        TestShareLibService.assertEquals((int)4, (int)fs.listStatus(basePath).length);
        TestShareLibService.assertTrue((boolean)fs.exists(noexpirePath));
        TestShareLibService.assertTrue((boolean)fs.exists(noexpirePath1));
        TestShareLibService.assertTrue((boolean)fs.exists(expirePath));
    }

    @Test
    public void testPurgeJar() throws Exception {
        this.setShipLauncherInOozieConfig();
        final FileSystem fs = this.getFileSystem();
        long expiryTime = System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(this.getOozieConfig().getInt("oozie.service.ShareLibService.temp.sharelib.retention.days", 7), TimeUnit.DAYS);
        String expireTs = this.dt.format(new Date(expiryTime - TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS)));
        String expireTs1 = this.dt.format(new Date(expiryTime - TimeUnit.MILLISECONDS.convert(2L, TimeUnit.DAYS)));
        String noexpireTs = this.dt.format(new Date(expiryTime + TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS)));
        String noexpireTs1 = this.dt.format(new Date(expiryTime + TimeUnit.MILLISECONDS.convert(2L, TimeUnit.DAYS)));
        final Path basePath = new Path(this.getOozieConfig().get("oozie.service.WorkflowAppService.system.libpath"));
        Path expirePath = new Path(basePath, "launcher_" + expireTs);
        Path expirePath1 = new Path(basePath, "launcher_" + expireTs1);
        Path noexpirePath = new Path(basePath, "launcher_" + noexpireTs);
        Path noexpirePath1 = new Path(basePath, "launcher_" + noexpireTs1);
        this.createDirs(fs, expirePath, expirePath1, noexpirePath, noexpirePath1);
        this.services.init();
        this.waitFor(20000, new XTestCase.Predicate(){

            @Override
            public boolean evaluate() throws Exception {
                return fs.listStatus(basePath).length == 4;
            }
        });
        TestShareLibService.assertEquals((int)4, (int)fs.listStatus(basePath).length);
        TestShareLibService.assertTrue((boolean)fs.exists(noexpirePath));
        TestShareLibService.assertTrue((boolean)fs.exists(noexpirePath1));
        TestShareLibService.assertTrue((boolean)fs.exists(expirePath));
        TestShareLibService.assertFalse((boolean)fs.exists(expirePath1));
    }

    @Test
    public void testGetShareLibCompatible() throws Exception {
        FileSystem fs = this.getFileSystem();
        Path basePath = new Path(this.getOozieConfig().get("oozie.service.WorkflowAppService.system.libpath"));
        fs.mkdirs(basePath);
        Path pigPath = new Path(basePath.toString() + "/" + "pig");
        fs.mkdirs(pigPath);
        this.services.init();
        ShareLibService shareLibService = (ShareLibService)Services.get().get(ShareLibService.class);
        TestShareLibService.assertNotNull((Object)shareLibService.getShareLibJars("pig"));
    }

    @Test
    public void testGetShareLibPath() throws Exception {
        FileSystem fs = this.getFileSystem();
        Path basePath = new Path(this.getOozieConfig().get("oozie.service.WorkflowAppService.system.libpath"));
        Date time = new Date(System.currentTimeMillis());
        Path libpath = new Path(basePath, "lib_" + ShareLibService.dateFormat.format(time));
        fs.mkdirs(libpath);
        Path pigPath = new Path(libpath.toString() + "/" + "pig");
        Path pigPath1 = new Path(libpath.toString() + "/" + "pig_9");
        Path pigPath2 = new Path(libpath.toString() + "/" + "pig_10");
        fs.mkdirs(pigPath);
        fs.mkdirs(pigPath1);
        fs.mkdirs(pigPath2);
        this.services.init();
        ShareLibService shareLibService = (ShareLibService)Services.get().get(ShareLibService.class);
        TestShareLibService.assertNotNull((Object)shareLibService.getShareLibJars("pig"));
        TestShareLibService.assertNotNull((Object)shareLibService.getShareLibJars("pig_9"));
        TestShareLibService.assertNotNull((Object)shareLibService.getShareLibJars("pig_10"));
        TestShareLibService.assertNull((Object)shareLibService.getShareLibJars("pig_11"));
    }

    @Test
    public void testShareLib() throws Exception {
        this.setShipLauncherInOozieConfig();
        FileSystem fs = this.getFileSystem();
        String dir1 = this.dt.format(new Date(System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(1L, TimeUnit.DAYS)));
        String dir2 = this.dt.format(new Date(System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(2L, TimeUnit.DAYS)));
        String dir3 = this.dt.format(new Date(System.currentTimeMillis() - TimeUnit.MILLISECONDS.convert(3L, TimeUnit.DAYS)));
        Path basePath = new Path(this.getOozieConfig().get("oozie.service.WorkflowAppService.system.libpath"));
        Path path1 = new Path(basePath, "lib_" + dir1);
        Path path2 = new Path(basePath, "lib_" + dir2);
        Path path3 = new Path(basePath, "lib_" + dir3);
        this.createDirs(fs, path1, path2, path3);
        this.createFiles(path1.toString() + "/" + "pig" + "/" + "pig.jar");
        this.services.init();
        ShareLibService shareLibService = (ShareLibService)Services.get().get(ShareLibService.class);
        TestShareLibService.assertTrue((boolean)((Path)shareLibService.getShareLibJars("pig").get(0)).getName().endsWith("pig.jar"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateShareLibLoadFiles(FileSystem fs, String schema) throws Exception {
        try {
            this.services.init();
            ShareLibService shareLibService = (ShareLibService)Services.get().get(ShareLibService.class);
            this.verifyShareLibFromMappingFileContent(schema, shareLibService);
        }
        finally {
            if (schema.startsWith(HDFS_SCHEME_PREFIX)) {
                fs.delete(new Path(SHARELIB_PATH), true);
                fs.delete(new Path("linkFile.xml"), true);
            }
        }
    }

    private void verifyShareLibFromMappingFileContent(String schema, ShareLibService shareLibService) throws IOException {
        TestShareLibService.assertTrue((boolean)((Path)shareLibService.getShareLibJars("something_new").get(0)).getName().endsWith("somethingNew.jar"));
        TestShareLibService.assertTrue((boolean)((Path)shareLibService.getShareLibJars("pig").get(0)).getName().endsWith("pig.jar"));
        TestShareLibService.assertTrue((boolean)((Path)shareLibService.getShareLibJars("directjar").get(0)).getName().endsWith("direct.jar"));
        TestShareLibService.assertTrue((boolean)((Path)shareLibService.getShareLibJars("linkFile").get(0)).getName().endsWith("targetOfLinkFile.xml"));
        List listOfPaths = shareLibService.getShareLibJars("directjar");
        for (Path p : listOfPaths) {
            TestShareLibService.assertTrue((boolean)p.toString().startsWith(schema));
        }
    }

    private void setupShareLibLoadFiles(FileSystem fs, String testUserHome) throws ServiceException, IOException {
        this.createShareLibMetaFileTestResources(fs, testUserHome);
        this.setShipLauncherInOozieConfig();
        Configuration conf = this.getOozieConfig();
        conf.set("oozie.service.ShareLibService.mapping.file", fs.getUri() + testUserHome + TEST_MAPPING_FILENAME);
    }

    @Test
    public void testShareLibLoadFilesFromLocalFs() throws Exception {
        FileSystem localFs = this.newLocalFileSystem();
        String testUserHome = Files.createTempDir().toString() + "/";
        try {
            this.setupShareLibLoadFiles(localFs, testUserHome);
            this.validateShareLibLoadFiles(localFs, "file:");
        }
        finally {
            localFs.delete(new Path(testUserHome), true);
        }
    }

    @Test
    public void testShareLibLoadFilesFromHDFS() throws Exception {
        FileSystem fs = this.getFileSystem();
        this.setupShareLibLoadFiles(fs, TEST_HDFS_HOME);
        this.validateShareLibLoadFiles(fs, HDFS_SCHEME_PREFIX);
    }

    @Test
    public void testLoadfromDFS() throws Exception {
        this.services.init();
        FileSystem fs = this.getFileSystem();
        Date time = new Date(System.currentTimeMillis());
        Path basePath = new Path(this.getOozieConfig().get("oozie.service.WorkflowAppService.system.libpath"));
        Path libpath = new Path(basePath, "lib_" + ShareLibService.dateFormat.format(time));
        fs.mkdirs(libpath);
        Path pigPath = new Path(libpath.toString() + "/" + "pig");
        Path ooziePath = new Path(libpath.toString() + "/" + "oozie");
        Path pigPath1 = new Path(libpath.toString() + "/" + "pig_9");
        Path pigPath2 = new Path(libpath.toString() + "/" + "pig_10");
        fs.mkdirs(pigPath);
        fs.mkdirs(ooziePath);
        fs.mkdirs(pigPath1);
        fs.mkdirs(pigPath2);
        this.createFiles(libpath.toString() + "/" + "pig_10" + "/" + "pig-10.jar");
        this.createFiles(libpath.toString() + "/" + "oozie" + "/" + "oozie_luncher.jar");
        String actionXml = "<pig><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><property><name>oozie.action.sharelib.for.pig</name><value>pig_10</value></property></pig>";
        Element eActionXml = XmlUtils.parseXml((String)actionXml);
        XConfiguration protoConf = new XConfiguration();
        protoConf.set("user.name", TestShareLibService.getTestUser());
        WorkflowJobBean wfj = new WorkflowJobBean();
        protoConf.setBoolean("oozie.use.system.libpath", true);
        wfj.setProtoActionConf(XmlUtils.prettyPrint((Configuration)protoConf).toString());
        wfj.setConf(XmlUtils.prettyPrint((Configuration)protoConf).toString());
        TestJavaActionExecutor testJavaActionExecutor = new TestJavaActionExecutor();
        ((Object)((Object)testJavaActionExecutor)).getClass();
        ActionExecutorTestCase.Context context = testJavaActionExecutor.new ActionExecutorTestCase.Context(wfj, new WorkflowActionBean());
        PigActionExecutor ae = new PigActionExecutor();
        Configuration jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
        jobConf.set("oozie.action.sharelib.for.pig", "pig_10");
        ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, new Path("hdfs://dummyAppPath"), jobConf);
        this.verifyFilesInDistributedCache(DistributedCache.getCacheFiles((Configuration)jobConf), "pig-10.jar", "oozie_luncher.jar");
    }

    @Test
    public void testShareLibLoadFileMultipleFile() throws Exception {
        FileSystem fs = this.getFileSystem();
        this.createTestShareLibMetaFile_multipleFile(fs);
        Configuration conf = this.getOozieConfig();
        this.setShipLauncherInOozieConfig();
        this.setShareLibMappingFileInOozieConfig(fs, conf);
        this.services.init();
        ShareLibService shareLibService = (ShareLibService)Services.get().get(ShareLibService.class);
        TestShareLibService.assertNull((Object)shareLibService.getShareLibJars("something_new"));
        TestShareLibService.assertEquals((int)shareLibService.getShareLibJars("pig").size(), (int)2);
        fs.delete(new Path(SHARELIB_PATH), true);
    }

    private void setShareLibMappingFileInOozieConfig(FileSystem fs, Configuration conf) {
        conf.set("oozie.service.ShareLibService.mapping.file", fs.getUri() + TEST_HDFS_HOME + TEST_MAPPING_FILENAME);
    }

    @Test
    public void testMultipleLauncherCall() throws Exception {
        this.setShipLauncherInOozieConfig();
        FileSystem fs = this.getFileSystem();
        Date time = new Date(System.currentTimeMillis());
        Path basePath = new Path(this.getOozieConfig().get("oozie.service.WorkflowAppService.system.libpath"));
        Path libpath = new Path(basePath, "lib_" + ShareLibService.dateFormat.format(time));
        fs.mkdirs(libpath);
        Path ooziePath = new Path(libpath.toString() + "/" + "oozie");
        fs.mkdirs(ooziePath);
        this.createFiles(libpath.toString() + "/" + "oozie" + "/" + "oozie_luncher.jar");
        this.services.init();
        ShareLibService shareLibService = (ShareLibService)Services.get().get(ShareLibService.class);
        List launcherPath = shareLibService.getSystemLibJars("oozie");
        TestShareLibService.assertEquals((int)launcherPath.size(), (int)2);
        launcherPath = shareLibService.getSystemLibJars("oozie");
        TestShareLibService.assertEquals((int)launcherPath.size(), (int)2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testMetafileSymlink() throws ServiceException, IOException {
        Configuration conf = this.getOozieConfig();
        this.setShipLauncherInOozieConfig();
        this.services.init();
        FileSystem fs = this.getFileSystem();
        Properties prop = new Properties();
        try {
            Path basePath = new Path("shareLibPath/testPath");
            Path basePath1 = new Path("shareLibPath/testPath1");
            Path hive_site = new Path(basePath.toString() + "/" + "hive_conf" + "/" + "hive-site.xml");
            Path hive_site1 = new Path(basePath.toString() + "/" + "hive_conf" + "/" + "hive-site1.xml");
            Path symlink = new Path("symlink/");
            Path symlink_hive_site = new Path("symlink/hive_conf/hive-site.xml");
            fs.mkdirs(basePath);
            this.createFiles(basePath.toString() + "/" + "pig" + "/" + "pig.jar");
            this.createFiles(basePath.toString() + "/" + "pig" + "/" + "pig_1.jar");
            this.createFiles(basePath1.toString() + "/" + "pig" + "/" + "pig_2.jar");
            this.createFiles(basePath1.toString() + "/" + "pig" + "/" + "pig_3.jar");
            this.createFiles(basePath1.toString() + "/" + "pig" + "/" + "pig_4.jar");
            this.createFiles(hive_site.toString());
            FSUtils.createSymlink((FileSystem)fs, (Path)basePath, (Path)symlink, (boolean)true);
            FSUtils.createSymlink((FileSystem)fs, (Path)hive_site, (Path)symlink_hive_site, (boolean)true);
            prop.put(ShareLibService.SHARE_LIB_CONF_PREFIX + ".pig", TEST_HDFS_HOME + symlink.toString());
            prop.put(ShareLibService.SHARE_LIB_CONF_PREFIX + ".hive_conf", TEST_HDFS_HOME + symlink_hive_site.toString() + "#hive-site.xml");
            this.createTestShareLibMappingFile(fs, prop);
            TestShareLibService.assertEquals((boolean)FSUtils.isSymlink((FileSystem)fs, (Path)symlink), (boolean)true);
            this.setShareLibMappingFileInOozieConfig(fs, conf);
            this.setShipLauncherInOozieConfig();
            try {
                ShareLibService shareLibService = (ShareLibService)Services.get().get(ShareLibService.class);
                TestShareLibService.assertEquals((int)shareLibService.getShareLibJars("pig").size(), (int)2);
                TestShareLibService.assertEquals((int)shareLibService.getShareLibJars("hive_conf").size(), (int)1);
                FSUtils.createSymlink((FileSystem)fs, (Path)basePath1, (Path)symlink, (boolean)true);
                FSUtils.createSymlink((FileSystem)fs, (Path)hive_site1, (Path)symlink_hive_site, (boolean)true);
                TestShareLibService.assertEquals((Object)FSUtils.getSymLinkTarget((FileSystem)fs, (Path)((Path)shareLibService.getShareLibJars("hive_conf").get(0))), (Object)hive_site1);
                TestShareLibService.assertEquals((int)shareLibService.getShareLibJars("pig").size(), (int)3);
            }
            finally {
                fs.delete(symlink, true);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        finally {
            fs.delete(new Path(SHARELIB_PATH), true);
            fs.delete(new Path(TEST_HDFS_MAPPING_FILE_PATH), true);
        }
    }

    @Test
    public void testDuplicateJarsInDistributedCache() throws Exception {
        FileSystem fs = this.getFileSystem();
        Path basePath = new Path(this.getOozieConfig().get("oozie.service.WorkflowAppService.system.libpath"));
        this.setShipLauncherInOozieConfig();
        Date time = new Date(System.currentTimeMillis());
        Path libpath = new Path(basePath, "lib_" + ShareLibService.dateFormat.format(time));
        Path pigPath = new Path(libpath.toString() + "/" + "pig");
        this.createDirs(fs, pigPath, new Path(pigPath, "temp"));
        this.createFiles(new Path(pigPath, "pig.jar"));
        this.createFiles(new Path(pigPath, "hive.jar"));
        this.createFiles(new Path(new Path(pigPath, "temp"), "pig.jar#pig.jar"));
        this.verifyFilesInDistributedCache(this.setUpPigJob(true), "pig.jar", "hive.jar", "MyOozie.jar", "MyPig.jar");
        ShareLibService shareLibService = (ShareLibService)this.services.get(ShareLibService.class);
        List shareLib = shareLibService.getShareLibJars("pig");
        TestShareLibService.assertEquals((int)shareLib.size(), (int)3);
        TestShareLibService.assertTrue((boolean)shareLib.toString().contains("pig.jar#pig.jar"));
        TestShareLibService.assertTrue((boolean)shareLib.toString().contains("hive.jar"));
    }

    private URI[] setUpPigJob(boolean useSystemSharelib) throws Exception {
        this.services.init();
        String actionXml = "<pig><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node></pig>";
        Element eActionXml = XmlUtils.parseXml((String)actionXml);
        XConfiguration protoConf = new XConfiguration();
        protoConf.set("user.name", TestShareLibService.getTestUser());
        WorkflowJobBean wfj = new WorkflowJobBean();
        protoConf.setBoolean("oozie.use.system.libpath", useSystemSharelib);
        wfj.setProtoActionConf(XmlUtils.prettyPrint((Configuration)protoConf).toString());
        wfj.setConf(XmlUtils.prettyPrint((Configuration)protoConf).toString());
        TestJavaActionExecutor testJavaActionExecutor = new TestJavaActionExecutor();
        ((Object)((Object)testJavaActionExecutor)).getClass();
        ActionExecutorTestCase.Context context = testJavaActionExecutor.new ActionExecutorTestCase.Context(wfj, new WorkflowActionBean());
        PigActionExecutor ae = new PigActionExecutor();
        Configuration jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
        jobConf.set("oozie.action.sharelib.for.pig", "pig");
        ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, new Path("hdfs://dummyAppPath"), jobConf);
        return DistributedCache.getCacheFiles((Configuration)jobConf);
    }

    private static void createFiles(FileSystem fs, Path ... paths) throws IOException {
        for (Path path : paths) {
            FSDataOutputStream out = fs.create(path);
            out.close();
        }
    }

    private static void createFiles(FileSystem fs, String ... filenames) throws IOException {
        Path[] paths = new Path[filenames.length];
        for (int i = 0; i != filenames.length; ++i) {
            paths[i] = new Path(filenames[i]);
        }
        TestShareLibService.createFiles(fs, paths);
    }

    private void createFiles(String ... filenames) throws IOException {
        TestShareLibService.createFiles(this.getFileSystem(), filenames);
    }

    private void createFiles(Path ... paths) throws IOException {
        TestShareLibService.createFiles(this.getFileSystem(), paths);
    }

    private void createShareLibMetaFileTestResources(FileSystem fs, String testUserHome) throws IOException {
        String testPath = testUserHome + SHARELIB_PATH;
        Path basePath = new Path(testPath + "testPath");
        Path somethingNew = new Path(testPath + "something_new");
        Path directJarDir = new Path(testPath + "directJarDir");
        String directJarPath = directJarDir.toString() + "/" + "direct.jar";
        String[] testFiles = new String[]{basePath.toString() + "/" + "pig" + "/" + "pig.jar", somethingNew.toString() + "/" + "somethingNew" + "/" + "somethingNew.jar", directJarDir.toString() + "/" + "direct.jar"};
        HashMap<String, String> symlinks = new HashMap<String, String>();
        symlinks.put(testPath + "/" + "linkDir" + "/" + "targetOfLinkFile.xml", testUserHome + "linkFile.xml");
        Properties mappingFileConfig = new Properties();
        mappingFileConfig.put(ShareLibService.SHARE_LIB_CONF_PREFIX + ".pig", TestShareLibMappingFileInput.getLocalizedShareLibPath(fs, basePath.toString()));
        mappingFileConfig.put(ShareLibService.SHARE_LIB_CONF_PREFIX + ".something_new", TestShareLibMappingFileInput.getLocalizedShareLibPath(fs, somethingNew.toString()));
        mappingFileConfig.put(ShareLibService.SHARE_LIB_CONF_PREFIX + ".directjar", TestShareLibMappingFileInput.getLocalizedShareLibPath(fs, directJarPath.toString()));
        String symlink = testUserHome + "linkFile.xml";
        mappingFileConfig.put(ShareLibService.SHARE_LIB_CONF_PREFIX + ".linkFile", TestShareLibMappingFileInput.getLocalizedShareLibPath(fs, symlink + "#targetOfLinkFile.xml"));
        this.createTestShareLibMappingFile(fs, testUserHome, Arrays.asList(testFiles), symlinks, mappingFileConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testLoadMappingFilesFromDFSandLocalFs() throws IOException, ServiceException {
        String testUserHome = Files.createTempDir().toString() + "/";
        String testPath = testUserHome + SHARELIB_PATH;
        Path basePath = new Path(testPath + "testPath");
        Path somethingNew = new Path(testPath + "something_new");
        Path directHdfsJarDir = new Path("/user/test/shareLibPath/directJarDir");
        String directHdfsJarPath = directHdfsJarDir.toString() + "/" + "direct.jar";
        String directjarShareLibName = "directjar";
        FileSystem localFs = this.newLocalFileSystem();
        FileSystem hdFs = this.getFileSystem();
        TestShareLibMappingFileInput[] testShareLibMappingFileInputs = new TestShareLibMappingFileInput[]{new TestShareLibMappingFileInput(localFs, "pig", basePath.toString() + "/" + "pig" + "/" + "pig.jar"), new TestShareLibMappingFileInput(localFs, "something_new", somethingNew.toString() + "/" + "something_new.jar"), new TestShareLibMappingFileInput(hdFs, "directjar", directHdfsJarPath), new TestShareLibMappingSymlinkInput(hdFs, "linkFile", "/user/test/symlinkTargetDir/targetOfLinkFile.xml", "/user/test/linkFile.xml")};
        Properties mappingFileConfig = new Properties();
        for (TestShareLibMappingFileInput shmfInput : testShareLibMappingFileInputs) {
            shmfInput.materialize();
            mappingFileConfig.put(shmfInput.sharelibNameWithMappingFilePrefix, shmfInput.getFullShareLibPathDir());
        }
        this.createTestShareLibMappingFile(testUserHome + TEST_MAPPING_FILENAME, localFs, mappingFileConfig);
        this.setShipLauncherInOozieConfig();
        Configuration oozieConfig = this.getOozieConfig();
        oozieConfig.set("oozie.service.ShareLibService.mapping.file", localFs.getUri() + testUserHome + TEST_MAPPING_FILENAME);
        try {
            this.services.init();
            ShareLibService shareLibService = (ShareLibService)Services.get().get(ShareLibService.class);
            for (TestShareLibMappingFileInput sh : testShareLibMappingFileInputs) {
                String firstShareLibPath = ((Path)shareLibService.getShareLibJars(sh.sharelibName).get(0)).toString();
                TestShareLibService.assertTrue((boolean)firstShareLibPath.endsWith(sh.baseName));
            }
            List listOfPaths = shareLibService.getShareLibJars("directjar");
            for (Path p : listOfPaths) {
                TestShareLibService.assertTrue((boolean)p.toString().startsWith(HDFS_SCHEME_PREFIX));
            }
        }
        finally {
            hdFs.delete(new Path(SHARELIB_PATH), true);
            hdFs.delete(new Path("linkFile.xml"), true);
            localFs.delete(new Path(testUserHome), true);
        }
    }

    private FileSystem newLocalFileSystem() throws IOException {
        Configuration emptyConfig = new Configuration(false);
        return LocalFileSystem.get((Configuration)emptyConfig);
    }

    private void setShipLauncherInOozieConfig() {
        Configuration oozieConfig = this.getOozieConfig();
        oozieConfig.set("oozie.action.ship.launcher.jar", "true");
    }

    private Configuration getOozieConfig() {
        return ((ConfigurationService)this.services.get(ConfigurationService.class)).getConf();
    }

    private void createTestShareLibMappingFile(FileSystem fs, String testUserHome, Iterable<String> testFiles, Map<String, String> testSymlinks, Properties mappingConf) throws IOException {
        this.createTestShareLibDirsAndFiles(fs, testFiles);
        this.createTestShareLibDirsAndSymlinks(fs, testSymlinks);
        this.createTestShareLibMappingFile(testUserHome + TEST_MAPPING_FILENAME, fs, mappingConf);
    }

    private void createTestShareLibDirsAndFiles(FileSystem fs, Iterable<String> testFiles) throws IOException {
        for (String f : testFiles) {
            TestShareLibService.createFileWithDirectoryPath(fs, f);
        }
    }

    static void createFileWithDirectoryPath(FileSystem fs, String f) throws IOException {
        if (!fs.exists(new Path(f))) {
            String dirName = f.substring(0, f.toString().lastIndexOf("/"));
            fs.mkdirs(new Path(dirName));
        }
        TestShareLibService.createFiles(fs, f);
    }

    void createTestShareLibDirsAndSymlinks(FileSystem fs, Map<String, String> symlinks) throws IOException {
        this.createTestShareLibDirsAndFiles(fs, symlinks.keySet());
        for (Map.Entry<String, String> symlinkEntry : symlinks.entrySet()) {
            String symlinkTarget = symlinkEntry.getKey();
            String symlink = symlinkEntry.getValue();
            FSUtils.createSymlink((FileSystem)fs, (Path)new Path(symlinkTarget), (Path)new Path(symlink), (boolean)true);
        }
    }

    private void createTestShareLibMappingFile(FileSystem fs, Properties prop) {
        this.createTestShareLibMappingFile(TEST_HDFS_MAPPING_FILE_PATH, fs, prop);
    }

    private void createTestShareLibMappingFile(String metaFile, FileSystem fs, Properties prop) {
        try (FSDataOutputStream out = fs.create(new Path(metaFile));){
            prop.store((OutputStream)out, null);
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    public void createTestShareLibMetaFile_multipleFile(FileSystem fs) {
        Properties prop = new Properties();
        try {
            Path basePath = new Path("shareLibPath/testPath");
            Path somethingNew = new Path("shareLibPath/something_new");
            fs.mkdirs(basePath);
            fs.mkdirs(somethingNew);
            this.createFiles(basePath.toString() + "/" + "pig" + "/" + "pig.jar");
            this.createFiles(somethingNew.toString() + "/" + "somethingNew" + "/" + "somethingNew.jar");
            prop.put(ShareLibService.SHARE_LIB_CONF_PREFIX + ".pig", TEST_HDFS_HOME + basePath.toString() + "/" + "pig" + "/" + "pig.jar," + TEST_HDFS_HOME + somethingNew.toString() + "/" + "somethingNew" + "/" + "somethingNew.jar");
            FSDataOutputStream out = fs.create(new Path(TEST_HDFS_MAPPING_FILE_PATH));
            prop.store((OutputStream)out, null);
            out.close();
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
    }

    private void createDirs(FileSystem fs, Path ... paths) throws IOException {
        for (Path path : paths) {
            fs.mkdirs(path);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfFileAddedToActionConf() throws Exception {
        try {
            XConfiguration protoConf = new XConfiguration();
            protoConf.set("user.name", TestShareLibService.getTestUser());
            WorkflowJobBean wfj = new WorkflowJobBean();
            protoConf.setBoolean("oozie.use.system.libpath", true);
            wfj.setProtoActionConf(XmlUtils.prettyPrint((Configuration)protoConf).toString());
            wfj.setConf(XmlUtils.prettyPrint((Configuration)protoConf).toString());
            TestJavaActionExecutor testJavaActionExecutor = new TestJavaActionExecutor();
            ((Object)((Object)testJavaActionExecutor)).getClass();
            ActionExecutorTestCase.Context context = testJavaActionExecutor.new ActionExecutorTestCase.Context(wfj, new WorkflowActionBean());
            this.setupSharelibConf("hive-site.xml", "oozie.hive_conf");
            ShareLibService shareLibService = (ShareLibService)this.services.get(ShareLibService.class);
            TestShareLibService.assertEquals((int)((Map)shareLibService.getShareLibConfigMap().get("hive_conf")).values().size(), (int)1);
            TestShareLibService.assertEquals((String)((Map)shareLibService.getShareLibConfigMap().get("hive_conf")).keySet().toArray(new Path[0])[0].getName(), (String)"hive-site.xml");
            this.setupSharelibConf("hive-site.xml", "oozie.hive_conf");
            String actionXml = "<hive><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><script>test</script></hive>";
            Element eActionXml = XmlUtils.parseXml((String)actionXml);
            HiveActionExecutor ae = new HiveActionExecutor();
            Configuration jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            Configuration actionConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            jobConf.set("oozie.action.sharelib.for.hive", "hive_conf");
            ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, new Path("hdfs://dummyAppPath"), jobConf);
            Object[] cacheFiles = DistributedCache.getCacheFiles((Configuration)actionConf);
            String cacheFilesStr = Arrays.toString(cacheFiles);
            TestShareLibService.assertFalse((boolean)cacheFilesStr.contains("hive-site.xml"));
            jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            Properties prop = new Properties();
            actionConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            prop.put("oozie.hive_conf", "/user/test/shareLibPath/hive-site.xml#hive-site.xml");
            this.setupSharelibConf("hive-site.xml", "oozie.hive_conf", prop);
            jobConf.set("oozie.action.sharelib.for.hive", "hive_conf");
            ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, new Path("hdfs://dummyAppPath"), jobConf);
            TestShareLibService.assertEquals((String)jobConf.get("oozie.hive_conf-sharelib-test"), (String)"test");
            prop = new Properties();
            jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            actionConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            prop.put("oozie.hive_conf", "hdfs:///user/test/shareLibPath/hive-site.xml#hive-site.xml");
            this.setupSharelibConf("hive-site.xml", "oozie.hive_conf", prop);
            jobConf.set("oozie.action.sharelib.for.hive", "hive_conf");
            ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, new Path("hdfs://dummyAppPath"), jobConf);
            TestShareLibService.assertEquals((String)jobConf.get("oozie.hive_conf-sharelib-test"), (String)"test");
            cacheFiles = DistributedCache.getCacheFiles((Configuration)actionConf);
            cacheFilesStr = Arrays.toString(cacheFiles);
            TestShareLibService.assertFalse((boolean)cacheFilesStr.contains("hive-site.xml"));
            prop = new Properties();
            jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            actionConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            prop.put("oozie.hive_conf", "/user/test/shareLibPath/hive-site.xml");
            this.setupSharelibConf("hive-site.xml", "oozie.hive_conf", prop);
            jobConf.set("oozie.action.sharelib.for.hive", "hive_conf");
            ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, new Path("hdfs://dummyAppPath"), jobConf);
            TestShareLibService.assertEquals((String)jobConf.get("oozie.hive_conf-sharelib-test"), (String)"test");
            cacheFiles = DistributedCache.getCacheFiles((Configuration)actionConf);
            cacheFilesStr = Arrays.toString(cacheFiles);
            TestShareLibService.assertFalse((boolean)cacheFilesStr.contains("hive-site.xml"));
            prop = new Properties();
            jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            actionConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            prop.put("oozie.hive_conf", "/user/test/shareLibPath/hive-site.xml#hive-site.xml");
            this.setupSharelibConf("hive-site.xml", "oozie.hive_conf", prop);
            jobConf.set("oozie.action.sharelib.for.hive", "hive_conf");
            ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, new Path("hdfs://dummyAppPath"), jobConf);
            TestShareLibService.assertEquals((String)jobConf.get("oozie.hive_conf-sharelib-test"), (String)"test");
            cacheFiles = DistributedCache.getCacheFiles((Configuration)actionConf);
            cacheFilesStr = Arrays.toString(cacheFiles);
            TestShareLibService.assertFalse((boolean)cacheFilesStr.contains("hive-site.xml"));
        }
        finally {
            this.getFileSystem().delete(new Path(SHARELIB_PATH), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testConfFileAddedToDistributedCache() throws Exception {
        try {
            Properties prop = new Properties();
            prop.put("oozie.hive_conf", "/user/test/shareLibPath/hive-site.xml#hive-site.xml");
            this.setupSharelibConf("hive-site.xml", "oozie.hive_conf", prop);
            String actionXml = "<pig><job-tracker>" + this.getJobTrackerUri() + "</job-tracker><name-node>" + this.getNameNodeUri() + "</name-node><script>test</script></pig>";
            Element eActionXml = XmlUtils.parseXml((String)actionXml);
            XConfiguration protoConf = new XConfiguration();
            protoConf.set("user.name", TestShareLibService.getTestUser());
            WorkflowJobBean wfj = new WorkflowJobBean();
            protoConf.setBoolean("oozie.use.system.libpath", true);
            wfj.setProtoActionConf(XmlUtils.prettyPrint((Configuration)protoConf).toString());
            wfj.setConf(XmlUtils.prettyPrint((Configuration)protoConf).toString());
            TestJavaActionExecutor testJavaActionExecutor = new TestJavaActionExecutor();
            ((Object)((Object)testJavaActionExecutor)).getClass();
            ActionExecutorTestCase.Context context = testJavaActionExecutor.new ActionExecutorTestCase.Context(wfj, new WorkflowActionBean());
            PigActionExecutor ae = new PigActionExecutor();
            Configuration jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            jobConf.set("oozie.action.sharelib.for.pig", "hive_conf");
            ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, new Path("hdfs://dummyAppPath"), jobConf);
            Object[] cacheFiles = DistributedCache.getCacheFiles((Configuration)jobConf);
            String cacheFilesStr = Arrays.toString(cacheFiles);
            TestShareLibService.assertEquals((String)jobConf.get("oozie.hive_conf-sharelib-test"), null);
            TestShareLibService.assertTrue((boolean)URLDecoder.decode(cacheFilesStr).contains("hive-site.xml#hive-site.xml"));
            this.setupSharelibConf("hbase-site.xml", "oozie.hbase_conf");
            jobConf = ae.createBaseHadoopConf((ActionExecutor.Context)context, eActionXml);
            jobConf.set("oozie.action.sharelib.for.pig", "hbase_conf");
            ae.setLibFilesArchives((ActionExecutor.Context)context, eActionXml, new Path("hdfs://dummyAppPath"), jobConf);
            cacheFiles = DistributedCache.getCacheFiles((Configuration)jobConf);
            cacheFilesStr = Arrays.toString(cacheFiles);
            TestShareLibService.assertTrue((boolean)cacheFilesStr.contains("hbase-site.xml"));
        }
        finally {
            this.getFileSystem().delete(new Path(SHARELIB_PATH), true);
        }
    }

    private void setupSharelibConf(String file, String tag) throws ServiceException, IOException {
        Properties prop = new Properties();
        prop.put(tag, "/user/test/shareLibPath/");
        this.setupSharelibConf(file, tag, prop);
    }

    private void setupSharelibConf(String file, String tag, Properties prop) throws IOException, ServiceException {
        this.setupSharelibConf(this.getFileSystem(), file, tag, prop);
    }

    private void setupSharelibConf(FileSystem fs, String file, String tag, Properties prop) throws IOException, ServiceException {
        Configuration conf = this.getOozieConfig();
        this.setShipLauncherInOozieConfig();
        this.setShareLibMappingFileInOozieConfig(fs, conf);
        XConfiguration hiveConf = new XConfiguration();
        hiveConf.set(tag + "-sharelib-test", "test");
        this.createDirs(this.getFileSystem(), new Path(SHARELIB_PATH));
        FSDataOutputStream out = this.getFileSystem().create(new Path(SHARELIB_PATH, file), true);
        PrintWriter bufOut = new PrintWriter((OutputStream)out);
        bufOut.write(hiveConf.toXmlString(false));
        bufOut.close();
        this.createTestShareLibMappingFile(this.getFileSystem(), prop);
        this.services.init();
    }

    private void verifyFilesInDistributedCache(URI[] cacheFiles, String ... files) {
        String cacheFilesStr = Arrays.toString(cacheFiles);
        TestShareLibService.assertEquals((int)cacheFiles.length, (int)(files.length + 2));
        TestShareLibService.assertTrue((boolean)cacheFilesStr.contains("MRAppJar.jar"));
        TestShareLibService.assertTrue((boolean)cacheFilesStr.contains("hadoop-mapreduce-client-jobclient-"));
        for (String file : files) {
            TestShareLibService.assertTrue((boolean)cacheFilesStr.contains(file));
        }
    }

    static class TestHive {
        TestHive() {
        }
    }

    static class MyPig {
        MyPig() {
        }
    }

    static class MyOozie {
        MyOozie() {
        }
    }

    public static class DummyHiveActionExecutor
    extends HiveActionExecutor {
        public List<Class<?>> getLauncherClasses() {
            return Lists.newArrayList((Object[])new Class[]{TestHive.class});
        }
    }

    public static class DummyPigActionExecutor
    extends PigActionExecutor {
        public List<Class<?>> getLauncherClasses() {
            return Lists.newArrayList((Object[])new Class[]{MyPig.class});
        }
    }

    public static class DummyShareLibService
    extends ShareLibService {
        public String findContainingJar(Class<?> clazz) {
            if (JavaActionExecutor.getCommonLauncherClasses().contains(clazz)) {
                return testCaseDirPath + "/" + MyOozie.class.getName() + ".jar";
            }
            return testCaseDirPath + "/" + clazz.getName() + ".jar";
        }
    }
}

