/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.SparkConfigurationService;
import org.apache.oozie.test.XTestCase;

public class TestSparkConfigurationService
extends XTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        Services services = new Services();
        services.init();
    }

    @Override
    protected void tearDown() throws Exception {
        Services.get().destroy();
        super.tearDown();
    }

    public void testSparkConfigsEmpty() throws Exception {
        SparkConfigurationService scs = (SparkConfigurationService)Services.get().get(SparkConfigurationService.class);
        scs.destroy();
        ConfigurationService.set((String)"oozie.service.SparkConfigurationService.spark.configurations", (String)"");
        scs.init(Services.get());
        Properties sparkConfigs = scs.getSparkConfig("foo");
        TestSparkConfigurationService.assertEquals((int)0, (int)sparkConfigs.size());
    }

    public void testSparkConfigs() throws Exception {
        File sparkConf1Dir = this.createSparkConfsInDir("spark-conf-1", "a", "A", "b", "B", "spark.yarn.jar", "foo");
        File sparkConf3Dir = this.createSparkConfsInDir("spark-conf-3", new String[0]);
        File sparkConf4Dir = this.createSparkConfsInDir("spark-conf-4", "y", "Y", "z", "Z", "spark.yarn.jars", "foo2");
        SparkConfigurationService scs = (SparkConfigurationService)Services.get().get(SparkConfigurationService.class);
        scs.destroy();
        ConfigurationService.set((String)"oozie.service.SparkConfigurationService.spark.configurations", (String)("rm1=" + sparkConf1Dir.getAbsolutePath() + ",rm2,rm3=" + sparkConf3Dir.getAbsolutePath() + ",rm4=" + sparkConf4Dir.getName()));
        scs.init(Services.get());
        Properties sparkConfigs = scs.getSparkConfig("foo");
        TestSparkConfigurationService.assertEquals((String)sparkConfigs.toString(), (int)0, (int)sparkConfigs.size());
        sparkConfigs = scs.getSparkConfig("rm1");
        TestSparkConfigurationService.assertEquals((String)sparkConfigs.toString(), (int)2, (int)sparkConfigs.size());
        TestSparkConfigurationService.assertEquals((Object)"A", (Object)sparkConfigs.get("a"));
        TestSparkConfigurationService.assertEquals((Object)"B", (Object)sparkConfigs.get("b"));
        sparkConfigs = scs.getSparkConfig("rm2");
        TestSparkConfigurationService.assertEquals((String)sparkConfigs.toString(), (int)0, (int)sparkConfigs.size());
        sparkConfigs = scs.getSparkConfig("rm3");
        TestSparkConfigurationService.assertEquals((String)sparkConfigs.toString(), (int)0, (int)sparkConfigs.size());
        sparkConfigs = scs.getSparkConfig("rm4");
        TestSparkConfigurationService.assertEquals((String)sparkConfigs.toString(), (int)2, (int)sparkConfigs.size());
        TestSparkConfigurationService.assertEquals((Object)"Y", (Object)sparkConfigs.get("y"));
        TestSparkConfigurationService.assertEquals((Object)"Z", (Object)sparkConfigs.get("z"));
        scs.destroy();
        ConfigurationService.setBoolean((String)"oozie.service.SparkConfigurationService.spark.configurations.ignore.spark.yarn.jar", (boolean)false);
        ConfigurationService.set((String)"oozie.service.SparkConfigurationService.spark.configurations.blacklist", (String)" ");
        scs.init(Services.get());
        sparkConfigs = scs.getSparkConfig("rm1");
        TestSparkConfigurationService.assertEquals((String)sparkConfigs.toString(), (int)3, (int)sparkConfigs.size());
        TestSparkConfigurationService.assertEquals((Object)"A", (Object)sparkConfigs.get("a"));
        TestSparkConfigurationService.assertEquals((Object)"B", (Object)sparkConfigs.get("b"));
        TestSparkConfigurationService.assertEquals((Object)"foo", (Object)sparkConfigs.get("spark.yarn.jar"));
        ConfigurationService.setBoolean((String)"oozie.service.SparkConfigurationService.spark.configurations.ignore.spark.yarn.jar", (boolean)true);
        ConfigurationService.set((String)"oozie.service.SparkConfigurationService.spark.configurations.blacklist", (String)"spark.yarn.jar,spark.yarn.jars");
        scs.destroy();
        ConfigurationService.set((String)"oozie.service.SparkConfigurationService.spark.configurations", (String)("rm1=" + sparkConf1Dir.getAbsolutePath() + ",*=" + sparkConf4Dir.getAbsolutePath()));
        scs.init(Services.get());
        sparkConfigs = scs.getSparkConfig("rm1");
        TestSparkConfigurationService.assertEquals((String)sparkConfigs.toString(), (int)2, (int)sparkConfigs.size());
        TestSparkConfigurationService.assertEquals((Object)"A", (Object)sparkConfigs.get("a"));
        TestSparkConfigurationService.assertEquals((Object)"B", (Object)sparkConfigs.get("b"));
        sparkConfigs = scs.getSparkConfig("rm2");
        TestSparkConfigurationService.assertEquals((String)sparkConfigs.toString(), (int)2, (int)sparkConfigs.size());
        TestSparkConfigurationService.assertEquals((Object)"Y", (Object)sparkConfigs.get("y"));
        TestSparkConfigurationService.assertEquals((Object)"Z", (Object)sparkConfigs.get("z"));
        sparkConfigs = scs.getSparkConfig("foo");
        TestSparkConfigurationService.assertEquals((String)sparkConfigs.toString(), (int)2, (int)sparkConfigs.size());
        TestSparkConfigurationService.assertEquals((Object)"Y", (Object)sparkConfigs.get("y"));
        TestSparkConfigurationService.assertEquals((Object)"Z", (Object)sparkConfigs.get("z"));
    }

    private File createSparkConfsInDir(String directory, String ... props) throws IOException {
        File sparkConf1Dir = new File(this.getTestCaseConfDir(), directory);
        sparkConf1Dir.mkdirs();
        File sparkConf1 = new File(sparkConf1Dir, "spark-defaults.conf");
        Properties sparkConf1Props = new Properties();
        for (int i = 0; i < props.length; i += 2) {
            sparkConf1Props.setProperty(props[i], props[i + 1]);
        }
        if (!sparkConf1Props.isEmpty()) {
            try (FileOutputStream fos = new FileOutputStream(sparkConf1);){
                sparkConf1Props.store(fos, "");
            }
        }
        return sparkConf1Dir;
    }

    public void testBlackList() throws Exception {
        File sparkConf1Dir = this.createSparkConfsInDir("spark-conf-1", "a", "A", "b", "B", "spark.yarn.jar", "foo");
        File sparkConf3Dir = this.createSparkConfsInDir("spark-conf-3", new String[0]);
        File sparkConf4Dir = this.createSparkConfsInDir("spark-conf-4", "y", "Y", "z", "Z", "spark.yarn.jars", "foo2");
        SparkConfigurationService scs = (SparkConfigurationService)Services.get().get(SparkConfigurationService.class);
        scs.destroy();
        ConfigurationService.set((String)"oozie.service.SparkConfigurationService.spark.configurations", (String)("rm1=" + sparkConf1Dir.getAbsolutePath() + ",rm2,rm3=" + sparkConf3Dir.getAbsolutePath() + ",rm4=" + sparkConf4Dir.getName()));
        ConfigurationService.setBoolean((String)"oozie.service.SparkConfigurationService.spark.configurations.ignore.spark.yarn.jar", (boolean)false);
        ConfigurationService.set((String)"oozie.service.SparkConfigurationService.spark.configurations.blacklist", (String)"a,z");
        scs.init(Services.get());
        Properties sparkConfigs = scs.getSparkConfig("foo");
        TestSparkConfigurationService.assertEquals((String)sparkConfigs.toString(), (int)0, (int)sparkConfigs.size());
        sparkConfigs = scs.getSparkConfig("rm1");
        TestSparkConfigurationService.assertEquals((String)sparkConfigs.toString(), (int)2, (int)sparkConfigs.size());
        TestSparkConfigurationService.assertEquals((Object)"B", (Object)sparkConfigs.get("b"));
        TestSparkConfigurationService.assertEquals((Object)"foo", (Object)sparkConfigs.get("spark.yarn.jar"));
        sparkConfigs = scs.getSparkConfig("rm2");
        TestSparkConfigurationService.assertEquals((String)sparkConfigs.toString(), (int)0, (int)sparkConfigs.size());
        sparkConfigs = scs.getSparkConfig("rm3");
        TestSparkConfigurationService.assertEquals((String)sparkConfigs.toString(), (int)0, (int)sparkConfigs.size());
        sparkConfigs = scs.getSparkConfig("rm4");
        TestSparkConfigurationService.assertEquals((String)sparkConfigs.toString(), (int)2, (int)sparkConfigs.size());
        TestSparkConfigurationService.assertEquals((Object)"Y", (Object)sparkConfigs.get("y"));
        TestSparkConfigurationService.assertEquals((Object)"foo2", (Object)sparkConfigs.get("spark.yarn.jars"));
        scs.destroy();
    }
}

