/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.test.XTestCase;

public class TestUUIDService
extends XTestCase {
    public void testConfiguration() throws Exception {
        this.setSystemProperty("oozie.service.UUIDService.generator", "counter");
        Services services = new Services();
        services.init();
        services.destroy();
        this.setSystemProperty("oozie.service.UUIDService.generator", "random");
        services = new Services();
        services.init();
        services.destroy();
        try {
            this.setSystemProperty("oozie.service.UUIDService.generator", "x");
            services = new Services();
            services.init();
            services.destroy();
            TestUUIDService.fail();
        }
        catch (ServiceException serviceException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testPadding() throws Exception {
        this.setSystemProperty("oozie.service.UUIDService.generator", "counter");
        Services services = new Services();
        services.init();
        try {
            UUIDService uuid = (UUIDService)services.get(UUIDService.class);
            String id = uuid.generateId(UUIDService.ApplicationType.WORKFLOW);
            TestUUIDService.assertTrue((boolean)id.startsWith("0000000-"));
            for (int i = 0; i < 1000; ++i) {
                id = uuid.generateId(UUIDService.ApplicationType.WORKFLOW);
            }
            TestUUIDService.assertTrue((boolean)id.startsWith("0001000-"));
        }
        finally {
            services.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testChildId() throws Exception {
        String childId;
        String id;
        UUIDService uuid;
        this.setSystemProperty("oozie.service.UUIDService.generator", "counter");
        Services services = new Services();
        services.init();
        try {
            uuid = (UUIDService)services.get(UUIDService.class);
            id = uuid.generateId(UUIDService.ApplicationType.WORKFLOW);
            childId = uuid.generateChildId(id, "a");
            TestUUIDService.assertEquals((String)id, (String)uuid.getId(childId));
            TestUUIDService.assertEquals((String)"a", (String)uuid.getChildName(childId));
        }
        finally {
            services.destroy();
        }
        this.setSystemProperty("oozie.service.UUIDService.generator", "random");
        services = new Services();
        services.init();
        try {
            uuid = (UUIDService)services.get(UUIDService.class);
            id = uuid.generateId(UUIDService.ApplicationType.WORKFLOW);
            childId = uuid.generateChildId(id, "a");
            TestUUIDService.assertEquals((String)id, (String)uuid.getId(childId));
            TestUUIDService.assertEquals((String)"a", (String)uuid.getChildName(childId));
        }
        finally {
            services.destroy();
        }
    }
}

