/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import junit.framework.Assert;
import org.apache.commons.logging.LogFactory;
import org.apache.log4j.LogManager;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.XLogService;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.util.IOUtils;
import org.apache.oozie.util.XLog;

public class TestXLogService
extends XTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
        LogFactory.getFactory().release();
        LogManager.resetConfiguration();
    }

    @Override
    protected void tearDown() throws Exception {
        LogFactory.getFactory().release();
        LogManager.resetConfiguration();
        super.tearDown();
    }

    public void testDefaultLog4jPropertiesFromClassLoader() throws Exception {
        XLogService ls = new XLogService();
        ls.init(null);
        Assert.assertTrue((boolean)ls.getFromClasspath());
        Assert.assertEquals((String)"oozie-log4j.properties", (String)ls.getLog4jProperties());
        ls.destroy();
    }

    public void testCustomLog4jPropertiesFromClassLoader() throws Exception {
        this.setSystemProperty("oozie.log4j.file", "test-custom-log4j.properties");
        XLogService ls = new XLogService();
        ls.init(null);
        Assert.assertTrue((boolean)ls.getFromClasspath());
        Assert.assertEquals((String)"test-custom-log4j.properties", (String)ls.getLog4jProperties());
        ls.destroy();
    }

    public void testDefaultLog4jFromConfigDir() throws Exception {
        File log4jFile = new File(this.getTestCaseConfDir(), "oozie-log4j.properties");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream("test-oozie-log4j.properties");
        IOUtils.copyStream((InputStream)is, (OutputStream)new FileOutputStream(log4jFile));
        XLogService ls = new XLogService();
        ls.init(null);
        Assert.assertFalse((boolean)ls.getFromClasspath());
        Assert.assertEquals((String)"oozie-log4j.properties", (String)ls.getLog4jProperties());
        ls.destroy();
    }

    public void testCustomLog4jFromConfigDir() throws Exception {
        File log4jFile = new File(this.getTestCaseConfDir(), "test-log4j.properties");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream("test-oozie-log4j.properties");
        IOUtils.copyStream((InputStream)is, (OutputStream)new FileOutputStream(log4jFile));
        this.setSystemProperty("oozie.log4j.file", "test-log4j.properties");
        XLogService ls = new XLogService();
        ls.init(null);
        Assert.assertFalse((boolean)ls.getFromClasspath());
        Assert.assertEquals((String)"test-log4j.properties", (String)ls.getLog4jProperties());
        ls.destroy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLog4jReload() throws Exception {
        File log4jFile = new File(this.getTestCaseConfDir(), "oozie-log4j.properties");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream("test-oozie-log4j.properties");
        IOUtils.copyStream((InputStream)is, (OutputStream)new FileOutputStream(log4jFile));
        this.setSystemProperty("oozie.log4j.reload", "1");
        XLogService ls = new XLogService();
        ls.init(null);
        TestXLogService.assertTrue((boolean)LogFactory.getLog((String)"a").isTraceEnabled());
        this.sleep(1000);
        is = cl.getResourceAsStream("test-custom-log4j.properties");
        IOUtils.copyStream((InputStream)is, (OutputStream)new FileOutputStream(log4jFile));
        float originalRatio = XTestCase.WAITFOR_RATIO;
        try {
            XTestCase.WAITFOR_RATIO = 1.0f;
            this.waitFor(5000, new XTestCase.Predicate(){

                @Override
                public boolean evaluate() throws Exception {
                    return !LogFactory.getLog((String)"a").isTraceEnabled();
                }
            });
            TestXLogService.assertFalse((boolean)LogFactory.getLog((String)"a").isTraceEnabled());
        }
        finally {
            XTestCase.WAITFOR_RATIO = originalRatio;
        }
        ls.destroy();
    }

    public void testInfoParameters() throws Exception {
        XLogService ls = new XLogService();
        ls.init(null);
        XLog.Info.get().clear();
        TestXLogService.assertEquals((String)"USER[-] GROUP[-]", (String)XLog.Info.get().createPrefix());
        ls.destroy();
    }

    public void testDefaultLogsDir() throws Exception {
        this.setSystemProperty("oozie.log.dir", null);
        String logs = Services.getOozieHome() + "/logs";
        XLogService ls = new XLogService();
        ls.init(null);
        TestXLogService.assertEquals((String)logs, (String)System.getProperty("oozie.log.dir"));
        ls.destroy();
    }

    public void testCustomLogsDir() throws Exception {
        String logs = "/tmp/oozie/logs";
        this.setSystemProperty("oozie.log.dir", logs);
        XLogService ls = new XLogService();
        ls.init(null);
        TestXLogService.assertEquals((String)logs, (String)System.getProperty("oozie.log.dir"));
        ls.destroy();
    }
}

