/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.ZKJobsConcurrencyService;
import org.apache.oozie.test.ZKXTestCase;
import org.apache.oozie.util.ConfigUtils;
import org.apache.oozie.util.Instrumentation;
import org.apache.oozie.util.ZKUtils;

public class TestZKJobsConcurrencyService
extends ZKXTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRegisterUnregister() throws Exception {
        TestZKJobsConcurrencyService.assertEquals((int)0, (int)ZKUtils.getUsers().size());
        ZKJobsConcurrencyService zkjcs = new ZKJobsConcurrencyService();
        try {
            zkjcs.init(Services.get());
            TestZKJobsConcurrencyService.assertEquals((int)1, (int)ZKUtils.getUsers().size());
            TestZKJobsConcurrencyService.assertEquals((Object)zkjcs, ZKUtils.getUsers().iterator().next());
            zkjcs.destroy();
            TestZKJobsConcurrencyService.assertEquals((int)0, (int)ZKUtils.getUsers().size());
        }
        finally {
            zkjcs.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsLeader() throws Exception {
        ZKJobsConcurrencyService zkjcs = new ZKJobsConcurrencyService();
        ZKXTestCase.DummyZKOozie dummyOozie = null;
        ZKXTestCase.DummyZKOozie dummyOozie2 = null;
        try {
            zkjcs.init(Services.get());
            dummyOozie = new ZKXTestCase.DummyZKOozie("a", "http://blah", true);
            dummyOozie2 = new ZKXTestCase.DummyZKOozie("b", "http://blah", true);
            this.sleep(3000);
            if (zkjcs.isLeader()) {
                TestZKJobsConcurrencyService.assertFalse((boolean)dummyOozie.isLeader());
                TestZKJobsConcurrencyService.assertFalse((boolean)dummyOozie2.isLeader());
                zkjcs.destroy();
                this.sleep(3000);
                if (dummyOozie.isLeader()) {
                    TestZKJobsConcurrencyService.assertFalse((boolean)dummyOozie2.isLeader());
                } else if (dummyOozie2.isLeader()) {
                    TestZKJobsConcurrencyService.assertFalse((boolean)dummyOozie.isLeader());
                } else {
                    TestZKJobsConcurrencyService.fail((String)"No leader");
                }
            } else if (dummyOozie.isLeader()) {
                TestZKJobsConcurrencyService.assertFalse((boolean)zkjcs.isLeader());
                TestZKJobsConcurrencyService.assertFalse((boolean)dummyOozie2.isLeader());
                dummyOozie.teardown();
                this.sleep(3000);
                if (zkjcs.isLeader()) {
                    TestZKJobsConcurrencyService.assertFalse((boolean)dummyOozie2.isLeader());
                } else if (dummyOozie2.isLeader()) {
                    TestZKJobsConcurrencyService.assertFalse((boolean)zkjcs.isLeader());
                } else {
                    TestZKJobsConcurrencyService.fail((String)"No leader");
                }
            } else if (dummyOozie2.isLeader()) {
                TestZKJobsConcurrencyService.assertFalse((boolean)zkjcs.isLeader());
                TestZKJobsConcurrencyService.assertFalse((boolean)dummyOozie.isLeader());
                dummyOozie2.teardown();
                this.sleep(3000);
                if (zkjcs.isLeader()) {
                    TestZKJobsConcurrencyService.assertFalse((boolean)dummyOozie.isLeader());
                } else if (dummyOozie.isLeader()) {
                    TestZKJobsConcurrencyService.assertFalse((boolean)zkjcs.isLeader());
                } else {
                    TestZKJobsConcurrencyService.fail((String)"No leader");
                }
            } else {
                TestZKJobsConcurrencyService.fail((String)"No leader");
            }
        }
        finally {
            zkjcs.destroy();
            if (dummyOozie != null) {
                dummyOozie.teardown();
            }
            if (dummyOozie2 != null) {
                dummyOozie2.teardown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testIsJobIdForThisServer() throws Exception {
        ZKJobsConcurrencyService zkjcs = new ZKJobsConcurrencyService();
        ZKXTestCase.DummyZKOozie dummyOozie = null;
        ZKXTestCase.DummyZKOozie dummyOozie2 = null;
        try {
            dummyOozie = new ZKXTestCase.DummyZKOozie("a", "http://blah");
            zkjcs.init(Services.get());
            TestZKJobsConcurrencyService.assertFalse((boolean)zkjcs.isJobIdForThisServer("0000000-130521183438837-oozie-rkan-W"));
            TestZKJobsConcurrencyService.assertTrue((boolean)zkjcs.isJobIdForThisServer("0000001-130521183438837-oozie-rkan-W"));
            TestZKJobsConcurrencyService.assertFalse((boolean)zkjcs.isJobIdForThisServer("0000002-130521183438837-oozie-rkan-W"));
            TestZKJobsConcurrencyService.assertTrue((boolean)zkjcs.isJobIdForThisServer("0000003-130521183438837-oozie-rkan-W"));
            TestZKJobsConcurrencyService.assertFalse((boolean)zkjcs.isJobIdForThisServer("0000004-130521183438837-oozie-rkan-W"));
            TestZKJobsConcurrencyService.assertTrue((boolean)zkjcs.isJobIdForThisServer("0000005-130521183438837-oozie-rkan-W"));
            TestZKJobsConcurrencyService.assertFalse((boolean)zkjcs.isJobIdForThisServer("0000006-130521183438837-oozie-rkan-W"));
            TestZKJobsConcurrencyService.assertTrue((boolean)zkjcs.isJobIdForThisServer("blah"));
            dummyOozie2 = new ZKXTestCase.DummyZKOozie("b", "http://blah");
            TestZKJobsConcurrencyService.assertFalse((boolean)zkjcs.isJobIdForThisServer("0000000-130521183438837-oozie-rkan-W"));
            TestZKJobsConcurrencyService.assertTrue((boolean)zkjcs.isJobIdForThisServer("0000001-130521183438837-oozie-rkan-W"));
            TestZKJobsConcurrencyService.assertFalse((boolean)zkjcs.isJobIdForThisServer("0000002-130521183438837-oozie-rkan-W"));
            TestZKJobsConcurrencyService.assertFalse((boolean)zkjcs.isJobIdForThisServer("0000003-130521183438837-oozie-rkan-W"));
            TestZKJobsConcurrencyService.assertTrue((boolean)zkjcs.isJobIdForThisServer("0000004-130521183438837-oozie-rkan-W"));
            TestZKJobsConcurrencyService.assertFalse((boolean)zkjcs.isJobIdForThisServer("0000005-130521183438837-oozie-rkan-W"));
            TestZKJobsConcurrencyService.assertFalse((boolean)zkjcs.isJobIdForThisServer("0000006-130521183438837-oozie-rkan-W"));
            TestZKJobsConcurrencyService.assertTrue((boolean)zkjcs.isJobIdForThisServer("blah"));
            dummyOozie.teardown();
            TestZKJobsConcurrencyService.assertTrue((boolean)zkjcs.isJobIdForThisServer("0000000-130521183438837-oozie-rkan-W"));
            TestZKJobsConcurrencyService.assertFalse((boolean)zkjcs.isJobIdForThisServer("0000001-130521183438837-oozie-rkan-W"));
            TestZKJobsConcurrencyService.assertTrue((boolean)zkjcs.isJobIdForThisServer("0000002-130521183438837-oozie-rkan-W"));
            TestZKJobsConcurrencyService.assertFalse((boolean)zkjcs.isJobIdForThisServer("0000003-130521183438837-oozie-rkan-W"));
            TestZKJobsConcurrencyService.assertTrue((boolean)zkjcs.isJobIdForThisServer("0000004-130521183438837-oozie-rkan-W"));
            TestZKJobsConcurrencyService.assertFalse((boolean)zkjcs.isJobIdForThisServer("0000005-130521183438837-oozie-rkan-W"));
            TestZKJobsConcurrencyService.assertTrue((boolean)zkjcs.isJobIdForThisServer("0000006-130521183438837-oozie-rkan-W"));
            TestZKJobsConcurrencyService.assertTrue((boolean)zkjcs.isJobIdForThisServer("blah"));
            dummyOozie2.teardown();
            TestZKJobsConcurrencyService.assertTrue((boolean)zkjcs.isJobIdForThisServer("0000000-130521183438837-oozie-rkan-W"));
            TestZKJobsConcurrencyService.assertTrue((boolean)zkjcs.isJobIdForThisServer("0000001-130521183438837-oozie-rkan-W"));
            TestZKJobsConcurrencyService.assertTrue((boolean)zkjcs.isJobIdForThisServer("0000002-130521183438837-oozie-rkan-W"));
            TestZKJobsConcurrencyService.assertTrue((boolean)zkjcs.isJobIdForThisServer("0000003-130521183438837-oozie-rkan-W"));
            TestZKJobsConcurrencyService.assertTrue((boolean)zkjcs.isJobIdForThisServer("0000004-130521183438837-oozie-rkan-W"));
            TestZKJobsConcurrencyService.assertTrue((boolean)zkjcs.isJobIdForThisServer("0000005-130521183438837-oozie-rkan-W"));
            TestZKJobsConcurrencyService.assertTrue((boolean)zkjcs.isJobIdForThisServer("0000006-130521183438837-oozie-rkan-W"));
            TestZKJobsConcurrencyService.assertTrue((boolean)zkjcs.isJobIdForThisServer("blah"));
        }
        finally {
            zkjcs.destroy();
            if (dummyOozie != null) {
                dummyOozie.teardown();
            }
            if (dummyOozie2 != null) {
                dummyOozie2.teardown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetJobIdsForThisServer() throws Exception {
        ZKJobsConcurrencyService zkjcs = new ZKJobsConcurrencyService();
        ZKXTestCase.DummyZKOozie dummyOozie = null;
        ZKXTestCase.DummyZKOozie dummyOozie2 = null;
        try {
            ArrayList<String> ids = new ArrayList<String>();
            ids.add("0000000-130521183438837-oozie-rkan-W");
            ids.add("0000001-130521183438837-oozie-rkan-W");
            ids.add("0000002-130521183438837-oozie-rkan-W");
            ids.add("0000003-130521183438837-oozie-rkan-W");
            ids.add("0000004-130521183438837-oozie-rkan-W");
            ids.add("0000005-130521183438837-oozie-rkan-W");
            ids.add("0000006-130521183438837-oozie-rkan-W");
            ids.add("blah");
            dummyOozie = new ZKXTestCase.DummyZKOozie("a", "http://blah");
            zkjcs.init(Services.get());
            List ids2 = zkjcs.getJobIdsForThisServer(ids);
            ArrayList<String> ids3 = new ArrayList<String>();
            ids3.add("0000001-130521183438837-oozie-rkan-W");
            ids3.add("0000003-130521183438837-oozie-rkan-W");
            ids3.add("0000005-130521183438837-oozie-rkan-W");
            ids3.add("blah");
            TestZKJobsConcurrencyService.assertEquals((int)4, (int)ids2.size());
            TestZKJobsConcurrencyService.assertTrue((boolean)ids2.containsAll(ids3));
            dummyOozie2 = new ZKXTestCase.DummyZKOozie("b", "http://blah");
            ids2 = zkjcs.getJobIdsForThisServer(ids);
            ids3 = new ArrayList();
            ids3.add("0000001-130521183438837-oozie-rkan-W");
            ids3.add("0000004-130521183438837-oozie-rkan-W");
            ids3.add("blah");
            TestZKJobsConcurrencyService.assertEquals((int)3, (int)ids2.size());
            TestZKJobsConcurrencyService.assertTrue((boolean)ids2.containsAll(ids3));
            dummyOozie.teardown();
            ids2 = zkjcs.getJobIdsForThisServer(ids);
            ids3 = new ArrayList();
            ids3.add("0000000-130521183438837-oozie-rkan-W");
            ids3.add("0000002-130521183438837-oozie-rkan-W");
            ids3.add("0000004-130521183438837-oozie-rkan-W");
            ids3.add("0000006-130521183438837-oozie-rkan-W");
            ids3.add("blah");
            TestZKJobsConcurrencyService.assertEquals((int)5, (int)ids2.size());
            TestZKJobsConcurrencyService.assertTrue((boolean)ids2.containsAll(ids3));
            dummyOozie2.teardown();
            ids2 = zkjcs.getJobIdsForThisServer(ids);
            TestZKJobsConcurrencyService.assertEquals((int)8, (int)ids2.size());
            TestZKJobsConcurrencyService.assertTrue((boolean)ids2.containsAll(ids));
        }
        finally {
            zkjcs.destroy();
            if (dummyOozie != null) {
                dummyOozie.teardown();
            }
            if (dummyOozie2 != null) {
                dummyOozie2.teardown();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetServerUrls() throws Exception {
        ZKJobsConcurrencyService zkjcs = new ZKJobsConcurrencyService();
        ZKXTestCase.DummyZKOozie dummyOozie = null;
        ZKXTestCase.DummyZKOozie dummyOozie2 = null;
        try {
            zkjcs.init(Services.get());
            Map map = zkjcs.getServerUrls();
            TestZKJobsConcurrencyService.assertEquals((int)1, (int)map.size());
            TestZKJobsConcurrencyService.assertEquals((String)"1234", (String)((String)map.keySet().iterator().next()));
            TestZKJobsConcurrencyService.assertEquals((String)ConfigUtils.getOozieURL((boolean)false), (String)((String)map.get("1234")));
            dummyOozie = new ZKXTestCase.DummyZKOozie("0000", "http://blah1");
            map = zkjcs.getServerUrls();
            TestZKJobsConcurrencyService.assertEquals((int)2, (int)map.size());
            TestZKJobsConcurrencyService.assertEquals((String)"1234", (String)((String)map.keySet().iterator().next()));
            TestZKJobsConcurrencyService.assertEquals((String)ConfigUtils.getOozieURL((boolean)false), (String)((String)map.get("1234")));
            TestZKJobsConcurrencyService.assertEquals((String)"1234", (String)((String)map.keySet().iterator().next()));
            TestZKJobsConcurrencyService.assertEquals((String)"http://blah1", (String)((String)map.get("0000")));
            dummyOozie2 = new ZKXTestCase.DummyZKOozie("z", "http://blah2");
            map = zkjcs.getServerUrls();
            TestZKJobsConcurrencyService.assertEquals((int)3, (int)map.size());
            TestZKJobsConcurrencyService.assertEquals((String)"1234", (String)((String)map.keySet().iterator().next()));
            TestZKJobsConcurrencyService.assertEquals((String)ConfigUtils.getOozieURL((boolean)false), (String)((String)map.get("1234")));
            TestZKJobsConcurrencyService.assertEquals((String)"1234", (String)((String)map.keySet().iterator().next()));
            TestZKJobsConcurrencyService.assertEquals((String)"http://blah1", (String)((String)map.get("0000")));
            TestZKJobsConcurrencyService.assertEquals((String)"1234", (String)((String)map.keySet().iterator().next()));
            TestZKJobsConcurrencyService.assertEquals((String)"http://blah2", (String)((String)map.get("z")));
            dummyOozie.teardown();
            map = zkjcs.getServerUrls();
            TestZKJobsConcurrencyService.assertEquals((int)2, (int)map.size());
            TestZKJobsConcurrencyService.assertEquals((String)"1234", (String)((String)map.keySet().iterator().next()));
            TestZKJobsConcurrencyService.assertEquals((String)ConfigUtils.getOozieURL((boolean)false), (String)((String)map.get("1234")));
            TestZKJobsConcurrencyService.assertEquals((String)"1234", (String)((String)map.keySet().iterator().next()));
            TestZKJobsConcurrencyService.assertEquals((String)"http://blah2", (String)((String)map.get("z")));
            dummyOozie2.teardown();
            map = zkjcs.getServerUrls();
            TestZKJobsConcurrencyService.assertEquals((int)1, (int)map.size());
            TestZKJobsConcurrencyService.assertEquals((String)"1234", (String)((String)map.keySet().iterator().next()));
            TestZKJobsConcurrencyService.assertEquals((String)ConfigUtils.getOozieURL((boolean)false), (String)((String)map.get("1234")));
        }
        finally {
            zkjcs.destroy();
            if (dummyOozie != null) {
                dummyOozie.teardown();
            }
            if (dummyOozie2 != null) {
                dummyOozie2.teardown();
            }
        }
    }

    public void testisAllServerRequest() throws Exception {
        ZKJobsConcurrencyService zkjcs = new ZKJobsConcurrencyService();
        try {
            zkjcs.init(Services.get());
            TestZKJobsConcurrencyService.assertTrue((boolean)zkjcs.isAllServerRequest(null));
            HashMap<String, String[]> param = new HashMap<String, String[]>();
            TestZKJobsConcurrencyService.assertTrue((boolean)zkjcs.isAllServerRequest(param));
            param.put("allservers", new String[]{"test"});
            TestZKJobsConcurrencyService.assertTrue((boolean)zkjcs.isAllServerRequest(param));
            param.put("allservers", new String[]{"true"});
            TestZKJobsConcurrencyService.assertTrue((boolean)zkjcs.isAllServerRequest(param));
            param.put("allservers", new String[]{"false"});
            TestZKJobsConcurrencyService.assertFalse((boolean)zkjcs.isAllServerRequest(param));
        }
        finally {
            zkjcs.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testInstrumentation() throws Exception {
        ZKJobsConcurrencyService zkjcs = new ZKJobsConcurrencyService();
        ZKXTestCase.DummyZKOozie dummyOozie = null;
        ZKXTestCase.DummyZKOozie dummyOozie2 = null;
        Instrumentation instr = new Instrumentation();
        try {
            zkjcs.init(Services.get());
            zkjcs.instrument(instr);
            String servers = "1234=" + ConfigUtils.getOozieURL((boolean)false);
            TestZKJobsConcurrencyService.assertEquals((Object)servers, (Object)((Instrumentation.Element)((Map)instr.getVariables().get("oozie")).get("servers")).getValue());
            dummyOozie = new ZKXTestCase.DummyZKOozie("0000", "http://blah1");
            servers = "1234=" + ConfigUtils.getOozieURL((boolean)false) + ",0000=http://blah1";
            TestZKJobsConcurrencyService.assertEquals((Object)servers, (Object)((Instrumentation.Element)((Map)instr.getVariables().get("oozie")).get("servers")).getValue());
            dummyOozie2 = new ZKXTestCase.DummyZKOozie("z", "http://blah2");
            servers = "1234=" + ConfigUtils.getOozieURL((boolean)false) + ",0000=http://blah1,z=http://blah2";
            TestZKJobsConcurrencyService.assertEquals((Object)servers, (Object)((Instrumentation.Element)((Map)instr.getVariables().get("oozie")).get("servers")).getValue());
            dummyOozie.teardown();
            servers = "1234=" + ConfigUtils.getOozieURL((boolean)false) + ",z=http://blah2";
            TestZKJobsConcurrencyService.assertEquals((Object)servers, (Object)((Instrumentation.Element)((Map)instr.getVariables().get("oozie")).get("servers")).getValue());
            dummyOozie2.teardown();
            servers = "1234=" + ConfigUtils.getOozieURL((boolean)false);
            TestZKJobsConcurrencyService.assertEquals((Object)servers, (Object)((Instrumentation.Element)((Map)instr.getVariables().get("oozie")).get("servers")).getValue());
        }
        finally {
            zkjcs.destroy();
            if (dummyOozie != null) {
                dummyOozie.teardown();
            }
            if (dummyOozie2 != null) {
                dummyOozie2.teardown();
            }
        }
    }
}

