/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.util.UUID;
import java.util.concurrent.TimeUnit;
import junit.framework.TestCase;
import org.apache.curator.framework.recipes.locks.InterProcessMutex;
import org.apache.curator.framework.recipes.locks.InterProcessReadWriteLock;
import org.apache.oozie.lock.LockToken;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.ServiceException;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.ZKLocksService;
import org.apache.oozie.test.XTestCase;
import org.apache.oozie.test.ZKXTestCase;
import org.apache.oozie.util.XLog;
import org.apache.oozie.util.ZKUtils;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.data.Stat;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class TestZKLocksService
extends ZKXTestCase {
    private XLog log = XLog.getLog(((Object)((Object)this)).getClass());

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRegisterUnregister() throws Exception {
        TestZKLocksService.assertEquals((int)0, (int)ZKUtils.getUsers().size());
        ZKLocksService zkls = new ZKLocksService();
        try {
            zkls.init(Services.get());
            TestZKLocksService.assertEquals((int)1, (int)ZKUtils.getUsers().size());
            TestZKLocksService.assertEquals((Object)zkls, ZKUtils.getUsers().iterator().next());
            zkls.destroy();
            TestZKLocksService.assertEquals((int)0, (int)ZKUtils.getUsers().size());
        }
        finally {
            zkls.destroy();
        }
    }

    public void testWaitWriteLockThreads() throws Exception {
        ZKLocksService zkls = new ZKLocksService();
        try {
            zkls.init(Services.get());
            this.checkWaitWriteLock(zkls, zkls);
        }
        finally {
            zkls.destroy();
        }
    }

    public void testWaitWriteLockOozies() throws Exception {
        ZKLocksService zkls1 = new ZKLocksService();
        ZKLocksService zkls2 = new ZKLocksService();
        try {
            zkls1.init(Services.get());
            zkls2.init(Services.get());
            this.checkWaitWriteLock(zkls1, zkls2);
        }
        finally {
            zkls1.destroy();
            zkls2.destroy();
        }
    }

    public void checkWaitWriteLock(ZKLocksService zkls1, ZKLocksService zkls2) throws Exception {
        StringBuffer sb = new StringBuffer("");
        WriteLocker l1 = new WriteLocker("a", 1, -1L, sb, zkls1);
        WriteLocker l2 = new WriteLocker("a", 2, -1L, sb, zkls2);
        new Thread(l1).start();
        this.sleep(1000);
        new Thread(l2).start();
        this.sleep(1000);
        l1.finish();
        this.sleep(1000);
        l2.finish();
        this.sleep(1000);
        TestZKLocksService.assertEquals((String)"a:1-L a:1-U a:2-L a:2-U", (String)sb.toString().trim());
    }

    public void testNoWaitWriteLockThreads() throws Exception {
        ZKLocksService zkls = new ZKLocksService();
        try {
            zkls.init(Services.get());
            this.checkNoWaitWriteLock(zkls, zkls);
        }
        finally {
            zkls.destroy();
        }
    }

    public void testNoWaitWriteLockOozies() throws Exception {
        ZKLocksService zkls1 = new ZKLocksService();
        ZKLocksService zkls2 = new ZKLocksService();
        try {
            zkls1.init(Services.get());
            zkls2.init(Services.get());
            this.checkNoWaitWriteLock(zkls1, zkls2);
        }
        finally {
            zkls1.destroy();
            zkls2.destroy();
        }
    }

    public void checkNoWaitWriteLock(ZKLocksService zkls1, ZKLocksService zkls2) throws Exception {
        StringBuffer sb = new StringBuffer("");
        WriteLocker l1 = new WriteLocker("a", 1, 0L, sb, zkls1);
        WriteLocker l2 = new WriteLocker("a", 2, 0L, sb, zkls2);
        new Thread(l1).start();
        this.sleep(1000);
        new Thread(l2).start();
        this.sleep(1000);
        l1.finish();
        this.sleep(1000);
        l2.finish();
        this.sleep(1000);
        TestZKLocksService.assertEquals((String)"a:1-L a:2-N a:1-U", (String)sb.toString().trim());
    }

    public void testTimeoutWaitingWriteLockThreads() throws Exception {
        ZKLocksService zkls = new ZKLocksService();
        try {
            zkls.init(Services.get());
            this.checkTimeoutWaitingWriteLock(zkls, zkls);
        }
        finally {
            zkls.destroy();
        }
    }

    public void testTimeoutWaitingWriteLockOozies() throws Exception {
        ZKLocksService zkls1 = new ZKLocksService();
        ZKLocksService zkls2 = new ZKLocksService();
        try {
            zkls1.init(Services.get());
            zkls2.init(Services.get());
            this.checkTimeoutWaitingWriteLock(zkls1, zkls2);
        }
        finally {
            zkls1.destroy();
            zkls2.destroy();
        }
    }

    public void checkTimeoutWaitingWriteLock(ZKLocksService zkls1, ZKLocksService zkls2) throws Exception {
        StringBuffer sb = new StringBuffer("");
        WriteLocker l1 = new WriteLocker("a", 1, 0L, sb, zkls1);
        WriteLocker l2 = new WriteLocker("a", 2, (long)(WAITFOR_RATIO * 2000.0f), sb, zkls2);
        new Thread(l1).start();
        this.sleep(1000);
        new Thread(l2).start();
        this.sleep(1000);
        l1.finish();
        this.sleep(1000);
        l2.finish();
        this.sleep(1000);
        TestZKLocksService.assertEquals((String)"a:1-L a:1-U a:2-L a:2-U", (String)sb.toString().trim());
    }

    public void testTimeoutTimingOutWriteLockThreads() throws Exception {
        ZKLocksService zkls = new ZKLocksService();
        try {
            zkls.init(Services.get());
            this.checkTimeoutTimingOutWriteLock(zkls, zkls);
        }
        finally {
            zkls.destroy();
        }
    }

    public void testTimeoutTimingOutWriteLockOozies() throws Exception {
        ZKLocksService zkls1 = new ZKLocksService();
        ZKLocksService zkls2 = new ZKLocksService();
        try {
            zkls1.init(Services.get());
            zkls2.init(Services.get());
            this.checkTimeoutTimingOutWriteLock(zkls1, zkls2);
        }
        finally {
            zkls1.destroy();
            zkls2.destroy();
        }
    }

    public void checkTimeoutTimingOutWriteLock(ZKLocksService zkls1, ZKLocksService zkls2) throws Exception {
        StringBuffer sb = new StringBuffer("");
        WriteLocker l1 = new WriteLocker("a", 1, 0L, sb, zkls1);
        WriteLocker l2 = new WriteLocker("a", 2, 50L, sb, zkls2);
        new Thread(l1).start();
        this.sleep(1000);
        new Thread(l2).start();
        this.sleep(1000);
        l1.finish();
        this.sleep(1000);
        l2.finish();
        this.sleep(1000);
        TestZKLocksService.assertEquals((String)"a:1-L a:2-N a:1-U", (String)sb.toString().trim());
    }

    public void testReadLockThreads() throws Exception {
        ZKLocksService zkls = new ZKLocksService();
        try {
            zkls.init(Services.get());
            this.checkReadLock(zkls, zkls);
        }
        finally {
            zkls.destroy();
        }
    }

    public void testReadLockOozies() throws Exception {
        ZKLocksService zkls1 = new ZKLocksService();
        ZKLocksService zkls2 = new ZKLocksService();
        try {
            zkls1.init(Services.get());
            zkls2.init(Services.get());
            this.checkReadLock(zkls1, zkls2);
        }
        finally {
            zkls1.destroy();
            zkls2.destroy();
        }
    }

    public void checkReadLock(ZKLocksService zkls1, ZKLocksService zkls2) throws Exception {
        StringBuffer sb = new StringBuffer("");
        ReadLocker l1 = new ReadLocker("a", 1, -1L, sb, zkls1);
        ReadLocker l2 = new ReadLocker("a", 2, -1L, sb, zkls2);
        new Thread(l1).start();
        this.sleep(1000);
        new Thread(l2).start();
        this.sleep(1000);
        l1.finish();
        this.sleep(1000);
        l2.finish();
        this.sleep(1000);
        TestZKLocksService.assertEquals((String)"a:1-L a:2-L a:1-U a:2-U", (String)sb.toString().trim());
    }

    public void testReadWriteLockThreads() throws Exception {
        ZKLocksService zkls = new ZKLocksService();
        try {
            zkls.init(Services.get());
            this.checkReadWriteLock(zkls, zkls);
        }
        finally {
            zkls.destroy();
        }
    }

    public void testReadWriteLockOozies() throws Exception {
        ZKLocksService zkls1 = new ZKLocksService();
        ZKLocksService zkls2 = new ZKLocksService();
        try {
            zkls1.init(Services.get());
            zkls2.init(Services.get());
            this.checkReadWriteLock(zkls1, zkls2);
        }
        finally {
            zkls1.destroy();
            zkls2.destroy();
        }
    }

    public void checkReadWriteLock(ZKLocksService zkls1, ZKLocksService zkls2) throws Exception {
        StringBuffer sb = new StringBuffer("");
        ReadLocker l1 = new ReadLocker("a", 1, -1L, sb, zkls1);
        WriteLocker l2 = new WriteLocker("a", 2, -1L, sb, zkls2);
        new Thread(l1).start();
        this.sleep(1000);
        new Thread(l2).start();
        this.sleep(1000);
        l1.finish();
        this.sleep(1000);
        l2.finish();
        this.sleep(1000);
        TestZKLocksService.assertEquals((String)"a:1-L a:1-U a:2-L a:2-U", (String)sb.toString().trim());
    }

    public void testWriteReadLockThreads() throws Exception {
        ZKLocksService zkls = new ZKLocksService();
        try {
            zkls.init(Services.get());
            this.checkWriteReadLock(zkls, zkls);
        }
        finally {
            zkls.destroy();
        }
    }

    public void testWriteReadLockOozies() throws Exception {
        ZKLocksService zkls1 = new ZKLocksService();
        ZKLocksService zkls2 = new ZKLocksService();
        try {
            zkls1.init(Services.get());
            zkls2.init(Services.get());
            this.checkWriteReadLock(zkls1, zkls2);
        }
        finally {
            zkls1.destroy();
            zkls2.destroy();
        }
    }

    public void checkWriteReadLock(ZKLocksService zkls1, ZKLocksService zkls2) throws Exception {
        StringBuffer sb = new StringBuffer("");
        WriteLocker l1 = new WriteLocker("a", 1, -1L, sb, zkls1);
        ReadLocker l2 = new ReadLocker("a", 2, -1L, sb, zkls2);
        new Thread(l1).start();
        this.sleep(1000);
        new Thread(l2).start();
        this.sleep(1000);
        l1.finish();
        this.sleep(1000);
        l2.finish();
        this.sleep(1000);
        TestZKLocksService.assertEquals((String)"a:1-L a:1-U a:2-L a:2-U", (String)sb.toString().trim());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLockRelease() throws ServiceException, InterruptedException {
        String path = UUID.randomUUID().toString();
        ZKLocksService zkls = new ZKLocksService();
        try {
            zkls.init(Services.get());
            ZKLocksService.ZKLockToken lock = (ZKLocksService.ZKLockToken)zkls.getWriteLock(path, 5000L);
            TestZKLocksService.assertTrue((boolean)zkls.getLocks().containsKey(path));
            lock.release();
            this.checkLockRelease(path, zkls);
        }
        finally {
            zkls.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReentrantMultipleCall() throws ServiceException, InterruptedException {
        String path = UUID.randomUUID().toString();
        ZKLocksService zkls = new ZKLocksService();
        try {
            zkls.init(Services.get());
            ZKLocksService.ZKLockToken lock = (ZKLocksService.ZKLockToken)zkls.getWriteLock(path, 5000L);
            lock = (ZKLocksService.ZKLockToken)zkls.getWriteLock(path, 5000L);
            lock = (ZKLocksService.ZKLockToken)zkls.getWriteLock(path, 5000L);
            TestZKLocksService.assertTrue((boolean)zkls.getLocks().containsKey(path));
            lock.release();
            TestZKLocksService.assertTrue((boolean)zkls.getLocks().containsKey(path));
            lock.release();
            TestZKLocksService.assertTrue((boolean)zkls.getLocks().containsKey(path));
            lock.release();
            this.checkLockRelease(path, zkls);
        }
        catch (Exception e) {
            TestZKLocksService.fail((String)"Reentrant property, it should have acquired lock");
        }
        finally {
            zkls.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testReentrantMultipleThread() throws ServiceException, InterruptedException {
        String path = UUID.randomUUID().toString();
        ZKLocksService zkls = new ZKLocksService();
        zkls.init(Services.get());
        try {
            ThreadLock t1 = new ThreadLock(zkls, path);
            ThreadLock t2 = new ThreadLock(zkls, path);
            t1.start();
            t1.join();
            this.checkLockRelease(path, zkls);
            t2.start();
            t2.join();
            this.checkLockRelease(path, zkls);
        }
        finally {
            zkls.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLockReaper() throws Exception {
        ConfigurationService.set((String)"oozie.service.ZKLocksService.locks.reaper.threshold", (String)"1");
        ZKLocksService zkls = new ZKLocksService();
        try {
            zkls.init(Services.get());
            for (int i = 0; i < 10; ++i) {
                LockToken l = zkls.getReadLock(String.valueOf(i), 1L);
                l.release();
            }
            this.waitFor(10000, new XTestCase.Predicate(){

                @Override
                public boolean evaluate() throws Exception {
                    Stat stat = (Stat)TestZKLocksService.this.getClient().checkExists().forPath("/locks");
                    return stat.getNumChildren() == 0;
                }
            });
            Stat stat = (Stat)this.getClient().checkExists().forPath("/locks");
            TestZKLocksService.assertEquals((int)0, (int)stat.getNumChildren());
        }
        finally {
            zkls.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLocksAreGarbageCollected() throws ServiceException, InterruptedException {
        String path = new String("a");
        String path1 = new String("a");
        ZKLocksService lockService = new ZKLocksService();
        try {
            lockService.init(Services.get());
            LockToken lock = lockService.getWriteLock(path, 5000L);
            lock.release();
            TestZKLocksService.assertEquals((int)lockService.getLocks().size(), (int)1);
            int oldHash = ((InterProcessReadWriteLock)lockService.getLocks().get(path)).hashCode();
            lock = lockService.getWriteLock(path1, 5000L);
            int newHash = ((InterProcessReadWriteLock)lockService.getLocks().get(path1)).hashCode();
            TestZKLocksService.assertTrue((oldHash == newHash ? 1 : 0) != 0);
            lock = null;
            System.gc();
            lock = lockService.getWriteLock(path, 5000L);
            newHash = ((InterProcessReadWriteLock)lockService.getLocks().get(path)).hashCode();
            TestZKLocksService.assertFalse((oldHash == newHash ? 1 : 0) != 0);
        }
        finally {
            lockService.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testLocksAreReused() throws ServiceException, InterruptedException {
        String path = "a";
        ZKLocksService lockService = new ZKLocksService();
        try {
            lockService.init(Services.get());
            LockToken lock = lockService.getWriteLock(path, 5000L);
            int oldHash = System.identityHashCode(lockService.getLocks().get(path));
            System.gc();
            lock.release();
            lock = lockService.getWriteLock(path, 5000L);
            TestZKLocksService.assertEquals((int)lockService.getLocks().size(), (int)1);
            int newHash = System.identityHashCode(lockService.getLocks().get(path));
            TestZKLocksService.assertTrue((oldHash == newHash ? 1 : 0) != 0);
        }
        finally {
            lockService.destroy();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testRetriableRelease() throws Exception {
        String path = UUID.randomUUID().toString();
        ZKLocksService zkls = new ZKLocksService();
        try {
            zkls.init(Services.get());
            InterProcessReadWriteLock lockEntry = (InterProcessReadWriteLock)Mockito.mock(InterProcessReadWriteLock.class);
            final InterProcessMutex writeLock = (InterProcessMutex)Mockito.mock(InterProcessMutex.class);
            Mockito.when((Object)lockEntry.writeLock()).thenReturn((Object)writeLock);
            ((InterProcessMutex)Mockito.doThrow((Throwable)new KeeperException.ConnectionLossException()).when((Object)writeLock)).release();
            ((InterProcessMutex)Mockito.doNothing().when((Object)writeLock)).acquire();
            zkls.getLocks().putIfAbsent(path, lockEntry);
            LockToken lock = zkls.getWriteLock(path, -1L);
            final boolean[] lockReleased = new boolean[]{false};
            Runnable exceptionStopper = new Runnable(){

                @Override
                public void run() {
                    try {
                        Thread.sleep(TimeUnit.SECONDS.toMillis(13L));
                        ((InterProcessMutex)Mockito.doAnswer((Answer)new Answer(){

                            public Object answer(InvocationOnMock invocation) throws Throwable {
                                lockReleased[0] = true;
                                return null;
                            }
                        }).when((Object)writeLock)).release();
                    }
                    catch (Exception e) {
                        TestZKLocksService.this.log.error((Object)e);
                        TestCase.fail((String)("Test case failed due to " + e.getMessage()));
                    }
                }
            };
            new Thread(exceptionStopper).start();
            lock.release();
            TestZKLocksService.assertEquals((String)"Failing the test case. The lock should have been released", (boolean)true, (boolean)lockReleased[0]);
        }
        finally {
            zkls.destroy();
        }
    }

    private void checkLockRelease(String path, ZKLocksService zkls) {
        if (zkls.getLocks().get(path) != null) {
            TestZKLocksService.assertFalse((boolean)((InterProcessReadWriteLock)zkls.getLocks().get(path)).writeLock().isAcquiredInThisProcess());
        }
    }

    static class ThreadLock
    extends Thread {
        ZKLocksService zkls;
        String path;
        LockToken lock = null;

        public ThreadLock(ZKLocksService zkls, String path) {
            this.zkls = zkls;
            this.path = path;
        }

        @Override
        public void run() {
            try {
                this.lock = this.zkls.getWriteLock(this.path, 5000L);
                if (this.lock != null) {
                    this.lock = this.zkls.getWriteLock(this.path, 5000L);
                    Thread.sleep(1000L);
                    this.lock.release();
                    Thread.sleep(1000L);
                    this.lock.release();
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public class WriteLocker
    extends Locker {
        public WriteLocker(String name, int nameIndex, long timeout, StringBuffer buffer, ZKLocksService zkls) {
            super(name, nameIndex, timeout, buffer, zkls);
        }

        @Override
        protected ZKLocksService.ZKLockToken getLock() throws InterruptedException {
            return (ZKLocksService.ZKLockToken)this.zkls.getWriteLock(this.name, this.timeout);
        }
    }

    public class ReadLocker
    extends Locker {
        public ReadLocker(String name, int nameIndex, long timeout, StringBuffer buffer, ZKLocksService zkls) {
            super(name, nameIndex, timeout, buffer, zkls);
        }

        @Override
        protected ZKLocksService.ZKLockToken getLock() throws InterruptedException {
            return (ZKLocksService.ZKLockToken)this.zkls.getReadLock(this.name, this.timeout);
        }
    }

    public abstract class Locker
    implements Runnable {
        protected String name;
        private String nameIndex;
        private StringBuffer sb;
        protected long timeout;
        protected ZKLocksService zkls;

        public Locker(String name, int nameIndex, long timeout, StringBuffer buffer, ZKLocksService zkls) {
            this.name = name;
            this.nameIndex = name + ":" + nameIndex;
            this.sb = buffer;
            this.timeout = timeout;
            this.zkls = zkls;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            block6: {
                try {
                    TestZKLocksService.this.log.info("Getting lock [{0}]", new Object[]{this.nameIndex});
                    ZKLocksService.ZKLockToken token = this.getLock();
                    if (token != null) {
                        TestZKLocksService.this.log.info("Got lock [{0}]", new Object[]{this.nameIndex});
                        this.sb.append(this.nameIndex).append("-L ");
                        Locker locker = this;
                        synchronized (locker) {
                            this.wait();
                        }
                        this.sb.append(this.nameIndex).append("-U ");
                        token.release();
                        TestZKLocksService.this.log.info("Release lock [{0}]", new Object[]{this.nameIndex});
                        break block6;
                    }
                    this.sb.append(this.nameIndex).append("-N ");
                    TestZKLocksService.this.log.info("Did not get lock [{0}]", new Object[]{this.nameIndex});
                }
                catch (Exception ex) {
                    throw new RuntimeException(ex);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finish() {
            Locker locker = this;
            synchronized (locker) {
                this.notify();
            }
        }

        protected abstract ZKLocksService.ZKLockToken getLock() throws InterruptedException;
    }
}

