/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.service;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.LogFactory;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.service.DummyLogStreamingServlet;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.XLogService;
import org.apache.oozie.service.ZKJobsConcurrencyService;
import org.apache.oozie.service.ZKXLogStreamingService;
import org.apache.oozie.test.EmbeddedServletContainer;
import org.apache.oozie.test.ZKXTestCase;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.XLogErrorStreamer;
import org.apache.oozie.util.XLogFilter;
import org.apache.oozie.util.XLogStreamer;
import org.apache.oozie.util.ZKUtils;

public class TestZKXLogStreamingService
extends ZKXTestCase {
    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public void testRegisterUnregister() throws Exception {
        TestZKXLogStreamingService.assertEquals((int)0, (int)ZKUtils.getUsers().size());
        ZKXLogStreamingService zkxlss = new ZKXLogStreamingService();
        try {
            zkxlss.init(Services.get());
            TestZKXLogStreamingService.assertEquals((int)1, (int)ZKUtils.getUsers().size());
            TestZKXLogStreamingService.assertEquals((Object)zkxlss, ZKUtils.getUsers().iterator().next());
            zkxlss.destroy();
            TestZKXLogStreamingService.assertEquals((int)0, (int)ZKUtils.getUsers().size());
        }
        finally {
            zkxlss.destroy();
        }
    }

    public void testDisableLogOverWS() throws Exception {
        Properties props = new Properties();
        props.setProperty("log4j.appender.oozie.File", "");
        File propsFile = new File(this.getTestCaseConfDir(), "test-disable-log-over-ws-log4j.properties");
        FileOutputStream fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        this.setSystemProperty("oozie.log4j.file", propsFile.getName());
        TestZKXLogStreamingService.assertTrue((boolean)this.doStreamDisabledCheck());
        props.setProperty("log4j.appender.oozie.File", "oozie.log");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestZKXLogStreamingService.assertTrue((boolean)this.doStreamDisabledCheck());
        props.setProperty("log4j.appender.oozie.File", "${oozie.log.dir}/oozie.log");
        props.setProperty("log4j.appender.oozie", "");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestZKXLogStreamingService.assertTrue((boolean)this.doStreamDisabledCheck());
        props.setProperty("log4j.appender.oozie", "org.blah.blah");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestZKXLogStreamingService.assertTrue((boolean)this.doStreamDisabledCheck());
        props.setProperty("log4j.appender.oozie", "org.apache.log4j.DailyRollingFileAppender");
        props.setProperty("log4j.appender.oozie.DatePattern", "");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestZKXLogStreamingService.assertTrue((boolean)this.doStreamDisabledCheck());
        props.setProperty("log4j.appender.oozie.DatePattern", "'.'yyyy-MM");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestZKXLogStreamingService.assertTrue((boolean)this.doStreamDisabledCheck());
        props.setProperty("log4j.appender.oozie.DatePattern", "'.'yyyy-MM-dd");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestZKXLogStreamingService.assertFalse((boolean)this.doStreamDisabledCheck());
        props.setProperty("log4j.appender.oozie.DatePattern", "'.'yyyy-MM-dd-HH");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestZKXLogStreamingService.assertFalse((boolean)this.doStreamDisabledCheck());
        props.setProperty("log4j.appender.oozie", "org.apache.log4j.rolling.RollingFileAppender");
        props.setProperty("log4j.appender.oozie.RollingPolicy.FileNamePattern", "");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestZKXLogStreamingService.assertTrue((boolean)this.doStreamDisabledCheck());
        props.setProperty("log4j.appender.oozie.RollingPolicy.FileNamePattern", "${oozie.log.dir}/oozie.log-blah");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestZKXLogStreamingService.assertTrue((boolean)this.doStreamDisabledCheck());
        props.setProperty("log4j.appender.oozie.RollingPolicy.FileNamePattern", "${oozie.log.dir}/blah.log-%d{yyyy-MM-dd-HH}");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestZKXLogStreamingService.assertTrue((boolean)this.doStreamDisabledCheck());
        props.setProperty("log4j.appender.oozie.RollingPolicy.FileNamePattern", "${oozie.log.dir}/oozie.log-%d{yyyy-MM-dd-HH}");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestZKXLogStreamingService.assertFalse((boolean)this.doStreamDisabledCheck());
        props.setProperty("log4j.appender.oozie.RollingPolicy.FileNamePattern", "${oozie.log.dir}/oozie.log-%d{yyyy-MM-dd-HH}.gz");
        fos = new FileOutputStream(propsFile);
        props.store(fos, "");
        TestZKXLogStreamingService.assertFalse((boolean)this.doStreamDisabledCheck());
    }

    public void testNoDashInConversionPattern() throws Exception {
        XLogFilter.reset();
        XLogFilter.defineParameter((String)"USER");
        XLogFilter.defineParameter((String)"GROUP");
        XLogFilter.defineParameter((String)"TOKEN");
        XLogFilter.defineParameter((String)"APP");
        XLogFilter.defineParameter((String)"JOB");
        XLogFilter.defineParameter((String)"ACTION");
        XLogFilter xf = new XLogFilter();
        xf.setParameter("USER", "oozie");
        xf.setLogLevel("DEBUG|INFO");
        File log4jFile = new File(this.getTestCaseConfDir(), "test-log4j.properties");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream("test-no-dash-log4j.properties");
        Properties log4jProps = new Properties();
        log4jProps.load(is);
        log4jProps.setProperty("log4j.appender.oozie.File", this.getTestCaseDir() + "/oozie.log");
        log4jProps.store(new FileOutputStream(log4jFile), "");
        this.setSystemProperty("oozie.log4j.file", log4jFile.getName());
        TestZKXLogStreamingService.assertFalse((boolean)this.doStreamDisabledCheck());
        LogFactory.getLog((String)"a").info((Object)"2009-06-24 02:43:14,505 INFO _L1_:317 - SERVER[foo] USER[oozie] GROUP[oozie] TOKEN[-] APP[-] JOB[-] ACTION[-] Released Lock");
        LogFactory.getLog((String)"a").info((Object)"2009-06-24 02:43:14,505 INFO _L2_:317 - SERVER[foo] USER[blah] GROUP[oozie] TOKEN[-] APP[-] JOB[-] ACTION[-] Released Lock");
        LogFactory.getLog((String)"a").info((Object)"2009-06-24 02:43:14,505 INFO _L3_:317 SERVER[foo] USER[oozie] GROUP[oozie] TOKEN[-] APP[-] JOB[-] ACTION[-] Released Lock");
        LogFactory.getLog((String)"a").info((Object)"2009-06-24 02:43:14,505 INFO _L4_:317 SERVER[foo] USER[blah] GROUP[oozie] TOKEN[-] APP[-] JOB[-] ACTION[-] Released Lock");
        String out = this.doStreamLog(xf);
        String[] outArr = out.split("\n");
        TestZKXLogStreamingService.assertEquals((int)2, (int)outArr.length);
        TestZKXLogStreamingService.assertTrue((boolean)outArr[0].contains("_L1_"));
        TestZKXLogStreamingService.assertFalse((boolean)out.contains("_L2_"));
        TestZKXLogStreamingService.assertTrue((boolean)outArr[1].contains("_L3_"));
        TestZKXLogStreamingService.assertFalse((boolean)out.contains("_L4_"));
    }

    private boolean doStreamDisabledCheck() throws Exception {
        ((XLogService)Services.get().get(XLogService.class)).init(Services.get());
        return this.doStreamLog(new XLogFilter()).equals("Log streaming disabled!!");
    }

    protected String doStreamLog(XLogFilter xf) throws Exception {
        return this.doStreamLog(xf, new HashMap<String, String[]>());
    }

    protected String doStreamLog(XLogFilter xf, Date startTime, Date endTime) throws Exception {
        return this.doStreamLog(xf, new HashMap<String, String[]>(), false, startTime, endTime);
    }

    protected String doStreamErrorLog(XLogFilter xf) throws Exception {
        return this.doStreamLog(xf, new HashMap<String, String[]>(), true);
    }

    private String doStreamErrorLog(XLogFilter xf, Date startDate, Date endDate) throws Exception {
        return this.doStreamLog(xf, new HashMap<String, String[]>(), true, startDate, startDate);
    }

    protected String doStreamLog(XLogFilter xf, Map<String, String[]> param) throws Exception {
        return this.doStreamLog(xf, param, false);
    }

    protected String doStreamLog(XLogFilter xf, Map<String, String[]> param, boolean isErrorLog) throws Exception {
        return this.doStreamLog(xf, param, isErrorLog, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String doStreamLog(XLogFilter xf, Map<String, String[]> param, boolean isErrorLog, Date startTime, Date endTime) throws Exception {
        StringWriter w = new StringWriter();
        ZKXLogStreamingService zkxlss = new ZKXLogStreamingService();
        try {
            Services services = Services.get();
            services.setService(ZKJobsConcurrencyService.class);
            zkxlss.init(services);
            this.sleep(1000);
            if (isErrorLog) {
                zkxlss.streamLog((XLogStreamer)new XLogErrorStreamer(xf, param), startTime, endTime, (Writer)w);
            } else {
                zkxlss.streamLog(new XLogStreamer(xf, param), startTime, endTime, (Writer)w);
            }
        }
        finally {
            zkxlss.destroy();
        }
        String wStr = w.toString();
        System.out.println("\ndoStreamLog:\n" + wStr + "\n");
        return wStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStreamingWithMultipleOozieServers() throws Exception {
        XLogFilter.reset();
        XLogFilter.defineParameter((String)"USER");
        XLogFilter.defineParameter((String)"GROUP");
        XLogFilter.defineParameter((String)"TOKEN");
        XLogFilter.defineParameter((String)"APP");
        XLogFilter.defineParameter((String)"JOB");
        XLogFilter.defineParameter((String)"ACTION");
        XLogFilter xf = new XLogFilter();
        xf.setParameter("JOB", "0000003-130610102426873-oozie-rkan-W");
        xf.setLogLevel("WARN|INFO");
        File log4jFile = new File(this.getTestCaseConfDir(), "test-log4j.properties");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream("test-no-dash-log4j.properties");
        Properties log4jProps = new Properties();
        log4jProps.load(is);
        log4jProps.setProperty("log4j.appender.oozie.File", this.getTestCaseDir() + "/oozie.log");
        log4jProps.store(new FileOutputStream(log4jFile), "");
        this.setSystemProperty("oozie.log4j.file", log4jFile.getName());
        TestZKXLogStreamingService.assertFalse((boolean)this.doStreamDisabledCheck());
        File logFile = new File(((XLogService)Services.get().get(XLogService.class)).getOozieLogPath(), ((XLogService)Services.get().get(XLogService.class)).getOozieLogName());
        logFile.getParentFile().mkdirs();
        FileWriter logWriter = new FileWriter(logFile);
        logWriter.append("2013-06-10 10:25:44,008 WARN HiveActionExecutor:542 SERVER[foo] USER[rkanter] GROUP[-] TOKEN[] APP[hive-wf] JOB[0000003-130610102426873-oozie-rkan-W] ACTION[0000003-130610102426873-oozie-rkan-W@hive-node] credentials is null for the action _L3_").append("\n").append("2013-06-10 10:26:10,008 INFO HiveActionExecutor:539 SERVER[foo] USER[rkanter] GROUP[-] TOKEN[] APP[hive-wf] JOB[0000003-130610102426873-oozie-rkan-W] ACTION[0000003-130610102426873-oozie-rkan-W@hive-node] action completed, external ID [job_201306101021_0005] _L4_").append("\n").append("2013-06-10 10:26:10,341 WARN ActionStartXCommand:542 USER[rkanter] GROUP[-] TOKEN[] APP[hive-wf] JOB[0000003-130610102426873-oozie-rkan-W] ACTION[0000003-130610102426873-oozie-rkan-W@end] [***0000003-130610102426873-oozie-rkan-W@end***]Action updated in DB! _L6_").append("\n");
        logWriter.close();
        DummyLogStreamingServlet.logs = "2013-06-10 10:25:43,575 WARN ActionStartXCommand:542 SERVER[foo] USER[rkanter] GROUP[-] TOKEN[] APP[hive-wf] JOB[0000003-130610102426873-oozie-rkan-W] ACTION[0000003-130610102426873-oozie-rkan-W@:start:] [***0000003-130610102426873-oozie-rkan-W@:start:***]Action status=DONE _L1_\n2013-06-10 10:25:43,575 WARN ActionStartXCommand:542 SERVER[foo] USER[rkanter] GROUP[-] TOKEN[] APP[hive-wf] JOB[0000003-130610102426873-oozie-rkan-W] ACTION[0000003-130610102426873-oozie-rkan-W@:start:] [***0000003-130610102426873-oozie-rkan-W@:start:***]Action updated in DB! _L2_\n2013-06-10 10:26:10,148 INFO HiveActionExecutor:539 SERVER[foo] USER[rkanter] GROUP[-] TOKEN[] APP[hive-wf] JOB[0000003-130610102426873-oozie-rkan-W] ACTION[0000003-130610102426873-oozie-rkan-W@hive-node] action produced output _L5_\n2013-06-10 10:26:30,202  WARN ActionStartXCommand:542 - SERVER[foo] USER[rkanter] GROUP[-] TOKEN[] APP[hive-wf] JOB[0000003-130610102426873-oozie-rkan-W] ACTION[0000003-130610102426873-oozie-rkan-W@hive-node] Error starting action [hive-node]. ErrorType [TRANSIENT], ErrorCode [JA009], Message [JA009: java.io.IOException: Unknown protocol to name node: org.apache.hadoop.mapred.JobSubmissionProtocol _L7_\n     at org.apache.hadoop.hdfs.server.namenode.NameNode.getProtocolVersion(NameNode.java:156) _L8_\n     at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method)_L9_\n     at org.apache.hadoop.security.UserGroupInformation.doAs(UserGroupInformation.java:1190) _L10_\n     at org.apache.hadoop.ipc.Server$Handler.run(Server.java:1426) _L11_\n] _L12_\norg.apache.oozie.action.ActionExecutorException: JA009: java.io.IOException: Unknown protocol to name node: org.apache.hadoop.mapred.JobSubmissionProtocol _L13_\n     at org.apache.hadoop.hdfs.server.namenode.NameNode.getProtocolVersion(NameNode.java:156) _L14_\n     at sun.reflect.NativeMethodAccessorImpl.invoke0(Native Method) _L15_\n     at sun.reflect.NativeMethodAccessorImpl.invoke(NativeMethodAccessorImpl.java:39) _L16_\n";
        String out = this.doStreamLog(xf);
        String[] outArr = out.split("\n");
        TestZKXLogStreamingService.assertEquals((int)3, (int)outArr.length);
        TestZKXLogStreamingService.assertFalse((boolean)out.contains("_L1_"));
        TestZKXLogStreamingService.assertFalse((boolean)out.contains("_L2_"));
        TestZKXLogStreamingService.assertTrue((boolean)outArr[0].contains("_L3_"));
        TestZKXLogStreamingService.assertTrue((boolean)outArr[1].contains("_L4_"));
        TestZKXLogStreamingService.assertFalse((boolean)out.contains("_L5_"));
        TestZKXLogStreamingService.assertTrue((boolean)outArr[2].contains("_L6_"));
        ZKXTestCase.DummyZKOozie dummyOozie = null;
        EmbeddedServletContainer container = new EmbeddedServletContainer("oozie");
        container.addServletEndpoint("/other-oozie-server/*", DummyLogStreamingServlet.class);
        try {
            container.start();
            dummyOozie = new ZKXTestCase.DummyZKOozie(this, "9876", container.getServletURL("/other-oozie-server/*"));
            DummyLogStreamingServlet.lastQueryString = null;
            out = this.doStreamLog(xf);
            outArr = out.split("\n");
            TestZKXLogStreamingService.assertEquals((int)16, (int)outArr.length);
            TestZKXLogStreamingService.assertTrue((boolean)outArr[0].contains("_L1_"));
            TestZKXLogStreamingService.assertTrue((boolean)outArr[1].contains("_L2_"));
            TestZKXLogStreamingService.assertTrue((boolean)outArr[2].contains("_L3_"));
            TestZKXLogStreamingService.assertTrue((boolean)outArr[3].contains("_L4_"));
            TestZKXLogStreamingService.assertTrue((boolean)outArr[4].contains("_L5_"));
            TestZKXLogStreamingService.assertTrue((boolean)outArr[5].contains("_L6_"));
            TestZKXLogStreamingService.assertTrue((boolean)outArr[6].contains("_L7_"));
            TestZKXLogStreamingService.assertTrue((boolean)outArr[7].contains("_L8_"));
            TestZKXLogStreamingService.assertTrue((boolean)outArr[8].contains("_L9_"));
            TestZKXLogStreamingService.assertTrue((boolean)outArr[9].contains("_L10_"));
            TestZKXLogStreamingService.assertTrue((boolean)outArr[10].contains("_L11_"));
            TestZKXLogStreamingService.assertTrue((boolean)outArr[11].contains("_L12_"));
            TestZKXLogStreamingService.assertTrue((boolean)outArr[12].contains("_L13_"));
            TestZKXLogStreamingService.assertTrue((boolean)outArr[13].contains("_L14_"));
            TestZKXLogStreamingService.assertTrue((boolean)outArr[14].contains("_L15_"));
            TestZKXLogStreamingService.assertTrue((boolean)outArr[15].contains("_L16_"));
            TestZKXLogStreamingService.assertEquals((String)"show=log&allservers=false", (String)DummyLogStreamingServlet.lastQueryString);
            container.stop();
            out = this.doStreamLog(xf);
            outArr = out.split("\n");
            TestZKXLogStreamingService.assertEquals((int)6, (int)outArr.length);
            TestZKXLogStreamingService.assertTrue((boolean)outArr[0].startsWith("Unable"));
            TestZKXLogStreamingService.assertEquals((String)"9876", (String)outArr[1].trim());
            TestZKXLogStreamingService.assertEquals((String)"", (String)outArr[2]);
            TestZKXLogStreamingService.assertFalse((boolean)out.contains("_L1_"));
            TestZKXLogStreamingService.assertFalse((boolean)out.contains("_L2_"));
            TestZKXLogStreamingService.assertTrue((boolean)outArr[3].contains("_L3_"));
            TestZKXLogStreamingService.assertTrue((boolean)outArr[4].contains("_L4_"));
            TestZKXLogStreamingService.assertFalse((boolean)out.contains("_L5_"));
            TestZKXLogStreamingService.assertTrue((boolean)outArr[5].contains("_L6_"));
        }
        finally {
            if (dummyOozie != null) {
                dummyOozie.teardown();
            }
            container.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStreamingWithMultipleOozieServers_coordActionList() throws Exception {
        XLogFilter.reset();
        File log4jFile = new File(this.getTestCaseConfDir(), "test-log4j.properties");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream("test-no-dash-log4j.properties");
        Properties log4jProps = new Properties();
        log4jProps.load(is);
        log4jProps.setProperty("log4j.appender.oozie.File", this.getTestCaseDir() + "/oozie.log");
        log4jProps.store(new FileOutputStream(log4jFile), "");
        this.setSystemProperty("oozie.log4j.file", log4jFile.getName());
        ((XLogService)Services.get().get(XLogService.class)).init(Services.get());
        File logFile = new File(((XLogService)Services.get().get(XLogService.class)).getOozieLogPath(), ((XLogService)Services.get().get(XLogService.class)).getOozieLogName());
        logFile.getParentFile().mkdirs();
        FileWriter logWriter = new FileWriter(logFile);
        StringBuffer bf = new StringBuffer();
        bf.append("2014-02-06 00:26:56,126 DEBUG CoordActionInputCheckXCommand:545 [pool-2-thread-26] - USER[-] GROUP[-] TOKEN[-] APP[-] JOB[0000003-140205233038063-oozie-oozi-C] ACTION[0000003-140205233038063-oozie-oozi-C@1] checking for the file ~:8020/user/purushah/examples/input-data/rawLogs/2010/01/01/01/00/_SUCCESS\n").append("2014-02-06 00:26:56,150  INFO CoordActionInputCheckXCommand:539 [pool-2-thread-26] - USER[-] GROUP[-] TOKEN[-] APP[-] JOB[0000003-140205233038063-oozie-oozi-C] ACTION[0000003-140205233038063-oozie-oozi-C@1] [0000003-140205233038063-oozie-oozi-C@1]::ActionInputCheck:: File::8020/user/purushah/examples/input-data/rawLogs/2010/01/01/01/00/_SUCCESS, Exists? :falseAction updated in DB! _L1_").append("\n").append("2014-02-06 00:27:56,126 DEBUG CoordActionInputCheckXCommand:545 [pool-2-thread-26] - USER[-] GROUP[-] TOKEN[-] APP[-] JOB[0000003-140205233038063-oozie-oozi-C] ACTION[0000003-140205233038063-oozie-oozi-C@2] checking for the file ~:8020/user/purushah/examples/input-data/rawLogs/2010/01/01/01/00/_SUCCESS\n").append("2014-02-06 00:27:56,150  INFO CoordActionInputCheckXCommand:539 [pool-2-thread-26] - USER[-] GROUP[-] TOKEN[-] APP[-] JOB[0000003-140205233038063-oozie-oozi-C] ACTION[0000003-140205233038063-oozie-oozi-C@2] [0000003-140205233038063-oozie-oozi-C@2]::ActionInputCheck:: File::8020/user/purushah/examples/input-data/rawLogs/2010/01/01/01/00/_SUCCESS, Exists? :falseAction updated in DB! _L2_").append("\n");
        logWriter.append(bf);
        logWriter.close();
        XLogFilter.reset();
        XLogFilter.defineParameter((String)"USER");
        XLogFilter.defineParameter((String)"GROUP");
        XLogFilter.defineParameter((String)"TOKEN");
        XLogFilter.defineParameter((String)"APP");
        XLogFilter.defineParameter((String)"JOB");
        XLogFilter.defineParameter((String)"ACTION");
        XLogFilter xf = new XLogFilter();
        xf.setLogLevel("DEBUG|INFO");
        xf.setParameter("USER", ".*");
        xf.setParameter("GROUP", ".*");
        xf.setParameter("TOKEN", ".*");
        xf.setParameter("APP", ".*");
        xf.setParameter("JOB", "0000003-140205233038063-oozie-oozi-C");
        xf.setParameter("ACTION", "0000003-140205233038063-oozie-oozi-C@1");
        String out = this.doStreamLog(xf);
        String[] outArr = out.split("\n");
        TestZKXLogStreamingService.assertEquals((int)2, (int)outArr.length);
        TestZKXLogStreamingService.assertTrue((boolean)out.contains("_L1_"));
        TestZKXLogStreamingService.assertFalse((boolean)out.contains("_L2_"));
        ZKXTestCase.DummyZKOozie dummyOozie = null;
        EmbeddedServletContainer container = new EmbeddedServletContainer("oozie");
        container.addServletEndpoint("/other-oozie-server/*", DummyLogStreamingServlet.class);
        try {
            container.start();
            dummyOozie = new ZKXTestCase.DummyZKOozie(this, "9876", container.getServletURL("/other-oozie-server/*"));
            DummyLogStreamingServlet.logs = "";
            DummyLogStreamingServlet.lastQueryString = null;
            HashMap<String, String[]> param = new HashMap<String, String[]>();
            param.put("type", new String[]{"action"});
            param.put("scope", new String[]{"1"});
            out = this.doStreamLog(xf, param);
            TestZKXLogStreamingService.assertTrue((boolean)DummyLogStreamingServlet.lastQueryString.contains("show=log&allservers=false"));
            TestZKXLogStreamingService.assertTrue((boolean)DummyLogStreamingServlet.lastQueryString.contains("type=action"));
            TestZKXLogStreamingService.assertTrue((boolean)DummyLogStreamingServlet.lastQueryString.contains("scope=1"));
            param.clear();
            param.put("type", new String[]{"action"});
            param.put("scope", new String[]{"1-4,5"});
            out = this.doStreamLog(xf, param);
            TestZKXLogStreamingService.assertTrue((boolean)DummyLogStreamingServlet.lastQueryString.contains("show=log&allservers=false"));
            TestZKXLogStreamingService.assertTrue((boolean)DummyLogStreamingServlet.lastQueryString.contains("type=action"));
            TestZKXLogStreamingService.assertTrue((boolean)DummyLogStreamingServlet.lastQueryString.contains("scope=1-4,5"));
            param.clear();
            Date endDate = new Date();
            Date createdDate = new Date(endDate.getTime() / 2L);
            String date = DateUtils.formatDateOozieTZ((Date)createdDate) + "::" + DateUtils.formatDateOozieTZ((Date)endDate);
            param.put("type", new String[]{"date"});
            param.put("scope", new String[]{date});
            out = this.doStreamLog(xf, param);
            TestZKXLogStreamingService.assertTrue((boolean)DummyLogStreamingServlet.lastQueryString.contains("show=log&allservers=false"));
            TestZKXLogStreamingService.assertTrue((boolean)DummyLogStreamingServlet.lastQueryString.contains("type=date"));
            TestZKXLogStreamingService.assertTrue((boolean)DummyLogStreamingServlet.lastQueryString.contains("scope=" + date));
            container.stop();
        }
        finally {
            if (dummyOozie != null) {
                dummyOozie.teardown();
            }
            container.stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testStreamingWithMultipleOozieServers_errorLog() throws Exception {
        XLogFilter.reset();
        File log4jFile = new File(this.getTestCaseConfDir(), "test-log4j.properties");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream("test-no-dash-log4j.properties");
        Properties log4jProps = new Properties();
        log4jProps.load(is);
        log4jProps.setProperty("log4j.appender.oozie.File", this.getTestCaseDir() + "/oozie.log");
        log4jProps.setProperty("log4j.appender.oozieError.File", this.getTestCaseDir() + "/oozie-error.log");
        log4jProps.store(new FileOutputStream(log4jFile), "");
        this.setSystemProperty("oozie.log4j.file", log4jFile.getName());
        ((XLogService)Services.get().get(XLogService.class)).init(Services.get());
        File logFile = new File(((XLogService)Services.get().get(XLogService.class)).getOozieErrorLogPath(), ((XLogService)Services.get().get(XLogService.class)).getOozieErrorLogName());
        logFile.getParentFile().mkdirs();
        FileWriter logWriter = new FileWriter(logFile);
        StringBuffer bf = new StringBuffer();
        bf.append("2014-02-06 00:26:56,126 WARN CoordActionInputCheckXCommand:545 [pool-2-thread-26] - USER[-] GROUP[-] TOKEN[-] APP[-] JOB[0000003-140205233038063-oozie-oozi-C] ACTION[0000003-140205233038063-oozie-oozi-C@1] checking for the file ~:8020/user/purushah/examples/input-data/rawLogs/2010/01/01/01/00/_SUCCESS\n").append("2014-02-06 00:26:56,150  WARN CoordActionInputCheckXCommand:539 [pool-2-thread-26] - USER[-] GROUP[-] TOKEN[-] APP[-] JOB[0000003-140205233038063-oozie-oozi-C] ACTION[0000003-140205233038063-oozie-oozi-C@1] [0000003-140205233038063-oozie-oozi-C@1]::ActionInputCheck::File::8020/user/purushah/examples/input-data/rawLogs/2010/01/01/01/00/_SUCCESS, Exists? :falseAction updated in DB! _L1_").append("\n").append("2014-02-06 00:27:56,126 WARN CoordActionInputCheckXCommand:545 [pool-2-thread-26] - USER[-] GROUP[-] TOKEN[-] APP[-] JOB[0000003-140205233038063-oozie-oozi-C] ACTION[0000003-140205233038063-oozie-oozi-C@2] checking for the file ~:8020/user/purushah/examples/input-data/rawLogs/2010/01/01/01/00/_SUCCESS\n").append("2014-02-06 00:27:56,150  WARN CoordActionInputCheckXCommand:539 [pool-2-thread-26] - USER[-] GROUP[-] TOKEN[-] APP[-] JOB[0000003-140205233038063-oozie-oozi-C] ACTION[0000003-140205233038063-oozie-oozi-C@2] [0000003-140205233038063-oozie-oozi-C@2]::ActionInputCheck::File::8020/user/purushah/examples/input-data/rawLogs/2010/01/01/01/00/_SUCCESS, Exists? :falseAction updated in DB! _L2_").append("\n");
        logWriter.append(bf);
        logWriter.close();
        XLogFilter.reset();
        XLogFilter.defineParameter((String)"USER");
        XLogFilter.defineParameter((String)"GROUP");
        XLogFilter.defineParameter((String)"TOKEN");
        XLogFilter.defineParameter((String)"APP");
        XLogFilter.defineParameter((String)"JOB");
        XLogFilter.defineParameter((String)"ACTION");
        XLogFilter xf = new XLogFilter();
        xf.setParameter("USER", ".*");
        xf.setParameter("GROUP", ".*");
        xf.setParameter("TOKEN", ".*");
        xf.setParameter("APP", ".*");
        xf.setParameter("JOB", "0000003-140205233038063-oozie-oozi-C");
        xf.setParameter("ACTION", "0000003-140205233038063-oozie-oozi-C@1");
        String out = this.doStreamErrorLog(xf);
        String[] outArr = out.split("\n");
        TestZKXLogStreamingService.assertEquals((int)2, (int)outArr.length);
        TestZKXLogStreamingService.assertTrue((boolean)out.contains("_L1_"));
        TestZKXLogStreamingService.assertFalse((boolean)out.contains("_L2_"));
        ZKXTestCase.DummyZKOozie dummyOozie = null;
        EmbeddedServletContainer container = new EmbeddedServletContainer("oozie");
        container.addServletEndpoint("/other-oozie-server/*", DummyLogStreamingServlet.class);
        try {
            container.start();
            dummyOozie = new ZKXTestCase.DummyZKOozie(this, "9876", container.getServletURL("/other-oozie-server/*"));
            StringBuffer newLog = new StringBuffer();
            newLog.append("2014-02-07 00:26:56,126 WARN CoordActionInputCheckXCommand:545 [pool-2-thread-26] - USER[-] GROUP[-] TOKEN[-] APP[-] JOB[0000003-140205233038063-oozie-oozi-C] ACTION[0000003-140205233038063-oozie-oozi-C@1] checking for the file ~:8020/user/purushah/examples/input-data/rawLogs/2010/01/01/01/00/_SUCCESS\n").append("2014-02-07 00:26:56,150  WARN CoordActionInputCheckXCommand:539 [pool-2-thread-26] - USER[-] GROUP[-] TOKEN[-] APP[-] JOB[0000003-140205233038063-oozie-oozi-C] ACTION[0000003-140205233038063-oozie-oozi-C@1] [0000003-140205233038063-oozie-oozi-C@1]::ActionInputCheck::File::8020/user/purushah/examples/input-data/rawLogs/2010/01/01/01/00/_SUCCESS, Exists? :falseAction updated in DB! _L3_").append("\n");
            DummyLogStreamingServlet.logs = newLog.toString();
            out = this.doStreamErrorLog(xf);
            outArr = out.split("\n");
            TestZKXLogStreamingService.assertEquals((int)4, (int)outArr.length);
            TestZKXLogStreamingService.assertTrue((boolean)out.contains("_L1_"));
            TestZKXLogStreamingService.assertTrue((boolean)out.contains("_L3_"));
            TestZKXLogStreamingService.assertFalse((boolean)out.contains("_L2_"));
            container.stop();
        }
        finally {
            if (dummyOozie != null) {
                dummyOozie.teardown();
            }
            container.stop();
        }
    }

    public void testTuncateLog() throws Exception {
        XLogFilter.reset();
        File log4jFile = new File(this.getTestCaseConfDir(), "test-log4j.properties");
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        InputStream is = cl.getResourceAsStream("test-no-dash-log4j.properties");
        Properties log4jProps = new Properties();
        log4jProps.load(is);
        log4jProps.setProperty("log4j.appender.oozie.File", this.getTestCaseDir() + "/oozie.log");
        log4jProps.store(new FileOutputStream(log4jFile), "");
        this.setSystemProperty("oozie.log4j.file", log4jFile.getName());
        TestZKXLogStreamingService.assertFalse((boolean)this.doStreamDisabledCheck());
        File logFile = new File(((XLogService)Services.get().get(XLogService.class)).getOozieLogPath(), ((XLogService)Services.get().get(XLogService.class)).getOozieLogName());
        logFile.getParentFile().mkdirs();
        ConfigurationService.set((String)XLogFilter.MAX_SCAN_DURATION, (String)"1");
        Date startDate = new Date();
        Date endDate = new Date(startDate.getTime() + 54000000L);
        String log = this.doStreamLog(new XLogFilter(), startDate, endDate);
        TestZKXLogStreamingService.assertTrue((boolean)log.contains("Truncated logs to max log scan duration"));
        String logError = this.doStreamErrorLog(new XLogFilter(), startDate, endDate);
        TestZKXLogStreamingService.assertFalse((boolean)logError.contains("Truncated logs to max log scan duration"));
    }
}

