/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.concurrent.Callable;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;
import org.apache.hadoop.util.Shell;
import org.apache.oozie.BuildInfo;
import org.apache.oozie.servlet.DagServletTestCase;
import org.apache.oozie.servlet.MockDagEngineService;
import org.apache.oozie.servlet.V0AdminServlet;
import org.apache.oozie.servlet.V0JobServlet;
import org.apache.oozie.servlet.V2AdminServlet;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class TestAdminServlet
extends DagServletTestCase {
    private static final boolean IS_SECURITY_ENABLED = false;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testStatus() throws Exception {
        this.runTest("/v0/admin/*", V0AdminServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                URL url = TestAdminServlet.this.createURL("status", Collections.EMPTY_MAP);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                TestCase.assertEquals((Object)false, (Object)json.get((Object)"safeMode"));
                return null;
            }
        });
    }

    public void testOsEnv() throws Exception {
        this.runTest("/v0/admin/*", V0AdminServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                URL url = TestAdminServlet.this.createURL("os-env", Collections.EMPTY_MAP);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                TestCase.assertTrue((String)"USERNAME, USER or HOME property not found in json", (json.containsKey((Object)(Shell.WINDOWS ? "USERNAME" : "USER")) || json.containsKey((Object)"HOME") ? 1 : 0) != 0);
                return null;
            }
        });
    }

    public void testJavaSysProps() throws Exception {
        this.runTest("/v0/admin/*", V0AdminServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                URL url = TestAdminServlet.this.createURL("java-sys-properties", Collections.EMPTY_MAP);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                TestCase.assertTrue((boolean)json.containsKey((Object)"java.version"));
                return null;
            }
        });
    }

    public void testConfiguration() throws Exception {
        this.runTest("/v0/admin/*", V0AdminServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                URL url = TestAdminServlet.this.createURL("configuration", Collections.EMPTY_MAP);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                TestCase.assertTrue((boolean)json.containsKey((Object)"oozie.services"));
                return null;
            }
        });
    }

    public void testMetrics() throws Exception {
        this.runTest("/v2/admin/*", V2AdminServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                URL url = TestAdminServlet.this.createURL("metrics", Collections.EMPTY_MAP);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                TestCase.assertTrue((boolean)json.containsKey((Object)"counters"));
                return null;
            }
        });
    }

    public void testSafeMode() throws Exception {
        this.runTest(new String[]{"/v0/admin/*", "/v0/job/*"}, new Class[]{V0AdminServlet.class, V0JobServlet.class}, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockDagEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("action", "start");
                URL url = TestAdminServlet.this.createURL("/v0/job/*", "job-1", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                MockDagEngineService.reset();
                url = TestAdminServlet.this.createURL("/v0/admin/*", "status", Collections.EMPTY_MAP);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                TestCase.assertTrue((boolean)json.containsKey((Object)"safeMode"));
                TestCase.assertFalse((boolean)((Boolean)json.get((Object)"safeMode")));
                MockDagEngineService.reset();
                params = new HashMap();
                params.put("safemode", "true");
                url = TestAdminServlet.this.createURL("/v0/admin/*", "status", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                MockDagEngineService.reset();
                url = TestAdminServlet.this.createURL("/v0/admin/*", "status", Collections.EMPTY_MAP);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                TestCase.assertTrue((boolean)json.containsKey((Object)"safeMode"));
                TestCase.assertTrue((boolean)((Boolean)json.get((Object)"safeMode")));
                MockDagEngineService.reset();
                params = new HashMap();
                params.put("action", "start");
                url = TestAdminServlet.this.createURL("/v0/job/*", "job-1", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                TestCase.assertEquals((int)503, (int)conn.getResponseCode());
                MockDagEngineService.reset();
                params = new HashMap();
                params.put("safemode", "false");
                url = TestAdminServlet.this.createURL("/v0/admin/*", "status", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                MockDagEngineService.reset();
                url = TestAdminServlet.this.createURL("/v0/admin/*", "status", Collections.EMPTY_MAP);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                TestCase.assertTrue((boolean)json.containsKey((Object)"safeMode"));
                TestCase.assertFalse((boolean)((Boolean)json.get((Object)"safeMode")));
                MockDagEngineService.reset();
                params = new HashMap();
                params.put("action", "start");
                url = TestAdminServlet.this.createURL("/v0/job/*", "job-1", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                return null;
            }
        });
    }

    public void testVersion() throws Exception {
        this.runTest("/v0/admin/*", V0AdminServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                URL url = TestAdminServlet.this.createURL("build-version", Collections.EMPTY_MAP);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                String response = IOUtils.toString((InputStream)conn.getInputStream());
                JSONObject json = (JSONObject)JSONValue.parse((Reader)new StringReader(response));
                TestCase.assertEquals((Object)BuildInfo.getBuildInfo().getProperty("build.version"), (Object)json.get((Object)"buildVersion"));
                JSONObject buildInfo = (JSONObject)json.get((Object)"buildInfo");
                for (String buildInfoKey : BuildInfo.getBuildInfo().stringPropertyNames()) {
                    TestCase.assertEquals((String)("Build value difference in key " + buildInfoKey), (Object)BuildInfo.getBuildInfo().getProperty(buildInfoKey), (Object)buildInfo.get((Object)buildInfoKey));
                }
                return null;
            }
        });
    }

    public void testShareLibUpdate() throws Exception {
        this.runTest("/v2/admin/*", V2AdminServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                URL url = TestAdminServlet.this.createURL("update_sharelib", Collections.EMPTY_MAP);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                TestCase.assertEquals((int)1, (int)json.entrySet().size());
                return null;
            }
        });
    }

    public void testShareLib() throws Exception {
        this.runTest("/v2/admin/*", V2AdminServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                URL url = TestAdminServlet.this.createURL("list_sharelib", Collections.EMPTY_MAP);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                TestCase.assertEquals(null, (Object)json.get((Object)"sharelib"));
                return null;
            }
        });
    }

    public void testShareLib_withKey() throws Exception {
        this.runTest("/v2/admin/*", V2AdminServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HashMap<String, String> map = new HashMap<String, String>();
                map.put("lib", "pig");
                URL url = TestAdminServlet.this.createURL("list_sharelib", map);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                TestCase.assertEquals(null, (Object)json.get((Object)"sharelib"));
                return null;
            }
        });
    }

    public void testPurgeServiceV2() throws Exception {
        this.runTest("/v2/admin/*", V2AdminServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                URL url = TestAdminServlet.this.createURL("purge", Collections.EMPTY_MAP);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("PUT");
                TestCase.assertEquals((int)200, (int)connection.getResponseCode());
                return null;
            }
        });
    }

    public void testPurgeServiceV2Negative() throws Exception {
        this.runTest("/v2/admin/*", V2AdminServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("wf", "30");
                params.put("coord", "7");
                params.put("bundle", "-7");
                URL url = TestAdminServlet.this.createURL("purge", params);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestMethod("PUT");
                TestCase.assertEquals((int)400, (int)connection.getResponseCode());
                return null;
            }
        });
    }

    static {
        new V0AdminServlet();
        new V0JobServlet();
    }
}

