/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import junit.framework.TestCase;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.CoordinatorActionBean;
import org.apache.oozie.client.CoordinatorAction;
import org.apache.oozie.client.Job;
import org.apache.oozie.client.rest.JsonTags;
import org.apache.oozie.executor.jpa.BundleJobInsertJPAExecutor;
import org.apache.oozie.executor.jpa.CoordActionInsertJPAExecutor;
import org.apache.oozie.executor.jpa.CoordJobsGetFromParentIdJPAExecutor;
import org.apache.oozie.executor.jpa.JPAExecutor;
import org.apache.oozie.local.LocalOozie;
import org.apache.oozie.service.BundleEngineService;
import org.apache.oozie.service.ForTestAuthorizationService;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.AuthFilter;
import org.apache.oozie.servlet.HostnameFilter;
import org.apache.oozie.servlet.V1JobsServlet;
import org.apache.oozie.test.EmbeddedServletContainer;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.DateUtils;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class TestBulkMonitorWebServiceAPI
extends XDataTestCase {
    private EmbeddedServletContainer container;
    private String servletPath;
    Services services;
    JPAService jpaService;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        LocalOozie.start();
        this.jpaService = (JPAService)Services.get().get(JPAService.class);
        this.addRecordsForBulkMonitor();
    }

    @Override
    protected void tearDown() throws Exception {
        LocalOozie.stop();
        this.services.destroy();
        super.tearDown();
    }

    private URL createURL(String servletPath, String resource, Map<String, String> parameters) throws Exception {
        StringBuilder sb = new StringBuilder();
        sb.append(this.container.getServletURL(servletPath));
        if (resource != null && resource.length() > 0) {
            sb.append("/").append(resource);
        }
        if (parameters.size() > 0) {
            String separator = "?";
            for (Map.Entry<String, String> param : parameters.entrySet()) {
                sb.append(separator).append(URLEncoder.encode(param.getKey(), "UTF-8")).append("=").append(URLEncoder.encode(param.getValue(), "UTF-8"));
                separator = "&";
            }
        }
        return new URL(sb.toString());
    }

    private URL createURL(String resource, Map<String, String> parameters) throws Exception {
        return this.createURL(this.servletPath, resource, parameters);
    }

    private void runTest(String servletPath, Class servletClass, boolean securityEnabled, Callable<Void> assertions) throws Exception {
        this.runTest(new String[]{servletPath}, new Class[]{servletClass}, securityEnabled, assertions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(String[] servletPath, Class[] servletClass, boolean securityEnabled, Callable<Void> assertions) throws Exception {
        Services services = new Services();
        this.servletPath = servletPath[0];
        try {
            String proxyUser = TestBulkMonitorWebServiceAPI.getTestUser();
            services.getConf().set("oozie.service.ProxyUserService.proxyuser." + proxyUser + ".hosts", "*");
            services.getConf().set("oozie.service.ProxyUserService.proxyuser." + proxyUser + ".groups", "*");
            services.init();
            services.getConf().setBoolean("oozie.service.AuthorizationService.security.enabled", securityEnabled);
            Services.get().setService(ForTestAuthorizationService.class);
            Services.get().setService(BundleEngineService.class);
            this.container = new EmbeddedServletContainer("oozie");
            for (int i = 0; i < servletPath.length; ++i) {
                this.container.addServletEndpoint(servletPath[i], servletClass[i]);
            }
            this.container.addFilter("*", HostnameFilter.class);
            this.container.addFilter("*", AuthFilter.class);
            this.setSystemProperty("user.name", TestBulkMonitorWebServiceAPI.getTestUser());
            this.container.start();
            assertions.call();
        }
        finally {
            this.servletPath = null;
            if (this.container != null) {
                this.container.stop();
            }
            services.destroy();
            this.container = null;
        }
    }

    public void testSingleRecord() throws Exception {
        this.runTest("/v1/jobs", V1JobsServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String bulkRequest = "bundle=" + TestBulkMonitorWebServiceAPI.this.bundleName + ";coordinators=Coord1;actionStatus=FAILED;startcreatedtime=2012-07-21T00:00Z";
                JSONArray array = TestBulkMonitorWebServiceAPI.this._requestToServer(bulkRequest);
                TestCase.assertEquals((int)1, (int)array.size());
                JSONObject jbundle = (JSONObject)((JSONObject)array.get(0)).get((Object)"bulkbundle");
                JSONObject jcoord = (JSONObject)((JSONObject)array.get(0)).get((Object)"bulkcoord");
                JSONObject jaction = (JSONObject)((JSONObject)array.get(0)).get((Object)"bulkaction");
                TestCase.assertEquals((Object)jbundle.get((Object)"bundleJobName"), (Object)"BUNDLE-TEST");
                TestCase.assertEquals((Object)jcoord.get((Object)"coordJobName"), (Object)"Coord1");
                TestCase.assertEquals((Object)jcoord.get((Object)"status"), (Object)"RUNNING");
                TestCase.assertEquals((Object)jaction.get((Object)"status"), (Object)"FAILED");
                TestCase.assertEquals((String)jaction.get((Object)"createdTime").toString().split(", ")[1], (String)DateUtils.parseDateUTC((String)TestBulkMonitorWebServiceAPI.this.CREATE_TIME).toGMTString());
                return null;
            }
        });
    }

    public void testMultipleRecords() throws Exception {
        this.runTest("/v1/jobs", V1JobsServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String bulkRequest = "bundle=" + TestBulkMonitorWebServiceAPI.this.bundleName + ";coordinators=Coord1;actionStatus=FAILED,KILLED;startcreatedtime=2012-07-21T00:00Z";
                JSONArray array = TestBulkMonitorWebServiceAPI.this._requestToServer(bulkRequest);
                TestCase.assertEquals((int)2, (int)array.size());
                JSONObject jbundle = (JSONObject)((JSONObject)array.get(0)).get((Object)"bulkbundle");
                TestCase.assertNotNull((Object)jbundle);
                JSONObject jaction1 = (JSONObject)((JSONObject)array.get(0)).get((Object)"bulkaction");
                JSONObject jaction2 = (JSONObject)((JSONObject)array.get(1)).get((Object)"bulkaction");
                TestCase.assertNotNull((Object)jaction1);
                TestCase.assertNotNull((Object)jaction2);
                TestCase.assertEquals((Object)jbundle.get((Object)"bundleJobName"), (Object)TestBulkMonitorWebServiceAPI.this.bundleName);
                TestCase.assertEquals((Object)jaction1.get((Object)"status"), (Object)"FAILED");
                TestCase.assertEquals((Object)jaction2.get((Object)"status"), (Object)"KILLED");
                return null;
            }
        });
    }

    public void testNoRecords() throws Exception {
        this.runTest("/v1/jobs", V1JobsServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String bulkRequest = "bundle=BUNDLE-ABC";
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("bulk", bulkRequest);
                params.put("offset", "1");
                params.put("len", "5");
                URL url = TestBulkMonitorWebServiceAPI.this.createURL("", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                TestCase.assertEquals((int)400, (int)conn.getResponseCode());
                return null;
            }
        });
    }

    public void testMultipleCoordinators() throws Exception {
        this.runTest("/v1/jobs", V1JobsServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String bulkRequest = "bundle=" + TestBulkMonitorWebServiceAPI.this.bundleName + ";coordinators=Coord1,Coord2;actionstatus=KILLED";
                JSONArray array = TestBulkMonitorWebServiceAPI.this._requestToServer(bulkRequest);
                TestCase.assertEquals((int)2, (int)array.size());
                JSONObject jbundle = (JSONObject)((JSONObject)array.get(0)).get((Object)"bulkbundle");
                TestCase.assertNotNull((Object)jbundle);
                JSONObject jaction1 = (JSONObject)((JSONObject)array.get(0)).get((Object)"bulkaction");
                JSONObject jaction2 = (JSONObject)((JSONObject)array.get(1)).get((Object)"bulkaction");
                TestCase.assertNotNull((Object)jaction1);
                TestCase.assertNotNull((Object)jaction2);
                TestCase.assertEquals((Object)jaction1.get((Object)"id"), (Object)"Coord1@2");
                TestCase.assertEquals((Object)jaction2.get((Object)"id"), (Object)"Coord2@1");
                return null;
            }
        });
    }

    public void testDefaultStatus() throws Exception {
        CoordinatorActionBean action4 = new CoordinatorActionBean();
        action4.setId("Coord3@1");
        action4.setStatus(CoordinatorAction.Status.FAILED);
        action4.setCreatedTime(DateUtils.parseDateUTC((String)this.CREATE_TIME));
        action4.setJobId("Coord3");
        Calendar cal = Calendar.getInstance();
        cal.setTime(DateUtils.parseDateUTC((String)this.CREATE_TIME));
        cal.add(5, -1);
        action4.setNominalTime(cal.getTime());
        CoordActionInsertJPAExecutor actionInsert = new CoordActionInsertJPAExecutor(action4);
        this.jpaService.execute((JPAExecutor)actionInsert);
        this.runTest("/v1/jobs", V1JobsServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String bulkRequest = "bundle=" + TestBulkMonitorWebServiceAPI.this.bundleName;
                JSONArray array = TestBulkMonitorWebServiceAPI.this._requestToServer(bulkRequest);
                TestCase.assertEquals((int)4, (int)array.size());
                return null;
            }
        });
    }

    public void testMultipleBundleIdsForName() throws Exception {
        BundleJobBean bundle = new BundleJobBean();
        bundle.setId("00002-12345-B");
        bundle.setAppName(this.bundleName);
        bundle.setStatus(Job.Status.RUNNING);
        bundle.setStartTime(new Date());
        BundleJobInsertJPAExecutor bundleInsert = new BundleJobInsertJPAExecutor(bundle);
        this.jpaService.execute((JPAExecutor)bundleInsert);
        this.runTest("/v1/jobs", V1JobsServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String bulkRequest = "bundle=" + TestBulkMonitorWebServiceAPI.this.bundleName;
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("bulk", bulkRequest);
                params.put("offset", "1");
                params.put("len", "5");
                URL url = TestBulkMonitorWebServiceAPI.this.createURL("", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                TestCase.assertFalse((400 == conn.getResponseCode() ? 1 : 0) != 0);
                return null;
            }
        });
    }

    public void testBundleId() throws Exception {
        this.runTest("/v1/jobs", V1JobsServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String bulkRequest = "bundle=" + TestBulkMonitorWebServiceAPI.this.bundleId + ";coordinators=Coord1;actionStatus=FAILED;startcreatedtime=2012-07-21T00:00Z";
                JSONArray array = TestBulkMonitorWebServiceAPI.this._requestToServer(bulkRequest);
                TestCase.assertEquals((int)1, (int)array.size());
                JSONObject jbundle = (JSONObject)((JSONObject)array.get(0)).get((Object)"bulkbundle");
                JSONObject jcoord = (JSONObject)((JSONObject)array.get(0)).get((Object)"bulkcoord");
                JSONObject jaction = (JSONObject)((JSONObject)array.get(0)).get((Object)"bulkaction");
                TestCase.assertNotNull((Object)jbundle);
                TestCase.assertNotNull((Object)jcoord);
                TestCase.assertNotNull((Object)jaction);
                TestCase.assertEquals((Object)jbundle.get((Object)"bundleJobId"), (Object)TestBulkMonitorWebServiceAPI.this.bundleId);
                TestCase.assertEquals((Object)jcoord.get((Object)"coordJobName"), (Object)"Coord1");
                TestCase.assertEquals((Object)jcoord.get((Object)"status"), (Object)"RUNNING");
                TestCase.assertEquals((Object)jaction.get((Object)"status"), (Object)"FAILED");
                TestCase.assertEquals((String)jaction.get((Object)"createdTime").toString().split(", ")[1], (String)DateUtils.parseDateUTC((String)TestBulkMonitorWebServiceAPI.this.CREATE_TIME).toGMTString());
                return null;
            }
        });
    }

    public void testBundleIdWithCoordId() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        List coordIds = (List)jpaService.execute((JPAExecutor)new CoordJobsGetFromParentIdJPAExecutor(this.bundleId, 10));
        final String coordIdsStr = (String)coordIds.get(0) + "," + (String)coordIds.get(1);
        this.runTest("/v1/jobs", V1JobsServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                String bulkRequest = "bundle=" + TestBulkMonitorWebServiceAPI.this.bundleId + ";coordinators=" + coordIdsStr + ";actionstatus=KILLED";
                JSONArray array = TestBulkMonitorWebServiceAPI.this._requestToServer(bulkRequest);
                TestCase.assertEquals((int)2, (int)array.size());
                JSONObject jbundle = (JSONObject)((JSONObject)array.get(0)).get((Object)"bulkbundle");
                JSONObject jaction1 = (JSONObject)((JSONObject)array.get(0)).get((Object)"bulkaction");
                JSONObject jaction2 = (JSONObject)((JSONObject)array.get(1)).get((Object)"bulkaction");
                TestCase.assertEquals((Object)jaction1.get((Object)"id"), (Object)"Coord1@2");
                TestCase.assertEquals((Object)jaction2.get((Object)"id"), (Object)"Coord2@1");
                return null;
            }
        });
    }

    private JSONArray _requestToServer(String bulkRequest) throws Exception {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("bulk", bulkRequest);
        params.put("offset", "1");
        params.put("len", "5");
        URL url = this.createURL("", params);
        HttpURLConnection conn = (HttpURLConnection)url.openConnection();
        conn.setRequestMethod("GET");
        TestBulkMonitorWebServiceAPI.assertEquals((int)200, (int)conn.getResponseCode());
        TestBulkMonitorWebServiceAPI.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
        JSONObject json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
        JSONArray array = (JSONArray)json.get(JsonTags.BULK_RESPONSES);
        return array;
    }

    static {
        new V1JobsServlet();
    }
}

