/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.IOException;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import junit.framework.Assert;
import junit.framework.TestCase;
import org.apache.hadoop.util.Shell;
import org.apache.oozie.servlet.HostnameFilter;
import org.mockito.Mockito;

public class TestHostnameFilter
extends TestCase {
    public void testHostname() throws Exception {
        ServletRequest request = (ServletRequest)Mockito.mock(ServletRequest.class);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn((Object)"localhost");
        ServletResponse response = (ServletResponse)Mockito.mock(ServletResponse.class);
        final AtomicBoolean invoked = new AtomicBoolean();
        FilterChain chain = new FilterChain(){

            public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
                Assert.assertTrue((boolean)HostnameFilter.get().contains(Shell.WINDOWS ? "127.0.0.1" : "localhost"));
                invoked.set(true);
            }
        };
        HostnameFilter filter = new HostnameFilter();
        filter.init(null);
        Assert.assertNull((Object)HostnameFilter.get());
        filter.doFilter(request, response, chain);
        Assert.assertTrue((boolean)invoked.get());
        Assert.assertNull((Object)HostnameFilter.get());
        filter.destroy();
    }

    public void testMissingHostname() throws Exception {
        ServletRequest request = (ServletRequest)Mockito.mock(ServletRequest.class);
        Mockito.when((Object)request.getRemoteAddr()).thenReturn(null);
        ServletResponse response = (ServletResponse)Mockito.mock(ServletResponse.class);
        final AtomicBoolean invoked = new AtomicBoolean();
        FilterChain chain = new FilterChain(){

            public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse) throws IOException, ServletException {
                Assert.assertTrue((boolean)HostnameFilter.get().contains("???"));
                invoked.set(true);
            }
        };
        HostnameFilter filter = new HostnameFilter();
        filter.init(null);
        Assert.assertNull((Object)HostnameFilter.get());
        filter.doFilter(request, response, chain);
        Assert.assertTrue((boolean)invoked.get());
        Assert.assertNull((Object)HostnameFilter.get());
        filter.destroy();
    }
}

