/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.concurrent.Callable;
import junit.framework.TestCase;
import org.apache.commons.io.IOUtils;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.JsonRestServlet;
import org.apache.oozie.servlet.MyJsonRestServlet;
import org.apache.oozie.test.EmbeddedServletContainer;
import org.apache.oozie.test.XTestCase;
import org.json.JSONException;
import org.json.JSONObject;

public class TestJsonRestServlet
extends XTestCase {
    EmbeddedServletContainer container;

    private int invoke(String method, String resource, String queryString) throws Exception {
        return this.invoke(method, resource, queryString, "dummy").getResponseCode();
    }

    private HttpURLConnection invoke(String method, String resource, String queryString, String contentType) throws Exception {
        String s = this.container.getServletURL("/dummy");
        if (resource != null) {
            s = s + resource;
        }
        if (queryString != null) {
            s = s + "?" + queryString;
        }
        HttpURLConnection conn = (HttpURLConnection)new URL(s).openConnection();
        conn.setRequestProperty("content-type", contentType);
        conn.setRequestMethod(method);
        conn.connect();
        return conn;
    }

    private String invokeAndGetResponse(String method, String resource, String queryString, String contentType) throws Exception {
        String s = this.container.getServletURL("/dummy");
        if (resource != null) {
            s = s + resource;
        }
        if (queryString != null) {
            s = s + "?" + queryString;
        }
        HttpURLConnection conn = (HttpURLConnection)new URL(s).openConnection();
        conn.setRequestProperty("content-type", contentType);
        conn.setRequestMethod(method);
        conn.connect();
        StringBuilder sb = new StringBuilder();
        BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
        String line = reader.readLine();
        while (line != null) {
            sb.append(line);
            line = reader.readLine();
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTest(JsonRestServlet.ResourceInfo[] resourceInfo, Callable<Void> assertions) throws Exception {
        this.container = new EmbeddedServletContainer("test");
        Services services = new Services();
        try {
            services.init();
            MyJsonRestServlet.ACTIVE = resourceInfo;
            this.container.addServletEndpoint("/dummy/*", MyJsonRestServlet.class);
            this.container.start();
            assertions.call();
        }
        finally {
            this.container.stop();
            services.destroy();
        }
    }

    public void testEmptyResources() {
        try {
            MyJsonRestServlet.ACTIVE = MyJsonRestServlet.EMPTY;
            new MyJsonRestServlet();
            TestJsonRestServlet.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testNoResourceNoParams() throws Exception {
        this.runTest(MyJsonRestServlet.NO_RESOURCE_NO_PARAMS, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestCase.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", null, null));
                TestCase.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "", null));
                TestCase.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "", "a=A"));
                TestCase.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "/", null));
                TestCase.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("GET", "/hello", null));
                return null;
            }
        });
    }

    public void testParamsRequired() throws Exception {
        this.runTest(MyJsonRestServlet.PARAMS_REQUIRED, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestCase.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "", "required=true"));
                TestCase.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "", "required=true&optional=true"));
                TestCase.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("GET", "", "optional=true"));
                return null;
            }
        });
    }

    public void testParamTypes() throws Exception {
        this.runTest(MyJsonRestServlet.PARAM_TYPES, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestCase.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "", "boolean=true"));
                TestCase.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "", "boolean=false"));
                TestCase.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("GET", "", "boolean=x"));
                TestCase.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "", "integer=1"));
                TestCase.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("GET", "", "integer=x"));
                TestCase.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "", "string=a"));
                return null;
            }
        });
    }

    public void testResourceGetPostParamGet() throws Exception {
        this.runTest(MyJsonRestServlet.RESOURCE_GET_POST_PARAM_GET, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestCase.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "", "param=true"));
                TestCase.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("POST", "", "param=true"));
                TestCase.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("GET", "", ""));
                TestCase.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("POST", "", ""));
                return null;
            }
        });
    }

    public void testFixedResource() throws Exception {
        this.runTest(MyJsonRestServlet.FIXED_RESOURCE, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestCase.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("GET", "", ""));
                TestCase.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "/resource", ""));
                TestCase.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("POST", "/resource", ""));
                return null;
            }
        });
    }

    public void testWildCardResource() throws Exception {
        this.runTest(MyJsonRestServlet.WILDCARD_RESOURCE, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestCase.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "/any", ""));
                TestCase.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("POST", "/any", ""));
                return null;
            }
        });
    }

    public void testInvalidResource() throws Exception {
        this.runTest(MyJsonRestServlet.WILDCARD_RESOURCE, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                HttpURLConnection conn = TestJsonRestServlet.this.invoke("GET", "/any/any", "dummy", "dummy");
                TestCase.assertEquals((int)400, (int)conn.getResponseCode());
                TestCase.assertEquals((String)"E0301: Invalid resource [any/any]", (String)conn.getResponseMessage());
                TestJsonRestServlet.this.checkErrorResponse(conn, 400, "E0301: Invalid resource [any/any]");
                return null;
            }
        });
    }

    public void testNoResourceWithParam() throws Exception {
        this.runTest(MyJsonRestServlet.WILDCARD_RESOURCE, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestCase.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("PUT", "/", "action=kill"));
                return null;
            }
        });
    }

    public void testMultipleResources() throws Exception {
        this.runTest(MyJsonRestServlet.MULTIPLE_RESOURCES, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestCase.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "/resource1", ""));
                TestCase.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("POST", "/resource1", ""));
                TestCase.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("GET", "/resource2", ""));
                TestCase.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("POST", "/resource2", ""));
                return null;
            }
        });
    }

    public void testMultipleResourcesNoResource() throws Exception {
        this.runTest(MyJsonRestServlet.MULTIPLE_RESOURCES_NO_RESOURCE, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestCase.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "/resource1", ""));
                TestCase.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "/resource2", ""));
                TestCase.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("POST", "", ""));
                TestCase.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("POST", "/resource1", ""));
                TestCase.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("POST", "/resource2", ""));
                TestCase.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("GET", "", ""));
                return null;
            }
        });
    }

    public void testMultipleResourcesWildCard() throws Exception {
        this.runTest(MyJsonRestServlet.MULTIPLE_RESOURCES_WILDCARD, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestCase.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "/resource1", ""));
                TestCase.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "/resource2", ""));
                TestCase.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("POST", "/any", ""));
                TestCase.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("POST", "/resource1", ""));
                TestCase.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("POST", "/resource2", ""));
                TestCase.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("GET", "/any", ""));
                return null;
            }
        });
    }

    public void testContentTypeJsonCron() throws Exception {
        this.runTest(MyJsonRestServlet.CONTENT_TYPE_JSON_CRON_TEST, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                TestCase.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "", "json=object", "application/xml").getResponseCode());
                TestCase.assertEquals((int)200, (int)TestJsonRestServlet.this.invoke("GET", "", "json=object", "application/xml; param=x").getResponseCode());
                TestCase.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("GET", "", "json=object", "").getResponseCode());
                TestCase.assertEquals((int)400, (int)TestJsonRestServlet.this.invoke("GET", "", "json=object", "application/json").getResponseCode());
                String response = TestJsonRestServlet.this.invokeAndGetResponse("GET", "", "json=object", "application/xml");
                TestCase.assertTrue((boolean)response.contains("object"));
                response = TestJsonRestServlet.this.invokeAndGetResponse("GET", "", "json=array", "application/xml");
                TestCase.assertTrue((boolean)response.contains("array"));
                return null;
            }
        });
    }

    private void checkErrorResponse(HttpURLConnection conn, int responseCode, String responseMessage) throws JSONException, IOException {
        JSONObject json = new JSONObject(IOUtils.toString((InputStream)conn.getErrorStream()).trim());
        TestJsonRestServlet.assertEquals((String)"Error message is different.", (String)responseMessage, (String)json.getString("errorMessage"));
        TestJsonRestServlet.assertEquals((String)"Error code is different", (int)responseCode, (int)json.getInt("httpStatusCode"));
    }

    static {
        new MyJsonRestServlet();
    }
}

