/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.Callable;
import junit.framework.TestCase;
import org.apache.oozie.BundleJobBean;
import org.apache.oozie.client.Job;
import org.apache.oozie.service.Services;
import org.apache.oozie.service.UUIDService;
import org.apache.oozie.servlet.DagServletTestCase;
import org.apache.oozie.servlet.MockCoordinatorEngineService;
import org.apache.oozie.servlet.V1JobServlet;
import org.apache.oozie.test.XDataTestCase;
import org.apache.oozie.util.IOUtils;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;
import org.junit.Ignore;

public class TestV1JobServletBundleEngine
extends DagServletTestCase {
    private static final boolean IS_SECURITY_ENABLED = false;
    private Services services;
    private final XDataTestCase xDataTestCase = new XDataTestCase1();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.xDataTestCase.setName(this.getName());
        this.xDataTestCase.setUpPub();
        new Services().init();
        this.services = Services.get();
        this.services.setService(UUIDService.class);
    }

    @Override
    protected void tearDown() throws Exception {
        if (this.services != null) {
            this.services.destroy();
        }
        this.xDataTestCase.tearDownPub();
        super.tearDown();
    }

    public void testBundleEngineGetBundleJob() throws Exception {
        final BundleJobBean bundleJobBean = this.xDataTestCase.addRecordToBundleJobTable(Job.Status.PREP, false);
        this.runTest("/v1/job/*", V1JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockCoordinatorEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("show", "info");
                String id = bundleJobBean.getId();
                URL url = TestV1JobServletBundleEngine.this.createURL(id, params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject obj = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                TestCase.assertEquals((Object)id, (Object)obj.get((Object)"bundleJobId"));
                return null;
            }
        });
    }

    public void testBundleEngineChange() throws Exception {
        final BundleJobBean bundleJobBean = this.xDataTestCase.addRecordToBundleJobTable(Job.Status.PREP, false);
        this.runTest("/v1/job/*", V1JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockCoordinatorEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("action", "change");
                String changeValue = "endtime=2011-12-01T05:00Z";
                params.put("value", changeValue);
                String id = bundleJobBean.getId();
                URL url = TestV1JobServletBundleEngine.this.createURL(id, params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                return null;
            }
        });
    }

    public void testBundleEngineGetDefinition() throws Exception {
        final BundleJobBean bundleJobBean = this.xDataTestCase.addRecordToBundleJobTable(Job.Status.PREP, false);
        this.runTest("/v1/job/*", V1JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockCoordinatorEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("show", "definition");
                String id = bundleJobBean.getId();
                URL url = TestV1JobServletBundleEngine.this.createURL(id, params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                String ct = conn.getHeaderField("content-type");
                TestCase.assertTrue((boolean)ct.startsWith("application/xml"));
                String response = IOUtils.getReaderAsString((Reader)new InputStreamReader(conn.getInputStream()), (int)-1);
                TestCase.assertTrue((response != null && response.length() > 0 ? 1 : 0) != 0);
                return null;
            }
        });
    }

    public void testBundleEngineStreamLog() throws Exception {
        final BundleJobBean bundleJobBean = this.xDataTestCase.addRecordToBundleJobTable(Job.Status.PREP, false);
        this.runTest("/v1/job/*", V1JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockCoordinatorEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("show", "log");
                String id = bundleJobBean.getId();
                URL url = TestV1JobServletBundleEngine.this.createURL(id, params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                return null;
            }
        });
    }

    public void testBundleEngineKill() throws Exception {
        this._testBundleEnginePutImpl("kill");
    }

    public void testBundleEngineResume() throws Exception {
        this._testBundleEnginePutImpl("resume");
    }

    public void testBundleEngineSuspend() throws Exception {
        this._testBundleEnginePutImpl("suspend");
    }

    public void testBundleEngineStart() throws Exception {
        this._testBundleEnginePutImpl("start");
    }

    public void testBundleEngineReRun() throws Exception {
        this._testBundleEnginePutImpl("bundle-rerun");
    }

    private void _testBundleEnginePutImpl(final String jobAction) throws Exception {
        final BundleJobBean bundleJobBean = this.xDataTestCase.addRecordToBundleJobTable(Job.Status.PREP, false);
        this.runTest("/v1/job/*", V1JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockCoordinatorEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("action", jobAction);
                String id = bundleJobBean.getId();
                URL url = TestV1JobServletBundleEngine.this.createURL(id, params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestProperty("content-type", "application/xml");
                conn.setRequestMethod("PUT");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                return null;
            }
        });
    }

    static {
        new V1JobServlet();
    }

    @Ignore
    private static class XDataTestCase1
    extends XDataTestCase {
        private XDataTestCase1() {
        }
    }
}

