/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.Callable;
import junit.framework.TestCase;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.oozie.DagEngine;
import org.apache.oozie.service.DagEngineService;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.DagServletTestCase;
import org.apache.oozie.servlet.MockDagEngineService;
import org.apache.oozie.servlet.V1JobsServlet;
import org.apache.oozie.util.XConfiguration;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class TestV1JobsServlet
extends DagServletTestCase {
    private static final boolean IS_SECURITY_ENABLED = false;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testSubmit() throws Exception {
        this.runTest("/v1/jobs", V1JobsServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockDagEngineService.reset();
                String appPath = TestV1JobsServlet.this.getFsTestCaseDir().toString() + "/app";
                FileSystem fs = TestV1JobsServlet.this.getFileSystem();
                Path jobXmlPath = new Path(appPath, "workflow.xml");
                fs.create(jobXmlPath);
                int wfCount = MockDagEngineService.workflows.size();
                XConfiguration jobConf = new XConfiguration();
                jobConf.set("user.name", TestV1JobsServlet.getTestUser());
                jobConf.set("oozie.wf.application.path", appPath);
                HashMap<String, String> params = new HashMap<String, String>();
                URL url = TestV1JobsServlet.this.createURL("", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("content-type", "application/xml");
                conn.setDoOutput(true);
                jobConf.writeXml(conn.getOutputStream());
                TestCase.assertEquals((int)201, (int)conn.getResponseCode());
                JSONObject obj = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                TestCase.assertEquals((Object)("job-" + wfCount + "-W"), (Object)obj.get((Object)"id"));
                TestCase.assertFalse((boolean)MockDagEngineService.started.get(wfCount));
                ++wfCount;
                jobConf = new XConfiguration();
                jobConf.set("user.name", TestV1JobsServlet.getTestUser());
                jobConf.set("oozie.wf.application.path", appPath);
                params = new HashMap();
                params.put("action", "start");
                url = TestV1JobsServlet.this.createURL("", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("content-type", "application/xml");
                conn.setDoOutput(true);
                jobConf.writeXml(conn.getOutputStream());
                TestCase.assertEquals((int)201, (int)conn.getResponseCode());
                obj = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                TestCase.assertEquals((Object)("job-" + wfCount + "-W"), (Object)obj.get((Object)"id"));
                TestCase.assertTrue((boolean)MockDagEngineService.started.get(wfCount));
                Services services = Services.get();
                DagEngine de = ((DagEngineService)services.get(DagEngineService.class)).getDagEngine(TestV1JobsServlet.getTestUser());
                StringReader sr = new StringReader(de.getJob("job-" + wfCount).getConf());
                XConfiguration conf1 = new XConfiguration((Reader)sr);
                ++wfCount;
                jobConf = new XConfiguration();
                jobConf.set("user.name", TestV1JobsServlet.getTestUser());
                params = new HashMap();
                url = TestV1JobsServlet.this.createURL("", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("content-type", "application/xml");
                conn.setDoOutput(true);
                jobConf.writeXml(conn.getOutputStream());
                TestCase.assertEquals((int)400, (int)conn.getResponseCode());
                Path libPath1 = new Path(TestV1JobsServlet.this.getFsTestCaseDir(), "libpath1");
                fs.mkdirs(libPath1);
                Path jobXmlPath1 = new Path(libPath1, "workflow.xml");
                fs.create(jobXmlPath1);
                jobConf = new XConfiguration();
                jobConf.set("user.name", TestV1JobsServlet.getTestUser());
                jobConf.set("oozie.libpath", libPath1.toString());
                params = new HashMap();
                url = TestV1JobsServlet.this.createURL("", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("content-type", "application/xml");
                conn.setDoOutput(true);
                jobConf.writeXml(conn.getOutputStream());
                TestCase.assertEquals((int)201, (int)conn.getResponseCode());
                TestCase.assertEquals((int)201, (int)conn.getResponseCode());
                obj = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                TestCase.assertEquals((Object)("job-" + wfCount + "-W"), (Object)obj.get((Object)"id"));
                TestCase.assertFalse((boolean)MockDagEngineService.started.get(wfCount));
                ++wfCount;
                Path libPath2 = new Path(TestV1JobsServlet.this.getFsTestCaseDir(), "libpath2");
                fs.mkdirs(libPath2);
                jobConf = new XConfiguration();
                jobConf.set("user.name", TestV1JobsServlet.getTestUser());
                jobConf.set("oozie.libpath", libPath1.toString() + "," + libPath2.toString());
                params = new HashMap();
                url = TestV1JobsServlet.this.createURL("", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("POST");
                conn.setRequestProperty("content-type", "application/xml");
                conn.setDoOutput(true);
                jobConf.writeXml(conn.getOutputStream());
                TestCase.assertEquals((int)201, (int)conn.getResponseCode());
                TestCase.assertEquals((int)201, (int)conn.getResponseCode());
                obj = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                TestCase.assertEquals((Object)("job-" + wfCount + "-W"), (Object)obj.get((Object)"id"));
                TestCase.assertFalse((boolean)MockDagEngineService.started.get(wfCount));
                ++wfCount;
                return null;
            }
        });
    }

    public void testJobs() throws Exception {
        this.runTest("/v1/jobs", V1JobsServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                int i;
                MockDagEngineService.reset();
                int wfCount = MockDagEngineService.workflows.size();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("filter", "name=x");
                URL url = TestV1JobsServlet.this.createURL("", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                JSONArray array = (JSONArray)json.get((Object)"workflows");
                TestCase.assertEquals((int)4, (int)array.size());
                for (i = 0; i < 4; ++i) {
                    TestCase.assertEquals((Object)("job-" + i + "-W"), (Object)((JSONObject)array.get(i)).get((Object)"id"));
                    TestCase.assertNotNull((Object)((JSONObject)array.get(i)).get((Object)"appPath"));
                }
                params = new HashMap();
                params.put("filter", "name=x");
                params.put("offset", "2");
                params.put("len", "100");
                params.put("timezone", "PST");
                url = TestV1JobsServlet.this.createURL("", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                array = (JSONArray)json.get((Object)"workflows");
                TestCase.assertEquals((int)4, (int)array.size());
                for (i = 0; i < 4; ++i) {
                    TestCase.assertEquals((Object)("job-" + i + "-W"), (Object)((JSONObject)array.get(i)).get((Object)"id"));
                    TestCase.assertNotNull((Object)((JSONObject)array.get(i)).get((Object)"appPath"));
                    String startTime = ((JSONObject)array.get(i)).get((Object)"startTime").toString();
                    TestCase.assertTrue((startTime.endsWith("PST") || startTime.endsWith("PDT") ? 1 : 0) != 0);
                }
                params = new HashMap();
                params.put("jobtype", "wf");
                params.put("external-id", "external-valid");
                url = TestV1JobsServlet.this.createURL("", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject obj = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                TestCase.assertEquals((Object)"id-valid", (Object)obj.get((Object)"id"));
                params = new HashMap();
                params.put("external-id", "external-invalid");
                url = TestV1JobsServlet.this.createURL("", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                obj = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                TestCase.assertNull((Object)obj.get((Object)"id"));
                params = new HashMap();
                params.put("filter", "startCreatedTime=2000-01-01T00:00Z;endCreatedTime=2100-12-31T00:00Z");
                url = TestV1JobsServlet.this.createURL("", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                json = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                array = (JSONArray)json.get((Object)"workflows");
                TestCase.assertEquals((int)4, (int)array.size());
                return null;
            }
        });
    }

    static {
        new V1JobsServlet();
    }
}

