/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.io.InputStreamReader;
import java.io.Reader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.HashMap;
import java.util.concurrent.Callable;
import junit.framework.TestCase;
import org.apache.oozie.client.CoordinatorWfAction;
import org.apache.oozie.service.ConfigurationService;
import org.apache.oozie.servlet.DagServletTestCase;
import org.apache.oozie.servlet.MockCoordinatorEngineService;
import org.apache.oozie.servlet.MockDagEngineService;
import org.apache.oozie.servlet.V0JobServlet;
import org.apache.oozie.servlet.V1JobServlet;
import org.apache.oozie.servlet.V2JobServlet;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.JSONValue;

public class TestV2JobServlet
extends DagServletTestCase {
    private static final boolean IS_SECURITY_ENABLED = false;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testJobInfo() throws Exception {
        this.runTest("/v2/job/*", V2JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockCoordinatorEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("show", "info");
                URL url = TestV2JobServlet.this.createURL("coord-job-C-1", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject obj = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                TestCase.assertEquals((Object)"coord-job-C-1", (Object)obj.get((Object)"coordJobId"));
                TestCase.assertEquals((String)"info", (String)MockCoordinatorEngineService.did);
                MockCoordinatorEngineService.reset();
                params = new HashMap();
                params.put("show", "info");
                params.put("offset", "2");
                params.put("len", "50");
                url = TestV2JobServlet.this.createURL("coord-job-C-1", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                obj = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                TestCase.assertEquals((Object)"coord-job-C-1", (Object)obj.get((Object)"coordJobId"));
                TestCase.assertEquals((String)"info", (String)MockCoordinatorEngineService.did);
                TestCase.assertEquals((Object)MockCoordinatorEngineService.offset, (Object)new Integer(2));
                TestCase.assertEquals((Object)MockCoordinatorEngineService.length, (Object)new Integer(50));
                MockCoordinatorEngineService.reset();
                params = new HashMap();
                params.put("show", "info");
                params.put("offset", "-1");
                params.put("len", "-1");
                url = TestV2JobServlet.this.createURL("coord-job-C-1", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                obj = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                TestCase.assertEquals((Object)"coord-job-C-1", (Object)obj.get((Object)"coordJobId"));
                TestCase.assertEquals((String)"info", (String)MockCoordinatorEngineService.did);
                TestCase.assertEquals((Object)MockCoordinatorEngineService.offset, (Object)new Integer(1));
                TestCase.assertEquals((Object)MockCoordinatorEngineService.length, (Object)new Integer(1000));
                MockCoordinatorEngineService.reset();
                params = new HashMap();
                params.put("show", "info");
                params.put("offset", "0");
                params.put("len", "0");
                url = TestV2JobServlet.this.createURL("coord-job-C-1", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                obj = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                TestCase.assertEquals((Object)"coord-job-C-1", (Object)obj.get((Object)"coordJobId"));
                TestCase.assertEquals((String)"info", (String)MockCoordinatorEngineService.did);
                TestCase.assertEquals((Object)MockCoordinatorEngineService.offset, (Object)new Integer(1));
                TestCase.assertEquals((Object)MockCoordinatorEngineService.length, (Object)new Integer(0));
                MockCoordinatorEngineService.reset();
                params = new HashMap();
                params.put("show", "info");
                url = TestV2JobServlet.this.createURL("coord-job-C-" + (MockCoordinatorEngineService.coordJobs.size() + 1), params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)400, (int)conn.getResponseCode());
                TestCase.assertEquals((String)"info", (String)MockCoordinatorEngineService.did);
                return null;
            }
        });
    }

    public void testGetCoordActionReruns() throws Exception {
        this.runTest("/v2/job/*", V1JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockDagEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("show", "allruns");
                URL url = TestV2JobServlet.this.createURL("coord-action-C@-1", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                MockDagEngineService.reset();
                params.put("type", "action");
                params.put("scope", "2");
                url = TestV2JobServlet.this.createURL("coord-job-C-2", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                return null;
            }
        });
    }

    public void testCoordJobIgnore() throws Exception {
        this.runTest("/v2/job/*", V2JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockDagEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("action", "ignore");
                URL url = TestV2JobServlet.this.createURL("coord-job-C-1", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                conn.setRequestProperty("content-type", "application/xml");
                conn.setDoOutput(true);
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertEquals((String)"change", (String)MockCoordinatorEngineService.did);
                MockCoordinatorEngineService.reset();
                params = new HashMap();
                params.put("action", "ignore");
                url = TestV2JobServlet.this.createURL("coord-job-C-" + (MockCoordinatorEngineService.coordJobs.size() + 1), params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                conn.setRequestProperty("content-type", "application/xml");
                conn.setDoOutput(true);
                TestCase.assertEquals((int)400, (int)conn.getResponseCode());
                TestCase.assertEquals((String)"change", (String)MockCoordinatorEngineService.did);
                return null;
            }
        });
    }

    public void testCoordActionIgnore() throws Exception {
        this.runTest("/v2/job/*", V2JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockDagEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("action", "ignore");
                params.put("type", "action");
                params.put("scope", "1");
                URL url = TestV2JobServlet.this.createURL("coord-job-C-1", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                conn.setRequestProperty("content-type", "application/xml");
                conn.setDoOutput(true);
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertEquals((String)"ignore", (String)MockCoordinatorEngineService.did);
                MockCoordinatorEngineService.reset();
                params = new HashMap();
                params.put("action", "ignore");
                params.put("type", "action");
                params.put("scope", "1");
                url = TestV2JobServlet.this.createURL("coord-job-C-" + (MockCoordinatorEngineService.coordJobs.size() + 1), params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("PUT");
                conn.setRequestProperty("content-type", "application/xml");
                conn.setDoOutput(true);
                TestCase.assertEquals((int)400, (int)conn.getResponseCode());
                TestCase.assertEquals((String)"ignore", (String)MockCoordinatorEngineService.did);
                return null;
            }
        });
    }

    public void testJobStatus() throws Exception {
        this.runTest("/v2/job/*", V2JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockDagEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("show", "status");
                URL url = TestV2JobServlet.this.createURL("job-1-W", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject obj = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                TestCase.assertEquals((Object)"SUCCEEDED", (Object)obj.get((Object)"status"));
                TestCase.assertEquals((String)"status", (String)MockDagEngineService.did);
                MockCoordinatorEngineService.reset();
                params = new HashMap();
                params.put("show", "status");
                url = TestV2JobServlet.this.createURL("coord-job-C-1", params);
                conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                obj = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                TestCase.assertEquals((Object)"RUNNING", (Object)obj.get((Object)"status"));
                TestCase.assertEquals((String)"status", (String)MockCoordinatorEngineService.did);
                return null;
            }
        });
    }

    public void testGetWfActionByJobIdAndNameNormal() throws Exception {
        this.runTest("/v2/job/*", V2JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockCoordinatorEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params = new HashMap();
                params.put("show", "wf-actions");
                params.put("offset", "2");
                params.put("len", "2");
                params.put("action-name", "actionTest");
                URL url = TestV2JobServlet.this.createURL("coord-job-C-1", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertTrue((boolean)conn.getHeaderField("content-type").startsWith("application/json"));
                JSONObject obj = (JSONObject)JSONValue.parse((Reader)new InputStreamReader(conn.getInputStream()));
                TestCase.assertEquals((Object)"coord-job-C-1", (Object)obj.get((Object)"coordJobId"));
                TestCase.assertEquals((String)"wf-actions", (String)MockCoordinatorEngineService.did);
                TestCase.assertEquals((int)MockCoordinatorEngineService.offset, (int)2);
                TestCase.assertEquals((int)MockCoordinatorEngineService.length, (int)2);
                JSONArray coordWfActions = (JSONArray)obj.get((Object)"actions");
                TestCase.assertEquals((int)coordWfActions.size(), (int)3);
                for (int i = 0; i < coordWfActions.size(); ++i) {
                    JSONObject coordWfAction = (JSONObject)coordWfActions.get(i);
                    JSONObject wfAction = (JSONObject)coordWfAction.get((Object)"action");
                    if (i == coordWfActions.size() - 1) {
                        TestCase.assertEquals(null, (Object)wfAction);
                        String nullReason = CoordinatorWfAction.NullReason.ACTION_NULL.getNullReason(new Object[]{"actionTest2", "wf1"});
                        TestCase.assertEquals((Object)nullReason, (Object)coordWfAction.get((Object)"nullReason"));
                        continue;
                    }
                    TestCase.assertEquals((Object)"actionTest", (Object)wfAction.get((Object)"name"));
                }
                return null;
            }
        });
    }

    public void testGetWfActionByJobIdAndNameActionNameMissing() throws Exception {
        this.runTest("/v2/job/*", V2JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockCoordinatorEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("show", "wf-actions");
                URL url = TestV2JobServlet.this.createURL("coord-job-C-1", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)400, (int)conn.getResponseCode());
                return null;
            }
        });
    }

    public void testGetWfActionByJobIdAndNameUnparseableOffset() throws Exception {
        this.runTest("/v2/job/*", V2JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockCoordinatorEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("show", "wf-actions");
                params.put("offset", "2abc");
                params.put("len", "2");
                params.put("action-name", "actionTest");
                URL url = TestV2JobServlet.this.createURL("coord-job-C-1", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)400, (int)conn.getResponseCode());
                return null;
            }
        });
    }

    public void testGetWfActionByJobIdAndNameUnparseableLen() throws Exception {
        this.runTest("/v2/job/*", V2JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockCoordinatorEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("show", "wf-actions");
                params.put("offset", "2");
                params.put("len", "2abc");
                params.put("action-name", "actionTest");
                URL url = TestV2JobServlet.this.createURL("coord-job-C-1", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)400, (int)conn.getResponseCode());
                return null;
            }
        });
    }

    public void testGetWfActionByJobIdAndNameOffsetOutOfRange() throws Exception {
        this.runTest("/v2/job/*", V2JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockCoordinatorEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("show", "wf-actions");
                params.put("offset", "-1");
                params.put("len", "2");
                params.put("action-name", "actionTest");
                URL url = TestV2JobServlet.this.createURL("coord-job-C-1", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertEquals((int)MockCoordinatorEngineService.offset, (int)1);
                return null;
            }
        });
    }

    public void testGetWfActionByJobIdAndNameLenOutOfRange() throws Exception {
        this.runTest("/v2/job/*", V2JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockCoordinatorEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("show", "wf-actions");
                params.put("offset", "1");
                params.put("len", "-1");
                params.put("action-name", "actionTest");
                URL url = TestV2JobServlet.this.createURL("coord-job-C-1", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)200, (int)conn.getResponseCode());
                TestCase.assertEquals((int)MockCoordinatorEngineService.length, (int)ConfigurationService.getInt((String)"oozie.coord.actions.default.length"));
                return null;
            }
        });
    }

    public void testGetWfActionFromV0JobServlet() throws Exception {
        this.runTest("/v0/job/*", V0JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockCoordinatorEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params = new HashMap();
                params.put("show", "wf-actions");
                params.put("offset", "2");
                params.put("len", "2");
                params.put("action-name", "actionTest");
                URL url = TestV2JobServlet.this.createURL("coord-job-C-1", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)400, (int)conn.getResponseCode());
                return null;
            }
        });
    }

    public void testGetWfActionFromV1JobServlet() throws Exception {
        this.runTest("/v1/job/*", V1JobServlet.class, false, new Callable<Void>(){

            @Override
            public Void call() throws Exception {
                MockCoordinatorEngineService.reset();
                HashMap<String, String> params = new HashMap<String, String>();
                params = new HashMap();
                params.put("show", "wf-actions");
                params.put("offset", "2");
                params.put("len", "2");
                params.put("action-name", "actionTest");
                URL url = TestV2JobServlet.this.createURL("coord-job-C-1", params);
                HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                conn.setRequestMethod("GET");
                TestCase.assertEquals((int)400, (int)conn.getResponseCode());
                return null;
            }
        });
    }

    static {
        new V2JobServlet();
    }
}

