/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.sla;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import org.apache.oozie.AppType;
import org.apache.oozie.FaultInjection;
import org.apache.oozie.client.event.SLAEvent;
import org.apache.oozie.client.rest.JsonBean;
import org.apache.oozie.executor.jpa.BatchQueryExecutor;
import org.apache.oozie.executor.jpa.SLASummaryQueryExecutor;
import org.apache.oozie.service.JPAService;
import org.apache.oozie.service.Services;
import org.apache.oozie.sla.SLASummaryBean;
import org.apache.oozie.test.XDataTestCase;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestSLACalculationJPAExecutor
extends XDataTestCase {
    Services services;
    Calendar cal;

    @Override
    @Before
    protected void setUp() throws Exception {
        super.setUp();
        this.services = new Services();
        this.services.init();
        this.cal = Calendar.getInstance();
    }

    @Override
    @After
    protected void tearDown() throws Exception {
        this.services.destroy();
        super.tearDown();
    }

    @Test
    public void testInsert() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestSLACalculationJPAExecutor.assertNotNull((Object)jpaService);
        String wfId = "workflow-1";
        this.cal.setTime(new Date());
        this.cal.add(5, -2);
        Date expStart = this.cal.getTime();
        this.cal.add(5, -1);
        Date expEnd = this.cal.getTime();
        Date actStart = new Date();
        this.cal.add(5, 2);
        Date actEnd = this.cal.getTime();
        SLASummaryBean bean2 = this._createSLASummaryBean(wfId, "RUNNING", SLAEvent.EventStatus.START_MISS, expStart, expEnd, 1000L, actStart, actEnd, 2000L, 1, actEnd);
        ArrayList<SLASummaryBean> insertList = new ArrayList<SLASummaryBean>();
        insertList.add(bean2);
        BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(insertList, null, null);
        SLASummaryBean sBean = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{wfId});
        TestSLACalculationJPAExecutor.assertEquals((String)wfId, (String)sBean.getId());
        TestSLACalculationJPAExecutor.assertEquals((String)"RUNNING", (String)sBean.getJobStatus());
        TestSLACalculationJPAExecutor.assertEquals((Object)SLAEvent.EventStatus.START_MISS, (Object)sBean.getEventStatus());
        TestSLACalculationJPAExecutor.assertEquals((Object)expStart, (Object)sBean.getExpectedStart());
        TestSLACalculationJPAExecutor.assertEquals((Object)expEnd, (Object)sBean.getExpectedEnd());
        TestSLACalculationJPAExecutor.assertEquals((long)1000L, (long)sBean.getExpectedDuration());
        TestSLACalculationJPAExecutor.assertEquals((Object)actStart, (Object)sBean.getActualStart());
        TestSLACalculationJPAExecutor.assertEquals((Object)actEnd, (Object)sBean.getActualEnd());
        TestSLACalculationJPAExecutor.assertEquals((long)2000L, (long)sBean.getActualDuration());
        TestSLACalculationJPAExecutor.assertEquals((Object)actEnd, (Object)sBean.getLastModifiedTime());
    }

    @Test
    public void testInsertUpdate() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestSLACalculationJPAExecutor.assertNotNull((Object)jpaService);
        String wfId = "workflow-1";
        this.cal.setTime(new Date());
        this.cal.add(5, -2);
        Date expStart = this.cal.getTime();
        this.cal.add(5, -1);
        Date expEnd = this.cal.getTime();
        Date actStart = new Date();
        SLASummaryBean bean2 = this._createSLASummaryBean(wfId, "RUNNING", SLAEvent.EventStatus.START_MISS, expStart, expEnd, 1000L, actStart, null, 2000L, 0, actStart);
        ArrayList<SLASummaryBean> insertList = new ArrayList<SLASummaryBean>();
        insertList.add(bean2);
        BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(insertList, null, null);
        Date newDate = new Date();
        bean2 = this._createSLASummaryBean(wfId, "RUNNING", SLAEvent.EventStatus.DURATION_MISS, expStart, expEnd, 1000L, actStart, newDate, 2000L, 1, newDate);
        bean2.setAppType(AppType.WORKFLOW_ACTION);
        ArrayList updateList = new ArrayList();
        SLASummaryQueryExecutor.getInstance().executeUpdate((Enum)SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_ALL, (Object)bean2);
        SLASummaryBean sBean = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{wfId});
        TestSLACalculationJPAExecutor.assertEquals((String)wfId, (String)sBean.getId());
        TestSLACalculationJPAExecutor.assertEquals((Object)SLAEvent.EventStatus.DURATION_MISS, (Object)sBean.getEventStatus());
        TestSLACalculationJPAExecutor.assertEquals((Object)expStart, (Object)sBean.getExpectedStart());
        TestSLACalculationJPAExecutor.assertEquals((Object)expEnd, (Object)sBean.getExpectedEnd());
        TestSLACalculationJPAExecutor.assertEquals((long)1000L, (long)sBean.getExpectedDuration());
        TestSLACalculationJPAExecutor.assertEquals((Object)actStart, (Object)sBean.getActualStart());
        TestSLACalculationJPAExecutor.assertEquals((Object)newDate, (Object)sBean.getActualEnd());
        TestSLACalculationJPAExecutor.assertEquals((long)2000L, (long)sBean.getActualDuration());
        TestSLACalculationJPAExecutor.assertEquals((Object)newDate, (Object)sBean.getLastModifiedTime());
    }

    @Test
    public void testRollback() throws Exception {
        JPAService jpaService = (JPAService)Services.get().get(JPAService.class);
        TestSLACalculationJPAExecutor.assertNotNull((Object)jpaService);
        String wfId1 = "workflow-1";
        String wfId2 = "workflow-2";
        SLASummaryBean bean1 = this._createSLASummaryBean(wfId1, "RUNNING", SLAEvent.EventStatus.START_MISS, new Date(), new Date(), 1000L, null, null, 2000L, 0, null);
        ArrayList<SLASummaryBean> list = new ArrayList<SLASummaryBean>();
        list.add(bean1);
        BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(list, null, null);
        Date newDate = new Date();
        bean1 = new SLASummaryBean();
        bean1.setId(wfId1);
        bean1.setActualEnd(newDate);
        ArrayList<BatchQueryExecutor.UpdateEntry> updateList = new ArrayList<BatchQueryExecutor.UpdateEntry>();
        updateList.add(new BatchQueryExecutor.UpdateEntry((Enum)SLASummaryQueryExecutor.SLASummaryQuery.UPDATE_SLA_SUMMARY_ALL, (JsonBean)bean1));
        SLASummaryBean bean2 = this._createSLASummaryBean(wfId2, "RUNNING", SLAEvent.EventStatus.END_MISS, new Date(), new Date(), 1000L, null, null, 2000L, 0, null);
        ArrayList<SLASummaryBean> insertList = new ArrayList<SLASummaryBean>();
        insertList.add(bean2);
        this.setSystemProperty("oozie.fault.injection", "true");
        this.setSystemProperty("oozie.fault.injection.action.failover", "true");
        try {
            BatchQueryExecutor.getInstance().executeBatchInsertUpdateDelete(insertList, updateList, null);
            TestSLACalculationJPAExecutor.fail((String)"Expected exception due to commit failure but didn't get any");
        }
        catch (Exception exception) {
            // empty catch block
        }
        FaultInjection.deactivate((String)"org.apache.oozie.command.SkipCommitFaultInjection");
        SLASummaryBean sBean = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{wfId1});
        TestSLACalculationJPAExecutor.assertNull((Object)sBean.getActualEnd());
        sBean = (SLASummaryBean)SLASummaryQueryExecutor.getInstance().get((Enum)SLASummaryQueryExecutor.SLASummaryQuery.GET_SLA_SUMMARY, new Object[]{wfId2});
        TestSLACalculationJPAExecutor.assertNull((Object)sBean);
    }

    private SLASummaryBean _createSLASummaryBean(String jobId, String status, SLAEvent.EventStatus slaType, Date eStart, Date eEnd, long eDur, Date aStart, Date aEnd, long aDur, int slaProc, Date lastMod) {
        SLASummaryBean bean = new SLASummaryBean();
        bean.setId(jobId);
        bean.setJobStatus(status);
        bean.setEventStatus(slaType);
        bean.setExpectedStart(eStart);
        bean.setExpectedEnd(eEnd);
        bean.setExpectedDuration(eDur);
        bean.setActualStart(aStart);
        bean.setActualEnd(aEnd);
        bean.setActualDuration(aDur);
        bean.setLastModifiedTime(lastMod);
        return bean;
    }
}

